module temp

import iTasks.Extensions.DateTime
import StdEnv
import Data.Func
import Data.Tuple
import Text

import iTasks

import mTask.Interpret
import mTask.Interpret.Device.TCP

Start w = doTasks monitor w

delayShare = sharedStore "delay" 500
tempShare  = sharedStore "temp" 0.0
lightShare = sharedStore "light" 0.0
devicePool = sharedStore "devicePool" []
msgs       = sharedStore "msgs" []

monitor
	=   (allTasks [addDevices, viewLog @! [], viewDevices] <<@ ArrangeHorizontal)
	||- (editInterval -&&- viewTemp <<@ ArrangeHorizontal)
	||- (mtask <<@ NoUserInterface)

where
	viewTemp =
			(viewSharedInformation [ViewAs \x->rp x +++ "°C"] tempShare <<@ Label "Temperature")
		-|| (viewSharedInformation [ViewAs rp] lightShare <<@ Label "Light intensity")
		<<@ ArrangeHorizontal
	where
		rp f = case split "." (toString f) of
			[a,b:rest] = join "." [a,b % (0, 1):rest]
			e = join "." e

	viewLog :: Task [String]
	viewLog = viewSharedInformation [ViewAs $ take 10] msgs
		<<@ Title "Log"

	viewDevices :: Task [TCPSettings]
	viewDevices = viewSharedInformation [] devicePool
		<<@ Title "Devices" <<@ widthAttr WrapSize

	editInterval :: Task Int
	editInterval = updateSharedInformation [] delayShare
		<<@ Title "Blinking interval" <<@ widthAttr WrapSize

	mtask :: Task ()
	mtask = mTaskPool blink devicePool msgs

	addDevices :: Task [TCPSettings]
	addDevices = Title "Add devices" @>> (forever $
			(enterInformation [] <<@ Label "New device")
			>>? \d->upd (\t->t++[d]) devicePool
		)

mTaskPool :: (Main (BCInterpret (TaskValue a))) (Shared sds [TCPSettings]) (Shared sds [String]) -> Task a | type a & RWShared sds
mTaskPool task pool msgs
	=   tell "Waiting for devices"
	>-| watch pool @? tvHd
	>>~ \d->upd tl pool
	>-| try (
			tell ("Running on: " +++ toSingleLineText d)
			>-| withDevice d True \dev->
					(deviceSpecification dev >>- \s->tell ("Spec: " +++ toMultiLineText s))
				||-
					liftmTask task dev
		) \e->case e of
			MTERTSError
				=   tell "RTS error, not going to requeue"
				>-| mTaskPool task pool msgs
			e = mTaskPool task pool msgs
				-|| (tell (toSingleLineText e +++ ", requeueing in ten seconds")
					>-| waitForTimer False 10 >-| queueDevice d)
			e = throw e
where
	queueDevice d = upd (\t->t ++ [d]) pool
	tell s = upd (\t->[s:t]) msgs

//blink :: Main (MTask v ((), ())) | mtask, liftsds, dht v & fun (v Real, v Real, v Real) v
blink =
	DHT (DHT_DHT (DigitalPin D4) DHT11) \dht->
	lightsensor 0x23 \ls->
	liftsds \dsh=delayShare In
	liftsds \tsh=tempShare In
	liftsds \lsh=lightShare In
	fun \blink=(\st->
		     getSds dsh
		>>~. delay
		>>|. writeD d4 st
		>>~. blink o Not) In
	fun \temp=(\st->
		temperature dht
		>>~. setSds tsh
		>>=. temp) In
	fun \lightm=(\(p1, p2)->
		     light ls
		>>~. \nv->setSds lsh ((p1 +. p2 +. nv) /. lit 3.0)
		>>|. lightm (p2, nv)) In
	{main=    blink (lit True)
		 .||. (getSds tsh >>~. temp)
		 .||. (getSds lsh >>~. \l->lightm (l, l))
	}
