implementation module mTask.Interpret.Peripheral

import StdEnv

import Data.Func
import Data.List
import Data.Functor
import Data.Functor.Identity
import Data.Monoid
import Data.Either
import Control.Monad
import Control.Monad.State
import Control.Monad.Writer
import Control.Applicative

import Text => qualified join

import mTask.Interpret.DSL
import mTask.Interpret.UInt
import mTask.Language

derive class gCons BCPeripheral

import Data.GenC
derive gToCValue BCPeripheral, DHTtype, DHTInfo, Pin, APin, DPin, LEDMatrixInfo
toByteCode{|BCPeripheral|} a = toString $ toCValue a []
derive gFromCValue BCPeripheral, DHTtype, DHTInfo, Pin, APin, DPin, LEDMatrixInfo
fromByteCode{|BCPeripheral|} = fromCValueToFromBytecode

nextPeripheral st = length st.bcs_hardware

instance dht (StateT BCState (WriterT [BCInstr] Identity)) where
	DHT dhtinfo def = {main
		=   Dht <$> gets nextPeripheral
		<*  modify (\s->{s & bcs_hardware=s.bcs_hardware ++ [BCDHT dhtinfo]})
		>>= unmain o def o pure
		}
	temperature dht = dht >>= \(Dht i)->tell` [BCMkTask $ BCDHTTemp $ fromInt i]
	humidity dht = dht >>= \(Dht i)->tell` [BCMkTask $ BCDHTHumid $ fromInt i]

instance LEDMatrix (StateT BCState (WriterT [BCInstr] Identity)) where
	ledmatrix i def = {main
		=   LEDMatrix <$> gets nextPeripheral
		<*  modify (\s->{s & bcs_hardware=s.bcs_hardware ++ [BCLEDMatrix i]})
		>>= unmain o def o pure
		}
	LMDot m x y s = m >>= \(LEDMatrix i)->x >>| y >>| s >>| tell` [BCMkTask $ BCLEDMatrixDot $ fromInt i]
	LMIntensity m x = m >>= \(LEDMatrix i)->x >>| tell` [BCMkTask $ BCLEDMatrixIntensity $ fromInt i]
	LMClear m = m >>= \(LEDMatrix i)->tell` [BCMkTask $ BCLEDMatrixClear $ fromInt i]
	LMDisplay m = m >>= \(LEDMatrix i)->tell` [BCMkTask $ BCLEDMatrixDisplay $ fromInt i]

instance i2cbutton (StateT BCState (WriterT [BCInstr] Identity)) where
	i2cbutton addr def = {main
		=   (\x->I2CButton x) <$> gets nextPeripheral
		<*  modify (\s->{s & bcs_hardware=s.bcs_hardware ++ [BCI2CButton (UInt8 addr)]})
		>>= unmain o def o pure
		}
	AButton m = m >>= \(I2CButton i)->tell` [BCMkTask (BCAButton (fromInt i))]
	BButton m = m >>= \(I2CButton i)->tell` [BCMkTask (BCBButton (fromInt i))]

instance LightSensor (StateT BCState (WriterT [BCInstr] Identity))
where
	lightsensor addr def = {main
		= LightSensor <$> gets nextPeripheral
		<* modify (\s -> {s & bcs_hardware=s.bcs_hardware ++ [BCLightSensor (UInt8 addr)]})
		>>= unmain o def o pure
		}
	light ls = ls >>= \(LightSensor i) -> tell` [BCMkTask (BCGetLight (fromInt i))]

instance AirQualitySensor (StateT BCState (WriterT [BCInstr] Identity))
where
	airqualitysensor addr def = {main
		= AirQualitySensor <$> gets nextPeripheral
		<* modify (\s -> {s & bcs_hardware=s.bcs_hardware ++ [BCAirQualitySensor (fromInt addr)]})
		>>= unmain o def o pure
		}
	setEnvironmentalData humid temp aqs = humid >>| temp >>| aqs >>= \(AirQualitySensor i)->tell` [BCMkTask (BCSetEnvironmentalData (fromInt i))]
	tvoc aqs = aqs >>= \(AirQualitySensor s) -> tell` [BCMkTask (BCTVOC (fromInt s))]
	co2 aqs = aqs >>= \(AirQualitySensor s) -> tell` [BCMkTask (BCCO2 (fromInt s))]
