definition module Data.GenC

import StdGeneric
from Data.Either import :: Either
from mTask.Interpret.UInt import :: UInt8, :: UInt16

class gGenC a | gToCType{|*|}, gToCParser{|*|}, gToCPrinter{|*|}, gToCValue{|*|}, gFromCValue{|*|} a

/**
 * Generate c code for printing, parsing and the type
 * @param the type in a box together with the basename
 * @param prefix
 * @result definitions (.h file)
 * @result implementations (.c file)
 */
generateC :: (Box String a) String -> ([String], [String]) | gGenC a

/**
 * Auxiliary type to house type information
 */
:: Box b a =: Box b
derive bimap Box

/**
 * @type (Box b a) -> b
 */
unBox (Box b) :== b

/**
 * @type b -> Box b a
 */
box b :== Box b

/**
 * @type (Box b a) -> Box b c
 */
reBox x :== box (unBox x)

/**
 * Make a C type definition for a given type
 *
 * @param prefix
 * @param CTypeMaker gotten from gToCType{|*|}
 * @result C type
 * @result C type definition
 */
toCType :: String (CTypeMaker a) -> ([String], [String])
:: SMInput
:: SMOutput
:: CTypeMaker a :== (SMInput [String] -> ([String], Box SMOutput a))
generic gToCType a :: SMInput [String] -> ([String], Box SMOutput a)
derive gToCType Int, Real, Bool, Char, UInt8, UInt16, UNIT, EITHER, PAIR, OBJECT of gtd, CONS of gcd, RECORD of grd, FIELD of gfd

/**
 * Generate a parser function for a given type
 * @param prefix
 * @param CParser gotten from gToCParser{|*|}
 * @param continuation list
 * @result C parser function
 */
toCParser :: String (CParser a) [String] -> [String]

:: CParser a :== CPState [String] -> Box [String] a
:: CPState
generic gToCParser a :: CPState [String] -> Box [String] a
derive gToCParser Int, Bool, Char, UInt8, UInt16, UNIT, EITHER, PAIR, CONS of gcd, FIELD of gfd, RECORD,OBJECT of gtd

/**
 * Generate a printer function for a given type
 * @param prefix
 * @param CPrinter gotten from gToCPrinter{|*|}
 * @param continuation list
 * @result C printer function
 */
toCPrinter :: String (CPrinter a) [String] -> [String]

:: CPrinter a :== CPState [String] -> Box [String] a
generic gToCPrinter a :: CPState [String] -> Box [String] a
derive gToCPrinter Int, Bool, Char, UInt8, UInt16, UNIT, EITHER, PAIR, CONS of gcd, FIELD of gfd, RECORD, OBJECT of gtd

/**
 * Generate a serialized value for the given type
 * @param value
 * @param continuation list
 * @result Bytes
 */
toCValue :: a [Char] -> [Char] | gToCValue{|*|} a
generic gToCValue a :: a [Char] -> [Char]
derive gToCValue Int, Bool, Char, UInt8, UInt16, UNIT, EITHER, PAIR, CONS of {gcd_index}, FIELD, RECORD, OBJECT

/**
 * Parse a value from the serializized value
 * @param bytes
 * @result Either an error or a value
 */
:: FromCValueError = CVEUnknownConstructor | CVEInputExhausted
fromCValue :: [Char] -> Either FromCValueError (a, [Char]) | gFromCValue{|*|} a
generic gFromCValue a :: ([Char] -> Either FromCValueError (a, [Char]))
derive gFromCValue Int, Bool, Char, UInt8, UInt16, UNIT, EITHER, PAIR, CONS of {gcd_index}, FIELD, RECORD, OBJECT
