module stat;

import StdEnv,pointer;

stat :: !Int !{#Char} !{#Char} -> Int;
stat i file_name stat_struct
	= code {
		ccall _xstat "Iss:I"
	}

localtime :: !{#Char} -> Int;
localtime time_t_p
	= code {
		ccall localtime "s:I"
	}

load_int_from_string s i
	= (toInt s.[i]) + ((toInt s.[i+1])<<8) + ((toInt s.[i+2])<<16) + ((toInt s.[i+3])<<24);

Start
	# s = createArray 64 '\0';
	# r = stat 0 "t.c\0" s;
	| r<>0
		= (0,0,0,0,0,0,0);
		# struct_tm = localtime (s % (48,51));
		| struct_tm==0
			= (0,0,0,0,0,0,0);
//			# mtime = load_int_from_string s 40;
			# sec=load_long (struct_tm+0);
			# min=load_long (struct_tm+4);
			# hour=load_long (struct_tm+8);
			# day=load_long (struct_tm+12);
			# mon=load_long (struct_tm+16);
			# year=load_long (struct_tm+20);
			= (r,1900+year,mon+1,day,hour,min,sec);
