definition module Data.OrdList

/**	
 * This module extends StdOrdList with extra functions.
 */

import StdOrdList
from StdOverloadedList import class List

/**
 * removeMembersSortedList `xs ys` removes all occurrences of elements in `ys`
 * from `xs`. The function assumes that both `xs` and `ys` are sorted and
 * contain no duplicate elements.
 */
removeMembersSortedList :: ![a] ![a] -> [a] | Eq, Ord a

/**
 * removeDupSortedList `xs` removes all duplicate elements from `xs`, assuming
 * `xs` is sorted.
 */
removeDupSortedList :: ![a] -> [a] | Eq a

/**
 * Merges two ordered lists. Overloaded version of `merge`.
 *
 * @param First list.
 * @param Second list.
 * @result The ordered list containing all elements of the first and second list.
 */
Merge :: !(l a) !(l a) -> (l a) | List l a & < a

/**
 * Merges two ordered lists given a custom `<` function. Overloaded version of `mergeBy`.
 *
 * @param The custom `<` function.
 * @param First list.
 * @param Second list.
 * @result The ordered list containing all elements of the first and second list.
 */
MergeBy :: (a a -> Bool) !(l a) !(l a) -> l a | List l a
