/*!
 * @pixi/sprite-tiling - v6.3.2
 * Compiled Wed, 04 May 2022 17:49:13 UTC
 *
 * @pixi/sprite-tiling is licensed under the MIT License.
 * http://www.opensource.org/licenses/mit-license
 */
this.PIXI=this.PIXI||{};var _pixi_sprite_tiling=function(e,t,r,n,o,i){"use strict";var a=function(e,t){return a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var r in t)t.hasOwnProperty(r)&&(e[r]=t[r])},a(e,t)};function u(e,t){function r(){this.constructor=e}a(e,t),e.prototype=null===t?Object.create(t):(r.prototype=t.prototype,new r)}var s=new r.Point,c=function(e){function n(n,o,i){void 0===o&&(o=100),void 0===i&&(i=100);var a=e.call(this,n)||this;return a.tileTransform=new r.Transform,a._width=o,a._height=i,a.uvMatrix=a.texture.uvMatrix||new t.TextureMatrix(n),a.pluginName="tilingSprite",a.uvRespectAnchor=!1,a}return u(n,e),Object.defineProperty(n.prototype,"clampMargin",{get:function(){return this.uvMatrix.clampMargin},set:function(e){this.uvMatrix.clampMargin=e,this.uvMatrix.update(!0)},enumerable:!1,configurable:!0}),Object.defineProperty(n.prototype,"tileScale",{get:function(){return this.tileTransform.scale},set:function(e){this.tileTransform.scale.copyFrom(e)},enumerable:!1,configurable:!0}),Object.defineProperty(n.prototype,"tilePosition",{get:function(){return this.tileTransform.position},set:function(e){this.tileTransform.position.copyFrom(e)},enumerable:!1,configurable:!0}),n.prototype._onTextureUpdate=function(){this.uvMatrix&&(this.uvMatrix.texture=this._texture),this._cachedTint=16777215},n.prototype._render=function(e){var t=this._texture;t&&t.valid&&(this.tileTransform.updateLocalTransform(),this.uvMatrix.update(),e.batch.setObjectRenderer(e.plugins[this.pluginName]),e.plugins[this.pluginName].render(this))},n.prototype._calculateBounds=function(){var e=this._width*-this._anchor._x,t=this._height*-this._anchor._y,r=this._width*(1-this._anchor._x),n=this._height*(1-this._anchor._y);this._bounds.addFrame(this.transform,e,t,r,n)},n.prototype.getLocalBounds=function(t){return 0===this.children.length?(this._bounds.minX=this._width*-this._anchor._x,this._bounds.minY=this._height*-this._anchor._y,this._bounds.maxX=this._width*(1-this._anchor._x),this._bounds.maxY=this._height*(1-this._anchor._y),t||(this._localBoundsRect||(this._localBoundsRect=new r.Rectangle),t=this._localBoundsRect),this._bounds.getRectangle(t)):e.prototype.getLocalBounds.call(this,t)},n.prototype.containsPoint=function(e){this.worldTransform.applyInverse(e,s);var t=this._width,r=this._height,n=-t*this.anchor._x;if(s.x>=n&&s.x<n+t){var o=-r*this.anchor._y;if(s.y>=o&&s.y<o+r)return!0}return!1},n.prototype.destroy=function(t){e.prototype.destroy.call(this,t),this.tileTransform=null,this.uvMatrix=null},n.from=function(e,r){return new n(e instanceof t.Texture?e:t.Texture.from(e,r),r.width,r.height)},Object.defineProperty(n.prototype,"width",{get:function(){return this._width},set:function(e){this._width=e},enumerable:!1,configurable:!0}),Object.defineProperty(n.prototype,"height",{get:function(){return this._height},set:function(e){this._height=e},enumerable:!1,configurable:!0}),n}(n.Sprite),l="#version 100\n#define SHADER_NAME Tiling-Sprite-100\n\nprecision lowp float;\n\nattribute vec2 aVertexPosition;\nattribute vec2 aTextureCoord;\n\nuniform mat3 projectionMatrix;\nuniform mat3 translationMatrix;\nuniform mat3 uTransform;\n\nvarying vec2 vTextureCoord;\n\nvoid main(void)\n{\n    gl_Position = vec4((projectionMatrix * translationMatrix * vec3(aVertexPosition, 1.0)).xy, 0.0, 1.0);\n\n    vTextureCoord = (uTransform * vec3(aTextureCoord, 1.0)).xy;\n}\n",d=new r.Matrix,h=function(e){function r(r){var n=e.call(this,r)||this;return r.runners.contextChange.add(n),n.quad=new t.QuadUv,n.state=t.State.for2d(),n}return u(r,e),r.prototype.contextChange=function(){var e=this.renderer,r={globals:e.globalUniforms};this.simpleShader=t.Shader.from(l,"#version 100\n#define SHADER_NAME Tiling-Sprite-Simple-100\n\nprecision lowp float;\n\nvarying vec2 vTextureCoord;\n\nuniform sampler2D uSampler;\nuniform vec4 uColor;\n\nvoid main(void)\n{\n    vec4 texSample = texture2D(uSampler, vTextureCoord);\n    gl_FragColor = texSample * uColor;\n}\n",r),this.shader=e.context.webGLVersion>1?t.Shader.from("#version 300 es\n#define SHADER_NAME Tiling-Sprite-300\n\nprecision lowp float;\n\nin vec2 aVertexPosition;\nin vec2 aTextureCoord;\n\nuniform mat3 projectionMatrix;\nuniform mat3 translationMatrix;\nuniform mat3 uTransform;\n\nout vec2 vTextureCoord;\n\nvoid main(void)\n{\n    gl_Position = vec4((projectionMatrix * translationMatrix * vec3(aVertexPosition, 1.0)).xy, 0.0, 1.0);\n\n    vTextureCoord = (uTransform * vec3(aTextureCoord, 1.0)).xy;\n}\n","#version 300 es\n#define SHADER_NAME Tiling-Sprite-100\n\nprecision lowp float;\n\nin vec2 vTextureCoord;\n\nout vec4 fragmentColor;\n\nuniform sampler2D uSampler;\nuniform vec4 uColor;\nuniform mat3 uMapCoord;\nuniform vec4 uClampFrame;\nuniform vec2 uClampOffset;\n\nvoid main(void)\n{\n    vec2 coord = vTextureCoord + ceil(uClampOffset - vTextureCoord);\n    coord = (uMapCoord * vec3(coord, 1.0)).xy;\n    vec2 unclamped = coord;\n    coord = clamp(coord, uClampFrame.xy, uClampFrame.zw);\n\n    vec4 texSample = texture(uSampler, coord, unclamped == coord ? 0.0f : -32.0f);// lod-bias very negative to force lod 0\n\n    fragmentColor = texSample * uColor;\n}\n",r):t.Shader.from(l,"#version 100\n#ifdef GL_EXT_shader_texture_lod\n    #extension GL_EXT_shader_texture_lod : enable\n#endif\n#define SHADER_NAME Tiling-Sprite-100\n\nprecision lowp float;\n\nvarying vec2 vTextureCoord;\n\nuniform sampler2D uSampler;\nuniform vec4 uColor;\nuniform mat3 uMapCoord;\nuniform vec4 uClampFrame;\nuniform vec2 uClampOffset;\n\nvoid main(void)\n{\n    vec2 coord = vTextureCoord + ceil(uClampOffset - vTextureCoord);\n    coord = (uMapCoord * vec3(coord, 1.0)).xy;\n    vec2 unclamped = coord;\n    coord = clamp(coord, uClampFrame.xy, uClampFrame.zw);\n\n    #ifdef GL_EXT_shader_texture_lod\n        vec4 texSample = unclamped == coord\n            ? texture2D(uSampler, coord) \n            : texture2DLodEXT(uSampler, coord, 0);\n    #else\n        vec4 texSample = texture2D(uSampler, coord);\n    #endif\n\n    gl_FragColor = texSample * uColor;\n}\n",r)},r.prototype.render=function(e){var t=this.renderer,r=this.quad,n=r.vertices;n[0]=n[6]=e._width*-e.anchor.x,n[1]=n[3]=e._height*-e.anchor.y,n[2]=n[4]=e._width*(1-e.anchor.x),n[5]=n[7]=e._height*(1-e.anchor.y);var a=e.uvRespectAnchor?e.anchor.x:0,u=e.uvRespectAnchor?e.anchor.y:0;(n=r.uvs)[0]=n[6]=-a,n[1]=n[3]=-u,n[2]=n[4]=1-a,n[5]=n[7]=1-u,r.invalidate();var s=e._texture,c=s.baseTexture,l=e.tileTransform.localTransform,h=e.uvMatrix,p=c.isPowerOfTwo&&s.frame.width===c.width&&s.frame.height===c.height;p&&(c._glTextures[t.CONTEXT_UID]?p=c.wrapMode!==o.WRAP_MODES.CLAMP:c.wrapMode===o.WRAP_MODES.CLAMP&&(c.wrapMode=o.WRAP_MODES.REPEAT));var m=p?this.simpleShader:this.shader,f=s.width,v=s.height,_=e._width,x=e._height;d.set(l.a*f/_,l.b*f/x,l.c*v/_,l.d*v/x,l.tx/_,l.ty/x),d.invert(),p?d.prepend(h.mapCoord):(m.uniforms.uMapCoord=h.mapCoord.toArray(!0),m.uniforms.uClampFrame=h.uClampFrame,m.uniforms.uClampOffset=h.uClampOffset),m.uniforms.uTransform=d.toArray(!0),m.uniforms.uColor=i.premultiplyTintToRgba(e.tint,e.worldAlpha,m.uniforms.uColor,c.alphaMode),m.uniforms.translationMatrix=e.transform.worldTransform.toArray(!0),m.uniforms.uSampler=s,t.shader.bind(m),t.geometry.bind(r),this.state.blendMode=i.correctBlendMode(e.blendMode,c.alphaMode),t.state.set(this.state),t.geometry.draw(this.renderer.gl.TRIANGLES,6,0)},r}(t.ObjectRenderer);return e.TilingSprite=c,e.TilingSpriteRenderer=h,Object.defineProperty(e,"__esModule",{value:!0}),e}({},PIXI,PIXI,PIXI,PIXI,PIXI.utils);Object.assign(this.PIXI,_pixi_sprite_tiling);
//# sourceMappingURL=sprite-tiling.min.js.map
