definition module iTasks.Extensions.SVG.SVGEditor

from Data.GenEq import generic gEq
import Graphics.Scalable.Image
from Text.GenJSON import :: JSONNode, generic JSONEncode, generic JSONDecode
from iTasks.Internal.Generic.Visualization import :: TextFormat, generic gText
from iTasks.UI.Editor import :: Editor, :: EditorReport

//* An SVGEditor let's you specify an editor as an interactive SVG image (Graphics.Scalable.Image)
:: SVGEditor m v =
	{ initView    :: m -> v                      // Generate the view value from the current model value
	, renderImage :: m v *TagSource -> Image v   // Render an interactive image from the current model and view value
	, updModel    :: m v -> m                    // When the view is updated (using the interactive image), update the model
	}

/**
* Convert an `SVGEditor` specification to a regular Editor for use in interaction tasks.
* The read and write type of the editor is the "model" type of the `SVGEditor`
*/
fromSVGEditor :: !(SVGEditor m v) -> Editor m m | gEq{|*|}, gText{|*|}, JSONEncode{|*|}, JSONDecode{|*|}, TC m
