/*!
 * @pixi/accessibility - v6.3.0
 * Compiled Wed, 23 Mar 2022 18:58:56 UTC
 *
 * @pixi/accessibility is licensed under the MIT License.
 * http://www.opensource.org/licenses/mit-license
 */
"use strict";Object.defineProperty(exports,"__esModule",{value:!0});var display=require("@pixi/display"),utils=require("@pixi/utils"),accessibleTarget={accessible:!1,accessibleTitle:null,accessibleHint:null,tabIndex:0,_accessibleActive:!1,_accessibleDiv:null,accessibleType:"button",accessiblePointerEvents:"auto",accessibleChildren:!0,renderId:-1};display.DisplayObject.mixin(accessibleTarget);var KEY_CODE_TAB=9,DIV_TOUCH_SIZE=100,DIV_TOUCH_POS_X=0,DIV_TOUCH_POS_Y=0,DIV_TOUCH_ZINDEX=2,DIV_HOOK_SIZE=1,DIV_HOOK_POS_X=-1e3,DIV_HOOK_POS_Y=-1e3,DIV_HOOK_ZINDEX=2,AccessibilityManager=function(){function e(e){this.debug=!1,this._isActive=!1,this._isMobileAccessibility=!1,this.pool=[],this.renderId=0,this.children=[],this.androidUpdateCount=0,this.androidUpdateFrequency=500,this._hookDiv=null,(utils.isMobile.tablet||utils.isMobile.phone)&&this.createTouchHook();var t=document.createElement("div");t.style.width=DIV_TOUCH_SIZE+"px",t.style.height=DIV_TOUCH_SIZE+"px",t.style.position="absolute",t.style.top=DIV_TOUCH_POS_X+"px",t.style.left=DIV_TOUCH_POS_Y+"px",t.style.zIndex=DIV_TOUCH_ZINDEX.toString(),this.div=t,this.renderer=e,this._onKeyDown=this._onKeyDown.bind(this),this._onMouseMove=this._onMouseMove.bind(this),globalThis.addEventListener("keydown",this._onKeyDown,!1)}return Object.defineProperty(e.prototype,"isActive",{get:function(){return this._isActive},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"isMobileAccessibility",{get:function(){return this._isMobileAccessibility},enumerable:!1,configurable:!0}),e.prototype.createTouchHook=function(){var e=this,t=document.createElement("button");t.style.width=DIV_HOOK_SIZE+"px",t.style.height=DIV_HOOK_SIZE+"px",t.style.position="absolute",t.style.top=DIV_HOOK_POS_X+"px",t.style.left=DIV_HOOK_POS_Y+"px",t.style.zIndex=DIV_HOOK_ZINDEX.toString(),t.style.backgroundColor="#FF0000",t.title="select to enable accessibility for this content",t.addEventListener("focus",function(){e._isMobileAccessibility=!0,e.activate(),e.destroyTouchHook()}),document.body.appendChild(t),this._hookDiv=t},e.prototype.destroyTouchHook=function(){this._hookDiv&&(document.body.removeChild(this._hookDiv),this._hookDiv=null)},e.prototype.activate=function(){var e;this._isActive||(this._isActive=!0,globalThis.document.addEventListener("mousemove",this._onMouseMove,!0),globalThis.removeEventListener("keydown",this._onKeyDown,!1),this.renderer.on("postrender",this.update,this),null===(e=this.renderer.view.parentNode)||void 0===e||e.appendChild(this.div))},e.prototype.deactivate=function(){var e;this._isActive&&!this._isMobileAccessibility&&(this._isActive=!1,globalThis.document.removeEventListener("mousemove",this._onMouseMove,!0),globalThis.addEventListener("keydown",this._onKeyDown,!1),this.renderer.off("postrender",this.update),null===(e=this.div.parentNode)||void 0===e||e.removeChild(this.div))},e.prototype.updateAccessibleObjects=function(e){if(e.visible&&e.accessibleChildren){e.accessible&&e.interactive&&(e._accessibleActive||this.addChild(e),e.renderId=this.renderId);var t=e.children;if(t)for(var i=0;i<t.length;i++)this.updateAccessibleObjects(t[i])}},e.prototype.update=function(){var e=performance.now();if(!(utils.isMobile.android.device&&e<this.androidUpdateCount)&&(this.androidUpdateCount=e+this.androidUpdateFrequency,this.renderer.renderingToScreen)){this.renderer._lastObjectRendered&&this.updateAccessibleObjects(this.renderer._lastObjectRendered);var t=this.renderer.view.getBoundingClientRect(),i=t.left,s=t.top,n=t.width,o=t.height,r=this.renderer,l=r.width,a=r.height,c=r.resolution,d=n/l*c,h=o/a*c,u=this.div;u.style.left=i+"px",u.style.top=s+"px",u.style.width=l+"px",u.style.height=a+"px";for(var b=0;b<this.children.length;b++){var p=this.children[b];if(p.renderId!==this.renderId)p._accessibleActive=!1,utils.removeItems(this.children,b,1),this.div.removeChild(p._accessibleDiv),this.pool.push(p._accessibleDiv),p._accessibleDiv=null,b--;else{u=p._accessibleDiv;var v=p.hitArea,y=p.worldTransform;p.hitArea?(u.style.left=(y.tx+v.x*y.a)*d+"px",u.style.top=(y.ty+v.y*y.d)*h+"px",u.style.width=v.width*y.a*d+"px",u.style.height=v.height*y.d*h+"px"):(v=p.getBounds(),this.capHitArea(v),u.style.left=v.x*d+"px",u.style.top=v.y*h+"px",u.style.width=v.width*d+"px",u.style.height=v.height*h+"px",u.title!==p.accessibleTitle&&null!==p.accessibleTitle&&(u.title=p.accessibleTitle),u.getAttribute("aria-label")!==p.accessibleHint&&null!==p.accessibleHint&&u.setAttribute("aria-label",p.accessibleHint)),p.accessibleTitle===u.title&&p.tabIndex===u.tabIndex||(u.title=p.accessibleTitle,u.tabIndex=p.tabIndex,this.debug&&this.updateDebugHTML(u))}}this.renderId++}},e.prototype.updateDebugHTML=function(e){e.innerHTML="type: "+e.type+"</br> title : "+e.title+"</br> tabIndex: "+e.tabIndex},e.prototype.capHitArea=function(e){e.x<0&&(e.width+=e.x,e.x=0),e.y<0&&(e.height+=e.y,e.y=0);var t=this.renderer,i=t.width,s=t.height;e.x+e.width>i&&(e.width=i-e.x),e.y+e.height>s&&(e.height=s-e.y)},e.prototype.addChild=function(e){var t=this.pool.pop();t||((t=document.createElement("button")).style.width=DIV_TOUCH_SIZE+"px",t.style.height=DIV_TOUCH_SIZE+"px",t.style.backgroundColor=this.debug?"rgba(255,255,255,0.5)":"transparent",t.style.position="absolute",t.style.zIndex=DIV_TOUCH_ZINDEX.toString(),t.style.borderStyle="none",navigator.userAgent.toLowerCase().indexOf("chrome")>-1?t.setAttribute("aria-live","off"):t.setAttribute("aria-live","polite"),navigator.userAgent.match(/rv:.*Gecko\//)?t.setAttribute("aria-relevant","additions"):t.setAttribute("aria-relevant","text"),t.addEventListener("click",this._onClick.bind(this)),t.addEventListener("focus",this._onFocus.bind(this)),t.addEventListener("focusout",this._onFocusOut.bind(this))),t.style.pointerEvents=e.accessiblePointerEvents,t.type=e.accessibleType,e.accessibleTitle&&null!==e.accessibleTitle?t.title=e.accessibleTitle:e.accessibleHint&&null!==e.accessibleHint||(t.title="displayObject "+e.tabIndex),e.accessibleHint&&null!==e.accessibleHint&&t.setAttribute("aria-label",e.accessibleHint),this.debug&&this.updateDebugHTML(t),e._accessibleActive=!0,e._accessibleDiv=t,t.displayObject=e,this.children.push(e),this.div.appendChild(e._accessibleDiv),e._accessibleDiv.tabIndex=e.tabIndex},e.prototype._onClick=function(e){var t=this.renderer.plugins.interaction,i=e.target.displayObject,s=t.eventData;t.dispatchEvent(i,"click",s),t.dispatchEvent(i,"pointertap",s),t.dispatchEvent(i,"tap",s)},e.prototype._onFocus=function(e){e.target.getAttribute("aria-live")||e.target.setAttribute("aria-live","assertive");var t=this.renderer.plugins.interaction,i=e.target.displayObject,s=t.eventData;t.dispatchEvent(i,"mouseover",s)},e.prototype._onFocusOut=function(e){e.target.getAttribute("aria-live")||e.target.setAttribute("aria-live","polite");var t=this.renderer.plugins.interaction,i=e.target.displayObject,s=t.eventData;t.dispatchEvent(i,"mouseout",s)},e.prototype._onKeyDown=function(e){e.keyCode===KEY_CODE_TAB&&this.activate()},e.prototype._onMouseMove=function(e){0===e.movementX&&0===e.movementY||this.deactivate()},e.prototype.destroy=function(){this.destroyTouchHook(),this.div=null,globalThis.document.removeEventListener("mousemove",this._onMouseMove,!0),globalThis.removeEventListener("keydown",this._onKeyDown),this.pool=null,this.children=null,this.renderer=null},e}();exports.AccessibilityManager=AccessibilityManager,exports.accessibleTarget=accessibleTarget;
//# sourceMappingURL=accessibility.min.js.map
