/*!
 * @pixi/text-bitmap - v6.3.0
 * Compiled Wed, 23 Mar 2022 18:58:56 UTC
 *
 * @pixi/text-bitmap is licensed under the MIT License.
 * http://www.opensource.org/licenses/mit-license
 */
"use strict";Object.defineProperty(exports,"__esModule",{value:!0});var math=require("@pixi/math"),settings=require("@pixi/settings"),mesh=require("@pixi/mesh"),utils=require("@pixi/utils"),core=require("@pixi/core"),text=require("@pixi/text"),constants=require("@pixi/constants"),display=require("@pixi/display"),loaders=require("@pixi/loaders"),extendStatics=function(e,t){return(extendStatics=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var r in t)t.hasOwnProperty(r)&&(e[r]=t[r])})(e,t)};function __extends(e,t){function r(){this.constructor=e}extendStatics(e,t),e.prototype=null===t?Object.create(t):(r.prototype=t.prototype,new r)}var BitmapFontData=function(){return function(){this.info=[],this.common=[],this.page=[],this.char=[],this.kerning=[],this.distanceField=[]}}(),TextFormat=function(){function e(){}return e.test=function(e){return"string"==typeof e&&0===e.indexOf("info face=")},e.parse=function(e){var t=e.match(/^[a-z]+\s+.+$/gm),r={info:[],common:[],page:[],char:[],chars:[],kerning:[],kernings:[],distanceField:[]};for(var i in t){var n=t[i].match(/^[a-z]+/gm)[0],a=t[i].match(/[a-zA-Z]+=([^\s"']+|"([^"]*)")/gm),o={};for(var s in a){var h=a[s].split("="),l=h[0],u=h[1].replace(/"/gm,""),c=parseFloat(u),f=isNaN(c)?u:c;o[l]=f}r[n].push(o)}var d=new BitmapFontData;return r.info.forEach(function(e){return d.info.push({face:e.face,size:parseInt(e.size,10)})}),r.common.forEach(function(e){return d.common.push({lineHeight:parseInt(e.lineHeight,10)})}),r.page.forEach(function(e){return d.page.push({id:parseInt(e.id,10),file:e.file})}),r.char.forEach(function(e){return d.char.push({id:parseInt(e.id,10),page:parseInt(e.page,10),x:parseInt(e.x,10),y:parseInt(e.y,10),width:parseInt(e.width,10),height:parseInt(e.height,10),xoffset:parseInt(e.xoffset,10),yoffset:parseInt(e.yoffset,10),xadvance:parseInt(e.xadvance,10)})}),r.kerning.forEach(function(e){return d.kerning.push({first:parseInt(e.first,10),second:parseInt(e.second,10),amount:parseInt(e.amount,10)})}),r.distanceField.forEach(function(e){return d.distanceField.push({distanceRange:parseInt(e.distanceRange,10),fieldType:e.fieldType})}),d},e}(),XMLFormat=function(){function e(){}return e.test=function(e){return e instanceof XMLDocument&&e.getElementsByTagName("page").length&&null!==e.getElementsByTagName("info")[0].getAttribute("face")},e.parse=function(e){for(var t=new BitmapFontData,r=e.getElementsByTagName("info"),i=e.getElementsByTagName("common"),n=e.getElementsByTagName("page"),a=e.getElementsByTagName("char"),o=e.getElementsByTagName("kerning"),s=e.getElementsByTagName("distanceField"),h=0;h<r.length;h++)t.info.push({face:r[h].getAttribute("face"),size:parseInt(r[h].getAttribute("size"),10)});for(h=0;h<i.length;h++)t.common.push({lineHeight:parseInt(i[h].getAttribute("lineHeight"),10)});for(h=0;h<n.length;h++)t.page.push({id:parseInt(n[h].getAttribute("id"),10)||0,file:n[h].getAttribute("file")});for(h=0;h<a.length;h++){var l=a[h];t.char.push({id:parseInt(l.getAttribute("id"),10),page:parseInt(l.getAttribute("page"),10)||0,x:parseInt(l.getAttribute("x"),10),y:parseInt(l.getAttribute("y"),10),width:parseInt(l.getAttribute("width"),10),height:parseInt(l.getAttribute("height"),10),xoffset:parseInt(l.getAttribute("xoffset"),10),yoffset:parseInt(l.getAttribute("yoffset"),10),xadvance:parseInt(l.getAttribute("xadvance"),10)})}for(h=0;h<o.length;h++)t.kerning.push({first:parseInt(o[h].getAttribute("first"),10),second:parseInt(o[h].getAttribute("second"),10),amount:parseInt(o[h].getAttribute("amount"),10)});for(h=0;h<s.length;h++)t.distanceField.push({fieldType:s[h].getAttribute("fieldType"),distanceRange:parseInt(s[h].getAttribute("distanceRange"),10)});return t},e}(),XMLStringFormat=function(){function e(){}return e.test=function(e){if("string"==typeof e&&e.indexOf("<font>")>-1){var t=(new globalThis.DOMParser).parseFromString(e,"text/xml");return XMLFormat.test(t)}return!1},e.parse=function(e){var t=(new globalThis.DOMParser).parseFromString(e,"text/xml");return XMLFormat.parse(t)},e}(),formats=[TextFormat,XMLFormat,XMLStringFormat];function autoDetectFormat(e){for(var t=0;t<formats.length;t++)if(formats[t].test(e))return formats[t];return null}function generateFillStyle(e,t,r,i,n,a){var o,s=r.fill;if(!Array.isArray(s))return s;if(1===s.length)return s[0];var h=r.dropShadow?r.dropShadowDistance:0,l=r.padding||0,u=e.width/i-h-2*l,c=e.height/i-h-2*l,f=s.slice(),d=r.fillGradientStops.slice();if(!d.length)for(var p=f.length+1,g=1;g<p;++g)d.push(g/p);if(f.unshift(s[0]),d.unshift(0),f.push(s[s.length-1]),d.push(1),r.fillGradientType===text.TEXT_GRADIENT.LINEAR_VERTICAL){o=t.createLinearGradient(u/2,l,u/2,c+l);var m=0,x=(a.fontProperties.fontSize+r.strokeThickness)/c;for(g=0;g<n.length;g++)for(var v=a.lineHeight*g,y=0;y<f.length;y++){var b=v/c+("number"==typeof d[y]?d[y]:y/f.length)*x,_=Math.max(m,b);_=Math.min(_,1),o.addColorStop(_,f[y]),m=_}}else{o=t.createLinearGradient(l,c/2,u+l,c/2);var T=f.length+1,w=1;for(g=0;g<f.length;g++){var M=void 0;M="number"==typeof d[g]?d[g]:w/T,o.addColorStop(M,f[g]),w++}}return o}function drawGlyph(e,t,r,i,n,a,o){var s=r.text,h=r.fontProperties;t.translate(i,n),t.scale(a,a);var l=o.strokeThickness/2,u=-o.strokeThickness/2;if(t.font=o.toFontString(),t.lineWidth=o.strokeThickness,t.textBaseline=o.textBaseline,t.lineJoin=o.lineJoin,t.miterLimit=o.miterLimit,t.fillStyle=generateFillStyle(e,t,o,a,[s],r),t.strokeStyle=o.stroke,o.dropShadow){var c=o.dropShadowColor,f=utils.hex2rgb("number"==typeof c?c:utils.string2hex(c)),d=o.dropShadowBlur*a,p=o.dropShadowDistance*a;t.shadowColor="rgba("+255*f[0]+","+255*f[1]+","+255*f[2]+","+o.dropShadowAlpha+")",t.shadowBlur=d,t.shadowOffsetX=Math.cos(o.dropShadowAngle)*p,t.shadowOffsetY=Math.sin(o.dropShadowAngle)*p}else t.shadowColor="black",t.shadowBlur=0,t.shadowOffsetX=0,t.shadowOffsetY=0;o.stroke&&o.strokeThickness&&t.strokeText(s,l,u+r.lineHeight-h.descent),o.fill&&t.fillText(s,l,u+r.lineHeight-h.descent),t.setTransform(1,0,0,1,0,0),t.fillStyle="rgba(0, 0, 0, 0)"}function splitTextToCharacters(e){return Array.from?Array.from(e):e.split("")}function resolveCharacters(e){"string"==typeof e&&(e=[e]);for(var t=[],r=0,i=e.length;r<i;r++){var n=e[r];if(Array.isArray(n)){if(2!==n.length)throw new Error("[BitmapFont]: Invalid character range length, expecting 2 got "+n.length+".");var a=n[0].charCodeAt(0),o=n[1].charCodeAt(0);if(o<a)throw new Error("[BitmapFont]: Invalid character range.");for(var s=a,h=o;s<=h;s++)t.push(String.fromCharCode(s))}else t.push.apply(t,splitTextToCharacters(n))}if(0===t.length)throw new Error("[BitmapFont]: Empty set when resolving characters.");return t}function extractCharCode(e){return e.codePointAt?e.codePointAt(0):e.charCodeAt(0)}var BitmapFont=function(){function e(e,t,r){var i,n,a=e.info[0],o=e.common[0],s=e.page[0],h=e.distanceField[0],l=utils.getResolutionOfUrl(s.file),u={};this._ownsTextures=r,this.font=a.face,this.size=a.size,this.lineHeight=o.lineHeight/l,this.chars={},this.pageTextures=u;for(var c=0;c<e.page.length;c++){var f=e.page[c],d=f.id,p=f.file;u[d]=t instanceof Array?t[c]:t[p],(null==h?void 0:h.fieldType)&&"none"!==h.fieldType&&(u[d].baseTexture.alphaMode=constants.ALPHA_MODES.NO_PREMULTIPLIED_ALPHA)}for(c=0;c<e.char.length;c++){var g=e.char[c],m=(d=g.id,g.page),x=e.char[c],v=x.x,y=x.y,b=x.width,_=x.height,T=x.xoffset,w=x.yoffset,M=x.xadvance;v/=l,y/=l,b/=l,_/=l,T/=l,w/=l,M/=l;var F=new math.Rectangle(v+u[m].frame.x/l,y+u[m].frame.y/l,b,_);this.chars[d]={xOffset:T,yOffset:w,xAdvance:M,kerning:{},texture:new core.Texture(u[m].baseTexture,F),page:m}}for(c=0;c<e.kerning.length;c++){var S=e.kerning[c],C=S.first,P=S.second,A=S.amount;C/=l,P/=l,A/=l,this.chars[P]&&(this.chars[P].kerning[C]=A)}this.distanceFieldRange=null==h?void 0:h.distanceRange,this.distanceFieldType=null!==(n=null===(i=null==h?void 0:h.fieldType)||void 0===i?void 0:i.toLowerCase())&&void 0!==n?n:"none"}return e.prototype.destroy=function(){for(var e in this.chars)this.chars[e].texture.destroy(),this.chars[e].texture=null;for(var e in this.pageTextures)this._ownsTextures&&this.pageTextures[e].destroy(!0),this.pageTextures[e]=null;this.chars=null,this.pageTextures=null},e.install=function(t,r,i){var n;if(t instanceof BitmapFontData)n=t;else{var a=autoDetectFormat(t);if(!a)throw new Error("Unrecognized data format for font.");n=a.parse(t)}r instanceof core.Texture&&(r=[r]);var o=new e(n,r,i);return e.available[o.font]=o,o},e.uninstall=function(t){var r=e.available[t];if(!r)throw new Error("No font found named '"+t+"'");r.destroy(),delete e.available[t]},e.from=function(t,r,i){if(!t)throw new Error("[BitmapFont] Property `name` is required.");var n=Object.assign({},e.defaultOptions,i),a=n.chars,o=n.padding,s=n.resolution,h=n.textureWidth,l=n.textureHeight,u=resolveCharacters(a),c=r instanceof text.TextStyle?r:new text.TextStyle(r),f=h,d=new BitmapFontData;d.info[0]={face:c.fontFamily,size:c.fontSize},d.common[0]={lineHeight:c.fontSize};for(var p,g,m,x=0,v=0,y=0,b=[],_=0;_<u.length;_++){p||((p=document.createElement("canvas")).width=h,p.height=l,g=p.getContext("2d"),m=new core.BaseTexture(p,{resolution:s}),b.push(new core.Texture(m)),d.page.push({id:b.length-1,file:""}));var T=text.TextMetrics.measureText(u[_],c,!1,p),w=T.width,M=Math.ceil(T.height),F=Math.ceil(("italic"===c.fontStyle?2:1)*w);if(v>=l-M*s){if(0===v)throw new Error("[BitmapFont] textureHeight "+l+"px is too small for "+c.fontSize+"px fonts");--_,p=null,g=null,m=null,v=0,x=0,y=0}else if(y=Math.max(M+T.fontProperties.descent,y),F*s+x>=f)--_,v+=y*s,v=Math.ceil(v),x=0,y=0;else{drawGlyph(p,g,T,x,v,s,c);var S=extractCharCode(T.text);d.char.push({id:S,page:b.length-1,x:x/s,y:v/s,width:F,height:M,xoffset:0,yoffset:0,xadvance:Math.ceil(w-(c.dropShadow?c.dropShadowDistance:0)-(c.stroke?c.strokeThickness:0))}),x+=(F+2*o)*s,x=Math.ceil(x)}}_=0;for(var C=u.length;_<C;_++)for(var P=u[_],A=0;A<C;A++){var D=u[A],B=g.measureText(P).width,E=g.measureText(D).width,O=g.measureText(P+D).width-(B+E);O&&d.kerning.push({first:extractCharCode(P),second:extractCharCode(D),amount:O})}var I=new e(d,b,!0);return void 0!==e.available[t]&&e.uninstall(t),e.available[t]=I,I},e.ALPHA=[["a","z"],["A","Z"]," "],e.NUMERIC=[["0","9"]],e.ALPHANUMERIC=[["a","z"],["A","Z"],["0","9"]," "],e.ASCII=[[" ","~"]],e.defaultOptions={resolution:1,textureWidth:512,textureHeight:512,padding:4,chars:e.ALPHANUMERIC},e.available={},e}(),msdfFrag="// Pixi texture info\r\nvarying vec2 vTextureCoord;\r\nuniform sampler2D uSampler;\r\n\r\n// Tint\r\nuniform vec4 uColor;\r\n\r\n// on 2D applications fwidth is screenScale / glyphAtlasScale * distanceFieldRange\r\nuniform float uFWidth;\r\n\r\nvoid main(void) {\r\n\r\n  // To stack MSDF and SDF we need a non-pre-multiplied-alpha texture.\r\n  vec4 texColor = texture2D(uSampler, vTextureCoord);\r\n\r\n  // MSDF\r\n  float median = texColor.r + texColor.g + texColor.b -\r\n                  min(texColor.r, min(texColor.g, texColor.b)) -\r\n                  max(texColor.r, max(texColor.g, texColor.b));\r\n  // SDF\r\n  median = min(median, texColor.a);\r\n\r\n  float screenPxDistance = uFWidth * (median - 0.5);\r\n  float alpha = clamp(screenPxDistance + 0.5, 0.0, 1.0);\r\n\r\n  // NPM Textures, NPM outputs\r\n  gl_FragColor = vec4(uColor.rgb, uColor.a * alpha);\r\n\r\n}\r\n",msdfVert="// Mesh material default fragment\r\nattribute vec2 aVertexPosition;\r\nattribute vec2 aTextureCoord;\r\n\r\nuniform mat3 projectionMatrix;\r\nuniform mat3 translationMatrix;\r\nuniform mat3 uTextureMatrix;\r\n\r\nvarying vec2 vTextureCoord;\r\n\r\nvoid main(void)\r\n{\r\n    gl_Position = vec4((projectionMatrix * translationMatrix * vec3(aVertexPosition, 1.0)).xy, 0.0, 1.0);\r\n\r\n    vTextureCoord = (uTextureMatrix * vec3(aTextureCoord, 1.0)).xy;\r\n}\r\n",pageMeshDataDefaultPageMeshData=[],pageMeshDataMSDFPageMeshData=[],charRenderDataPool=[],BitmapText=function(e){function t(r,i){void 0===i&&(i={});var n=e.call(this)||this;n._tint=16777215;var a=Object.assign({},t.styleDefaults,i),o=a.align,s=a.tint,h=a.maxWidth,l=a.letterSpacing,u=a.fontName,c=a.fontSize;if(!BitmapFont.available[u])throw new Error('Missing BitmapFont "'+u+'"');return n._activePagesMeshData=[],n._textWidth=0,n._textHeight=0,n._align=o,n._tint=s,n._fontName=u,n._fontSize=c||BitmapFont.available[u].size,n._text=r,n._maxWidth=h,n._maxLineHeight=0,n._letterSpacing=l,n._anchor=new math.ObservablePoint(function(){n.dirty=!0},n,0,0),n._roundPixels=settings.settings.ROUND_PIXELS,n.dirty=!0,n._textureCache={},n}return __extends(t,e),t.prototype.updateText=function(){for(var e,t=BitmapFont.available[this._fontName],r=this._fontSize/t.size,i=new math.Point,n=[],a=[],o=[],s=splitTextToCharacters(this._text.replace(/(?:\r\n|\r)/g,"\n")||" "),h=this._maxWidth*t.size/this._fontSize,l="none"===t.distanceFieldType?pageMeshDataDefaultPageMeshData:pageMeshDataMSDFPageMeshData,u=null,c=0,f=0,d=0,p=-1,g=0,m=0,x=0,v=0,y=0;y<s.length;y++){var b=extractCharCode(R=s[y]);if(/(?:\s)/.test(R)&&(p=y,g=c,v++),"\r"!==R&&"\n"!==R){var _=t.chars[b];if(_){u&&_.kerning[u]&&(i.x+=_.kerning[u]);var T=charRenderDataPool.pop()||{texture:core.Texture.EMPTY,line:0,charCode:0,prevSpaces:0,position:new math.Point};T.texture=_.texture,T.line=d,T.charCode=b,T.position.x=i.x+_.xOffset+this._letterSpacing/2,T.position.y=i.y+_.yOffset,T.prevSpaces=v,n.push(T),c=T.position.x+Math.max(_.xAdvance,_.texture.orig.width),i.x+=_.xAdvance+this._letterSpacing,x=Math.max(x,_.yOffset+_.texture.height),u=b,-1!==p&&h>0&&i.x>h&&(++m,utils.removeItems(n,1+p-m,1+y-p),y=p,p=-1,a.push(g),o.push(n.length>0?n[n.length-1].prevSpaces:0),f=Math.max(f,g),d++,i.x=0,i.y+=t.lineHeight,u=null,v=0)}}else a.push(c),o.push(-1),f=Math.max(f,c),++d,++m,i.x=0,i.y+=t.lineHeight,u=null,v=0}var w=s[s.length-1];"\r"!==w&&"\n"!==w&&(/(?:\s)/.test(w)&&(c=g),a.push(c),f=Math.max(f,c),o.push(-1));var M=[];for(y=0;y<=d;y++){var F=0;"right"===this._align?F=f-a[y]:"center"===this._align?F=(f-a[y])/2:"justify"===this._align&&(F=o[y]<0?0:(f-a[y])/o[y]),M.push(F)}var S=n.length,C={},P=[],A=this._activePagesMeshData;for(y=0;y<A.length;y++)l.push(A[y]);for(y=0;y<S;y++){var D=(W=n[y].texture).baseTexture.uid;if(!C[D]){if(!(Z=l.pop())){var B=new mesh.MeshGeometry,E=void 0,O=void 0;"none"===t.distanceFieldType?(E=new mesh.MeshMaterial(core.Texture.EMPTY),O=constants.BLEND_MODES.NORMAL):(E=new mesh.MeshMaterial(core.Texture.EMPTY,{program:core.Program.from(msdfVert,msdfFrag),uniforms:{uFWidth:0}}),O=constants.BLEND_MODES.NORMAL_NPM);var I=new mesh.Mesh(B,E);I.blendMode=O,Z={index:0,indexCount:0,vertexCount:0,uvsCount:0,total:0,mesh:I,vertices:null,uvs:null,indices:null}}Z.index=0,Z.indexCount=0,Z.vertexCount=0,Z.uvsCount=0,Z.total=0;var L=this._textureCache;L[D]=L[D]||new core.Texture(W.baseTexture),Z.mesh.texture=L[D],Z.mesh.tint=this._tint,P.push(Z),C[D]=Z}C[D].total++}for(y=0;y<A.length;y++)-1===P.indexOf(A[y])&&this.removeChild(A[y].mesh);for(y=0;y<P.length;y++)P[y].mesh.parent!==this&&this.addChild(P[y].mesh);for(var y in this._activePagesMeshData=P,C){var k=(Z=C[y]).total;if(!((null===(e=Z.indices)||void 0===e?void 0:e.length)>6*k)||Z.vertices.length<2*mesh.Mesh.BATCHABLE_SIZE)Z.vertices=new Float32Array(8*k),Z.uvs=new Float32Array(8*k),Z.indices=new Uint16Array(6*k);else for(var N=Z.total,H=Z.vertices,z=4*N*2;z<H.length;z++)H[z]=0;Z.mesh.size=6*k}for(y=0;y<S;y++){var R,j=(R=n[y]).position.x+M[R.line]*("justify"===this._align?R.prevSpaces:1);this._roundPixels&&(j=Math.round(j));var W,U=j*r,X=R.position.y*r,q=C[(W=R.texture).baseTexture.uid],G=W.frame,Y=W._uvs,V=q.index++;q.indices[6*V+0]=0+4*V,q.indices[6*V+1]=1+4*V,q.indices[6*V+2]=2+4*V,q.indices[6*V+3]=0+4*V,q.indices[6*V+4]=2+4*V,q.indices[6*V+5]=3+4*V,q.vertices[8*V+0]=U,q.vertices[8*V+1]=X,q.vertices[8*V+2]=U+G.width*r,q.vertices[8*V+3]=X,q.vertices[8*V+4]=U+G.width*r,q.vertices[8*V+5]=X+G.height*r,q.vertices[8*V+6]=U,q.vertices[8*V+7]=X+G.height*r,q.uvs[8*V+0]=Y.x0,q.uvs[8*V+1]=Y.y0,q.uvs[8*V+2]=Y.x1,q.uvs[8*V+3]=Y.y1,q.uvs[8*V+4]=Y.x2,q.uvs[8*V+5]=Y.y2,q.uvs[8*V+6]=Y.x3,q.uvs[8*V+7]=Y.y3}for(var y in this._textWidth=f*r,this._textHeight=(i.y+t.lineHeight)*r,C){var Z=C[y];if(0!==this.anchor.x||0!==this.anchor.y)for(var $=0,J=this._textWidth*this.anchor.x,K=this._textHeight*this.anchor.y,Q=0;Q<Z.total;Q++)Z.vertices[$++]-=J,Z.vertices[$++]-=K,Z.vertices[$++]-=J,Z.vertices[$++]-=K,Z.vertices[$++]-=J,Z.vertices[$++]-=K,Z.vertices[$++]-=J,Z.vertices[$++]-=K;this._maxLineHeight=x*r;var ee=Z.mesh.geometry.getBuffer("aVertexPosition"),te=Z.mesh.geometry.getBuffer("aTextureCoord"),re=Z.mesh.geometry.getIndex();ee.data=Z.vertices,te.data=Z.uvs,re.data=Z.indices,ee.update(),te.update(),re.update()}for(y=0;y<n.length;y++)charRenderDataPool.push(n[y])},t.prototype.updateTransform=function(){this.validate(),this.containerUpdateTransform()},t.prototype._render=function(t){var r=BitmapFont.available[this._fontName],i=r.distanceFieldRange,n=r.distanceFieldType,a=r.size;if("none"!==n)for(var o=this.worldTransform,s=o.a,h=o.b,l=o.c,u=o.d,c=Math.sqrt(s*s+h*h),f=Math.sqrt(l*l+u*u),d=(Math.abs(c)+Math.abs(f))/2,p=this._fontSize/a,g=0,m=this._activePagesMeshData;g<m.length;g++){m[g].mesh.shader.uniforms.uFWidth=d*i*p*t.resolution}e.prototype._render.call(this,t)},t.prototype.getLocalBounds=function(){return this.validate(),e.prototype.getLocalBounds.call(this)},t.prototype.validate=function(){this.dirty&&(this.updateText(),this.dirty=!1)},Object.defineProperty(t.prototype,"tint",{get:function(){return this._tint},set:function(e){if(this._tint!==e){this._tint=e;for(var t=0;t<this._activePagesMeshData.length;t++)this._activePagesMeshData[t].mesh.tint=e}},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"align",{get:function(){return this._align},set:function(e){this._align!==e&&(this._align=e,this.dirty=!0)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"fontName",{get:function(){return this._fontName},set:function(e){if(!BitmapFont.available[e])throw new Error('Missing BitmapFont "'+e+'"');this._fontName!==e&&(this._fontName=e,this.dirty=!0)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"fontSize",{get:function(){return this._fontSize},set:function(e){this._fontSize!==e&&(this._fontSize=e,this.dirty=!0)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"anchor",{get:function(){return this._anchor},set:function(e){"number"==typeof e?this._anchor.set(e):this._anchor.copyFrom(e)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"text",{get:function(){return this._text},set:function(e){e=String(null==e?"":e),this._text!==e&&(this._text=e,this.dirty=!0)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"maxWidth",{get:function(){return this._maxWidth},set:function(e){this._maxWidth!==e&&(this._maxWidth=e,this.dirty=!0)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"maxLineHeight",{get:function(){return this.validate(),this._maxLineHeight},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"textWidth",{get:function(){return this.validate(),this._textWidth},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"letterSpacing",{get:function(){return this._letterSpacing},set:function(e){this._letterSpacing!==e&&(this._letterSpacing=e,this.dirty=!0)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"roundPixels",{get:function(){return this._roundPixels},set:function(e){e!==this._roundPixels&&(this._roundPixels=e,this.dirty=!0)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"textHeight",{get:function(){return this.validate(),this._textHeight},enumerable:!1,configurable:!0}),t.prototype.destroy=function(t){var r=this._textureCache;for(var i in r){r[i].destroy(),delete r[i]}this._textureCache=null,e.prototype.destroy.call(this,t)},t.styleDefaults={align:"left",tint:16777215,maxWidth:0,letterSpacing:0},t}(display.Container),BitmapFontLoader=function(){function e(){}return e.add=function(){loaders.LoaderResource.setExtensionXhrType("fnt",loaders.LoaderResource.XHR_RESPONSE_TYPE.TEXT)},e.use=function(t,r){var i=autoDetectFormat(t.data);if(i)for(var n=e.getBaseUrl(this,t),a=i.parse(t.data),o={},s=function(e){o[e.metadata.pageFile]=e.texture,Object.keys(o).length===a.page.length&&(t.bitmapFont=BitmapFont.install(a,o,!0),r())},h=0;h<a.page.length;++h){var l=a.page[h].file,u=n+l,c=!1;for(var f in this.resources){var d=this.resources[f];if(d.url===u){d.metadata.pageFile=l,d.texture?s(d):d.onAfterMiddleware.add(s),c=!0;break}}if(!c){var p={crossOrigin:t.crossOrigin,loadType:loaders.LoaderResource.LOAD_TYPE.IMAGE,metadata:Object.assign({pageFile:l},t.metadata.imageMetadata),parentResource:t};this.add(u,p,s)}}else r()},e.getBaseUrl=function(t,r){var i=r.isDataUrl?"":e.dirname(r.url);return r.isDataUrl&&("."===i&&(i=""),t.baseUrl&&i&&"/"===t.baseUrl.charAt(t.baseUrl.length-1)&&(i+="/")),(i=i.replace(t.baseUrl,""))&&"/"!==i.charAt(i.length-1)&&(i+="/"),i},e.dirname=function(e){var t=e.replace(/\\/g,"/").replace(/\/$/,"").replace(/\/[^\/]*$/,"");return t===e?".":""===t?"/":t},e}();exports.BitmapFont=BitmapFont,exports.BitmapFontData=BitmapFontData,exports.BitmapFontLoader=BitmapFontLoader,exports.BitmapText=BitmapText;
//# sourceMappingURL=text-bitmap.min.js.map
