/*!
 * @pixi/mesh - v6.3.0
 * Compiled Wed, 23 Mar 2022 18:58:56 UTC
 *
 * @pixi/mesh is licensed under the MIT License.
 * http://www.opensource.org/licenses/mit-license
 */
"use strict";Object.defineProperty(exports,"__esModule",{value:!0});var core=require("@pixi/core"),math=require("@pixi/math"),constants=require("@pixi/constants"),display=require("@pixi/display"),settings=require("@pixi/settings"),utils=require("@pixi/utils"),extendStatics=function(t,e){return(extendStatics=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var r in e)e.hasOwnProperty(r)&&(t[r]=e[r])})(t,e)};function __extends(t,e){function r(){this.constructor=t}extendStatics(t,e),t.prototype=null===e?Object.create(e):(r.prototype=e.prototype,new r)}var MeshBatchUvs=function(){function t(t,e){this.uvBuffer=t,this.uvMatrix=e,this.data=null,this._bufferUpdateId=-1,this._textureUpdateId=-1,this._updateID=0}return t.prototype.update=function(t){if(t||this._bufferUpdateId!==this.uvBuffer._updateID||this._textureUpdateId!==this.uvMatrix._updateID){this._bufferUpdateId=this.uvBuffer._updateID,this._textureUpdateId=this.uvMatrix._updateID;var e=this.uvBuffer.data;this.data&&this.data.length===e.length||(this.data=new Float32Array(e.length)),this.uvMatrix.multiplyUvs(e,this.data),this._updateID++}},t}(),tempPoint=new math.Point,tempPolygon=new math.Polygon,Mesh=function(t){function e(e,r,i,n){void 0===n&&(n=constants.DRAW_MODES.TRIANGLES);var o=t.call(this)||this;return o.geometry=e,o.shader=r,o.state=i||core.State.for2d(),o.drawMode=n,o.start=0,o.size=0,o.uvs=null,o.indices=null,o.vertexData=new Float32Array(1),o.vertexDirty=-1,o._transformID=-1,o._roundPixels=settings.settings.ROUND_PIXELS,o.batchUvs=null,o}return __extends(e,t),Object.defineProperty(e.prototype,"geometry",{get:function(){return this._geometry},set:function(t){this._geometry!==t&&(this._geometry&&(this._geometry.refCount--,0===this._geometry.refCount&&this._geometry.dispose()),this._geometry=t,this._geometry&&this._geometry.refCount++,this.vertexDirty=-1)},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"uvBuffer",{get:function(){return this.geometry.buffers[1]},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"verticesBuffer",{get:function(){return this.geometry.buffers[0]},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"material",{get:function(){return this.shader},set:function(t){this.shader=t},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"blendMode",{get:function(){return this.state.blendMode},set:function(t){this.state.blendMode=t},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"roundPixels",{get:function(){return this._roundPixels},set:function(t){this._roundPixels!==t&&(this._transformID=-1),this._roundPixels=t},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"tint",{get:function(){return"tint"in this.shader?this.shader.tint:null},set:function(t){this.shader.tint=t},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"texture",{get:function(){return"texture"in this.shader?this.shader.texture:null},set:function(t){this.shader.texture=t},enumerable:!1,configurable:!0}),e.prototype._render=function(t){var r=this.geometry.buffers[0].data;this.shader.batchable&&this.drawMode===constants.DRAW_MODES.TRIANGLES&&r.length<2*e.BATCHABLE_SIZE?this._renderToBatch(t):this._renderDefault(t)},e.prototype._renderDefault=function(t){var e=this.shader;e.alpha=this.worldAlpha,e.update&&e.update(),t.batch.flush(),e.uniforms.translationMatrix=this.transform.worldTransform.toArray(!0),t.shader.bind(e),t.state.set(this.state),t.geometry.bind(this.geometry,e),t.geometry.draw(this.drawMode,this.size,this.start,this.geometry.instanceCount)},e.prototype._renderToBatch=function(t){var e=this.geometry,r=this.shader;r.uvMatrix&&(r.uvMatrix.update(),this.calculateUvs()),this.calculateVertices(),this.indices=e.indexBuffer.data,this._tintRGB=r._tintRGB,this._texture=r.texture;var i=this.material.pluginName;t.batch.setObjectRenderer(t.plugins[i]),t.plugins[i].render(this)},e.prototype.calculateVertices=function(){var t=this.geometry.buffers[0],e=t.data,r=t._updateID;if(r!==this.vertexDirty||this._transformID!==this.transform._worldID){this._transformID=this.transform._worldID,this.vertexData.length!==e.length&&(this.vertexData=new Float32Array(e.length));for(var i=this.transform.worldTransform,n=i.a,o=i.b,a=i.c,s=i.d,u=i.tx,h=i.ty,l=this.vertexData,c=0;c<l.length/2;c++){var d=e[2*c],f=e[2*c+1];l[2*c]=n*d+a*f+u,l[2*c+1]=o*d+s*f+h}if(this._roundPixels){var p=settings.settings.RESOLUTION;for(c=0;c<l.length;++c)l[c]=Math.round((l[c]*p|0)/p)}this.vertexDirty=r}},e.prototype.calculateUvs=function(){var t=this.geometry.buffers[1],e=this.shader;e.uvMatrix.isSimple?this.uvs=t.data:(this.batchUvs||(this.batchUvs=new MeshBatchUvs(t,e.uvMatrix)),this.batchUvs.update(),this.uvs=this.batchUvs.data)},e.prototype._calculateBounds=function(){this.calculateVertices(),this._bounds.addVertexData(this.vertexData,0,this.vertexData.length)},e.prototype.containsPoint=function(t){if(!this.getBounds().contains(t.x,t.y))return!1;this.worldTransform.applyInverse(t,tempPoint);for(var e=this.geometry.getBuffer("aVertexPosition").data,r=tempPolygon.points,i=this.geometry.getIndex().data,n=i.length,o=4===this.drawMode?3:1,a=0;a+2<n;a+=o){var s=2*i[a],u=2*i[a+1],h=2*i[a+2];if(r[0]=e[s],r[1]=e[s+1],r[2]=e[u],r[3]=e[u+1],r[4]=e[h],r[5]=e[h+1],tempPolygon.contains(tempPoint.x,tempPoint.y))return!0}return!1},e.prototype.destroy=function(e){t.prototype.destroy.call(this,e),this._cachedTexture&&(this._cachedTexture.destroy(),this._cachedTexture=null),this.geometry=null,this.shader=null,this.state=null,this.uvs=null,this.indices=null,this.vertexData=null},e.BATCHABLE_SIZE=100,e}(display.Container),fragment="varying vec2 vTextureCoord;\nuniform vec4 uColor;\n\nuniform sampler2D uSampler;\n\nvoid main(void)\n{\n    gl_FragColor = texture2D(uSampler, vTextureCoord) * uColor;\n}\n",vertex="attribute vec2 aVertexPosition;\nattribute vec2 aTextureCoord;\n\nuniform mat3 projectionMatrix;\nuniform mat3 translationMatrix;\nuniform mat3 uTextureMatrix;\n\nvarying vec2 vTextureCoord;\n\nvoid main(void)\n{\n    gl_Position = vec4((projectionMatrix * translationMatrix * vec3(aVertexPosition, 1.0)).xy, 0.0, 1.0);\n\n    vTextureCoord = (uTextureMatrix * vec3(aTextureCoord, 1.0)).xy;\n}\n",MeshMaterial=function(t){function e(e,r){var i=this,n={uSampler:e,alpha:1,uTextureMatrix:math.Matrix.IDENTITY,uColor:new Float32Array([1,1,1,1])};return(r=Object.assign({tint:16777215,alpha:1,pluginName:"batch"},r)).uniforms&&Object.assign(n,r.uniforms),(i=t.call(this,r.program||core.Program.from(vertex,fragment),n)||this)._colorDirty=!1,i.uvMatrix=new core.TextureMatrix(e),i.batchable=void 0===r.program,i.pluginName=r.pluginName,i.tint=r.tint,i.alpha=r.alpha,i}return __extends(e,t),Object.defineProperty(e.prototype,"texture",{get:function(){return this.uniforms.uSampler},set:function(t){this.uniforms.uSampler!==t&&(this.uniforms.uSampler=t,this.uvMatrix.texture=t)},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"alpha",{get:function(){return this._alpha},set:function(t){t!==this._alpha&&(this._alpha=t,this._colorDirty=!0)},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"tint",{get:function(){return this._tint},set:function(t){t!==this._tint&&(this._tint=t,this._tintRGB=(t>>16)+(65280&t)+((255&t)<<16),this._colorDirty=!0)},enumerable:!1,configurable:!0}),e.prototype.update=function(){if(this._colorDirty){this._colorDirty=!1;var t=this.texture.baseTexture;utils.premultiplyTintToRgba(this._tint,this._alpha,this.uniforms.uColor,t.alphaMode)}this.uvMatrix.update()&&(this.uniforms.uTextureMatrix=this.uvMatrix.mapCoord)},e}(core.Shader),MeshGeometry=function(t){function e(e,r,i){var n=t.call(this)||this,o=new core.Buffer(e),a=new core.Buffer(r,!0),s=new core.Buffer(i,!0,!0);return n.addAttribute("aVertexPosition",o,2,!1,constants.TYPES.FLOAT).addAttribute("aTextureCoord",a,2,!1,constants.TYPES.FLOAT).addIndex(s),n._updateId=-1,n}return __extends(e,t),Object.defineProperty(e.prototype,"vertexDirtyId",{get:function(){return this.buffers[0]._updateID},enumerable:!1,configurable:!0}),e}(core.Geometry);exports.Mesh=Mesh,exports.MeshBatchUvs=MeshBatchUvs,exports.MeshGeometry=MeshGeometry,exports.MeshMaterial=MeshMaterial;
//# sourceMappingURL=mesh.min.js.map
