definition module System._Linux

from System._Pointer import :: Pointer

//* https://man7.org/linux/man-pages/man2/sendfile.2.html
sendfile :: !Int !Int !Pointer !Int !*env -> (!Int, !*env)

//* https://man7.org/linux/man-pages/man3/ftruncate.3p.html
ftruncate :: !Int !Int !*env -> (!Int, !*env)

PR_SET_PDEATHSIG :== 1

//* Change the capacity of a pipe (see https://man7.org/linux/man-pages/man2/fcntl.2.html).
F_SETPIPE_SZ :== 1031

/**
 * Control process execution. See `man prctl`. This function is Linux-specific.
 *
 * This is the version with one argument besides the `option`.
 */
prctl1 :: !Int !Int !*env -> *(!Int, !*env)

//* https://man7.org/linux/man-pages/man3/get_nprocs_conf.3.html
get_nprocs :: !*env -> (!Int, !*env)
