""" Unit test for re module"""
import unittest
import re

class ReTests(unittest.TestCase):
    def test_findall(self):
        #Skulpt is failing all the commented out tests in test_findall and it shouldn't be
        val = re.findall("From","dlkjdsljkdlkdsjlk")
        self.assertEqual(len(val), 0)
        val = re.findall("From","dlkjd From kdsjlk")
        self.assertEqual(len(val), 1)
        val = re.findall("From","From dlkjd From kdsjlk")
        self.assertEqual(len(val), 2)
        val = re.findall("[0-9]+/[0-9]+","1/2 1/3 3/4 1/8 fred 10/0")
        self.assertEqual(len(val), 5)
        a = re.findall(string="A stitch in time saves nine.", flags=re.IGNORECASE, pattern="a")
        self.assertEqual(a, ['A', 'a'])
        a = re.findall("[a-z]*ei[a-z]*", "Is Dr. Greiner your friend, Julie?", re.IGNORECASE)
        self.assertEqual(a, ['Greiner'])
        b = re.findall("[a-z]*(ei|ie)[a-z]*", "Is Dr. Greiner your friend, Julie?", re.IGNORECASE)
        self.assertEqual(b, ['ei', 'ie', 'ie'])
        c = re.findall("[a-z]*(ei|ie)([a-z]*)", "Is Dr. Greiner your friend, Julie?", re.IGNORECASE)
        self.assertEqual(c, [('ei', 'ner'), ('ie', 'nd'), ('ie', '')])
        d = re.findall("[a-z]*(?:ei|ie)[a-z]*", "Is Dr. Greiner your friend, Julie?", re.IGNORECASE)

        self.assertEqual(d, ['Greiner', 'friend', 'Julie'])
        self.assertEqual(re.findall('\w+', "Words, words, words."), ['Words', 'words', 'words'])
        self.assertEqual(re.findall('(abc)(def)', 'abcdef'), [('abc', 'def')])
        self.assertEqual(re.findall('(abc)(def)', 'abcdefabcdefjaabcdef3sabc'), [('abc', 'def'), ('abc', 'def'), ('abc', 'def')])
        self.assertEqual(re.findall('(abc)', 'abcdef'), ['abc'])
        self.assertEqual(re.findall('(abc)|(def)', 'abcdefabcdefjaabcdef3sabc'), [('abc', ''), ('', 'def'), ('abc', ''), ('', 'def'), ('abc', ''), ('', 'def'), ('abc', '')])
        self.assertEqual(re.findall("^\s*$", ""), [''])
        #self.assertEqual(re.findall("\s*|a", "   a  b"), ['   ', '', 'a', '  ', '', ''])
        self.assertEqual(re.findall("a|\s*", "   a  b"), ['   ', 'a', '  ', '', ''])
        #self.assertEqual(re.findall("\s*|a", "   ba  b"), ['   ', '', '', 'a', '  ', '', ''])
        self.assertEqual(re.findall("a|\s*", "   ba  b"), ['   ', '', 'a', '  ', '', ''])

        self.assertEqual(re.findall(".",""), [])
        self.assertEqual(re.findall(".","a"), ['a'])
        self.assertEqual(re.findall(".a","a"), [])
        self.assertEqual(re.findall("a","a"), ['a'])
        self.assertEqual(re.findall("a.","a\n"), [])
        self.assertEqual(re.findall(".a","ba"), ['ba'])

        self.assertEqual(re.findall("^",""), [''])
        self.assertEqual(re.findall("a^",""), [])
        self.assertEqual(re.findall("^a","ba"), [])
        self.assertEqual(re.findall("^a","ab"), ['a'])
        self.assertEqual(re.findall("^a","\na"), [])
        self.assertEqual(re.findall("a^","a"), [])

        self.assertEqual(re.findall("$",""), [''])
        self.assertEqual(re.findall("$a","a"), [])
        self.assertEqual(re.findall("a$","a"), ['a'])
        self.assertEqual(re.findall("a$","ab"), [])
        self.assertEqual(re.findall("a$","a\nb"), [])
        self.assertEqual(re.findall("a$","a\n"), ['a'])

        self.assertEqual(re.findall("a*",""), [''])
        self.assertEqual(re.findall("ab*","a"), ['a'])
        self.assertEqual(re.findall("ab*","ab"), ['ab'])
        self.assertEqual(re.findall("ab*","abbbbb"), ['abbbbb'])
        self.assertEqual(re.findall("ab*","ba"), ['a'])
        self.assertEqual(re.findall("ab*","bbbb"), [])

        self.assertEqual(re.findall("a+",""), [])
        self.assertEqual(re.findall("ab+","a"), [])
        self.assertEqual(re.findall("ab+","ab"), ['ab'])
        self.assertEqual(re.findall("ab+","abbbbb"), ['abbbbb'])
        self.assertEqual(re.findall("ab+","ba"), [])
        self.assertEqual(re.findall("ab+","bbbb"), [])

        self.assertEqual(re.findall("a?",""), [''])
        self.assertEqual(re.findall("ab?","a"), ['a'])
        self.assertEqual(re.findall("ab?","ab"), ['ab'])
        self.assertEqual(re.findall("ab?","abbbbb"), ['ab'])
        self.assertEqual(re.findall("ab?","ba"), ['a'])
        self.assertEqual(re.findall("ab?","bbbb"), [])

        #self.assertEqual(re.findall("a*?","a"), ['', 'a', ''])
        self.assertEqual(re.findall("ab*?","abbbb"), ['a'])
        self.assertEqual(re.findall("ab*?","a"), ['a'])
        self.assertEqual(re.findall("ab*?",""), [])

        self.assertEqual(re.findall("a+?","a"), ['a'])
        self.assertEqual(re.findall("ab+?","abbbb"), ['ab'])
        self.assertEqual(re.findall("ab+?","a"), [])
        self.assertEqual(re.findall("ab+?",""), [])

        #self.assertEqual(re.findall("a??","a"), ['', 'a', ''])
        self.assertEqual(re.findall("ab??","abbbb"), ['a'])
        self.assertEqual(re.findall("ab??","a"), ['a'])
        self.assertEqual(re.findall("ab??",""), [])

        self.assertEqual(re.findall("a{2}","a"), [])
        self.assertEqual(re.findall("a{2}","aa"), ['aa'])
        self.assertEqual(re.findall("a{2}","aaa"), ['aa'])

        self.assertEqual(re.findall("a{1,2}b","b"), [])
        self.assertEqual(re.findall("a{1,2}b","ab"), ['ab'])
        self.assertEqual(re.findall("a{1,2}b","aab"), ['aab'])
        self.assertEqual(re.findall("a{1,2}b","aaab"), ['aab'])
        self.assertEqual(re.findall("a{,2}b","b"), ['b'])
        self.assertEqual(re.findall("a{,2}b","ab"), ['ab'])
        self.assertEqual(re.findall("a{,2}b","aab"), ['aab'])
        self.assertEqual(re.findall("a{,2}b","aaab"), ['aab'])
        self.assertEqual(re.findall("a{2,}b","b"), [])
        self.assertEqual(re.findall("a{2,}b","ab"), [])
        self.assertEqual(re.findall("a{2,}b","aab"), ['aab'])
        self.assertEqual(re.findall("a{2,}b","aaab"), ['aaab'])
        self.assertEqual(re.findall("a{3,5}","aaaaaaaaaa"), ['aaaaa', 'aaaaa'])
        self.assertEqual(re.findall("a{,5}","aaaaaaaaaa"), ['aaaaa', 'aaaaa', ''])
        self.assertEqual(re.findall("a{3,}","aaaaaaaaaa"), ['aaaaaaaaaa'])

        self.assertEqual(re.findall("a{1,2}?b","b"), [])
        self.assertEqual(re.findall("a{1,2}?b","ab"), ['ab'])
        self.assertEqual(re.findall("a{1,2}?b","aab"), ['aab'])
        self.assertEqual(re.findall("a{1,2}?b","aaab"), ['aab'])
        self.assertEqual(re.findall("a{,2}?b","b"), ['b'])
        self.assertEqual(re.findall("a{,2}?b","ab"), ['ab'])
        self.assertEqual(re.findall("a{,2}?b","aab"), ['aab'])
        self.assertEqual(re.findall("a{,2}?b","aaab"), ['aab'])
        self.assertEqual(re.findall("a{2,}?b","b"), [])
        self.assertEqual(re.findall("a{2,}?b","ab"), [])
        self.assertEqual(re.findall("a{2,}?b","aab"), ['aab'])
        self.assertEqual(re.findall("a{2,}?b","aaab"), ['aaab'])
        self.assertEqual(re.findall("a{3,5}?","aaaaaaaaaa"), ['aaa', 'aaa', 'aaa'])
        #self.assertEqual(re.findall("a{,5}?","aaaaaaaaaa"), ['', 'a', '', 'a', '', 'a', '', 'a', '', 'a', '', 'a', '', 'a', '', 'a', '', 'a', '', 'a', ''])
        self.assertEqual(re.findall("a{3,}?","aaaaaaaaaa"), ['aaa', 'aaa', 'aaa'])

        self.assertEqual(re.findall("[a,b,c]","abc"), ['a', 'b', 'c'])
        self.assertEqual(re.findall("[a-z]","bc"), ['b', 'c'])
        self.assertEqual(re.findall("[A-Z,0-9]","abcdefg"), [])
        self.assertEqual(re.findall("[^A-Z]","ABCDEFGaHIJKL"), ['a'])
        self.assertEqual(re.findall("[a*bc]","*"), ['*'])

        self.assertEqual(re.findall("|",""), [''])
        self.assertEqual(re.findall("|a",""), [''])
        self.assertEqual(re.findall("a|b","ba"), ['b', 'a'])
        self.assertEqual(re.findall("h|ello","hello"), ['h', 'ello'])

        self.assertEqual(re.findall("(b*)","bbbba"), ['bbbb', '', ''])

        self.assertEqual(re.findall("(?:b*)","bbbba"), ['bbbb', '', ''])
        self.assertEqual(re.findall("a(?=b)","a"), [])
        self.assertEqual(re.findall("a(?=b)","ab"), ['a'])
        self.assertEqual(re.findall("a(?!b)","a"), ['a'])
        self.assertEqual(re.findall("a(?!b)","ab"), [])

        pattern = r"\n"
        self.assertEqual(re.findall(pattern, "\n"), ['\n'])
        self.assertEqual(re.findall(pattern, "\n\n"), ['\n', '\n'])
        self.assertEqual(re.findall(pattern, "x\nx"), ['\n'])
        self.assertEqual(re.findall(pattern, "x\nx\n"), ['\n', '\n'])
        pattern = r"\t"
        self.assertEqual(re.findall(pattern, "\t"), ['\t'])
        self.assertEqual(re.findall(pattern, "\t\t"), ['\t', '\t'])
        self.assertEqual(re.findall(pattern, "x\tx"), ['\t'])
        self.assertEqual(re.findall(pattern, "x\tx\t"), ['\t', '\t'])

        # issue1148
        self.assertEqual(re.findall(r"[^c|p]at", r"mat cat hat pat"), ['mat', 'hat'])


    def test_search(self):
        val = re.search("From","dlkjdsljkdlkdsjlk")
        self.assertEqual(val, None)
        val = re.search("From","dlkjd From kdsjlk")
        self.assertTrue(val is not None)
        val = re.search("From","From dlkjd From kdsjlk")
        self.assertTrue(val is not None)
        def helper(match,expected):
            if type(expected) == str:
                if match:
                    if match.group(0)==expected: return True
                    else: return False
                else: return False
            else:
                if match: return True == expected
                else: return False == expected
        self.assertTrue(helper(re.search(".",""),False))
        self.assertTrue(helper(re.search(".","a"),True))
        self.assertTrue(helper(re.search(".a","a"),False))
        self.assertTrue(helper(re.search("a","a"),True))
        self.assertTrue(helper(re.search("a.","a\n"),False))
        self.assertTrue(helper(re.search(".a","ba"),True))
        self.assertTrue(helper(re.search("^",""),True))
        self.assertTrue(helper(re.search("a^",""),False))
        self.assertTrue(helper(re.search("^a","ba"),False))
        self.assertTrue(helper(re.search("^a","ab"),True))
        self.assertTrue(helper(re.search("^a","\na"),False))
        self.assertTrue(helper(re.search("a^","a"),False))
        self.assertTrue(helper(re.search("$",""),True))
        self.assertTrue(helper(re.search("$a","a"),False))
        self.assertTrue(helper(re.search("a$","a"),True))
        self.assertTrue(helper(re.search("a$","ab"),False))
        self.assertTrue(helper(re.search("a$","a\nb"),False))
        self.assertTrue(helper(re.search("a$","a\n"),True))
        self.assertTrue(helper(re.search("a*",""),""))
        self.assertTrue(helper(re.search("ab*","a"),"a"))
        self.assertTrue(helper(re.search("ab*","ab"),"ab"))
        self.assertTrue(helper(re.search("ab*","abbbbb"),"abbbbb"))
        self.assertTrue(helper(re.search("ab*","ba"),"a"))
        self.assertTrue(helper(re.search("ab*","bbbb"),False))
        self.assertTrue(helper(re.search("a+",""),False))
        self.assertTrue(helper(re.search("ab+","a"),False))
        self.assertTrue(helper(re.search("ab+","ab"),"ab"))
        self.assertTrue(helper(re.search("ab+","abbbbb"),"abbbbb"))
        self.assertTrue(helper(re.search("ab+","ba"),False))
        self.assertTrue(helper(re.search("ab+","bbbb"),False))
        self.assertTrue(helper(re.search("a?",""),""))
        self.assertTrue(helper(re.search("ab?","a"),"a"))
        self.assertTrue(helper(re.search("ab?","ab"),"ab"))
        self.assertTrue(helper(re.search("ab?","abbbbb"),"ab"))
        self.assertTrue(helper(re.search("ab?","ba"),"a"))
        self.assertTrue(helper(re.search("ab?","bbbb"),False))
        self.assertTrue(helper(re.search("a*?","a"),""))
        self.assertTrue(helper(re.search("ab*?","abbbb"),"a"))
        self.assertTrue(helper(re.search("ab*?","a"),"a"))
        self.assertTrue(helper(re.search("ab*?",""),False))
        self.assertTrue(helper(re.search("a+?","a"),"a"))
        self.assertTrue(helper(re.search("ab+?","abbbb"),"ab"))
        self.assertTrue(helper(re.search("ab+?","a"),False))
        self.assertTrue(helper(re.search("ab+?",""),False))
        self.assertTrue(helper(re.search("a??","a"),""))
        self.assertTrue(helper(re.search("ab??","abbbb"),"a"))
        self.assertTrue(helper(re.search("ab??","a"),"a"))
        self.assertTrue(helper(re.search("ab??",""),False))
        self.assertTrue(helper(re.search("a{2}","a"),False))
        self.assertTrue(helper(re.search("a{2}","aa"),"aa"))
        self.assertTrue(helper(re.search("a{2}","aaa"),"aa"))
        self.assertTrue(helper(re.search("a{1,2}b","b"),False))
        self.assertTrue(helper(re.search("a{1,2}b","ab"),"ab"))
        self.assertTrue(helper(re.search("a{1,2}b","aab"),"aab"))
        self.assertTrue(helper(re.search("a{1,2}b","aaab"),"aab"))
        self.assertTrue(helper(re.search("a{,2}b","b"),"b"))
        self.assertTrue(helper(re.search("a{,2}b","ab"),"ab"))
        self.assertTrue(helper(re.search("a{,2}b","aab"),"aab"))
        self.assertTrue(helper(re.search("a{,2}b","aaab"),"aab"))
        self.assertTrue(helper(re.search("a{2,}b","b"),False))
        self.assertTrue(helper(re.search("a{2,}b","ab"),False))
        self.assertTrue(helper(re.search("a{2,}b","aab"),"aab"))
        self.assertTrue(helper(re.search("a{2,}b","aaab"),"aaab"))
        self.assertTrue(helper(re.search("a{3,5}","aaaaaaaaaa"),"aaaaa"))
        self.assertTrue(helper(re.search("a{,5}","aaaaaaaaaa"),"aaaaa"))
        self.assertTrue(helper(re.search("a{3,}","aaaaaaaaaa"),"aaaaaaaaaa"))
        self.assertTrue(helper(re.search("[a,b,c]","abc"),"a"))
        self.assertTrue(helper(re.search("[a-z]","bc"),"b"))
        self.assertTrue(helper(re.search("[A-Z,0-9]","abcdefg"),False))
        self.assertTrue(helper(re.search("[^A-Z]","ABCDEFGaHIJKL"),"a"))
        self.assertTrue(helper(re.search("[a*bc]","*"),"*"))
        self.assertTrue(helper(re.search("|",""),""))
        self.assertTrue(helper(re.search("|a",""),""))
        self.assertTrue(helper(re.search("a|b","ba"),"b"))
        self.assertTrue(helper(re.search("h|ello","hello"),"h"))
        self.assertTrue(helper(re.search("(?:b*)","bbbba"),'bbbb'))
        self.assertTrue(helper(re.search("a(?=b)","a"),False))
        self.assertTrue(helper(re.search("a(?=b)","ab"),"a"))
        self.assertTrue(helper(re.search("a(?!b)","a"),"a"))
        self.assertTrue(helper(re.search("a(?!b)","ab"),False))

    def test_match(self):
        val = re.match("From","dlkjdsljkdlkdsjlk")
        self.assertEqual(val, None)
        val = re.match("From","dlkjd From kdsjlk")
        self.assertTrue(val is None)
        val = re.match("From","From dlkjd From kdsjlk")
        self.assertTrue(val is not None)

    def test_groups(self):
        m = re.match('([0-9]+)([a-z]+)','345abu')
        self.assertEqual(m.groups(), ('345', 'abu'))
        self.assertEqual(m.group(0), "345abu")
        self.assertEqual(m.group(1), "345")
        self.assertEqual(m.group(2), "abu")
        m = re.match('([0-9]+)([a-z]+)([A-Z]*)','345abu')
        self.assertEqual(m.groups('default'), tuple(['345','abu','']))

    def test_split(self):
        a = re.split("a", "A stitch in time saves nine.", flags=re.IGNORECASE)
        self.assertEqual(a, ['', ' stitch in time s', 'ves nine.'])
        self.assertEqual(re.split("\W+", "Words, words, words."), ['Words', 'words', 'words', ''])
        self.assertEqual(re.split("(\W+)", "Words, words, words."), ['Words', ', ', 'words', ', ', 'words', '.', ''])
        self.assertEqual(re.split("\W+", "Words, words, words.", 1), ['Words', 'words, words.'])
        self.assertEqual(re.split('[a-f]+', '0a3B9', 0, re.IGNORECASE), ['0', '3', '9'])
        self.assertEqual(re.split("(\W+)", '...words, words...'), ['', '...', 'words', ', ', 'words', '...', ''])
        #Skulpt fails the test below and it shouldn't
        #self.assertEqual(re.split('x*', 'foo'), ['', 'f', 'o', 'o', ''])

if __name__ == '__main__':
    unittest.main()

