definition module Debug.StackTrace

/**
 * This module provides functions to adjust the stack trace functionality.
 * NB: this module can only be imported while stack tracing is enabled.
 * Stack tracing can be enabled in the .prj file of the project by enabling both(!) the Stack and Time options.
 */

/**
 * Sets a custom stack trace depth, when a program crashes, the provided number of stack frames are written to stderr.
 * Typical usage:
 *    #! world = setStackTraceDepth 42 world
 * Use strictness to ensure the function is evaluated.
 *
 * @param The number of stack frames that should be printed in the stack trace.
 * @param An environment.
 * @result The environment
 */
setStackTraceDepth :: !Int !.env -> .env
