implementation module Incidone.RoleBased.WatchOfficerTasks

import iTasks, Data.Tuple, Data.Either, Data.Functor, Text
import qualified Data.Map

import Incidone.OP.Concepts, Incidone.OP.SDSs, Incidone.OP.Conversions
import Incidone.OP.IncidentManagementTasks, Incidone.OP.ContactManagementTasks, Incidone.OP.CommunicationManagementTasks
import Incidone.ActionManagementTasks
import Incidone.Util.TaskPatterns

keepWatch :: [Workspace -> Task ()]
keepWatch =	[browseCommunications,browseIncidents,browseContacts,browseActions]

/*
* The communication dashboard shows all ongoing communication.
*/
browseCommunications :: Workspace -> Task ()
browseCommunications ws
    =   selectCommunication
    >^* [OnAction (Action "/Add/Phone/Answer call")    (always createAndAnswerPhoneCall)
		,OnAction (Action "/Add/Phone/Initiate call")  (always createAndInitiatePhoneCall)
		,OnAction (Action "/Add/Radio/Answer call")	   (always createAndAnswerRadioCall)
		,OnAction (Action "/Add/Radio/Initiate call")  (always createAndInitiateRadioCall)
		,OnAction (Action "/Add/E-mail/Send message")  (always createAndComposeEmailMessage)
		,OnAction (Action "/Add/P2000/Send message")   (always createAndComposeP2000Message)
		,OnAction (Action "/Open")                     (hasValue (openCommunication ws))
        ] @! ()
where
	selectCommunication
        = Icon "communication" @>> Title "Communication" @>> enterChoiceWithSharedAs [ChooseFromGrid id] allCommunications communicationIdentity
    openCommunication ws communicationNo
        = addToWorkspace ((doOrClose (updateCommunication communicationNo)) <<@ InWindow) ws @! ()

    createAndAnswerPhoneCall     = (doOrClose (createCommunication PhoneCall In  ?None >>- answerPhoneCall   )) <<@ InWindow @!()
    createAndInitiatePhoneCall   = (doOrClose (createCommunication PhoneCall Out ?None >>- initiatePhoneCall )) <<@ InWindow @!()
    createAndAnswerRadioCall     = (doOrClose (createCommunication RadioCall In  ?None >>- answerRadioCall   )) <<@ InWindow @!()
    createAndInitiateRadioCall   = (doOrClose (createCommunication RadioCall Out ?None >>- initiateRadioCall )) <<@ InWindow @!()
    createAndComposeEmailMessage = (doOrClose (createCommunication EmailMessage Out ?None >>- composeEmailMessage)) <<@ InWindow @!()
    createAndComposeP2000Message = (doOrClose (createCommunication P2000Message Out ?None >>- composeP2000Message)) <<@ InWindow @!()

/*
* The incident dashboard gives an overview of all open incidents,
* provides ad-hoc creation of new incidents and provides
* a way to open the incident information browsing incident task for open incidents.
*/
browseIncidents :: Workspace -> Task ()
browseIncidents ws
	=	feedForward
    (   selectIncident
        >^* [OnAction (Action "/Add incident") (always (createNewIncident <<@ InWindow @! ()))
            ,OnAction (Action "/Open") (hasValue (\i -> openIncidentInWorkspace ws i @! ()))
            ]
    )
	(	withSelection viewNoSelection viewIncidentDetails
	)	<<@ (ArrangeWithSideBar 1 RightSide True) <<@ (Icon "incidents") <<@ (Title "Incidents")
    @! ()
where
	selectIncident
		= ( ((Title "Open incidents") @>> enterChoiceWithSharedAs 
			    [ChooseFromGrid id] openIncidentsDetails (\{IncidentDetails|incidentNo} -> incidentNo) /* <<@ AfterLayout (tweakUI fill) */) //FIXME
            -||-
            ((Title "Recent incidents") @>> enterChoiceWithSharedAs 
                [ChooseFromGrid id] recentIncidentsDetails (\{IncidentDetails|incidentNo} -> incidentNo) /* <<@ AfterLayout (tweakUI fill) */) //FIXME
         ) <<@ ArrangeWithTabs True

browseContacts :: Workspace -> Task ()
browseContacts ws
	=	feedForward
    (   selectContact
        >^* [(OnAction (Action "/Add contact") (always (addContact <<@ InWindow @! ())))
            ,(OnAction (Action "/Open") (ifValue (\c-> c=:(Left _)) (\(Left c) -> (openContactInWorkspace ws c) @! ())))
            ,(OnAction (Action "/Quick update/Position") (ifValue (\c-> c=:(Left _)) (\(Left c) -> updateContactPosition c <<@ InWindow @! ())))
            ,(OnAction (Action "/Quick update/Status") (ifValue (\c-> c=:(Left _)) (\(Left c) -> updateContactStatus c <<@ InWindow @! ())))
            ]
    )
	(   withSelection viewNoSelection viewDetails
	)	<<@ (ArrangeWithSideBar 1 RightSide True) <<@ (Icon "contacts") <<@ (Title "Contacts")
    @! ()
where
    viewDetails (Left contactNo)    = viewContactDetails contactNo
    viewDetails (Right mmsi)        = viewAISContactDetails mmsi

    addContact :: Task (?ContactNo)
    addContact
        =   (Title "Add contact") @>> enterInformation []
        >?? createContact

:: ActionSet = PersonalActions | IncidentActions !IncidentNo

:: ActionShort =
	{	status		:: ?String
	,	title		:: ?String
	,	createdOn	:: ?String
	,	createdBy	:: ?String
	}

derive class iTask ActionSet, ActionShort

browseActions :: Workspace -> Task ()
browseActions ws
	=	selectAndWorkOnActions
    >^* [OnAction (Action "/Add action") (always (addTopActionItem [] []))]
	@!  ()
where
	selectAndWorkOnActions
     = feedForward (Title "Overview" @>> chooseActionItem  True True actionStatuses /* <<@ AfterLayout (tweakUI fill) */) //FIXME
        (\s -> whileUnchanged s
            (\t -> case t of
              ?Just taskId    = workOnActionItem taskId
              ?None           = viewInformation [] ()
            )
        ) <<@ (ArrangeWithSideBar 0 LeftSide True) <<@ (Icon "actions") <<@ (Title "Actions")



