"""Unit tests for numbers.py."""

import math
import operator
import unittest

class TestNumbers(unittest.TestCase):
    def test_int(self):
        # self.assertEqual(7, int(7).real)
        # self.assertEqual(0, int(7).imag)
        self.assertEqual(7, int(7).conjugate())
        self.assertEqual(-7, int(-7).conjugate())
        # self.assertEqual(7, int(7).numerator)
        # self.assertEqual(1, int(7).denominator)

    def test_float(self):
        # self.assertEqual(7.3, float(7.3).real)
        # self.assertEqual(0, float(7.3).imag)
        self.assertEqual(7.3, float(7.3).conjugate())
        self.assertEqual(-7.3, float(-7.3).conjugate())

        c1, c2 = complex(3, 2), complex(4,1)
        # XXX: This is not ideal, but see the comment in math_trunc().
        self.assertRaises(TypeError, math.trunc, c1)
        self.assertRaises(TypeError, operator.mod, c1, c2)
        self.assertRaises(TypeError, divmod, c1, c2)
        self.assertRaises(TypeError, operator.floordiv, c1, c2)
        self.assertRaises(TypeError, float, c1)
        self.assertRaises(TypeError, int, c1)


if __name__ == "__main__":
    unittest.main()
