definition module CollectTypes;

from StdDynamicTypes import :: TIO_TypeReference;
from typetable import :: TypeTable;
from type_io_read import :: TypeTableTypeReference;

:: *CollectTypesState
	= {
	// Input
		cts_type_tables							:: !*{#TypeTable}

	// Reserved		
	,	cts_collected_types						:: !*{#Bool}									// already collected types
	,	cts_module_base_indices					:: !{#Int}

	// Output
	,	cts_type_dependencies					:: ![(TIO_TypeReference,TIO_TypeReference)]

	// Reserved		
	,	cts_type_dependencies_to_be_collected	:: ![(TIO_TypeReference,TIO_TypeReference)]		// set of type dependencies to be examined

	,	cts_left_i								:: !Int
	,	cts_right_i								:: !Int

	,	cts_left_module_i						:: !Int
	,	cts_right_module_i						:: !Int
	};
	
// interne type equivalenties

default_collect_types_state :: *CollectTypesState;

class collect_types a :: !a !a !*CollectTypesState -> *CollectTypesState;
	
instance collect_types TypeTableTypeReference;

init_collect_types :: !Int !Int ![(TIO_TypeReference,TIO_TypeReference)] !*CollectTypesState -> *CollectTypesState;
// init_collect_types type_table_left type_table_right types cts

collect_types_loop :: !*CollectTypesState -> *CollectTypesState;
// computes all dependencies