/*
 * Decompiled with CFR 0.152.
 */
package jme;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.JarURLConnection;
import java.net.URL;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import jme.Interpreter;

public class MainApplet
extends JApplet {
    private Interpreter inter;
    private Thread outthread = null;
    private boolean stopped = false;
    private String program;
    private JButton reloadBtn;
    private JButton showcodeBtn;
    private JButton evaluateBtn;
    private JButton stopBtn;
    private JLabel evalLbl;
    private JScrollPane jScrollPane1;
    private JTextArea outputTxt;
    private JTextField evalTxt;
    private JComboBox progCombo;

    public void init() {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    MainApplet.this.initComponents();
                    MainApplet.this.initInterpreter();
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void initInterpreter() {
        try {
            this.inter = new Interpreter(1000000, 100000, 8000);
            this.loadprog("primes.cfp");
        }
        catch (Exception ex) {
            this.outputTxt.setText(ex.getMessage());
            ex.printStackTrace();
        }
    }

    private void loadprog(String progname) {
        this.readsaplfromserver(progname);
        this.outputTxt.setText(this.getFileContents(progname));
        this.outputTxt.setCaretPosition(0);
        this.evalTxt.setText("main");
    }

    public String readsaplfromserver(String saplfile) {
        try {
            URL url = new URL("jar:" + this.getCodeBase().toString() + "allprogs.zip!/" + saplfile);
            JarURLConnection urlConn = (JarURLConnection)url.openConnection();
            urlConn.setDoInput(true);
            urlConn.setUseCaches(false);
            DataInputStream is = new DataInputStream(urlConn.getInputStream());
            if (is == null) {
                return "ERROR: No sapl file found";
            }
            String res = "OK: " + saplfile + " loaded from server " + this.getCodeBase().toString();
            this.inter.setInputStream(is);
            return res;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "ERROR: " + ex.getMessage();
        }
    }

    String getFileContents(String saplfile) {
        try {
            String line;
            URL url = new URL("jar:" + this.getCodeBase().toString() + "allprogs.zip!/" + saplfile);
            JarURLConnection urlConn = (JarURLConnection)url.openConnection();
            urlConn.setDoInput(true);
            urlConn.setUseCaches(false);
            DataInputStream is = new DataInputStream(urlConn.getInputStream());
            if (is == null) {
                return "ERROR: No sapl file found";
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            is = new DataInputStream(urlConn.getInputStream());
            this.program = "";
            while ((line = br.readLine()) != null) {
                this.program = this.program + line + "\n";
            }
            ((InputStream)is).close();
            return this.program;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "ERROR: " + ex.getMessage();
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.outputTxt = new JTextArea();
        this.evalTxt = new JTextField();
        this.showcodeBtn = new JButton();
        this.evalLbl = new JLabel();
        this.reloadBtn = new JButton();
        this.evaluateBtn = new JButton();
        this.stopBtn = new JButton();
        this.progCombo = new JComboBox();
        this.outputTxt.setColumns(20);
        this.outputTxt.setFont(new Font("Courier New", 0, 12));
        this.outputTxt.setLineWrap(true);
        this.outputTxt.setRows(5);
        this.jScrollPane1.setViewportView(this.outputTxt);
        this.evalTxt.setMinimumSize(new Dimension(200, 20));
        this.evalTxt.setPreferredSize(new Dimension(200, 20));
        this.evalTxt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainApplet.this.doiets(evt);
            }
        });
        this.showcodeBtn.setText("Show Code");
        this.showcodeBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainApplet.this.showcode(evt);
            }
        });
        this.evaluateBtn.setText("Evaluate");
        this.evaluateBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainApplet.this.doiets(evt);
            }
        });
        this.stopBtn.setText("Stop");
        this.stopBtn.setEnabled(false);
        this.stopBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainApplet.this.interruptOutput();
            }
        });
        this.evalLbl.setText("Evaluate:");
        this.reloadBtn.setText("Reload");
        this.reloadBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainApplet.this.reload(evt);
            }
        });
        this.progCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"primes", "eval", "sprimes", "benchmarks", "parselibnew"}));
        this.progCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainApplet.this.changeProg();
            }
        });
        this.progCombo.setName("progCombo");
        this.getContentPane().setLayout(new BorderLayout());
        JPanel btnPanel = new JPanel();
        this.add((Component)btnPanel, "South");
        this.add((Component)this.jScrollPane1, "Center");
        btnPanel.add(this.progCombo);
        btnPanel.add(this.reloadBtn);
        btnPanel.add(this.showcodeBtn);
        btnPanel.add(this.evalLbl);
        btnPanel.add(this.evalTxt);
        this.evalTxt.setText("main");
        btnPanel.add(this.evaluateBtn);
        btnPanel.add(this.stopBtn);
    }

    private void reload(ActionEvent evt) {
        try {
            this.program = this.outputTxt.getText();
            this.inter.setFunctions(this.program);
            this.outputTxt.setText("Program correctly loaded");
            this.outputTxt.setCaretPosition(0);
            this.evalTxt.setSelectionStart(0);
            this.evalTxt.setSelectionEnd(100);
        }
        catch (Exception ex) {
            this.outputTxt.setText(ex.getMessage());
            ex.printStackTrace();
        }
    }

    private void showcode(ActionEvent evt) {
        this.outputTxt.setText(this.program);
        this.outputTxt.setCaretPosition(0);
        this.evalTxt.setSelectionStart(0);
        this.evalTxt.setSelectionEnd(100);
    }

    private void doiets(ActionEvent evt) {
        String line = this.evalTxt.getText();
        this.outthread = new Runner(line);
        this.outthread.start();
    }

    public void changeProg() {
        String prog = (String)this.progCombo.getSelectedItem();
        this.loadprog(prog + ".cfp");
    }

    private void interruptOutput() {
        try {
            this.outthread.interrupt();
            this.stopped = true;
            while (!this.outthread.isInterrupted()) {
                Thread.sleep(100L);
            }
            this.inter.reset();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    void printRes(Interpreter interpreter) throws Exception {
        int type;
        int nrapp = 0;
        while ((type = interpreter.printer.getExpression()) == 0) {
            ++nrapp;
        }
        if (nrapp > 0) {
            this.outputTxt.append("(");
        }
        switch (type) {
            case 1: {
                this.outputTxt.append("" + interpreter.printer.getIntValue());
                break;
            }
            case 2: {
                this.outputTxt.append("" + interpreter.printer.getBoolValue());
                break;
            }
            case 3: {
                this.outputTxt.append("" + interpreter.printer.getCharValue());
                break;
            }
            case 5: {
                this.outputTxt.append("" + interpreter.printer.getStringValue());
                break;
            }
            case 4: {
                this.outputTxt.append("" + interpreter.printer.getFuncValue());
            }
        }
        for (int i = 0; i < nrapp; ++i) {
            this.outputTxt.append(" ");
            this.printRes(interpreter);
        }
        if (nrapp > 0) {
            this.outputTxt.append(")");
        }
    }

    void printEvalString(Interpreter inter) {
        try {
            this.printRes(inter);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    class Runner
    extends Thread {
        String line;

        Runner(String line) {
            this.line = line;
        }

        public void run() {
            MainApplet.this.stopBtn.setEnabled(true);
            MainApplet.this.outputTxt.setText("");
            try {
                long time1 = System.currentTimeMillis();
                MainApplet.this.inter.setExpression(this.line);
                MainApplet.this.printEvalString(MainApplet.this.inter);
                long time2 = System.currentTimeMillis();
                MainApplet.this.outputTxt.append("\ntime: " + (time2 - time1) / 1000L + "." + (time2 - time1) / 100L % 10L + "s");
            }
            catch (Exception ex) {
                if (MainApplet.this.stopped) {
                    MainApplet.this.outputTxt.append("\nInterrupted\n");
                } else {
                    MainApplet.this.outputTxt.setText(ex.getMessage());
                }
                ex.printStackTrace();
            }
            MainApplet.this.evalTxt.setSelectionStart(0);
            MainApplet.this.evalTxt.setSelectionEnd(100);
            MainApplet.this.stopBtn.setEnabled(false);
            MainApplet.this.stopped = false;
        }
    }
}

