/*
 * Decompiled with CFR 0.152.
 */
package jme;

import java.awt.EventQueue;
import java.io.DataInputStream;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import javax.swing.JApplet;
import jme.Interpreter;

public class ClientApplet
extends JApplet {
    private Interpreter inter;

    public void init() {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    ClientApplet.this.initComponents();
                    ClientApplet.this.initInterpreter();
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void initInterpreter() {
        try {
            this.inter = new Interpreter(1000000, 170000, 7000);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void readsaplfromjar() {
        try {
            InputStream is = this.getClass().getResourceAsStream("/main.sapl");
            if (is == null) {
                System.out.println("No sapl file found");
            } else {
                System.out.println("main.sapl loaded from jar file");
                this.inter.setInputStream(is);
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
    }

    public String readsaplfromserver(String saplfile) {
        try {
            URL url = new URL("jar:" + this.getCodeBase().toString() + saplfile + ".jar!/" + saplfile + ".sapl");
            JarURLConnection urlConn = (JarURLConnection)url.openConnection();
            urlConn.setDoInput(true);
            urlConn.setUseCaches(false);
            DataInputStream is = new DataInputStream(urlConn.getInputStream());
            if (is == null) {
                return "ERROR: No sapl file found";
            }
            String res = "OK: " + saplfile + " loaded from server " + this.getCodeBase().toString();
            this.inter.setInputStream(is);
            return res;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "ERROR: " + ex.getMessage();
        }
    }

    public String evalExpression(String expression) {
        try {
            this.inter.setExpression(expression);
            return this.printRes2String(this.inter);
        }
        catch (Exception ex) {
            if (ex.getMessage().startsWith("ABORT")) {
                this.inter.eval.reset();
                return ex.getMessage();
            }
            this.inter.eval.printStackTrace();
            this.inter.eval.reset();
            ex.printStackTrace();
            return "";
        }
    }

    public void setInput(String inp) {
        this.inter.setInput(inp);
    }

    public String getOutput() {
        return this.inter.getOutput();
    }

    String printRes2String(Interpreter interpreter) throws Exception {
        int type;
        int nrapp = 0;
        String res = "";
        while ((type = interpreter.printer.getExpression()) == 0) {
            ++nrapp;
        }
        if (nrapp > 0) {
            res = res + "(";
        }
        switch (type) {
            case 1: {
                res = res + interpreter.printer.getIntValue();
                break;
            }
            case 2: {
                res = res + interpreter.printer.getBoolValue();
                break;
            }
            case 3: {
                res = res + interpreter.printer.getCharValue();
                break;
            }
            case 5: {
                res = res + interpreter.printer.getStringValue();
                break;
            }
            case 4: {
                res = res + interpreter.printer.getFuncValue();
            }
        }
        for (int i = 0; i < nrapp; ++i) {
            res = res + " ";
            this.printRes2String(interpreter);
        }
        if (nrapp > 0) {
            res = res + ")";
        }
        return res;
    }

    private void initComponents() {
    }
}

