module LifeGameExample

//	This is the version of the LifeGame program written in Clean 1.2 for I/O system 0.8

import StdEnv, deltaEventIO, deltaMenu, deltaWindow, deltaTimer
import Life, Help

::	*State	=	{gen::Generation, size::CellSize}
::	*IO		:==	IOState State

Start :: *World -> *World
Start world
	# (about,world)	= accFiles (MakeAboutDialog "LifeGameExample" "LifeHelp" (\s io->(s,ShowHelp "LifeHelp" io))) world
	  (_,world)		= StartIO [DialogSystem [about], window, timer, menus] start_state init_io world
	= world
where
	start_state		= {gen=MakeGeneration, size=StartCellSize}
	init_io			= [\s io->(s,DrawInWindow WindowID [SetBackColour BlackColour] io)]
	
	window			= WindowSystem
						[	ScrollWindow WindowID (0,0) "Life" 
							(ScrollBar (Thumb 0) (Scroll StartCellSize))
							(ScrollBar (Thumb 0) (Scroll StartCellSize)) 
							picturedomain (100,100) (RectangleSize picturedomain) UpdateWindow
							[	GoAway	Quit
							,	Mouse	Able Track
							]
						]
	picturedomain	= GetPictureDomain StartCellSize
	timer			= TimerSystem [Timer TimerID Unable 0 (\_ ->Step)]
	menus			= MenuSystem 
						[	PullDownMenu FileMenuID "File" Able
							[	MenuItem QuitID "Quit" (Key 'Q') Able Quit
							]
						,	PullDownMenu OptionsMenuID "Options" Able
							[	MenuItem EraseID "Erase All Cells" (Key 'E') Able Erase
				  			,	SubMenuItem CellSizeID "Cell Size" Able 
				  				[	MenuRadioItems Size8ID
									[	MenuRadioItem Size1ID  "1 * 1" (Key '1') Able (ChangeSize 1)
									,	MenuRadioItem Size2ID  "2 * 2" (Key '2') Able (ChangeSize 2)
									,	MenuRadioItem Size4ID  "4 * 4" (Key '3') Able (ChangeSize 4)
									,	MenuRadioItem Size8ID  "8 * 8" (Key '4') Able (ChangeSize 8)
									,	MenuRadioItem Size16ID "16*16" (Key '5') Able (ChangeSize 16)
									]
				  				]
							]
						, 	PullDownMenu CommandsMenuID "Commands" Able
							[	MenuItem PlayID "Play" (Key 'P') Able Play
							,	MenuItem HaltID "Halt" (Key 'H') Unable Halt
							,	MenuItem StepID "Step" (Key 'S') Able Step
							]
						]

Quit :: State IO -> (State, IO)
Quit state io = (state, QuitIO io)

Play :: State IO -> (State, IO)
Play state io
	# io	= DisableActiveMouse						io
	  io	= DisableMenuItems	[PlayID,StepID,EraseID]	io
	  io	= EnableMenuItems	[HaltID]				io
	  io	= EnableTimer		TimerID					io
	= (state, io)

Halt :: State IO -> (State, IO)
Halt state io
	# io	= EnableActiveMouse							io
	  io	= DisableMenuItems	[HaltID]				io
	  io	= EnableMenuItems	[PlayID,StepID,EraseID]	io
	  io	= DisableTimer		TimerID					io
	= (state, io)

Step :: State IO -> (State, IO)
Step state=:{gen,size} io
	= ({state & gen = next}, DrawInWindow WindowID (DrawCells (EraseCell size) died ++ DrawCells (DrawCell size) next) io)
where
	(next,died)	= LifeGame gen

Erase :: State IO -> (State, IO)
Erase state=:{size} io
	= ({state & gen = MakeGeneration}, DrawInWindow WindowID [EraseRectangle (GetPictureDomain size)] io)

ChangeSize :: Int State IO -> (State, IO)
ChangeSize newSize state=:{gen,size=oldSize} io
	# state				= {state & gen=MakeGeneration,size=newSize}
	  (((x,y),_),io)	= ActiveWindowGetFrame io
	  (state,io)		= ChangeActivePictureDomain (GetPictureDomain newSize) state io
	  (state,io)		= ChangeActiveScrollBar     (ChangeHBar (x/oldSize*newSize) newSize) state io
	  (state,io)		= ChangeActiveScrollBar     (ChangeVBar (y/oldSize*newSize) newSize) state io
	  state				= {state & gen=gen}
	  io				= DrawInWindow WindowID		[EraseRectangle (GetPictureDomain newSize):DrawCells (DrawCell newSize) gen] io
	= (state,io)

UpdateWindow :: UpdateArea State -> (State,[DrawFunction])
UpdateWindow _ state=:{gen,size}
	= (state,DrawCells (DrawCell size) gen)

Track :: MouseState State IO -> (State, IO)
Track (_,ButtonUp,_) state io
	= (state, io)
Track (pos,_,(_,_,command,_)) state=:{gen,size} io
	| command
	= ({state & gen = RemoveCell cell gen}, DrawInWindow WindowID [EraseCell size cell] io)
	| otherwise
	= ({state & gen = InsertCell cell gen}, DrawInWindow WindowID [DrawCell  size cell] io)
where
	cell	= MakeLifeCell pos size

GetPictureDomain :: CellSize -> PictureDomain
GetPictureDomain size
	= ((size*left,size*top),(size*right,size*bottom))
where
	((left,top),(right,bottom))	= Universe

RectangleSize :: Rectangle -> (Int,Int)
RectangleSize ((left,top),(right,bottom))
	= (abs (right-left),abs (bottom-top))


//	Program constants.

FileMenuID		:== 1
QuitID	 			:== 11
OptionsMenuID 	:== 2
EraseID				:== 21
CellSizeID 			:== 22
Size1ID					:== 221
Size2ID					:== 222
Size4ID					:== 223
Size8ID					:== 224
Size16ID				:== 225
CommandsMenuID 	:== 3
PlayID				:== 31
HaltID				:== 32
StepID				:== 33

WindowID		:== 1
Universe		:==	((-1000,-1000),(1000,1000))

TimerID			:== 1

StartCellSize	:== 8
