definition module elf_relocations;

import StdInt,StdArray,StdFile;
import elf_linker_types;

BigOrLittleEndian big little :== little;
                                                                                                                        
SIZE_OF_RELOCATION:==8;

R_386_NONE:==0;
R_386_32:==1;
R_386_PC32:==2;

SHT_RELA:==4;
SHT_REL:==9;

SHT_relocations:==SHT_REL;

RELOCATION_TYPE_OFFSET:== 4;
RELOCATION_SYMBOL_N_OFFSET:== 5;

(BYTE) string i :== toInt (string.[i]);
                                                                                                                        
(WORD) :: !{#Char} !Int -> Int;
// (WORD) string i = (string BYTE (i+1)<<8) bitor (string BYTE i);
                                                                                                                        
(LONG) :: !{#Char} !Int -> Int;
// (LONG) string i = (string BYTE (i+3)<<24) bitor (string BYTE (i+2)<<16) bitor (string BYTE (i+1)<<8) bitor (string BYTE i);

(TBYTE) :: !{#Char} !Int -> Int;
// (TBYTE) string i = (string BYTE (i+2)<<16) bitor (string BYTE (i+1)<<8) bitor (string BYTE i);i

shstrtab_data_relocations_section_name_offset :== 38;
shstrtab_symbol_table_section_name_offset :== 48;
shstrtab_string_table_section_name_offset :== 56;
shstrtab_size :== 64;

write_elf_header :: !*File -> *File;
write_shstrtab_end :: !*File -> *File;

count_relocations :: !Int !{#Char} !{!Symbol} -> Int;

write_module_relocations :: !Symbol !Int !Int !SSymbolArray !XcoffArray !{#Int} !{#Int} !*File -> *File;

relocate_text :: !.Int Int Int Int Int {#Char} {#SXcoff} {#Int} {#Int} {!Symbol} !*{#.Char} -> .{#Char};
relocate_data :: Int Int Int Int Int String Int {#Int} {#Int} {!Symbol} XcoffArray *{#Char}-> *{#Char};
