definition module DynID

from StdOverloaded import class fromString, class toString, class +++ (+++)
from StdFile import class FileSystem
from StdString import instance +++ {#Char}
from StdDynamicTypes import NAME_PREFIXES

::DynamicID1

createDynIDFromString :: String -> DynamicID1
createDynIDFromFile	:: String *World -> (DynamicID1,*World)
	//creates unique ID for the dynamic file named by the string

instance toString DynamicID1
instance fromString DynamicID1

// Applications used by dynamics
DS_DYNAMIC_LINKER		:== "DynamicLinker.exe";

// Predefined directories (w.r.t. root-directory):
DS_LIBRARIES_DIR		:== "libraries"
DS_SYSTEM_DYNAMICS_DIR	:== "system dynamics"
DS_CONVERSION_DIR		:== "conversion"
DS_UTILITIES_DIR		:== "utilities"
DS_LOGS_DIR				:== "logs"

// IDS FOR DYNAMICS:
// encoded file_name:												<link_name>_<md5>
// run-time file_name:  	<DLINK PATH>\\<DS_SYSTEM_DYNAMICS_DIR>\\<link_name>_<md5>
CREATE_ENCODED_DYNAMIC_FILE_NAME link_name md5_dynamic_identification
	:== (NAME_PREFIXES (link_name +++ "_") "") +++ md5_dynamic_identification;
	
CONVERTED_ENCODED_DYNAMIC_FILE_NAME_INTO_PATH base_directory encoded_dynamic_file_name
	:== base_directory +++ "\\" +++ DS_SYSTEM_DYNAMICS_DIR +++ "\\" +++ encoded_dynamic_file_name +++ "." +++ EXTENSION_SYSTEM_DYNAMIC;
	
EXTENSION_SYSTEM_DYNAMIC
	:== "sysdyn"

// user supplied extension	
	
// IDS FOR LIBRARIES
// encoded file_name:	<library name>_<md5 from code>_<md5 from type>
// run-time file_name:	<DLINK PATH>\\<DS_SYSTEM_DYNAMICS_DIR>\\<library name>_<md5 from code>_<md5 from type>.{typ,lib}
CREATE_ENCODED_LIBRARY_FILE_NAME library_name code_md5 type_md5
	:== (NAME_PREFIXES (library_name +++ "_") "") +++ code_md5 +++ "_" +++ type_md5;
	
CONVERT_ENCODED_LIBRARY_IDENTIFICATION_INTO_RUN_TIME_LIBRARY_IDENTIFICATION base_directory encoded_library_identification
	:== base_directory +++ "\\" +++ DS_LIBRARIES_DIR +++ "\\" +++ encoded_library_identification;

ADD_CODE_LIBRARY_EXTENSION library_identification
	:== library_identification +++ "." +++ EXTENSION_CODE_LIBRARY;
ADD_TYPE_LIBRARY_EXTENSION library_identification
	:== library_identification +++ "." +++ EXTENSION_TYPE_LIBRARY;
	
EXTENSION_CODE_LIBRARY
	:== "lib"
EXTENSION_TYPE_LIBRARY
	:== "typ"
	
extract_dynamic_or_library_identification :: !String -> String
	
EXTENSION_USER_DYNAMIC
	:== "dyn"
	
get_system_dynamic_identification :: !String !*f -> (!Bool,!String,!*f) | FileSystem f
