/*
** Program: Clean Prover System
** Module:  Core (.dcl)
** 
** Author:  Maarten de Mol
** Created: 13 September 1999
*/

definition module 
	Rewrite

import 
	StdEnv,
	CoreTypes,
	CoreAccess,
	States

// -------------------------------------------------------------------------------------------------------------------------------------------------
:: ReductionOptions =
// -------------------------------------------------------------------------------------------------------------------------------------------------
	{ roMode							:: !ReduceMode
	, roDefinedVariables				:: ![CExprVarPtr]
	, roDefinedExpressions				:: ![CExprH]
	}

// -------------------------------------------------------------------------------------------------------------------------------------------------
:: ReductionStatus 
// -------------------------------------------------------------------------------------------------------------------------------------------------
	= NotReducable							// root normal form found (but not bottom)
	| UndefinedForm							// bottom
	| VariableForm							// always stop reduction (also used for opaque functions)
	| MaybeVariableForm	![CExprVarPtr]		// check if all variables occur in options.roDefined (only in function reduction)
	| ReducedOnce							// only used in ReduceStep
instance DummyValue ReductionStatus
instance == ReductionStatus

ReduceStep			:: !ReductionOptions !CExprH !*CHeaps !*CProject -> (!Error, !(!ReductionStatus, !CExprH), !*CHeaps, !*CProject)
InnerReduceStep		:: !ReductionOptions !CExprH !*CHeaps !*CProject -> (!Error, !(!ReductionStatus, !CExprH), !*CHeaps, !*CProject)
Reduce				:: !ReductionOptions !Int !CExprH !*CHeaps !*CProject -> (!Error, !(!Int, !ReductionStatus, !CExprH), !*CHeaps, !*CProject)
InnerReduce			:: !ReductionOptions !Int !CExprH !*CHeaps !*CProject -> (!Error, !(!Int, !ReductionStatus, !CExprH), !*CHeaps, !*CProject)
ReduceAll			:: !ReductionOptions !Int !CExprH !*CHeaps !*CProject -> (!Error, !(!Int, !CExprH), !*CHeaps, !*CProject)

getRealArity		:: !ReduceMode !CFunDefH -> Int
