module matrixBlink

import StdEnv, iTasks

import Interpret
import Interpret.Device.TCP

Start :: *World -> *World
Start w = doTasks main w

:: Ledstatus = {x :: Int, y :: Int, status :: Bool}
derive class iTask Ledstatus

main = enterDevice >>= \spec->withDevice spec
	\dev-> viewDevice dev >^*
		[OnAction (Action "Toggle") (always (
			enterInformation () [] >>= \s->liftmTask (toggle s) dev
				>>~ viewInformation "done" []))
		,OnAction (Action "Clear") (always (
			liftmTask clear dev
			>>~ viewInformation "done" []))
		,OnAction (Action "42") (always (iTask42 dev))
		,OnAction (Action "42mtask") (always (liftmTask mTask42 dev))
		] @! ()
where
	dot lm s = LMDot lm (lit s.x) (lit s.y) (lit s.status)

	toggle :: Ledstatus -> Main (MTask v ()) | mtask, LEDMatrix v
	toggle s = ledmatrix D5 D7 \lm->{main=dot lm s >>|. LMDisplay lm}

	clear :: Main (MTask v ()) | mtask, LEDMatrix v
	clear = ledmatrix D5 D7 \lm->{main=LMClear lm >>|. LMDisplay lm}

	//Write 42 to the LED matrix using only the toggle and the clear tasks
	iTask42 :: MTDevice -> Task ()
	iTask42 dev = ...

	//Write 42 to the LED matrix as a single mTask task.
	mTask42 :: Main (MTask v ()) | mtask, LEDMatrix v
	mTask42 = ...

fourtytwo =
	//Four
	[(0, 5), (0, 4), (0, 3), (0, 2) ,(1, 2), (2, 2), (2, 3) ,(2, 1), (2, 0)
	//Two
	,(4, 5), (5, 5), (6, 4), (6, 3), (5, 2), (4, 1), (4, 0), (5, 0), (6, 0)
	]
