definition module Interpret.Message

import Interpret.Instructions
import Interpret.DSL
import Interpret.Specification
import Interpret.ByteCodeEncoding
import Interpret.Compile
import Interpret.String255

:: MTMessageTo
	//* taskid returnwidth peripherals shares instructions
	= MTTTask MTTTaskData
	//* taskid (task prep for devices that have small comm buffers)
	| MTTTaskPrep UInt8
	//* taskid
	| MTTTaskDel UInt8
	//*
	| MTTSpecRequest
	//*
	| MTTShutdown
	//* taskid sdsid sds value
	| MTTSdsUpdate UInt8 UInt8 String255

:: MTTTaskData =
	{ mtttd_taskid       :: UInt8
	, mtttd_returnwidth  :: UInt8
	, mtttd_peripherals  :: [BCPeripheral]
	, mtttd_shares       :: [BCShareSpec]
	, mtttd_instructions :: [BCInstr]
	}

:: MTMessageFro
	//* taskid
	= MTFTaskAck UInt8
	//* taskid (task prep ack for devices that have small comm buffers)
	| MTFTaskPrepAck UInt8
	//* taskid
	| MTFTaskDelAck UInt8
	//* taskid stability returnvalue
	| MTFTaskReturn UInt8 (TaskValue String255)
	//* specification
	| MTFSpec MTDeviceSpec
	//* taskid sdsid sds value
	| MTFSdsUpdate UInt8 UInt8 String255
	//* debug message
	| MTFDebug String255

derive toByteCode MTMessageFro, MTMessageTo
derive fromByteCode MTMessageFro, MTMessageTo
