implementation module SQL

import StdString, StdList, StdTime, StdMaybe, StdBool

//Utility functions
instance toString SQLType
where
	toString (SQLTChar i)		= "Char " +++ (toString i)
	toString (SQLTVarchar i)	= "Varchar" +++ (toString i)
	toString (SQLTText)			= "Text"
	toString (SQLTInteger)		= "Integer"
	toString (SQLTReal)			= "Real"
	toString (SQLTFloat)		= "Float"
	toString (SQLTDouble)		= "Double"
	toString (SQLTDate)			= "Date"
	toString (SQLTTime)			= "Time"
	toString (SQLTTimestamp)	= "Timestamp"
	toString (SQLTDatetime)		= "Datetime"
	toString (SQLTEnum s)		= "Enum ( " +++ (foldr (+++) ")" [ e +++ " " \\ e <- s])
	toString (SQLTUnknown i)	= "Unknown (" +++ (toString i) +++ ")"

instance toString SQLValue					
where
	toString (SQLVChar s)		= "SQLVChar " +++ s
	toString (SQLVVarchar s)	= "SQLVVarchar " +++ s
	toString (SQLVText s)		= "SQLVText " +++ s
	toString (SQLVInteger i)	= "SQLVInteger " +++ (toString i)
	toString (SQLVReal r)		= "SQLVReal " +++ (toString r)
	toString (SQLVFloat	f)		= "SQLVFloat " +++ (toString f)
	toString (SQLVDouble d)		= "SQLVDouble " +++ (toString d)
	toString (SQLVDate d)		= "SQLVDate " +++ (toString d)
	toString (SQLVTime t)		= "SQLVTime " +++ (toString t)
	toString (SQLVTimestamp	i)	= "SQLVTimestamp " +++ (toString i)
	toString (SQLVDatetime d t)	= "SQLVDatetime " +++ (toString d) +++ " " +++ (toString t)
	toString (SQLVEnum s)		= "SQLVEnum " +++ s
	toString (SQLVNull)			= "SQLVNull"
	toString (SQLVUnknown s)	= "SQLVUnknown " +++ s

instance == SQLType
where
	(==) (SQLTChar x)		(SQLTChar y)	= x == y
	(==) (SQLTVarchar x)	(SQLTVarchar y)	= x == y
	(==) (SQLTText)			(SQLTText)		= True
	(==) (SQLTInteger)		(SQLTInteger)	= True
	(==) (SQLTReal)			(SQLTReal)		= True
	(==) (SQLTFloat)		(SQLTFloat)		= True
	(==) (SQLTDouble)		(SQLTDouble)	= True
	(==) (SQLTDate)			(SQLTDate)		= True
	(==) (SQLTTime)			(SQLTTime)		= True
	(==) (SQLTTimestamp)	(SQLTTimestamp)	= True
	(==) (SQLTDatetime)		(SQLTDatetime)	= True
	(==) (SQLTEnum x)		(SQLTEnum y)	= x == y
	(==) (SQLTUnknown x)	(SQLTUnknown y)	= x == y
	(==) _					_				= False

instance == SQLValue
where
	(==) (SQLVChar x)			(SQLVChar y)			= x == y
	(==) (SQLVVarchar x)		(SQLVVarchar y)			= x == y
	(==) (SQLVText x)			(SQLVText y)			= x == y
	(==) (SQLVInteger x)		(SQLVInteger y)			= x == y
	(==) (SQLVReal x)			(SQLVReal y)			= x == y
	(==) (SQLVFloat x)			(SQLVFloat y)			= x == y
	(==) (SQLVDouble x)			(SQLVDouble y)			= x == y
	(==) (SQLVDate x)			(SQLVDate y)			= x == y
	(==) (SQLVTime x)			(SQLVTime y)			= x == y
	(==) (SQLVTimestamp x)		(SQLVTimestamp y)		= x == y
	(==) (SQLVDatetime xd xt)	(SQLVDatetime yd yt)	= xd == yd && xt == yt
	(==) (SQLVEnum x)			(SQLVEnum y)			= x == y
	(==) (SQLVNull)				(SQLVNull)				= True
	(==) (SQLVUnknown x)		(SQLVUnknown y)			= x == y
	(==) _						_						= False

instance toString SQLError
where
	toString	(SQLWarning errno errmsg)			= "SQLWarning " +++ toString errno +++ ": " +++ errmsg
	toString	(SQLInterfaceError errno errmsg)	= "SQLInterfaceError " +++ toString errno +++ ": " +++ errmsg
	toString	(SQLDatabaseError errno errmsg)		= "SQLDatabaseError " +++ toString errno +++ ": " +++ errmsg
	toString	(SQLDataError errno errmsg)			= "SQLDataError " +++ toString errno +++ ": " +++ errmsg
	toString	(SQLOperationalError errno errmsg)	= "SQLOperationalError " +++ toString errno +++ ": " +++ errmsg
	toString	(SQLIntegrityError errno errmsg)	= "SQLIntegrityError " +++ toString errno +++ ": " +++ errmsg
	toString	(SQLInternalError errno errmsg)		= "SQLInternalError " +++ toString errno +++ ": " +++ errmsg
	toString	(SQLProgrammingError errno errmsg)	= "SQLProgrammingError " +++ toString errno +++ ": " +++ errmsg
	toString	(SQLNotSupportedError)				= "SQLNotSupportedError"
