
Module test_all;

(*
   This file loads all lego files, except classical logic (EM.l).
   It generates the executables

	lego_base	basics (logic, sets, functions, relations)
	lego_N  	natural numbers
	lego_alg	algebra
	lego_poly	polynomials
	lego_C		complex numbers
	lego_all	all the rest, except classical logic

  Use `Include test_all' to load all the files. Because we make use of
  the `Freeze' command, `Make' will not work.

*)   

(* --------------------------------------------------------------------------------
   Basics.
*)

Load Product;
Load Sum;
Load neList;

(* ExportState "lego_base"; *)
ExportState "l";


(* --------------------------------------------------------------------------------
   Natural numbers
*)

Load Nat_div;
Load mu;

(* ExportState "lego_N"; *)
ExportState "l";

(* --------------------------------------------------------------------------------
   Algebra
*)

Load Group_quot;
Load Field_order;

(* ExportState "lego_alg"; *)
ExportState "l";

(* --------------------------------------------------------------------------------
   Real numbers;
*)

Load AbsR;

(* ExportState "LegoReal"; *)
ExportState "l";

(* --------------------------------------------------------------------------------
   Polynomials.
*)

Load Poly1;

(* ExportState "lego_poly"; *)
ExportState "l";

(* --------------------------------------------------------------------------------
  Complex numbers.
*)

Load RootC;

(* ExportState "lego_C"; *)
ExportState "l";

(* --------------------------------------------------------------------------------
   Miscellaneous.
*)

Load Bijection;
Load Bishop;
Load Prime;
Load Binomium;

(* ExportState "lego_all"; *)
ExportState "l";

(* --------------------------------------------------------------------------------
   This is the list of all assumptions made in the Lego code:

    OREAL         : OrderedField
    Real_discr    : Discrete Real

    SqrtR         : UFun Real
    SqrtR_lemma1  : {x|el Real} (PositiveR.ap x) -> Eq (SquareR.ap (SqrtR.ap x)) x
    PositiveSqrtR : {x|el Real} (PositiveR.ap x) -> PositiveR.ap (SqrtR.ap x)

    OddRootR      : {P:el PolyR} (Odd.ap (DegreeR.ap P)) ->
                                 Ex ([y:el Real] Eq (P.apPR y) ZeroR)

   Which means in human language:

   1) Assume a discrete ordered field R.

   2) Assume we have a unary function Sqrt over R such that for positive x from R
      -  (Sqrt x)^2 = x
      -  Sqrt x is positive

   3) Assume that every polynomial in R of odd degree has a root in R.

*)
