
Module case Import Pred Product;

(* This module defines case distinction and the notion of characteristic function. *)

(*
   First we define a selector such that for [P1,P2 : Prop] we have
   for arbitrary [T:SET][x,y:T]:

     select (inl|P1|P2 z) x y   =_\beta_\iota   x     if [z : P1]
     select (inr|P1|P2 z) x y   =_\beta_\iota   y     if [z : P2]

  So for example

     select (Nat_discr ZeroN ZeroN) x y   =_\beta_\iota   x
     select (Nat_discr ZeroN  OneN) x y   =_\beta_\iota   y

  To do so, we define the inductive or. As a result the impredicative or
  becomes strong!

*)

Inductive [Or : Prop]
Parameters [P,P' : Prop]
Constructors [Inl : P -> Or] [Inr : P' -> Or]
ElimOver SET;
Discharge P;

Goal {P,P':Prop} iff (or P P') (Or P P');
  intros;
  Refine pair;
  intros; Refine H; Refine Inl; Refine Inr;
  Refine Or_elim ?? (Or P P')\(or P P'); Refine inl; Refine inr;
Save orOr;

[P,P' | Prop] [z : P \/ P'];

[     select : {T|SET} T -> T -> T
          = [T|SET] [x,y:T] Or_elim ?? ((Or P P')\T)
                                       (P\x)
                                       (P'\y)
                                       (z (Inl P P') (Inr P P'))
];

(*
[P,P':Prop] [z:P] [z':P'] [T:SET] [a,b:T];
  select (inl|P|P' z ) a b;  Equiv VReg a;
  select (inr|P|P' z') a b;  Equiv VReg b;
Discharge P;
*)

[A : Set];

Goal extensional2 (select|A.el);
  Intros;
  Refine Or_elim ?? ([z:Or P P'] Eq (Or_elim ?? ((Or P P')\el A) (P\x ) (P'\y)  z)
                                    (Or_elim ?? ((Or P P')\el A) (P\x') (P'\y') z));
  intros; Refine H;
  intros; Refine H1;
Save select_exten;

[     Select : Fun2 A A A
          = Fun2_intro ? select_exten
];

Discharge z;

(* --------------------------------------------------------------------------------
   Prove some basic properties:

      (P->(phi x)) -> (P'->(phi y)) -> phi (select z x y)

       P  -> (select x y) = x
       P' -> (select x y) = y

   if P -> P' -> x = y
*)

[z | P \/ P'];

Goal {T|SET} {phi:T->SET} {x,y|T} (P -> phi x) -> (P' -> phi y) -> phi (select z x y);
  intros;
  Refine Or_elim ?? ([z:Or P P'] phi (Or_elim ?? ((Or P P')\T) (P\x) (P'\y) z));
  Refine H; Refine H1;
Save select_lemma;

[A | Set] [x,y | el A] [z' : P -> P' -> Eq x y];

Goal select_left : P -> Eq (select z x y) x;
  intros;
  Refine select_lemma ([z:el A] Eq z x);
  intros; Refine Eq_refl;
  intros; Refine (z' H H1).Eq_sym;
Save;

Goal select_right : P' -> Eq (select z x y) y;
  intros;
  Refine select_lemma ([z:el A] Eq z y);
  intros; Refine z' H1 H;
  intros; Refine Eq_refl;
Save;

Discharge P;

(* ================================================================================
   Let phi be a decidable predicate. Define the characteristic
   function K_phi such that for any x

      (phi x)  <->  (K_phi x) = 0
*)

[T | SET] [phi | T -> Prop] [z : decidable_pred phi];

[     char : T -> nat
          = [x:T] select (z x) ZeroN OneN
];

Goal {x:T} iff (phi x) (Eq|Nat (char x) ZeroN);
  intros; Refine select_lemma [t:nat] iff (phi x) (Eq|Nat t ZeroN);
  intros; Refine pair;
  intros; Refine Eq_refl; intros; Refine H;
  intros; Refine pair;
  intros; Refine H H1; intros; Refine Succ_not_zero ? H1;
Save char_ok;

Discharge T;

[A | Set] [phi : Pred A] [z : DecidablePred phi];

Goal extensional|A|Nat (char z);
  Intros ___; Refine select_lemma (Eq|Nat (select (z x) ZeroN OneN));
  intros; Refine select_lemma ([t:nat] Eq|Nat t ZeroN);
  intros; Refine Eq_refl;
  intros; Refine H2; Refine extenPred ? H.Eq_sym; Refine H1;
  intros; Refine select_lemma ([t:nat] Eq|Nat t OneN);
  intros; Refine H1; Refine extenPred ? H; Refine H2;
  intros; Refine Eq_refl;
Save char_exten;

[     Char : Fun A Nat
          = Fun_intro ? char_exten
];

Goal {x:el A} iff (phi.ap x) (Eq (Char.ap x) ZeroN);
  Refine char_ok;
Save Char_ok;

Discharge A;

(* ================================================================================
   Define case distinction 'if' such  that

     (if x y a b) = a     if x = y
     (if x y a b) = b     otherwise

   assuming the discreteness of the set to which x and y belong.
*)

[A | Set] [A_discr : Discrete A];

[     if : (el A) -> (el A) -> {T|SET} T -> T -> T
          = [x,y:el A] select (A_discr x y)
];

Discharge A;

[A | Set] [A_discr | Discrete A]
[B | Set] [B_discr | Discrete B]
[C | Set];

Goal if_true : {x,y|el A} (Eq x y) -> {a,b:el C} Eq (if A_discr x y a b) a;
  intros;
  Refine select_left;
  intros; Refine H2 H1;
  Refine H;
Save;

Goal if_false : {x,y|el A} ~(Eq x y) -> {a,b:el C} Eq (if A_discr x y a b) b;
  intros;
  Refine select_right;
  intros; Refine H2 H1;
  Refine H;
Save;

DischargeKeep A;

Goal {x,y|el A} {x',y'|el B} ((Eq x y) -> (Eq x' y')) -> ((Eq x' y') -> (Eq x y)) ->
     {a,a'|el C} (Eq a a') ->
     {b,b'|el C} (Eq b b') ->
     Eq (if A_discr x y a b) (if B_discr x' y' a' b');
  intros;
  orE A_discr x y;
  intros;
    Refine Eq_trans a; Refine if_true H4;
    Refine Eq_trans a'; Refine H2;
    Refine Eq_sym; Refine if_true (H H4);
  intros;
    Refine Eq_trans b; Refine if_false H4;
    Refine Eq_trans b'; Refine H3;
    Refine Eq_sym; Refine if_false;
    Intros _; Refine H4 (H1 H5);
Save if_exten;

(* --------------------------------------------------------------------------------
   Prove some properties of if.
*)

Goal {x,y:el A} {z:el B} Eq (if A_discr x y z z) z;
  intros;
  orE A_discr x y;
  intros; Refine if_true H;
  intros; Refine if_false H;
Save if_ident;

Goal {f:op B.el} {x,y:el A}{a,b:el B}
     Eq (if A_discr x y (f a) (f b)) (f (if A_discr x y a b));
  intros;
  orE A_discr x y;
  intros;
    Refine Eq_trans (f a);
      Refine if_true H;
    Refine select_lemma ([t:el B] Eq (f a) (f t));
      intros; Refine Eq_refl;
      intros; Refine H1 H;
  intros;
    Refine Eq_trans (f b);
      Refine if_false H;
    Refine select_lemma ([t:el B] Eq (f b) (f t));
      intros; Refine H H1;
      intros; Refine Eq_refl;
Save if_distrib;

Discharge A;
