
Module basic Import lib_logic;

(* --------------------------------------------------------------------------------
   Extend the lib_logic file with some more (impredicative) logic.
*)

[     trueprf : trueProp
          = [P:Prop] [p:P] p
];

[A,B,C,D,E,F,G,H,I|Prop] [a:A][b:B][c:C][d:D][e:E][f:F][g:G][h:H][i:I];

[     and8 [A,B,C,D,E,F,G,H:Prop] : Prop
          = {chi|Prop} {premise:A->B->C->D->E->F->G->H->chi} chi
]
[     pair8 : and8 A B C D E F G H
          = [chi|Prop] [premise:A->B->C->D->E->F->G->H->chi] premise a b c d e f g h
]
[     and8_out1 [conj:and8 A B C D E F G H] : A
          = conj [a:A]B\C\D\E\F\G\H\a
]
[     and8_out2 [conj:and8 A B C D E F G H] : B
          = conj A\[b:B]C\D\E\F\G\H\b
]
[     and8_out3 [conj:and8 A B C D E F G H] : C
          = conj A\B\[c:C]D\E\F\G\H\c
]
[     and8_out4 [conj:and8 A B C D E F G H] : D
          = conj A\B\C\[d:D]E\F\G\H\d
]
[     and8_out5 [conj:and8 A B C D E F G H] : E
          = conj A\B\C\D\[e:E]F\G\H\e
]
[     and8_out6 [conj:and8 A B C D E F G H] : F
          = conj A\B\C\D\E\[f:F]G\H\f
]
[     and8_out7 [conj:and8 A B C D E F G H] : G
          = conj A\B\C\D\E\F\[g:G]H\g
]
[     and8_out8 [conj:and8 A B C D E F G H] : H
          = conj A\B\C\D\E\F\G\[h:H]h
];

[     and9 [A,B,C,D,E,F,G,H,I:Prop] : Prop
          = {chi|Prop} {premise:A->B->C->D->E->F->G->H->I->chi} chi
]
[     pair9 : and9 A B C D E F G H I
          = [chi|Prop] [prem:A->B->C->D->E->F->G->H->I->chi] (prem a b c d e f g h i)
]
[     and9_out1 [conj:and9 A B C D E F G H I] : A
          = conj [a:A]B\C\D\E\F\G\H\I\a
]
[     and9_out2 [conj:and9 A B C D E F G H I] : B
          = conj A\[b:B]C\D\E\F\G\H\I\b
]
[     and9_out3 [conj:and9 A B C D E F G H I] : C
          = conj A\B\[c:C]D\E\F\G\H\I\c
]
[     and9_out4 [conj:and9 A B C D E F G H I] : D
          = conj A\B\C\[d:D]E\F\G\H\I\d
]
[     and9_out5 [conj:and9 A B C D E F G H I] : E
          = conj A\B\C\D\[e:E]F\G\H\I\e
]
[     and9_out6 [conj:and9 A B C D E F G H I] : F
          = conj A\B\C\D\E\[f:F]G\H\I\f
]
[     and9_out7 [conj:and9 A B C D E F G H I] : G
          = conj A\B\C\D\E\F\[g:G]H\I\g
]
[     and9_out8 [conj:and9 A B C D E F G H I] : H
          = conj A\B\C\D\E\F\G\[h:H]I\h
]
[     and9_out9 [conj:and9 A B C D E F G H I] : I
          = conj A\B\C\D\E\F\G\H\[i:I]i
];

Discharge A;

(* Define two notions of classical logic without assuming it. *)

[    ExcludedMiddle : Prop
          = {alpha:Prop} alpha \/ ~alpha
]
[    Classical : Prop
          = {alpha:Prop} ~~alpha -> alpha
];

(* ------------------------------------------------------------------------------
   Define the notion of unary and binary operations over a type T.
*)

[     op [T:TYPE] : TYPE
          = T -> T
]
[     bop [T:TYPE] : TYPE
          = T -> T -> T
];

(* --------------------------------------------------------------------------------
   Define some notions for predicates and relations.
*)

[T | SET] [eq : T->T->Prop] [R : T->T->Prop] [P : T->Prop];

[     reflexive : Prop
          = {x:T} R x x
]
[     irreflexive : Prop
          = {x:T} ~(R x x)
]
[     symmetric : Prop
          = {x,y|T} (R x y) -> (R y x)
]
[     transitive : Prop
          = {x|T}{y:T}{z|T} (R x y) -> (R y z) -> (R x z)
]
[     antisymmetric : Prop
          = {x,y|T} (R x y) -> (R y x) -> eq x y
]
[     total : Prop
          = {x,y:T} (R x y) \/ (R y x)
]
[     decidable_pred : Prop
          = {x:T} (P x) \/ ~(P x)
]
[     decidable_rel : Prop
          = {x,y:T} (R x y) \/ ~(R x y)
];

Discharge T;

[     lowerbound [T,U|SET] [R:T->U->Prop] [e:T] : Prop
          = {x:U} R e x
];

(* --------------------------------------------------------------------------------
   Next, some notions regarding binary operators.
*)

[T,U,V | SET] [eqT : T->T->Prop] [eqU : U->U->Prop] [eqV : V->V->Prop];

[     idempotent [o:T->T->T] : Prop
          = {x:T} eqT (o x x) x
]
[     associative [o:T->T->T]
          = {x,y,z:T} eqT (o x (o y z)) (o (o x y) z)
]
[     commutative
          = [o:U->U->T] {x,y:U} eqT (o x y) (o y x)
]
[     involutive [f:T->T] : Prop
          = {x:T} eqT (f (f x)) x
]
[     distributive [o:T->T->T] [f:T->T] : Prop
          = {y,y':T} eqT (f (o y y')) (o (f y) (f y'))
]
[     l_inverse [o:V->U->T] [e:T] [f:U->V] : Prop
          =  {x:U} eqT (o (f x) x) e
]
[     r_inverse [o:V->U->T] [e:T] [f:V->U]: Prop
          =  {x:V} eqT (o x (f x)) e
]
[     l_identity [o:U->T->T] [e:U] : Prop
          = {x:T} eqT (o e x) x
]
[     r_identity [o:T->U->T] [e:U] : Prop
          = {x:T} eqT (o x e) x
]
[     l_cancelation [o:U->T->V] : Prop
          = {a:U}{x,y|T} (eqV (o a x) (o a y)) -> eqT x y
]
[     r_cancelation [o:T->U->V] : Prop
          = {a:U}{x,y|T} (eqV (o x a) (o y a)) -> eqT x y
];

DischargeKeep T;

[     inverse [o:U->U->T] [e:T] [f:U->U] : Prop
          = (l_inverse eqT o e f) /\ (r_inverse eqT o e f)
]
[     identity [o:T->T->T] [e:T] : Prop
          = (l_identity eqT o e) /\ (r_identity eqT o e)
]
[     cancelation [o:T->U->V] : Prop
          = (l_cancelation eqU eqV o) /\ (r_cancelation eqT eqV o)
];

Discharge eqT;

(* --------------------------------------------------------------------------------
   Define what it is for a function to preserve some relation.
*)

[RT : T->T->Prop] [RU : U->U->Prop] [RV : V->V->Prop];

[     preserve1 [f:T->V] : Prop
          = {x,x'|T} (RT x x') -> RV (f x) (f x')
]
[     preserve2 [o:T->U->V] : Prop
          = {x,x'|T} (RT x x') -> {y,y'|U} (RU y y') -> RV (o x y) (o x' y')
]
[     preserve2r [o:T->U->V] : Prop
          = {x,x'|T} (RT x x') -> {y:U} RV (o x y) (o x' y)
];

Discharge T;

(* --------------------------------------------------------------------------------
   The composition of a binary function h and two unary functions f and g.
*)

[     compose2 [S,T,U,V|SET] : (T->U->V) -> (S->T) -> (S->U) -> (S->V)
          = [h:T->U->V] [f:S->T] [g:S->U] [x:S] h (f x) (g x)
];
