
Module Sum Import Set;

(* Define the sum -or disjoint union- of two types by an inductive defintion. *)

Inductive [sum : SET]
Parameters [A,B : SET]
Constructors [sum_i' : A -> sum] [sum_j' : B -> sum]
Double;
Discharge A;

[T,U | SET];

[     sum_i : T -> sum T U
          = sum_i' T U
]
[     sum_j : U -> sum T U
          = sum_j' T U
];

Discharge T;

(* --------------------------------------------------------------------------------
   Define the disjoint union of two sets.
*)

[A,B : Set];

[     eq_sum : (sum A.el B.el) -> (sum A.el B.el) -> Prop
          = sum_double_elim A.el B.el ([_,_:sum A.el B.el] Prop)
                            (Eq|A)
                            (A.el\B.el\absurd)
                            (B.el\A.el\absurd)
                            (Eq|B)
];

Goal reflexive eq_sum;
  Refine sum_elim ?? [x:sum A.el B.el] eq_sum x x;
  Refine Eq_refl;
  Refine Eq_refl;
Save eq_sum_refl;

Goal symmetric eq_sum;
  Refine sum_double_elim ?? [x,y:sum A.el B.el] (eq_sum x y) -> (eq_sum y x);
  Refine Eq_sym;
  intros; Refine H;
  intros; Refine H;
  Refine Eq_sym;
Save eq_sum_sym;

Goal transitive eq_sum;
  Refine sum_double_elim ?? [x,y:sum A.el B.el] {z:sum A.el B.el}
         (eq_sum x y) -> (eq_sum y z) -> (eq_sum x z);
  intros x x';
    Refine sum_elim ?? [z:sum A.el B.el]
      (eq_sum (sum_i x) (sum_i x')) -> (eq_sum (sum_i x') z) -> (eq_sum (sum_i x) z);
    Refine Eq_trans;
    intros __; Refine Id;
  intros; Refine H;
  intros; Refine H;
  intros y y';
    Refine sum_elim ?? [z:sum A.el B.el]
      (eq_sum (sum_j y) (sum_j y')) -> (eq_sum (sum_j y') z) -> (eq_sum (sum_j y) z);
    intros __; Refine Id;
    Refine Eq_trans;
Save eq_sum_trans;

[     Sum : Set
          = Set_intro eq_sum_refl eq_sum_sym eq_sum_trans
];

Discharge A;

(* --------------------------------------------------------------------------------
   Show that the sum of two discrete sets is discrete again.
*)

Goal Sum_discr : {A,B|Set} A.Discrete -> B.Discrete -> (Sum A B).Discrete;
  Intros A B discr_A discr_B;
  Refine sum_double_elim ?? [t,u:el (Sum A B)] (Eq t u) \/ ~(Eq t u);
  Refine discr_A;
  intros; Refine inr; Refine PropId;
  intros; Refine inr; Refine PropId;
  Refine discr_B;
Save;

(* --------------------------------------------------------------------------------
   Show that B \/ A and A \/ B are isomorphic.
*)

[     sum_swap [A,B|Set] : (Sum A B).el -> (Sum B A).el
          = sum_elim (el A) (el B) ((Sum A B).el\(Sum B A).el)
                     (sum_j|(el B)|(el A))
                     (sum_i|(el B)|(el A))
];

Goal {A,B|Set} extensional (sum_swap|A|B);
  intros;
  Refine sum_double_elim ?? [x,x'|el (Sum A B)]
           (Eq x x') -> Eq (sum_swap x) (sum_swap x');
  intros __; Refine Id;
  intros __; Refine Id;
  intros __; Refine Id;
  intros __; Refine Id;
Save sum_swap_exten;

[     SumSwap [A,B:Set] : Fun (Sum A B) (Sum B A)
          = Fun_intro (sum_swap|A|B) (sum_swap_exten|A|B)
];

Goal {A,B:Set} Isomorphism (Sum A B) (Sum B A);
  intros;
  Intros #; Refine SumSwap;
  Intros #; Refine SumSwap;
  Refine pair;
  Refine sum_elim ?? [a:el (Sum A B)] Eq (sum_swap (sum_swap a)) a;
  Refine Eq_refl;
  Refine Eq_refl;
  Refine sum_elim ?? [b:el (Sum B A)] Eq (sum_swap (sum_swap b)) b;
  Refine Eq_refl;
  Refine Eq_refl;
Save SumSwap_iso;
