
Module RootC Import SqrtC PolyC;

(* This module shows that for every complex number x and every natural
   number k>0 we have a complex number y such that y^n = x. *)

(* For this we assume that every polynomial in R with odd degree has a root. *)

$[    OddRootR
          : {P:el PolyR} (Odd.ap (DegreeR.ap P)) -> Ex [y:el Real] Eq (apPR P y) ZeroR
];

(* --------------------------------------------------------------------------------
   This is the induction predicate:
*)

[     RootC_phi : Nat.el -> Prop
          = [n:el Nat] {x:el Cplx} ~(Eq n ZeroN) ->
                       Ex [y:el Cplx] Eq (PowerC.ap2 y n) x
];

(* Prove (phi n) for all even n, if we assume (phi m) for all m smaller then n. *)

Goal {n:el Nat} ({p:el Nat} (LessN.ap2 p n) -> RootC_phi p) ->
     (Even.ap n) -> RootC_phi n;
  Intros n ih n_even x n_not_zero;
  exE n_even; intros p H;
  exE ih p ? (SqrtC.ap x);
    Refine extenRel ? ?.Eq_refl H; Refine LessN_lemma3 ?+1;
    Refine DoubleN_lemma2; Qrepl H; Refine n_not_zero;
    intros y _;
  Refine ExIntro; Refine y;
  Qrepl H.Eq_sym;
  Refine Eq_trans (SquareC.ap (PowerC.ap2 y p));
    Refine PowerC_plus;
  Refine Eq_trans (SquareC.ap (SqrtC.ap x));
    Refine exten SquareC H1;
  Refine SqrtC_lemma1;
Save RootC_even_n;

(* --------------------------------------------------------------------------------
   So from now we only have to prove (phi n) for odd n.
*)

[n | el Nat] [n_odd : odd n];

(* Prove every x in R has an n-th root if n is odd. *)

Goal {x:el Real} Ex [y:el Real] Eq (PowerR.ap2 y n) x;
  intros;
  [P = PlusPR.ap2 (PowerPR.ap2 IdPolyR n) (ConstPolyR.ap (NegR.ap x))];
  exE OddRootR P;

  Refine extenPred Odd ? n_odd; Refine Eq_sym;
  Refine Eq_trans (DegreeR.ap (PowerPR.ap2 IdPolyR n));
    Refine DegreePlusPR_lemma2;
    Refine DegreeP1_const;
  Refine Eq_trans (TimesN.ap2 n (DegreeR.ap IdPolyR));
    Refine DegreeP1_power;
  Refine Eq_trans (TimesN.ap2 n OneN);
    Refine exten2 ? ?.Eq_refl;
    Refine DegreeP1_id;
  Refine rOneN_ident;

  intros y _;
  Refine ExIntro; Refine y;
  Refine MinusR_lemma1;
  Refine Eq_trans (apPR P y);
    Refine +1 H;
  Refine Eq_sym;
  Refine Eq_trans (PlusR.ap2 (apPR (PowerPR.ap2 IdPolyR n) y)
                             (apPR (ConstPolyR.ap (NegR.ap x)) y));
    Refine apPR_plus;
  Refine exten2; Refine +1 apPR_const;
  Refine Eq_trans (PowerR.ap2 (apPR IdPolyR y) n);
    Refine apPR_power;
  Refine exten2 PowerR ? ?.Eq_refl; Refine apPR_id;
Save RootR_odd_n;

(* --------------------------------------------------------------------------------
*)

[f : el Cplx];

Goal (IsReal.ap f) -> Ex [y1:el Cplx] Eq (PowerC.ap2 y1 n) f;
  intros;
  exE RootR_odd_n | f.re; intros y1 _;
  Refine ExIntro; Refine Cp.ap y1;
  Refine Eq_trans (PowerR.ap2 y1 n).cp;
    Refine (Cp_power ? ?).Eq_sym;
  Refine eq_cplx_intro; Refine H1; Refine H.Eq_sym;
Save RootC_real_f;

$[d : el Cplx = SqrtC.ap f]

$[dP     = ConstPolyC.ap d]       $[mdP    = ConstPolyC.ap (NegC.ap d)];
                                  $[cdP    = ConstPolyC.ap (Conj.ap d)];
$[IP     = ConstPolyC.ap I]       $[mIP    = ConstPolyC.ap (NegC.ap I)];
$[XpI    = PlusPC.ap2 IdPolyC IP] $[XmI    = PlusPC.ap2 IdPolyC mIP];
$[XpIn   = PowerPC.ap2 XpI n]     $[XmIn   = PowerPC.ap2 XmI n];
$[cdXpIn = TimesPC.ap2 cdP XpIn]  $[mdXmIn = TimesPC.ap2 mdP XmIn];

$[P = TimesPC.ap2 (ConstPolyC.ap I) (PlusPC.ap2 cdXpIn mdXmIn)];

Freeze PlusPC TimesPC;

Goal Eq (ConjP.ap cdXpIn) (TimesPC.ap2 dP XmIn);
  Refine Eq_trans (TimesPC.ap2 (ConjP.ap cdP) (ConjP.ap XpIn));
    Refine ConjP_times;
  Refine exten2;
  Refine Eq_trans (ConstPolyC.ap (Conj.ap (Conj.ap d)));
    Refine ConjP_const;
  Refine exten; Refine Conj_invol;
  Refine Eq_trans (PowerPC.ap2 (ConjP.ap XpI) n);
    Refine ConjP_power;
  Refine exten2 ? ? ?.Eq_refl;
  Refine Eq_trans (PlusPC.ap2 (ConjP.ap IdPolyC) (ConjP.ap IP));
    Refine ConjP_plus;
  Refine exten2 ? ConjP_id;
  Refine Eq_trans (ConstPolyC.ap (Conj.ap I));
    Refine ConjP_const;
  Refine exten; Refine ConjI;
Save RootC_lemma4;

Goal Eq (ConjP.ap mdXmIn) (NegPC.ap cdXpIn);
  Refine Eq_trans (ConjP.ap (NegPC.ap (TimesPC.ap2 dP XmIn)));
    Refine exten;
    Refine Eq_trans (TimesPC.ap2 (NegPC.ap dP) XmIn);
      Refine exten2 ? ?.Eq_sym ?.Eq_refl; Refine NegPC_const;
    Refine lTimesNegPC_distrib;
  Refine Eq_trans (NegPC.ap (ConjP.ap (TimesPC.ap2 dP XmIn)));
    Refine ConjP_neg;
  Refine exten;
  Refine Eq_trans (TimesPC.ap2 (ConjP.ap dP) (ConjP.ap XmIn));
    Refine ConjP_times;
  Refine exten2; Refine ConjP_const;
  Refine Eq_trans (PowerPC.ap2 (ConjP.ap XmI) n);
    Refine ConjP_power;
  Refine exten2 ? ? ?.Eq_refl;
  Refine Eq_trans (PlusPC.ap2 (ConjP.ap IdPolyC) (ConjP.ap mIP));
    Refine ConjP_plus;
  Refine exten2; Refine ConjP_id;
  Refine Eq_trans (ConstPolyC.ap (Conj.ap (NegC.ap I)));
    Refine ConjP_const;
  Refine exten;
  Refine Eq_trans (Conj.ap (Conj.ap I));
    Refine exten; Refine Eq_sym ConjI;
  Refine Conj_invol;
Save RootC_lemma5;

Goal Eq P (ConjP.ap P);
  Refine Eq_sym;
  Refine Eq_trans (TimesPC.ap2 (ConjP.ap IP) (ConjP.ap (PlusPC.ap2 cdXpIn mdXmIn)));
    Refine ConjP_times;
  Refine Eq_trans (TimesPC.ap2 (NegPC.ap IP)
                               (PlusPC.ap2 (ConjP.ap cdXpIn) (ConjP.ap mdXmIn)));
    Refine exten2;
    Refine +1 ConjP_plus;
    Refine Eq_trans (ConstPolyC.ap (Conj.ap I));
      Refine ConjP_const;
    Refine Eq_trans (ConstPolyC.ap (NegC.ap I));
      Refine exten; Refine ConjI;
    Refine Eq_sym; Refine NegPC_const;
  Refine Eq_trans (NegPC.ap (TimesPC.ap2 IP
                                 (PlusPC.ap2 (ConjP.ap cdXpIn) (ConjP.ap mdXmIn))));
    Refine lTimesNegPC_distrib;
  Refine Eq_trans (TimesPC.ap2 IP (NegPC.ap
                                 (PlusPC.ap2 (ConjP.ap cdXpIn) (ConjP.ap mdXmIn))));
    Refine Eq_sym; Refine rTimesNegPC_distrib;
  Refine exten2 ? ?.Eq_refl;
  Refine Eq_trans (PlusPC.ap2 (NegPC.ap (ConjP.ap cdXpIn))
                              (NegPC.ap (ConjP.ap mdXmIn)));
    Refine Eq_sym; Refine PlusNegPC_distrib;
  Refine Eq_trans (PlusPC.ap2 (NegPC.ap (ConjP.ap mdXmIn))
                              (NegPC.ap (ConjP.ap cdXpIn)));
    Refine PlusPC_commut;
  Refine exten2;
  Refine Eq_trans (NegPC.ap (NegPC.ap cdXpIn));
    Refine exten; Refine RootC_lemma5;
  Refine NegPC_invol;
  Refine Eq_trans (NegPC.ap (TimesPC.ap2 dP XmIn));
    Refine exten; Refine RootC_lemma4;
  Refine Eq_trans (TimesPC.ap2 (NegPC.ap dP) XmIn);
    Refine Eq_sym; Refine lTimesNegPC_distrib;
  Refine exten2 ? ? ?.Eq_refl; Refine NegPC_const;
Save RootC_lemma6;

[f_not_real : ~(IsReal.ap f)];

Goal ~(IsReal.ap d);
  Intros _;
  Refine f_not_real;
  Refine SqrtC_is_real H;
Save RootC_d_not_real;

Goal ~(Eq d ZeroC);
  Intros _;
  Refine RootC_d_not_real;
  Refine snd H.eq_cplx_elim;
Save RootC_d_not_zero;

Goal LessEqN.ap2 (DegreeC.ap P) n;
  Refine extenRel;
    Refine DegreeC.ap (PlusPC.ap2 cdXpIn mdXmIn);
    Refine +1 MaxN.ap2 (DegreeC.ap cdXpIn) (DegreeC.ap mdXmIn);
  Refine Eq_sym; Refine DegreeC_const_times; Refine I_not_zero;
  Refine +1 DegreeC_plus;
  Refine Eq_trans (MaxN.ap2 n n);
    Refine +1 Max_idempot;
  Refine exten2;

  Refine Eq_trans (DegreeC.ap XpIn);
    Refine DegreeC_const_times; Refine Conj_not_zero; Refine RootC_d_not_zero;
  Refine Eq_trans (TimesN.ap2 n (DegreeC.ap XpI));
    Refine DegreeC_power;
  Refine Eq_trans (TimesN.ap2 n OneN);
    Refine +1 rOneN_ident;
  Refine exten2 ? ?.Eq_refl;
  Refine Eq_trans (DegreeC.ap IdPolyC);
    Refine DegreeC_plus_const;
  Refine DegreeP1_id;

  Refine Eq_trans (DegreeC.ap XmIn);
    Refine DegreeC_const_times; Refine NegC_not_zero; Refine RootC_d_not_zero;
  Refine Eq_trans (TimesN.ap2 n (DegreeC.ap XmI));
    Refine DegreeC_power;
  Refine Eq_trans (TimesN.ap2 n OneN);
    Refine +1 rOneN_ident;
  Refine exten2 ? ?.Eq_refl;
  Refine Eq_trans (DegreeC.ap IdPolyC);
    Refine DegreeC_plus_const;
  Refine DegreeP1_id;
Save RootC_lemma7;

Freeze PlusC;

Goal ~(Eq (CoefC.ap2 P n) ZeroC);
  Intros _;
  Refine TimesFd_not_zero COMPLEX | I | (MinusC.ap2 (Conj.ap d) d);
  Refine I_not_zero;
  Intros _; Refine RootC_d_not_real; Refine ConjIsReal;
    Refine Eq_sym; Refine MinusFd_lemma1 COMPLEX H1;
  Refine Eq_trans (CoefC.ap2 P n) ? H;
  Refine Eq_sym;
  Refine Eq_trans (TimesC.ap2 I (CoefC.ap2 (PlusPC.ap2 cdXpIn mdXmIn) n));
    Refine lTimesPolyC_const;
  Refine exten2 ? ?.Eq_refl;
  Refine Eq_trans (PlusC.ap2 (CoefC.ap2 cdXpIn n) (CoefC.ap2 mdXmIn n));
    Refine PlusPC_distrib;
  Refine exten2 PlusC;
  Refine Eq_trans (TimesC.ap2 (Conj.ap d) (CoefC.ap2 XpIn n));
    Refine lTimesPolyC_const;
  Refine Eq_trans (TimesC.ap2 (Conj.ap d) OneC);
    Refine exten2 ? ?.Eq_refl; Refine PolyC_binon_lemma1;
  Refine rOneC_ident;
  Refine Eq_trans (TimesC.ap2 (NegC.ap d) (CoefC.ap2 XmIn n));
    Refine lTimesPolyC_const;
  Refine Eq_trans (TimesC.ap2 (NegC.ap d) OneC);
    Refine exten2 ? ?.Eq_refl; Refine PolyC_binon_lemma1;
  Refine rOneC_ident;
Save RootC_lemma8;

Unfreeze PlusC;

Goal Eq (DegreeC.ap P) n;
  Refine DegreeP1_intro COMPLEX_Ring Cplx_discr;
  Refine RootC_lemma8;
  Refine RootC_lemma7;
Save RootC_degree;

Goal Odd.ap (DegreeR.ap (ReP.ap P));
  Refine extenPred; Refine +2 n_odd;
  Refine Eq_sym;
  Refine Eq_trans ? ? RootC_degree;
  Refine DegreeC_lemma1;
  Refine RootC_lemma6;
Save RootC_odd_degree;

Goal Ex [y:el Real] Eq (apPC P (Cp.ap y)) ZeroC;
  exE OddRootR (ReP.ap P);
  Refine RootC_odd_degree;
  intros y _; Refine ExIntro; Refine y;
  Refine Eq_trans (apPC (CpP.ap (ReP.ap P)) (Cp.ap y));
    Refine exten2 ApPC; Refine +1 Eq_refl;
    Refine Eq_sym; Refine CpP_lemma;
    Refine RootC_lemma6;
  Refine Eq_trans (Cp.ap (apPR (ReP.ap P) y));
    Refine Eq_sym; Refine apP_Cp_distrib;
  Refine eq_cplx_intro; Refine H; Refine Eq_refl;
Save RootC_root;

[x : el Cplx] [x_not_I : ~(Eq x I)];

$[xpI = PlusC.ap2 x I] $[xmI = MinusC.ap2 x I]
$[xpIn = PowerC.ap2 xpI n] $[xmIn = PowerC.ap2 xmI n];

Goal (Eq (TimesC.ap2 I (MinusC.ap2 (TimesC.ap2 (Conj.ap d) xpIn) (TimesC.ap2 d xmIn)))
         ZeroC) ->
     Eq (PowerC.ap2 (DivC.ap2 xpI xmI) n) (DivC.ap2 d (Conj.ap d));
  intros;
  Claim ~(Eq xmI ZeroC);
  Refine Eq_trans (DivC.ap2 xpIn xmIn);
    Refine Eq_sym; Refine PowerFd_div COMPLEX ?+2;
  Refine DivFd_lemma7 COMPLEX;
    Refine Conj_not_zero; Refine RootC_d_not_zero;
    Refine PowerFd_not_zero COMPLEX ?+2;
  Refine Eq_trans (TimesC.ap2 (Conj.ap d) xpIn);
    Refine TimesC_commut;
  Refine Eq_trans (TimesC.ap2 d xmIn);
    Refine +1 TimesC_commut;
  Refine MinusFd_lemma1 COMPLEX;
  orE TimesC_zero ? ? H;
  intros; Refine I_not_zero H1;
  Refine Id;
  Intros _; Refine x_not_I; Refine MinusFd_lemma1 COMPLEX H1;
Save RootC_lemma9;

Goal (Eq (apPC P x) ZeroC) ->
     Eq (PowerC.ap2 (DivC.ap2 xpI xmI) n) (DivC.ap2 d (Conj.ap d));
  intros;
  Refine RootC_lemma9;
  Refine Eq_trans (apPC P x) ? H;
  Refine Eq_sym;
  Refine Eq_trans (TimesC.ap2 (apPC IP x) (apPC (PlusPC.ap2 cdXpIn mdXmIn) x));
    Refine apPC_times;
  Refine exten2; Refine apPC_const;
  Refine Eq_trans (PlusC.ap2 (apPC cdXpIn x) (apPC mdXmIn x));
    Refine apPC_plus;
  Refine exten2 PlusC;

  Refine Eq_trans (TimesC.ap2 (apPC cdP x) (apPC XpIn x));
    Refine apPC_times;
  Refine exten2; Refine apPC_const;
  Refine Eq_trans (PowerC.ap2 (apPC XpI x) n);
    Refine apPC_power;
  Refine exten2 ? ? ?.Eq_refl;
  Refine Eq_trans (PlusC.ap2 (apPC IdPolyC x) (apPC IP x));
    Refine apPC_plus;
  Refine exten2; Refine apPC_id; Refine apPC_const;

  Refine Eq_trans (TimesC.ap2 (apPC mdP x) (apPC XmIn x));
    Refine apPC_times;
  Refine Eq_trans (TimesC.ap2 (NegC.ap d) xmIn);
    Refine +1 lTimesNegFd_distrib COMPLEX;
  Refine exten2; Refine apPC_const;
  Refine Eq_trans (PowerC.ap2 (apPC XmI x) n);
    Refine apPC_power;
  Refine exten2 ? ? ?.Eq_refl;
  Refine Eq_trans (PlusC.ap2 (apPC IdPolyC x) (apPC mIP x));
    Refine apPC_plus;
  Refine exten2; Refine apPC_id; Refine apPC_const;
Save RootC_lemma10;

Goal (Eq (AbsC.ap f) OneR) -> (Eq (apPC P x) ZeroC) ->
     Eq (PowerC.ap2 (DivC.ap2 xpI xmI) n) f;
  intros;
  Refine Eq_trans (DivC.ap2 d (Conj.ap d));
    Refine RootC_lemma10 H1;
  Refine SqrtC_lemma3 H;
Save RootC_lemma11;

Discharge n;

Unfreeze PlusPC TimesPC;

(* ================================================================================

   \forall x \in C .
      \forall n>0 \in N .      n
        \exists y \in C .     y   =   x

*)

Goal RootC
   : {x:el Cplx}{n:el Nat} ~(Eq n ZeroN) -> Ex [y:el Cplx] Eq (PowerC.ap2 y n) x;
  intros x' n';
  Refine CourseValueInduction RootC_phi;
  Intros n ih x _;
  orE odd_or_even n;
  intros +1; Refine RootC_even_n n ih H1 x H;

(* suppose n is odd                              *)
  intros;
  exE CplxSplit x; intros f _; andE H2;
(* let f:C be such that |f| = 1 and |x|f = x     *)
  exE RootR_odd_n H1 (AbsC.ap x); intros y0 _;
(* let y0:R be such that y0^n = |x|              *)
  Claim Ex [y3:el Cplx] Eq (PowerC.ap2 y3 n) f;
  exE ?+1; intros y3 _;
  Refine ExIntro; Refine TimesC.ap2 (Cp.ap y0) y3;
  Refine Eq_trans (TimesC.ap2 (PowerC.ap2 (Cp.ap y0) n) (PowerC.ap2 y3 n));
    Refine PowerC_distrib;
  Refine Eq_trans (TimesC.ap2 (Cp.ap (AbsC.ap x)) f);
    Refine +1 H4;
  Refine exten2 ? ? H6;
  Refine Eq_trans (Cp.ap (PowerR.ap2 y0 n));
    Refine Eq_sym; Refine Cp_power;
  Refine exten ? H5;

  orE IsReal_dec f;
  Refine RootC_real_f H1 f;

(* suppose f is not real                     *)
  intros; [d = SqrtC.ap f];
  exE RootC_root H1 f H6;
  intros y1 _; [y2 = Cp.ap y1];
  Refine ExIntro; Refine (DivC.ap2 (PlusC.ap2 y2 I) (MinusC.ap2 y2 I));
  Refine RootC_lemma11 f H6 ? ? H3 H7;
  Intros _; Refine Real_non_trivial H8.eq_cplx_elim.snd;
Save;
