
Module Ring Import AbMonoid Group_homo;

[     sigRg : Signature
          = Signature_intro (FiveSET_iter ZeroN   (* a constant *)
                                          ZeroN   (* a constant *)
                                          OneN    (* a unary function *)
                                          TwoN    (* a binary function *)
                                          TwoN    (* a binary function *)
                            )
                            EmptySET_nat
];

Goal axiomsRg : Axioms sigRg;
  Refine Axioms_intro;
  Intros A IC IP;
  Zero  == (IC star51).apn : el A;
  One   == (IC star52).apn : el A;
  Neg   == IC star53       : Fun A A;
  Plus  == IC star54       : Fun2 A A A;
  Times == IC star55       : Fun2 A A A;
  Refine and7 (Associative Plus)
              (Commutative Plus)
              (Identity Plus Zero)
              (Inverse Plus Zero Neg)
              (Associative Times)
              (Identity Times One)
              (Distributive Plus Times);
Save;

[     Ring
          = Model axiomsRg
];

Goal Ring_intro : {A:Set}{Plus,Times:Fun2 A A A}{Neg:Fun A A}{Zero,One:el A}
      {Plus_assoc  : Associative Plus}    {Plus_commut  : Commutative Plus}
      {rZero_ident : rIdentity Plus Zero} {rNeg_invers  : rInverse Plus Zero Neg}
      {Times_assoc : Associative Times}   {One_ident    : Identity Times One}
      {Plus_Times_distrib : Distributive Plus Times}
      Ring;
  intros;
  Refine Model_intro;
  Refine A;
  Refine FiveSET_elim [c:FuncSymb sigRg] nFunc A (FuncArity c);
  Refine constant Zero;
  Refine constant One;
  Refine Neg;
  Refine Plus;
  Refine Times;
  intros c; Refine EmptySET_iter c;
  Refine pair7 Plus_assoc
               Plus_commut
               (Identity_intro Plus_commut rZero_ident)
               (Inverse_intro Plus_commut rNeg_invers)
               Times_assoc
               One_ident
               Plus_Times_distrib;
Save;

(* --------------------------------------------------------------------------------
   Let R be a ring. Define functions to extract all components of R.
*)

[R : Ring];

  [ZeroRg     : obj R       = intCons R star51]
  [OneRg      : obj R       = intCons R star52]
  [NegRg      : UFunMdl R   = intFunc R star53]
  [PlusRg     : BFunMdl R   = intFunc R star54]
  [TimesRg    : BFunMdl R   = intFunc R star55];

  [PlusRg_assoc        : Associative PlusRg           = and7_out1 R.axioms]
  [PlusRg_commut       : Commutative PlusRg           = and7_out2 R.axioms]
  [ZeroRg_ident        : Identity PlusRg ZeroRg       = and7_out3 R.axioms]
  [NegRg_invers        : Inverse PlusRg ZeroRg NegRg  = and7_out4 R.axioms]
  [TimesRg_assoc       : Associative TimesRg          = and7_out5 R.axioms]
  [OneRg_ident         : Identity TimesRg OneRg       = and7_out6 R.axioms]
  [TimesPlusRg_distrib : Distributive PlusRg TimesRg  = and7_out7 R.axioms];

Freeze ZeroRg OneRg NegRg PlusRg TimesRg;

  [lZeroRg_ident        : lIdentity PlusRg ZeroRg      = fst ZeroRg_ident       ]
  [lNegRg_invers        : lInverse PlusRg ZeroRg NegRg = fst NegRg_invers       ]
  [lOneRg_ident         : lIdentity TimesRg OneRg      = fst OneRg_ident        ]
  [lTimesPlusRg_distrib : lDistributive PlusRg TimesRg = fst TimesPlusRg_distrib]
  [rZeroRg_ident        : rIdentity PlusRg ZeroRg      = snd ZeroRg_ident       ]
  [rNegRg_invers        : rInverse PlusRg ZeroRg NegRg = snd NegRg_invers       ]
  [rOneRg_ident         : rIdentity TimesRg OneRg      = snd OneRg_ident        ]
  [rTimesPlusRg_distrib : rDistributive PlusRg TimesRg = snd TimesPlusRg_distrib];

  [applGroup  : Group  = Group_intro PlusRg_assoc rNegRg_invers rZeroRg_ident]
  [multMonoid : Monoid = Monoid_intro TimesRg_assoc OneRg_ident];

  [NegOneRg : obj R       = NegRg.ap OneRg]
  [TwoRg    : obj R       = PlusRg.ap2 OneRg OneRg]
  [MinusRg  : BFunMdl R   = applGroup.DivGr];

  [     NegRg_invol : Involutive NegRg
            = applGroup.InvGr_invol
  ];

  Goal MinusRg_lemma1 : {x,y|obj R} (Eq (MinusRg.ap2 x y) ZeroRg) -> Eq x y;
    Refine applGroup.DivGr_lemma1;
  Save;

  [     PlusRg_cancel : Cancelation PlusRg
            = applGroup.TimesGr_cancel
  ]
  [     rPlusRg_cancel : rCancelation PlusRg
            = applGroup.rTimesGr_cancel
  ]
  [     lPlusRg_cancel : lCancelation PlusRg
            = applGroup.lTimesGr_cancel
  ]
  [     NegZeroRg : Eq (NegRg.ap ZeroRg) ZeroRg
            = applGroup.InvOneGr
  ]
  [     NegZeroRg_ident : Identity PlusRg (NegRg.ap ZeroRg)
            = applGroup.InvOneGr_ident
  ]
  [     rNegZeroRg_ident : rIdentity PlusRg (NegRg.ap ZeroRg)
            = applGroup.rInvOneGr_ident
  ]
  [     lNegZeroRg_ident : lIdentity PlusRg (NegRg.ap ZeroRg)
            = applGroup.lInvOneGr_ident
  ]
  [     NegRg_inj : Injection NegRg
            = applGroup.InvGr_inj
  ]
  [     NegRg_zero : {x|obj R} (Eq (NegRg.ap x) ZeroRg) -> Eq x ZeroRg
            = applGroup.InvGr_one
  ]
  [     NegRg_not_zero : {x|obj R} ~(Eq x ZeroRg) -> ~(Eq (NegRg.ap x) ZeroRg)
            = applGroup.InvGr_not_one
  ]
  [     NegRg_lemma1 : {x|obj R} (Eq x ZeroRg) -> Eq x (NegRg.ap x)
            = applGroup.InvGr_lemma1
  ]
  [     rPlusRg_commut : {x,y,z:obj R} Eq (PlusRg.ap2 (PlusRg.ap2 x y) z)
                                          (PlusRg.ap2 (PlusRg.ap2 x z) y)
            = applGroup.rTimesGr_commut PlusRg_commut
  ]
  [     lPlusRg_commut : {x,y,z:obj R} Eq (PlusRg.ap2 x (PlusRg.ap2 y z))
                                          (PlusRg.ap2 y (PlusRg.ap2 x z))
            = applGroup.lTimesGr_commut PlusRg_commut
  ];

  Goal PlusNegRg_distrib : {x,y:obj R} Eq (PlusRg.ap2 (NegRg.ap x) (NegRg.ap y))
                                         (NegRg.ap (PlusRg.ap2 x y));
    Intros;
    Refine Eq_trans (NegRg.ap (PlusRg.ap2 y x));
    Refine applGroup.TimesInvGr_distrib;
    Refine exten; Refine PlusRg_commut;
  Save;

  [     DoubleRg : UFunMdl R
            = applGroup.SquareGr
  ]
  [     SquareRg : UFunMdl R
            = multMonoid.SquareMN
  ]
  [     MultRg : Fun2 R.car Nat R.car
            = applGroup.PowerGr
  ];

(* --------------------------------------------------------------------------------
   Prove a list of lemma's valid for rings.
*)

  Goal rTimesMinusRg_distrib : rDistributive MinusRg TimesRg;
    Intros x y y';
    Refine Eq_trans (PlusRg.ap2 (TimesRg.ap2 (MinusRg.ap2 y y') x) ZeroRg);
      Refine Eq_sym; Refine rZeroRg_ident;
    Refine Eq_trans (PlusRg.ap2 (TimesRg.ap2 (MinusRg.ap2 y y') x)
                                (MinusRg.ap2 (TimesRg.ap2 y' x) (TimesRg.ap2 y' x)));
      Refine exten2; Refine Eq_refl; Refine Eq_sym; Refine rNegRg_invers;
    Refine Eq_trans (MinusRg.ap2 (PlusRg.ap2 (TimesRg.ap2 (MinusRg.ap2 y y') x)
                                             (TimesRg.ap2 y' x)) (TimesRg.ap2 y' x));
      Refine PlusRg_assoc;
    Refine exten2; Refine +1 Eq_refl;
    Refine Eq_trans (TimesRg.ap2 (PlusRg.ap2 (MinusRg.ap2 y y') y') x);
      Refine Eq_sym; Refine rTimesPlusRg_distrib;
    Refine exten2; Refine +1 Eq_refl;
    Refine Eq_trans (PlusRg.ap2 y (PlusRg.ap2 (NegRg.ap y') y'));
      Refine Eq_sym; Refine PlusRg_assoc;
    Refine Eq_trans (PlusRg.ap2 y ZeroRg);
      Refine exten2; Refine Eq_refl; Refine lNegRg_invers;
    Refine rZeroRg_ident;
  Save;

  Goal lTimesMinusRg_distrib : lDistributive MinusRg TimesRg;
    Intros x y y';
    [ymy' = MinusRg.ap2 y y'] [xy' = TimesRg.ap2 x y'];
    Refine Eq_trans (PlusRg.ap2 (TimesRg.ap2 x ymy') ZeroRg);
      Refine Eq_sym; Refine rZeroRg_ident;
    Refine Eq_trans (PlusRg.ap2 (TimesRg.ap2 x ymy') (MinusRg.ap2 xy' xy'));
      Refine exten2; Refine Eq_refl; Refine Eq_sym; Refine rNegRg_invers;
    Refine Eq_trans (MinusRg.ap2 (PlusRg.ap2 (TimesRg.ap2 x ymy') xy') xy');
      Refine PlusRg_assoc;
    Refine exten2; Refine +1 Eq_refl;
    Refine Eq_trans (TimesRg.ap2 x (PlusRg.ap2 ymy' y'));
     Refine Eq_sym; Refine lTimesPlusRg_distrib;
    Refine exten2; Refine Eq_refl;
    Refine Eq_trans (PlusRg.ap2 y (PlusRg.ap2 (NegRg.ap y') y'));
      Refine Eq_sym; Refine PlusRg_assoc;
    Refine Eq_trans (PlusRg.ap2 y ZeroRg);
      Refine exten2; Refine Eq_refl; Refine lNegRg_invers;
    Refine rZeroRg_ident;
  Save;

  Goal TimesMinusRg_distrib : Distributive MinusRg TimesRg;
    Refine pair lTimesMinusRg_distrib rTimesMinusRg_distrib;
  Save;

  Goal rTimesZeroRg : {x:obj R} Eq (TimesRg.ap2 x ZeroRg) ZeroRg;
    Intros;
    Refine Eq_trans (TimesRg.ap2 x (MinusRg.ap2 x x));
      Refine exten2; Refine Eq_refl; Refine Eq_sym; Refine rNegRg_invers;
    Refine Eq_trans (MinusRg.ap2 (TimesRg.ap2 x x) (TimesRg.ap2 x x));
      Refine lTimesMinusRg_distrib;
    Refine rNegRg_invers;
  Save;

  Goal lTimesZeroRg : {x:obj R} Eq (TimesRg.ap2 ZeroRg x) ZeroRg;
    Intros;
    Refine Eq_trans (TimesRg.ap2 (MinusRg.ap2 x x) x);
      Refine exten2; Refine Eq_sym; Refine rNegRg_invers; Refine Eq_refl;
    Refine Eq_trans (MinusRg.ap2 (TimesRg.ap2 x x) (TimesRg.ap2 x x));
      Refine rTimesMinusRg_distrib;
    Refine rNegRg_invers;
  Save;

  Goal rTimesNegRg_distrib
     : {x,y:obj R} Eq (TimesRg.ap2 x (NegRg.ap y)) (NegRg.ap (TimesRg.ap2 x y));
    Intros;
    Refine Eq_trans (TimesRg.ap2 x (MinusRg.ap2 ZeroRg y));
      Refine exten2; Refine Eq_refl; Refine Eq_sym; Refine lZeroRg_ident;
    Refine Eq_trans (MinusRg.ap2 (TimesRg.ap2 x ZeroRg) (TimesRg.ap2 x y));
      Refine lTimesMinusRg_distrib;
    Refine Eq_trans (MinusRg.ap2 ZeroRg (TimesRg.ap2 x y));
      Refine exten2; Refine rTimesZeroRg; Refine Eq_refl;
    Refine lZeroRg_ident;
  Save;

  Goal lTimesNegRg_distrib
     : {x,y:obj R} Eq (TimesRg.ap2 (NegRg.ap x) y) (NegRg.ap (TimesRg.ap2 x y));
    Intros;
    Refine Eq_trans (TimesRg.ap2 (MinusRg.ap2 ZeroRg x) y);
      Refine exten2; Refine Eq_sym; Refine lZeroRg_ident; Refine Eq_refl;
    Refine Eq_trans (MinusRg.ap2 (TimesRg.ap2 ZeroRg y) (TimesRg.ap2 x y));
      Refine rTimesMinusRg_distrib;
    Refine Eq_trans (MinusRg.ap2 ZeroRg (TimesRg.ap2 x y));
      Refine exten2; Refine lTimesZeroRg; Refine Eq_refl;
    Refine lZeroRg_ident;
  Save;

  Goal TimesNegRg_distrib
     : {x,y:obj R} Eq (TimesRg.ap2 (NegRg.ap x) (NegRg.ap y)) (TimesRg.ap2 x y);
    Intros;
    Refine Eq_trans (NegRg.ap (TimesRg.ap2 x (NegRg.ap y)));
      Refine lTimesNegRg_distrib;
    Refine Eq_trans (NegRg.ap (NegRg.ap (TimesRg.ap2 x y)));
      Refine exten; Refine rTimesNegRg_distrib;
    Refine NegRg_invol;
  Save;

(* --------------------------------------------------------------------------------
   This lemma is useful for proving MultInverse when building a field
   if it's non-trivial.
*)

  Goal Ring_Field_lemma1 : ~(Eq ZeroRg OneRg) ->
       {f:UFunMdl R} {x|obj R}
       (Eq (TimesRg.ap2 x (f.ap x)) OneRg) -> ~(Eq x ZeroRg);
    intros; Intros _; Refine H;
    Refine Eq_trans (TimesRg.ap2 ZeroRg (f.ap x));
      Refine Eq_sym; Refine lTimesZeroRg;
    Refine Eq_trans (TimesRg.ap2 x (f.ap x));
      Refine exten2; Refine Eq_sym H2; Refine Eq_refl;
    Refine H1;
  Save;

  Goal {a,b,c,d:obj R} Eq (TimesRg.ap2 (PlusRg.ap2 a b) (PlusRg.ap2 c d))
       (PlusRg.ap2 (PlusRg.ap2 (PlusRg.ap2 (TimesRg.ap2 a c) (TimesRg.ap2 a d))
                               (TimesRg.ap2 b c))
                   (TimesRg.ap2 b d));
    intros; [cd = PlusRg.ap2 c d];
    Refine Eq_trans (PlusRg.ap2 (TimesRg.ap2 a cd) (TimesRg.ap2 b cd));
      Refine rTimesPlusRg_distrib;
    Refine Eq_trans (PlusRg.ap2 (PlusRg.ap2 (TimesRg.ap2 a c) (TimesRg.ap2 a d))
                                (PlusRg.ap2 (TimesRg.ap2 b c) (TimesRg.ap2 b d)));
      Refine exten2; Refine lTimesPlusRg_distrib; Refine lTimesPlusRg_distrib;
    Refine PlusRg_assoc;
  Save TimesRg_lemma1;

  [TimesRg_commut : Commutative TimesRg];

  Goal {x,y:obj R} Eq (SquareRg.ap (PlusRg.ap2 x y))
       (PlusRg.ap2 (PlusRg.ap2 (SquareRg.ap x) (DoubleRg.ap (TimesRg.ap2 x y)))
                   (SquareRg.ap y));
    intros;
    [sx = SquareRg.ap x] [sy = SquareRg.ap y]
    [xy = TimesRg.ap2 x y] [yx = TimesRg.ap2 y x];
    Refine Eq_trans (PlusRg.ap2 (PlusRg.ap2 (PlusRg.ap2 sx xy) yx) sy);
      Refine TimesRg_lemma1;
    Refine exten2 ? ? ?.Eq_refl;
    Refine Eq_trans (PlusRg.ap2 (PlusRg.ap2 sx xy) xy);
      Refine exten2 ? ?.Eq_refl; Refine TimesRg_commut;
    Refine Eq_sym; Refine PlusRg_assoc;
  Save TimesRg_lemma2;

  Goal {x,y:obj R} Eq (SquareRg.ap (MinusRg.ap2 x y))
       (PlusRg.ap2 (MinusRg.ap2 (SquareRg.ap x) (DoubleRg.ap (TimesRg.ap2 x y)))
                   (SquareRg.ap y));
    intros;
    [sx = SquareRg.ap x] [sy = SquareRg.ap y]
    [xy = TimesRg.ap2 x y] [yx = TimesRg.ap2 y x];
    Refine Eq_trans (PlusRg.ap2 (PlusRg.ap2 sx
              (DoubleRg.ap (TimesRg.ap2 x (NegRg.ap y)))) (SquareRg.ap (NegRg.ap y)));
      Refine TimesRg_lemma2;
    Refine exten2; Refine +1 TimesNegRg_distrib;
    Refine exten2 ? ?.Eq_refl;
    Refine Eq_trans (DoubleRg.ap (NegRg.ap xy));
      Refine exten; Refine rTimesNegRg_distrib;
    Refine PlusNegRg_distrib;
  Save TimesRg_lemma3;

  Goal {a,b,c,d:obj R}
       Eq (TimesRg.ap2 (TimesRg.ap2 a b) (TimesRg.ap2 c d))
          (TimesRg.ap2 (TimesRg.ap2 a c) (TimesRg.ap2 b d));
    intros;
    Refine Eq_trans (TimesRg.ap2 a (TimesRg.ap2 b (TimesRg.ap2 c d)));
      Refine Eq_sym; Refine TimesRg_assoc;
    Refine Eq_trans (TimesRg.ap2 a (TimesRg.ap2 c (TimesRg.ap2 b d)));
      Refine +1 TimesRg_assoc;
    Refine exten2 ??.Eq_refl;
    Refine Eq_trans (TimesRg.ap2 (TimesRg.ap2 b c) d);
      Refine TimesRg_assoc;
    Refine Eq_trans (TimesRg.ap2 (TimesRg.ap2 c b) d);
      Refine +1 Eq_sym; Refine +1 TimesRg_assoc;
    Refine exten2 ???.Eq_refl;
    Refine TimesRg_commut;
  Save TimesRg_lemma4;

  Goal {x,y:obj R} Eq (SquareRg.ap (PlusRg.ap2 x y))
                      (PlusRg.ap2 (SquareRg.ap (MinusRg.ap2 x y))
                                  (DoubleRg.ap (DoubleRg.ap (TimesRg.ap2 x y))));
    intros;
    [x2 = SquareRg.ap x] [y2 = SquareRg.ap y];
    [dxy = DoubleRg.ap (TimesRg.ap2 x y)];
    Refine Eq_trans (PlusRg.ap2 (PlusRg.ap2 x2 dxy) y2);
      Refine TimesRg_lemma2;
    Refine Eq_trans (PlusRg.ap2 (PlusRg.ap2 (MinusRg.ap2 x2 dxy) y2) (DoubleRg.ap dxy));
      Refine +1 exten2 ? ?.Eq_sym ?.Eq_refl; Refine +1 TimesRg_lemma3;
    Refine Eq_trans (PlusRg.ap2 (PlusRg.ap2 (MinusRg.ap2 x2 dxy) (DoubleRg.ap dxy)) y2);
      Refine +1 rPlusRg_commut;
    Refine exten2 ? ? ?.Eq_refl;
    Refine Eq_trans (PlusRg.ap2 x2 (PlusRg.ap2 (NegRg.ap dxy) (DoubleRg.ap dxy)));
      Refine +1 PlusRg_assoc;
    Refine exten2 ? ?.Eq_refl;
    Refine Eq_trans (PlusRg.ap2 ZeroRg dxy);
      Refine Eq_sym; Refine lZeroRg_ident;
    Refine Eq_trans (PlusRg.ap2 (PlusRg.ap2 (NegRg.ap dxy) dxy) dxy);
      Refine exten2 ? ? ?.Eq_refl; Refine Eq_sym; Refine lNegRg_invers;
    Refine Eq_sym; Refine PlusRg_assoc;
  Save SquareRg_lemma1;

  Discharge TimesRg_commut;

  Goal {x:obj R} Eq (SquareRg.ap (DoubleRg.ap x))
                   (DoubleRg.ap (DoubleRg.ap (SquareRg.ap x)));
    intros; [sx = SquareRg.ap x];
    Refine Eq_trans (PlusRg.ap2 (PlusRg.ap2 (DoubleRg.ap sx) sx) sx);
      Refine TimesRg_lemma1;
    Refine Eq_sym; Refine PlusRg_assoc;
  Save SquareDoubleRg;

  Goal {x:obj R} Eq (PlusRg.ap2 x x) (TimesRg.ap2 TwoRg x);
    intros;
    Refine Eq_trans (PlusRg.ap2 (TimesRg.ap2 OneRg x) (TimesRg.ap2 OneRg x));
      Refine exten2; Refine ?+1; Refine Eq_sym; Refine lOneRg_ident;
    Refine Eq_sym; Refine rTimesPlusRg_distrib;
  Save TwoRg_lemma1;

(* ------------------------------------------------------------------------------
*)

  [     PowerRg : Fun2 R.car Nat R.car
            = multMonoid.PowerMN
  ];

  Goal {x:obj R} Eq (PowerRg.ap2 x ZeroN) OneRg;
    Refine multMonoid.PowerMN_zero;
  Save PowerRg_zero;

  Goal {x:obj R}{n:el Nat}
       Eq (PowerRg.ap2 x (Succ.ap n)) (TimesRg.ap2 (PowerRg.ap2 x n) x);
    Refine multMonoid.PowerMN_succ;
  Save PowerRg_succ;

  Goal {x:obj R} Eq (PowerRg.ap2 x OneN) x;
    Refine multMonoid.PowerMN_one;
  Save PowerRg_one;

  Goal {x:obj R} Eq (PowerRg.ap2 x TwoN) (SquareRg.ap x);
    Refine multMonoid.PowerMN_two;
  Save PowerRg_two;

  Goal {x:obj R}{m,n:el Nat} Eq (PowerRg.ap2 x (PlusN.ap2 m n))
                                   (TimesRg.ap2 (PowerRg.ap2 x m) (PowerRg.ap2 x n));
    Refine multMonoid.PowerMN_plus;
  Save PowerRg_plus;

  Goal {x:obj R}{m,n:el Nat} Eq (PowerRg.ap2 x (TimesN.ap2 m n))
                                   (PowerRg.ap2 (PowerRg.ap2 x m) n);
    Refine multMonoid.PowerMN_times;
  Save PowerRg_times;

  Goal (Commutative TimesRg) -> {x,y:obj R}{n:el Nat}
        Eq (PowerRg.ap2 (TimesRg.ap2 x y) n)
           (TimesRg.ap2 (PowerRg.ap2 x n) (PowerRg.ap2 y n));
    Refine multMonoid.PowerMN_distrib;
  Save PowerRg_distrib;

  Goal {n:el Nat} Eq (PowerRg.ap2 OneRg n) OneRg;
    Refine multMonoid.PowerMN_lemma1;
  Save PowerRg_lemma1;

  Goal {x:obj R}{m,n:el Nat} Eq (PowerRg.ap2 (PowerRg.ap2 x m) n)
                               (PowerRg.ap2 (PowerRg.ap2 x n) m);
    Refine multMonoid.PowerMN_lemma2;
  Save PowerRg_lemma2;

  Goal {n:el Nat} ~(Eq n ZeroN) -> Eq (PowerRg.ap2 ZeroRg n) ZeroRg;
    Refine nat_ind [n:el Nat] ~(Eq n ZeroN) -> Eq (PowerRg.ap2 ZeroRg n) ZeroRg;
    intros; Refine H; Refine Eq_refl;
    intros;
      Refine Eq_trans (TimesRg.ap2 (PowerRg.ap2 ZeroRg n) ZeroRg);
        Refine PowerRg_succ;
      Refine rTimesZeroRg;
  Save PowerRg_lemma3;

  Goal {x:obj R} Eq (MultRg.ap2 x OneN) x;
    Refine MultMN_one (applGroup.MonoidGr);
  Save MultRg_one;

  Goal {x:obj R} Eq (MultRg.ap2 x ZeroN) ZeroRg;
    Refine MultMN_zero (applGroup.MonoidGr);
  Save MultRg_zero;

  Goal {x,y:obj R}{n:el Nat}
       Eq (MultRg.ap2 (TimesRg.ap2 x y) n) (TimesRg.ap2 (MultRg.ap2 x n) y);
    intros __; [xy = TimesRg.ap2 x y];
    Refine nat_ind [n:el Nat] Eq (MultRg.ap2 xy n) (TimesRg.ap2 (MultRg.ap2 x n) y);

    Refine Eq_trans ZeroRg;
      Refine MultRg_zero;
    Refine Eq_sym; Refine Eq_trans (TimesRg.ap2 ZeroRg y);
      Refine exten2 ? ? ?.Eq_refl; Refine MultRg_zero;
    Refine lTimesZeroRg;

    intros n ih; [xn = MultRg.ap2 x n];
    Refine Eq_trans (PlusRg.ap2 (MultRg.ap2 xy n) xy);
      Refine MultMN_succ (applGroup.MonoidGr);
    Refine Eq_trans (PlusRg.ap2 (TimesRg.ap2 xn y) xy);
      Refine exten2 ? ih ?.Eq_refl;
    Refine Eq_trans (TimesRg.ap2 (PlusRg.ap2 xn x) y);
      Refine Eq_sym; Refine rTimesPlusRg_distrib;
    Refine exten2 ? ?.Eq_sym ?.Eq_refl; Refine MultMN_succ (applGroup.MonoidGr);
  Save rMultTimesRg;

  Goal {x,y:obj R}{n:el Nat}
       Eq (MultRg.ap2 (TimesRg.ap2 x y) n) (TimesRg.ap2 x (MultRg.ap2 y n));
    intros __; [xy = TimesRg.ap2 x y];
    Refine nat_ind [n:el Nat] Eq (MultRg.ap2 xy n) (TimesRg.ap2 x (MultRg.ap2 y n));

    Refine Eq_trans ZeroRg;
      Refine MultRg_zero;
    Refine Eq_sym; Refine Eq_trans (TimesRg.ap2 x ZeroRg);
      Refine exten2 ? ?.Eq_refl; Refine MultRg_zero;
    Refine rTimesZeroRg;

    intros n ih; [yn = MultRg.ap2 y n];
    Refine Eq_trans (PlusRg.ap2 (MultRg.ap2 xy n) xy);
      Refine MultMN_succ (applGroup.MonoidGr);
    Refine Eq_trans (PlusRg.ap2 (TimesRg.ap2 x yn) xy);
      Refine exten2 ? ih ?.Eq_refl;
    Refine Eq_trans (TimesRg.ap2 x (PlusRg.ap2 yn y));
      Refine Eq_sym; Refine lTimesPlusRg_distrib;
    Refine exten2 ? ?.Eq_refl ?.Eq_sym; Refine MultMN_succ (applGroup.MonoidGr);
  Save lMultTimesRg;

Discharge R;

(* ================================================================================
   Define homomorphism of rings.
*)

[R,R' | Ring];

Unfreeze ZeroRg OneRg NegRg PlusRg TimesRg;

  Goal HomomorphismRg_intro
     : {f : Fun R.car R'.car}
       {f_one : Eq (f.ap R.OneRg) R'.OneRg}
       {f_plus  : {x,y:obj R} Eq (f.ap (R.PlusRg.ap2 x y))
                                 (R'.PlusRg.ap2 (f.ap x) (f.ap y))}
       {f_times : {x,y:obj R} Eq (f.ap (R.TimesRg.ap2 x y))
                            (R'.TimesRg.ap2 (f.ap x) (f.ap y))}

       Homomorphism R R';
    intros;
    HomoGr == HomomorphismGr_intro|R.applGroup|R'.applGroup f f_plus;
    Refine Homomorphism_intro f;
    Refine FiveSET_elim [c:FuncSymb sigRg] homo_resp_Functions f c;
    Refine HomoGr_one HomoGr;
    Refine f_one;
    Refine HomoGr_inv HomoGr;
    Refine f_plus;
    Refine f_times;
    Intros p; Refine EmptySET_iter p;
  Save;

  [h : Homomorphism R R'];
  
  [     HomoRg_one
            : Eq (h.Homo_f.ap R.OneRg) R'.OneRg
            = h.Homo_resp_Functions star52
  ]
  [     HomoRg_plus
            : {x,y:obj R} Eq (h.Homo_f.ap (R.PlusRg.ap2 x y))
                             (R'.PlusRg.ap2 (h.Homo_f.ap x) (h.Homo_f.ap y))
            = h.Homo_resp_Functions star54
  ]
  [     HomoRg_times
            : {x,y:obj R} Eq (h.Homo_f.ap (R.TimesRg.ap2 x y))
                             (R'.TimesRg.ap2 (h.Homo_f.ap x) (h.Homo_f.ap y))
            = h.Homo_resp_Functions star55
  ];

Freeze ZeroRg OneRg NegRg PlusRg TimesRg;

  [     HomoRg_Gr
            : Homomorphism R.applGroup R'.applGroup
            = HomomorphismGr_intro|R.applGroup|R'.applGroup h.Homo_f HomoRg_plus
  ]

  [     HomoRg_zero
            : Eq (h.Homo_f.ap R.ZeroRg) R'.ZeroRg
            = HomoGr_one HomoRg_Gr
  ]
  [     HomoRg_neg
            : {x:obj R} Eq (h.Homo_f.ap (R.NegRg.ap x))
                           (R'.NegRg.ap (h.Homo_f.ap x))
            = HomoGr_inv HomoRg_Gr
  ]

  [     HomoRg_not_zero
            : (Injection h.Homo_f) ->
              {x|obj R} ~(Eq x R.ZeroRg) -> ~(Eq (h.Homo_f.ap x) R'.ZeroRg)
            = HomoGr_not_one HomoRg_Gr
  ];

  Goal HomoRg_power : {x:obj R}{n:el Nat}
             Eq (h.Homo_f.ap (R.PowerRg.ap2 x n)) (R'.PowerRg.ap2 (h.Homo_f.ap x) n);
    intros _;
    Refine nat_ind [n:el Nat] 
             Eq (h.Homo_f.ap (R.PowerRg.ap2 x n)) (R'.PowerRg.ap2 (h.Homo_f.ap x) n);

    Refine Eq_trans (h.Homo_f.ap R.OneRg);
      Refine exten; Refine PowerRg_zero;
    Refine Eq_trans R'.OneRg;
      Refine HomoRg_one;
    Refine Eq_sym; Refine PowerRg_zero;

    intros n ih;
    Refine Eq_trans (h.Homo_f.ap (R.TimesRg.ap2 (R.PowerRg.ap2 x n) x));
      Refine exten; Refine PowerRg_succ;
    Refine Eq_trans (R'.TimesRg.ap2 (h.Homo_f.ap (R.PowerRg.ap2 x n)) (h.Homo_f.ap x));
      Refine HomoRg_times;
    Refine Eq_trans (R'.TimesRg.ap2 (R'.PowerRg.ap2 (h.Homo_f.ap x) n) (h.Homo_f.ap x));
      Refine exten2 ? ih ?.Eq_refl;
    Refine Eq_sym; Refine PowerRg_succ;
  Save;

Discharge R;

Goal NegRg_homoGr : {R:Ring} R.applGroup.Endomorphism;
  intros;
  Refine InvGr_homoGr;
  Refine PlusRg_commut;
Save;

Unfreeze ZeroRg OneRg NegRg PlusRg TimesRg;

