
Module Poly_ap Import Poly;

(* ================================================================================
   Define the application f(x_1,...x_n) and show it preserves equality.
*)

(* Parts of the proofs leading to apP'_exten are done by Robert Maron. *)

[R : Ring] [IMN : indexMonoid];


  $[B_discr : Discrete IMN.car = indexMonoid_discr IMN];

  $[Plus   : BFunMdl R   = R.PlusRg ]
  $[Times  : BFunMdl R   = R.TimesRg]
  $[Zero   : obj R       = R.ZeroRg ]
  $[One    : obj R       = R.OneRg  ]
  $[Neg    : UFunMdl R   = R.NegRg  ];

  $[Monom       : Set                      = Monomial IMN R      ]
  $[Monom_intro : Fun2 R.car IMN.car Monom = Monomial_intro IMN R]
  $[CoefM       : Fun Monom R.car          = CoefMon IMN R       ]
  $[IndexM      : Fun Monom IMN.car        = IndexMon IMN R      ]
  $[TimesM      : Fun2 Monom Monom Monom   = TimesMon IMN R      ];

  $[PolyRg : Ring                = PolyRing IMN R ]
  $[Poly   : Set                 = Polyn IMN R    ]
  $[ZeroP  : el Poly             = ZeroPoly IMN R ]
  $[PlusP  : Fun2 Poly Poly Poly = PlusPoly IMN R ]
  $[NegP   : Fun Poly Poly       = NegPoly IMN R  ]
  $[TimesP : Fun2 Poly Poly Poly = TimesPoly IMN R]
  $[PowerP : Fun2 Poly Nat Poly  = PowerPoly IMN R]
  $[ConstP : Fun R.car Poly      = ConstPoly IMN R];

  $[Plus_MP : Fun2 Monom Poly Poly          = PlusMP IMN R          ];
  $[CoefP   : Fun2 Poly IMN.car R.car       = CoefPoly IMN R        ];

(* --------------------------------------------------------------------------------
   Define polynomial without one coefficient.
*)

[     skipCoefPoly : Poly.el -> IMN.obj -> Poly.el
          = [l:el Poly] [i:obj IMN]
            list_iter ZeroP
                      ([t:el Monom] [f:el Poly]
                       if B_discr (IndexM.ap t) i f (Plus_MP.ap2 t f)
                      )
                      l
];

(*
    (t + f)\(t_2)  =   f\(t_2)
                    L
*)

Goal {f:el Poly}{t:el Monom} Q (skipCoefPoly (Plus_MP.ap2 t f) (IndexM.ap t))
                               (skipCoefPoly f (IndexM.ap t));
  intros;
  Refine select_lemma ([l:el Poly] Q l (skipCoefPoly f (IndexM.ap t)));
  intros; Refine Q_refl;
  intros; Refine H; Refine Eq_refl;
Save skipCoefPoly_Q;

(*
    ln (f\i)  <=  ln f
*)

Goal {f:el Poly} {i:obj IMN} LessEqN.ap2 (length (skipCoefPoly f i)) (length f);
  intros g _;
  Refine Polyn_ind ?? ([f:el Poly] LessEqN.ap2 (length (skipCoefPoly f i)) (length f));
  Refine LessEqN_refl;
  intros t f ih;
  Refine select_lemma ([l:el Poly] LessEqN.ap2 (length l) (length (Plus_MP.ap2 t f)));
  intros;
    Refine LessEqN_trans; Refine +1 ih; Refine LessEqN_succ;
  intros;
    Refine LessEqN_succ_pres; Refine ih;
Save skipCoefPoly_length;

(*
    i = j  ->  (f\j)_j = 0
*)

Goal {f|el Poly} {i,j|obj IMN} (Eq i j) -> Eq (CoefP.ap2 (skipCoefPoly f i) j) Zero;
  intros h i j _;
  Refine Eq_trans (CoefP.ap2 (skipCoefPoly h i) i);
    Refine exten2 ??.Eq_refl H.Eq_sym;
  Refine Polyn_ind ?? [f:el Poly] Eq (CoefP.ap2 (skipCoefPoly f i) i) Zero;
  Refine CoefPoly_zerop; Refine Eq_refl;
  intros t f ih;
  Refine select_lemma ([l:Poly.el] Eq (CoefP.ap2 l i) Zero);
  intros; Refine ih;
  intros;
    Refine Eq_trans (CoefP.ap2 (skipCoefPoly f i) i); Refine +1 ih;
    Refine CoefPoly_MP_neq; Refine H1;
Save skipCoefPoly_eq;

(*
    i != j  ->  (f\i)_j = f_j
*)

Goal {f|el Poly} {i,j|obj IMN} ~(Eq i j) ->
                               Eq (CoefP.ap2 (skipCoefPoly f i) j) (CoefP.ap2 f j);
  intros h ___;
  Refine Polyn_ind ?? [f:el Poly] Eq (CoefP.ap2 (skipCoefPoly f i) j) (CoefP.ap2 f j);
  Refine Eq_refl;
  intros t f ih;
  Refine select_lemma ([l:el Poly] Eq (CoefP.ap2 l j) (CoefP.ap2 (Plus_MP.ap2 t f) j));
  intros;
    Refine Eq_trans (CoefP.ap2 f j); Refine ih;
    Refine Eq_sym; Refine CoefPoly_MP_neq;
    Intros _; Refine H; Refine Eq_trans ? H1.Eq_sym H2;
  intros;
  Refine CoefPoly_PlusMP; Refine Eq_refl; Refine Eq_refl;
  Refine ih;
Save skipCoefPoly_neq;

(*
    f = 0  ->  (f\i) = 0
*)

Goal {f|el Poly} {i|obj IMN} (Eq f ZeroP) -> Eq (skipCoefPoly f i) ZeroP;
  Intros ___ j;
  Refine B_discr i j;
  intros;
    Refine Eq_trans Zero;
    Refine skipCoefPoly_eq H1;
    Refine Eq_sym; Refine CoefPoly_zero;
  intros;
    Refine Eq_trans (CoefP.ap2 f j); Refine skipCoefPoly_neq H1;
    Refine H;
Save skipCoefPoly_zero;

(*       i
    f_i x  + f\i  =  f
*)

Goal Poly_split
   : {f:el Poly}{i:obj IMN}
     Eq (Plus_MP.ap2 (Monom_intro.ap2 (CoefP.ap2 f i) i) (skipCoefPoly f i)) f;
  Intros _ i j;
  Refine B_discr i j;
  intros;
    Refine Eq_trans (Plus.ap2 (CoefP.ap2 f i) (CoefP.ap2 (skipCoefPoly f i) j));
      Refine CoefPoly_MP_eq; Refine H;
    Refine Eq_trans (Plus.ap2 (CoefP.ap2 f j) Zero);
      Refine exten2; Refine exten2 ??.Eq_refl H; Refine skipCoefPoly_eq H;
    Refine rZeroRg_ident;
  intros;
    Refine Eq_trans (CoefP.ap2 (skipCoefPoly f i) j);
      Refine CoefPoly_MP_neq; Refine H;
    Refine skipCoefPoly_neq H;
Save;

(*
    f = g  ->  i = j  ->  f\i = g\j
*)

Goal extensional2 skipCoefPoly;
  Intros f g _ i j _;
  [fii = Monom_intro.ap2 (CoefP.ap2 f i) i]
  [gjj = Monom_intro.ap2 (CoefP.ap2 g j) j];
  Refine Eq_trans (Plus_MP.ap2 ((NegMon ??).ap fii) f);
    Refine PlusMP_lemma2; Refine Poly_split;
  Refine Eq_trans (Plus_MP.ap2 ((NegMon ??).ap gjj) g);
    Refine +1 Eq_sym; Refine +1 PlusMP_lemma2; Refine +1 Poly_split;
  Refine exten2 ?? H;
  Refine exten; Refine eq_Monomial_intro; Refine +1 H1;
  Refine exten2; Refine H; Refine H1;
Save skipCoefPoly_exten;

[     SkipCoefPoly : Fun2 Poly IMN.car Poly
          = Fun2_intro ? skipCoefPoly_exten
];

(* ================================================================================
   For application to make sense, we need
    - that the multiplication of the ring is commutative,
    - to know the number of variables n, and
    - a notion of power : R^n -> R.
*)

[     Times_commut : Commutative Times
]
[     n : nat
]

$[    Rn : Set
          = Product R.car n : Set
];

[     Power : Fun2 Rn IMN.car R.car
]
[     Power_zero : {x:el Rn} Eq (Power.ap2 x IMN.ZeroIMN) One
]
[     Power_plus : {x:el Rn} {a,b:obj IMN}
                   Eq (Power.ap2 x (IMN.PlusIMN.ap2 a b))
                      (Times.ap2 (Power.ap2 x a) (Power.ap2 x b))
];

(* --------------------------------------------------------------------------------
   Define the notion of application for polynomials and prove it preserves
   equality. First we fix an element of the ring which will be discharged later.
*)

[x : el Rn];

[     apM' : Monom.el -> R.obj
          = [m:el Monom] Times.ap2 (CoefM.ap m) (Power.ap2 x (IndexM.ap m))
]
[     ApM' : Fun Monom R.car
          = Fun_intro apM' ([f,f'|el Monom] [H:Eq|Monom f f']
                            exten2 Times
                                   (exten CoefM H)
                                   (exten2 Power (Eq_refl x) (exten IndexM H)))
];

[     apP' : Poly.el -> R.obj
          = [P:el Poly] opL ([m:el Monom][ih:obj R] Plus.ap2 m.apM' ih) Zero P
];

(* To prove the extensionality of apP' we first prove two auxiliary lemma's. *)

(*        i
     f_i x   + (f\i)(x)   = f(x)
*)

Goal apP'_split
   : {f:el Poly}{i:obj IMN}
     Eq (Plus.ap2 (apM' (Monom_intro.ap2 (CoefP.ap2 f i) i)) (apP' (skipCoefPoly f i)))
        (apP' f);
  intros h i;
  Refine Polyn_ind ?? ([f:Poly.el]
                       Eq (Plus.ap2 (apM' (Monom_intro.ap2 (CoefP.ap2 f i) i))
                                    (apP' (skipCoefPoly f i)))
                          (apP' f));

  Refine Eq_trans (Plus.ap2 Zero Zero); Refine +1 rZeroRg_ident;
  Refine exten2 ???.Eq_refl;
  Refine Eq_trans (Times.ap2 Zero ?); Refine +2 lTimesZeroRg;
  Refine +1 exten2 ???.Eq_refl;
  Refine CoefPoly_zerop; Refine Eq_refl;

  intros t f ih;
  [t1 = CoefM.ap t] [t2 = IndexM.ap t];
  [fi = CoefP.ap2 f i]; [g = skipCoefPoly f i];
  [xi = Power.ap2 x i];
  Refine B_discr t2 i;

  intros; (* t2 = i *)

  Refine Eq_trans (Plus.ap2 (Plus.ap2 (Times.ap2 t1 xi) (Times.ap2 fi xi)) (apP' g));
  Refine exten2;
  Refine Eq_trans (Times.ap2 (Plus.ap2 t1 fi) xi); Refine +1 rTimesPlusRg_distrib;
  Refine exten2 ???.Eq_refl;
  Refine CoefPoly_MP_eq ?? H;
  Refine select_lemma ([l:Poly.el] Eq (apP' l) (apP' g));
    intros; Refine Eq_refl;
    intros; Refine H1 H;

  Refine Eq_trans (Plus.ap2 (Times.ap2 t1 xi) (Plus.ap2 (Times.ap2 fi xi) (apP' g)));
  Refine Eq_sym; Refine PlusRg_assoc;

  Refine exten2;
  Refine exten2 ??.Eq_refl; Refine exten2 ??.Eq_refl; Refine Eq_sym H;
  Refine ih;
  
  intros; (* t2 != i *)

  Refine Eq_trans (Plus.ap2 (Times.ap2 fi xi) (Plus.ap2 (apM' t) (apP' g)));
  Refine exten2;
  Refine exten2 ???.Eq_refl; Refine CoefPoly_MP_neq; Refine H;
  Refine select_lemma ([l:Poly.el] Eq  (apP' l) (Plus.ap2 (apM' t) (apP' g)));
  intros; Refine H H1; intros; Refine Eq_refl;

  Refine Eq_trans (Plus.ap2 (apM' t) (Plus.ap2 (Times.ap2 fi xi) (apP' g)));
    Refine lPlusRg_commut;

  Refine exten2 ??.Eq_refl; Refine ih;
Save;

(*
     f = 0  ->  f(x) = 0
*)

Goal {f|el Poly} (Eq f ZeroP) -> Eq (apP' f) Zero;
  intros f';
  Refine Polyn_ind ?? ([h:el Poly] {f:el Poly}
                                   (LessEqN.ap2 (length f) (length h)) ->
                                   (Eq f ZeroP) -> Eq (apP' f) Zero);
  Refine +3 LessEqN_refl;

  intros;
  Qrepl length_zero|?|f; Refine +1 Eq_refl;
  Refine LessEqN_zero H;

  intros m f'';
  [p = length f''];
  Equiv ({f:el Poly} (LessEqN.ap2 (length f) p) -> (Eq f ZeroP) -> Eq (apP' f) Zero) ->
         {f:el Poly} (LessEqN.ap2 (length f) (Succ.ap p)) ->
                     (Eq f ZeroP) ->
                     Eq (apP' f) Zero;
  intros ih f __;
  Refine LessEq2LessN H; Next +1;
  intros; Refine ih; Refine +1 H1; Refine LessEqN_intro_succ H2;
  intros;
  Refine length_succ H2; intros t g _;
  [t2 = IndexM.ap t] [h = skipCoefPoly f t2];
 
  Refine Eq_trans (Plus.ap2 (apM' (Monom_intro.ap2 (CoefP.ap2 f t2) t2)) (apP' h));
    Refine Eq_sym; Refine apP'_split;
  Refine Eq_trans (Plus.ap2 Zero Zero);
    Refine +1 rZeroRg_ident;
  Refine exten2;
  Refine Eq_trans (apM' (Monom_intro.ap2 Zero t2));
    Refine +1 lTimesZeroRg;
  Refine exten2 ???.Eq_refl; Refine exten; Refine exten2 ???.Eq_refl;
  Refine CoefPoly_zerop;  Refine H1;
  Refine ih;

  Refine LessEqN_succ_inj; Qrepl H2.Q_sym; Qrepl H3;
  Refine LessEqN_succ_pres;
  Refine extenRel ?? ?.Eq_refl; Refine +2 skipCoefPoly_length; Refine +1 t2;
  Expand h; Qrepl H3;
  Qrepl (skipCoefPoly_Q g t); Refine Eq_refl;

  Refine skipCoefPoly_zero H1;
Save apP'_zero;

(*
    f = g  ->  f(x) = g(x)
*)

Goal apP'_exten : extensional apP';
  Refine Polyn_ind IMN R ([f:Poly.el] {g:Poly.el} (Eq f g) -> Eq (apP' f) (apP' g));
  intros; Refine Eq_sym; Refine apP'_zero H.Eq_sym;
  intros t f ih g _;
  [t1 = CoefM.ap t] [t2 = IndexM.ap t];
  Refine Eq_trans (Plus.ap2 (apM' t) (Plus.ap2 (Neg.ap (apM' t)) (apP' g)));
    Refine +1 Eq_trans (Plus.ap2 (Plus.ap2 (apM' t) (Neg.ap (apM' t))) (apP' g));
      Refine +1 PlusRg_assoc;
    Refine +1 Eq_trans (Plus.ap2 Zero (apP' g));
      Refine +1 exten2 ???.Eq_refl; Refine +1 rNegRg_invers;
    Refine +1 lZeroRg_ident;
  Refine exten2 ??.Eq_refl;
  Refine Eq_trans (Plus.ap2 (apM' ((NegMon ??).ap t)) (apP' g));
    Refine ih (Plus_MP.ap2 ((NegMon ??).ap t) g);
    Refine PlusMP_lemma2;
    Refine H;
  Refine exten2 ???.Eq_refl;
  Equiv Eq (apM' ((NegMon IMN R).ap t)) (Neg.ap (apM' t));
  Refine lTimesNegRg_distrib;
Save;

[     ApP' : Fun Poly R.car
          = Fun_intro apP' apP'_exten
];

(*
    f(c)  =  c
*)

Goal {c:obj R} Eq (apP' (ConstP.ap c)) c;
  intros;
  Refine Eq_trans (Times.ap2 c (Power.ap2 x IMN.ZeroIMN));
    Refine rZeroRg_ident;
  Refine Eq_trans (Times.ap2 c One);
    Refine exten2 ? ?.Eq_refl ?.Power_zero;
  Refine rOneRg_ident;
Save apP'_const;

(*
    (f+g)(x)  =  f(x) + g(x)
*)

Goal {f,g:el Poly} Eq (apP' (PlusP.ap2 f g)) (Plus.ap2 (apP' f) (apP' g));
  Refine list_ind [f:el Poly]{g:el Poly}
                    Eq (apP' (PlusP.ap2 f g)) (Plus.ap2 (apP' f) (apP' g));
  intros; Refine Eq_sym; Refine lZeroRg_ident;
  intros m f ih _;
  Refine Eq_trans (Plus.ap2 (apM' m) (Plus.ap2 (apP' f) (apP' g)));
    Refine exten2 Plus ?.Eq_refl; Refine ih;
  Refine PlusRg_assoc;
Save apP'_plus;

(*      t2      u2                (t2 + u2)
    t1 x    u1 x     =  (t1 u1) x
*)

Goal {t,u:el Monom} Eq (apM' (TimesM.ap2 t u)) (Times.ap2 (apM' t) (apM' u));
  intros;
  [t0 = CoefM.ap t] [t1 = Power.ap2 x (IndexM.ap t)];
  [u0 = CoefM.ap u] [u1 = Power.ap2 x (IndexM.ap u)];
  Refine Eq_trans (Times.ap2 (Times.ap2 t0 u0) (Times.ap2 t1 u1));
    Refine exten2 Times ?.Eq_refl; Refine Power_plus;
  Refine Eq_trans (Times.ap2 t0 (Times.ap2 u0 (Times.ap2 t1 u1)));
    Refine Eq_sym; Refine TimesRg_assoc;
  Refine Eq_trans (Times.ap2 t0 (Times.ap2 t1 (Times.ap2 u0 u1)));
    Refine +1 TimesRg_assoc;
  Refine exten2 ? ?.Eq_refl;
  Refine Eq_trans (Times.ap2 (Times.ap2 u0 t1) u1);
    Refine TimesRg_assoc;
  Refine Eq_trans (Times.ap2 (Times.ap2 t1 u0) u1);
    Refine exten2 ? ? ?.Eq_refl; Refine Times_commut;
  Refine Eq_sym; Refine TimesRg_assoc;
Save apM'_times;

(*                         m2
    ((m1,m2)^g)(x)  =  m1 x   g(x)
*)

Goal {m:el Monom}{g:el Poly}
     Eq (apP' ((TimesMP IMN R).ap2 m g)) (Times.ap2 (apM' m) (apP' g));
  intros;
  Refine list_ind [g:el Poly]
                   Eq (apP' ((TimesMP IMN R).ap2 m g)) (Times.ap2 (apM' m) (apP' g));
  Refine Eq_sym; Refine rTimesZeroRg;
  intros t f ih;
  Refine Eq_trans (Plus.ap2 (Times.ap2 (apM' m) (apM' t))
                            (Times.ap2 (apM' m) (apP' f)));
    Refine exten2; Refine apM'_times; Refine ih;
  Refine Eq_sym; Refine lTimesPlusRg_distrib;
Save apP'_timesMP;

(*
    (f g)(x)  =  f(x) g(x)
*)

Goal {f,g:el Poly} Eq (apP' (TimesP.ap2 f g)) (Times.ap2 (apP' f) (apP' g));
  intros f' g;
  Refine list_ind [f:el Poly]
                   Eq (apP' (TimesP.ap2 f g)) (Times.ap2 (apP' f) (apP' g));
  Refine Eq_sym; Refine lTimesZeroRg;
  intros t f ih;
  Refine Eq_trans (Plus.ap2 (apP' ((TimesMP IMN R).ap2 t g)) (apP' (TimesP.ap2 f g)));
    Refine apP'_plus;
  Refine Eq_trans (Plus.ap2 (Times.ap2 (apM' t) (apP' g))
                            (Times.ap2 (apP' f) (apP' g)));
    Refine exten2; Refine apP'_timesMP; Refine ih;
  Refine Eq_sym; Refine rTimesPlusRg_distrib;
Save apP'_times;

Goal ApP'_homoRg : Homomorphism PolyRg R;
  Refine HomomorphismRg_intro;
  Refine ApP';
  Refine apP'_const One;
  Refine apP'_plus;
  Refine apP'_times;
Save;

Discharge x;

(* ================================================================================
   And only now we are able to define the real application of polynomials.
*)

[     apP : Poly.el -> Rn.el -> R.obj
          = [f:el Poly] [x:Rn.el] apP' x f
];

Goal extensional2 apP;
  Intros f f' _ x x' _;
  Refine Eq_trans (apP f x');
    Refine +1 exten (ApP' x') H;
  Refine list_ind [g:el Poly] Eq (apP g x) (apP g x');
  Equiv Eq Zero Zero; Refine Eq_refl;
  intros t g ih;
  Refine exten2 Plus ? ih;
  Refine exten2 Times ?.Eq_refl; Refine exten2 ? H1 ?.Eq_refl;
Save apP_exten;

[     ApP : Fun2 Poly Rn R.car
          = Fun2_intro apP apP_exten
];

Goal apP_zero : {x:el Rn} Eq (apP ZeroP x) Zero;
  intros;
  Refine HomoRg_zero (ApP'_homoRg x);
Save;

Goal apP_const : {c:obj R}{x:el Rn} Eq (apP (ConstP.ap c) x) c;
  intros; Refine apP'_const;
Save;

Goal apP_neg : {f:el Poly}{x:el Rn} Eq (apP (NegP.ap f) x) (Neg.ap (apP f x));
  intros;
  Refine HomoRg_neg (ApP'_homoRg x);
Save;

Goal apP_plus : {f,g:el Poly} {x:el Rn}
                Eq (apP (PlusP.ap2 f g) x) (Plus.ap2 (apP f x) (apP g x));
  intros; Refine apP'_plus;
Save;

Goal apP_times : {f,g:el Poly}{x:el Rn}
                 Eq (apP (TimesP.ap2 f g) x) (Times.ap2 (apP f x) (apP g x));
  intros; Refine apP'_times;
Save;

Goal apP_power : {f:el Poly}{m:el Nat}{x:el Rn}
                 Eq (apP (PowerP.ap2 f m) x) (R.PowerRg.ap2 (apP f x) m);
  intros; Refine HomoRg_power (ApP'_homoRg x);
Save;

Discharge R;
