
Module Monomial Import Ring IndexMonoid;

(* 
   Given an index monoid IMN and a ring R. Define the set of monomials
   as R # IMN.
*)

[IMN : indexMonoid] [R : Ring];

[     Monomial
          = Prod R.car IMN.car
];

Goal monomial_intro : R.obj -> IMN.obj -> Monomial.el;
  Refine Tuple;
Save;

Goal coefMon : Monomial.el -> R.obj;
  Refine First;
Save;

Goal indexMon : Monomial.el -> IMN.obj;
  Refine Second;
Save;

Goal Monomial_intro : Fun2 R.car IMN.car Monomial;
  Refine Fun2_intro monomial_intro;
  Intros ______;
  Refine pair H H1; 
Save;

Goal CoefMon : Fun Monomial R.car;
  Refine Fun_intro coefMon;
  Intros __; Refine fst;
Save;

Goal IndexMon : Fun Monomial IMN.car;
  Refine Fun_intro indexMon;
  Intros __; Refine snd;
Save;

Discharge R;

(* --------------------------------------------------------------------------------
*)

[R,R' | Ring];

Goal mapM : (R.obj -> R'.obj) -> (R.Monomial.el -> R'.Monomial.el);
  intros f t;
  Refine R'.Monomial_intro.ap2 (f (R.CoefMon.ap t)) (R.IndexMon.ap t);
Save;

Goal MapM : (Fun R.car R'.car) -> Fun R.Monomial R'.Monomial;
  intros f;
  Refine Fun_intro (mapM f.ap);
  Intros ___;
  Refine exten2;
  Refine exten; Refine exten ? H;
  Refine exten ? H;
Save;

Discharge R;

(* --------------------------------------------------------------------------------
*)

[R : Ring];

[     OneMon : R.Monomial.el
          = R.Monomial_intro.ap2 R.OneRg IMN.ZeroIMN
]
[     NegMon : Fun R.Monomial R.Monomial
          = MapM R.NegRg
]
[     timesMon : bop R.Monomial.el
           = [a,b:el R.Monomial] R.Monomial_intro.ap2
                    (R.TimesRg.ap2 (?.CoefMon.ap a) (R.CoefMon.ap b))
                    (IMN.PlusIMN.ap2 (R.IndexMon.ap a) (R.IndexMon.ap b))
];

Goal TimesMon : Fun2 R.Monomial R.Monomial R.Monomial;
  Refine Fun2_intro timesMon;
  Intros ______;
  Refine exten2;
  Refine exten2; Refine exten ? H; Refine exten ? H1;
  Refine exten2; Refine exten ? H; Refine exten ? H1;
Save;

Goal Associative TimesMon;
  Intros ___;
  Refine pair;
  Refine TimesRg_assoc; Refine PlusIMN_assoc;
Save TimesMon_assoc;

Goal Identity TimesMon OneMon;
  andI;
  Intros _;
  Refine pair;
  Refine lOneRg_ident; Refine lZeroIMN_ident;
  Intros _;
  Refine pair;
  Refine rOneRg_ident; Refine rZeroIMN_ident;
Save OneMon_ident;

Goal MonomialMN : Monoid;
  Refine Monoid_intro;
  Refine +3 TimesMon_assoc;
  Refine +1 OneMon_ident;
Save;

Discharge IMN;

(* --------------------------------------------------------------------------------
*)

[IMN | indexMonoid] [R | Ring];

[     eq_Monomial_elim [t,u|el (Monomial IMN R)][z:Eq t u]
          = z
          : and (Eq ((CoefMon IMN R).ap t) ((CoefMon IMN R).ap u))
                (Eq ((IndexMon IMN R).ap t) ((IndexMon IMN R).ap u))
]
[     eq_Monomial_intro [t,u|el (Monomial IMN R)]
                        [z1:Eq ((CoefMon IMN R).ap t) ((CoefMon IMN R).ap u)]
                        [z2:Eq ((IndexMon IMN R).ap t) ((IndexMon IMN R).ap u)]
          = pair z1 z2
          : Eq t u
];

Discharge IMN;

(*
   It is very important to freeze Monomail. Otherwise type checking
   will be very slow.
*)

Freeze Monomial;  

