
Module Monoid Import semantics Homomorphism Submodel;

[     sigMN : Signature
          = Signature_intro (TwoSET_iter ZeroN    (* a constant *)
                                         TwoN     (* a binary function *)
                            ) 
                            EmptySET_nat
];

Goal axiomsMN : Axioms sigMN;
  Refine Axioms_intro;
  Intros A IC IP;
  One   == (IC star21).apn : el A;
  Times == IC star22       : Fun2 A A A;
  Refine (Associative Times) /\ (Identity Times One);
Save;

[     Monoid
          = Model axiomsMN
];

Goal Monoid_intro : {A|Set}{Times|Fun2 A A A}{One|el A}
                    {Times_assoc : Associative Times}{One_ident : Identity Times One}
                    Monoid;
  intros;
  Refine Model_intro;
  Refine A;
  Refine TwoSET_elim [c:FuncSymb sigMN] nFunc A (FuncArity c);
    Refine constant One;
    Refine Times;
  Refine EmptySET_elim [c:PredSymb sigMN] nPred A (PredArity c);
  Refine pair Times_assoc One_ident;
Save;

(* --------------------------------------------------------------------------------
   Let MN be a monoid. Define functions to extract all components of MN.
*)

[MN : Monoid];
  [OneMN          : obj MN                  = intCons MN star21]
  [TimesMN        : BFunMdl MN              = intFunc MN star22];

  [TimesMN_assoc  : Associative TimesMN     = fst MN.axioms]
  [OneMN_ident    : Identity TimesMN OneMN  = snd MN.axioms];

Freeze OneMN TimesMN;

  [lOneMN_ident   : lIdentity TimesMN OneMN = fst OneMN_ident]
  [rOneMN_ident   : rIdentity TimesMN OneMN = snd OneMN_ident];

(* --------------------------------------------------------------------------------
   Prove a combination of comutativity and associativity.
*)

  Goal (Commutative TimesMN) -> {x,y,z:obj MN}
       Eq (TimesMN.ap2 (TimesMN.ap2 x y) z) (TimesMN.ap2 (TimesMN.ap2 x z) y);
    intros;
    Refine Eq_trans (TimesMN.ap2 x (TimesMN.ap2 y z));
      Refine Eq_sym; Refine TimesMN_assoc;
    Refine Eq_trans (TimesMN.ap2 x (TimesMN.ap2 z y));
      Refine exten2 ??.Eq_refl; Refine H;
    Refine TimesMN_assoc;
  Save rTimesMN_commut;

  Goal (Commutative TimesMN) -> {x,y,z:obj MN}
       Eq (TimesMN.ap2 x (TimesMN.ap2 y z)) (TimesMN.ap2 y (TimesMN.ap2 x z));
    intros;
    Refine Eq_trans (TimesMN.ap2 (TimesMN.ap2 x y) z);
      Refine TimesMN_assoc;
    Refine Eq_trans (TimesMN.ap2 (TimesMN.ap2 y x) z);
      Refine exten2 ???.Eq_refl; Refine H;
    Refine Eq_sym; Refine TimesMN_assoc;
  Save lTimesMN_commut;

(* --------------------------------------------------------------------------------
   Define Square(x) as x^2.
*)

  [squareMN : MN.obj -> MN.obj
    = [x:obj MN] TimesMN.ap2 x x];

  Goal SquareMN : UFunMdl MN;
    Refine Fun_intro;
    Refine squareMN;
    Intros; Refine exten2; Immed;
  Save;

  Goal SquareMN_lemma1 : {x|obj MN} (Eq x OneMN) -> Eq (SquareMN.ap x) OneMN;
    intros;
    Refine Eq_trans (TimesMN.ap2 OneMN OneMN);
      Refine exten2 TimesMN H H;
    Refine rOneMN_ident;
  Save;

  Goal SquareMN_lemma2 : {x|obj MN} ~(Eq (SquareMN.ap x) OneMN) -> ~(Eq x OneMN);
    intros _; Refine Contrapos; Refine SquareMN_lemma1;
  Save;

(* --------------------------------------------------------------------------------
   Define Power(x,n) as x^n
*)

  [powerMN : MN.obj -> Nat.el -> MN.obj
    = [x:obj MN] nat_iter OneMN ([ih:obj MN] TimesMN.ap2 ih x)];

  Goal PowerMN : Fun2 MN.car Nat MN.car;
    Refine Fun2_intro;
    Refine powerMN;
    Intros;
    Qrepl H1;
    Refine nat_ind ([z:nat] Eq (powerMN x z) (powerMN x' z));
    Refine Eq_refl;
    intros; Refine exten2; Immed;
  Save;

  Goal {x:obj MN} Eq (PowerMN.ap2 x ZeroN) OneMN;
    intros; Refine Eq_refl;
  Save PowerMN_zero;

  Goal {x:obj MN}{n:el Nat}
       Eq (PowerMN.ap2 x (Succ.ap n)) (TimesMN.ap2 (PowerMN.ap2 x n) x);
    intros; Refine Eq_refl;
  Save PowerMN_succ;

  Goal rIdentity PowerMN OneN;
    Refine lOneMN_ident;
  Save PowerMN_one;

  Goal {x:obj MN} Eq (PowerMN.ap2 x TwoN) (SquareMN.ap x);
    intros;
    Refine exten2 TimesMN ? ?.Eq_refl;
    Refine PowerMN_one;
  Save PowerMN_two;

  Goal {x:obj MN}{m,n:el Nat} Eq (PowerMN.ap2 x (PlusN.ap2 m n))
                                 (TimesMN.ap2 (PowerMN.ap2 x m) (PowerMN.ap2 x n));
    intros __;
    Refine nat_ind [n:el Nat] Eq (PowerMN.ap2 x (PlusN.ap2 m n))
                                 (TimesMN.ap2 (PowerMN.ap2 x m) (PowerMN.ap2 x n));
    Refine Eq_sym; Refine rOneMN_ident;
    intros n ih;
    Refine Eq_trans (TimesMN.ap2 (TimesMN.ap2 (PowerMN.ap2 x m) (PowerMN.ap2 x n)) x);
      Refine exten2 TimesMN ? ?.Eq_refl; Refine ih;
    Refine Eq_sym; Refine TimesMN_assoc;
  Save PowerMN_plus;

  Goal {x:obj MN}{m,n:el Nat} Eq (PowerMN.ap2 x (TimesN.ap2 m n))
                                 (PowerMN.ap2 (PowerMN.ap2 x m) n);
    intros __;
    Refine nat_ind [n:el Nat] Eq (PowerMN.ap2 x (TimesN.ap2 m n))
                                 (PowerMN.ap2 (PowerMN.ap2 x m) n);
    Refine Eq_refl;
    intros n ih;
    Refine Eq_trans (PowerMN.ap2 x (PlusN.ap2 (TimesN.ap2 m n) m));
      Refine exten2 ? ?.Eq_refl; Refine PlusN_commut;
    Refine Eq_trans (TimesMN.ap2 (PowerMN.ap2 x (TimesN.ap2 m n)) (PowerMN.ap2 x m));
      Refine PowerMN_plus;
    Refine exten2 TimesMN ? ?.Eq_refl; Refine ih;    
  Save PowerMN_times;

  Goal (Commutative TimesMN) -> {x,y:obj MN}{n:el Nat}
       Eq (PowerMN.ap2 (TimesMN.ap2 x y) n)
          (TimesMN.ap2 (PowerMN.ap2 x n) (PowerMN.ap2 y n));
    intros TimesMN_commut x y;
    Refine nat_ind [n:el Nat] Eq (PowerMN.ap2 (TimesMN.ap2 x y) n)
                                  (TimesMN.ap2 (PowerMN.ap2 x n) (PowerMN.ap2 y n));
    Refine Eq_sym; Refine rOneMN_ident;
    intros n ih;
    Refine Eq_trans (TimesMN.ap2 (TimesMN.ap2 (PowerMN.ap2 x n) (PowerMN.ap2 y n))
                                (TimesMN.ap2 x y));
      Refine exten2 TimesMN ? ?.Eq_refl; Refine ih;
    Refine Eq_trans (TimesMN.ap2 (PowerMN.ap2 x n)
                                (TimesMN.ap2 (PowerMN.ap2 y n) (TimesMN.ap2 x y)));
      Refine Eq_sym; Refine TimesMN_assoc;
    Refine Eq_trans (TimesMN.ap2 (PowerMN.ap2 x n)
                                (TimesMN.ap2 x (TimesMN.ap2 (PowerMN.ap2 y n) y)));
      Refine +1 TimesMN_assoc;
    Refine exten2 ? ?.Eq_refl;
    Refine Eq_trans (TimesMN.ap2 (TimesMN.ap2 (PowerMN.ap2 y n) x) y);
      Refine TimesMN_assoc;
    Refine Eq_trans (TimesMN.ap2 (TimesMN.ap2 x (PowerMN.ap2 y n)) y);
      Refine exten2 ? ? ?.Eq_refl; Refine TimesMN_commut;
    Refine Eq_sym; Refine TimesMN_assoc;
  Save PowerMN_distrib;

  Goal {n:el Nat} Eq (PowerMN.ap2 OneMN n) OneMN;
    Refine nat_ind [n:el Nat] Eq (PowerMN.ap2 OneMN n) OneMN;
    Refine Eq_refl;
    intros;
    Refine Eq_trans (PowerMN.ap2 OneMN n);
      Refine rOneMN_ident;
    Refine ih;
  Save PowerMN_lemma1;

  Goal {x:obj MN}{m,n:el Nat} Eq (PowerMN.ap2 (PowerMN.ap2 x m) n)
                                 (PowerMN.ap2 (PowerMN.ap2 x n) m);
    intros;
    Refine Eq_trans (PowerMN.ap2 x (TimesN.ap2 m n));
      Refine Eq_sym; Refine PowerMN_times;
    Refine Eq_trans (PowerMN.ap2 x (TimesN.ap2 n m));
      Refine exten2 ? ?.Eq_refl; Refine TimesN_commut;
    Refine PowerMN_times;
  Save PowerMN_lemma2;

  Freeze PowerMN;

(* --------------------------------------------------------------------------------
   Prove a few uniqueness results.
*)

  Goal OneMN_unique
     : {x,y|obj MN} (rIdentity TimesMN x) -> (lIdentity TimesMN y) -> Eq x y;
    intros;
    Refine Eq_trans (TimesMN.ap2 y x);
    Refine Eq_sym; Immed;
  Save;

  Goal InvMN_unique
     : {f,g|UFunMdl MN} (rInverse TimesMN OneMN f) -> (lInverse TimesMN OneMN g) ->
                       Eq|(Function MN.car MN.car) f g;
    Intros __ f_invers g_invers x;
    [fx = f.ap x] [gx = g.ap x];
    Refine Eq_trans (TimesMN.ap2 OneMN fx);
      Refine Eq_sym; Refine lOneMN_ident;
    Refine Eq_trans (TimesMN.ap2 (TimesMN.ap2 gx x) fx);
      Refine exten2; Refine Eq_sym; Refine g_invers; Refine Eq_refl;
    Refine Eq_trans (TimesMN.ap2 gx (TimesMN.ap2 x fx));
      Refine Eq_sym; Refine TimesMN_assoc;
    Refine Eq_trans (TimesMN.ap2 gx OneMN);
      Refine exten2; Refine Eq_refl; Refine f_invers;
    Refine rOneMN_ident;
  Save;

(* --------------------------------------------------------------------------------
   From the module Set.l we have less-equal by an existantial quantifier.

   Prove that the ordering has a lowerbound and is reflexive and transitive.
   We can't prove it is anti-symmetric nor that it preserves addition.
*)

  [     rLessEqMN : BRelMdl MN
            = rLessEq TimesMN
  ]
  [     lLessEqMN : BRelMdl MN
            = lLessEq TimesMN
  ];

  Goal lLessEqMN_refl : Reflexive lLessEqMN;
    Intros x;
    Refine ExIntro; Refine OneMN;
    Refine lOneMN_ident;
  Save;

  Goal lLessEqMN_trans : Transitive lLessEqMN;
    Intros x y z __;
    Refine H; Refine H1; Intros k _ l _; Refine ExIntro; Refine TimesMN.ap2 k l;
    Refine Eq_trans (TimesMN.ap2 k (TimesMN.ap2 l x));
      Refine Eq_sym; Refine TimesMN_assoc;
    Refine Eq_trans (TimesMN.ap2 k y);
      Refine exten2; Refine Eq_refl; Refine H3;
    Refine H2;
  Save;

  Goal (rCancelation TimesMN) ->
       r_cancelation (lLessEqMN.ap2) (lLessEqMN.ap2) (TimesMN.ap2);
    Intros _ z x y _; Refine H1; Intros k _; Refine ExIntro; Refine k;
    Refine H z;
    Refine Eq_trans (TimesMN.ap2 k (TimesMN.ap2 x z));
    Refine Eq_sym; Refine TimesMN_assoc; Refine H2;
  Save lLessEqMN_cancel;

  Goal TimesMN.Commutative -> rLessEqMN.DecidableRel -> lLessEqMN.DecidableRel;
    Intros __ x y; orE H1 x y;
    intros; Refine inl;
      Refine H2; Intros k _; Refine ExIntro; Refine k;
      Refine Eq_trans (TimesMN.ap2 x k); Refine H; Immed;
    intros; Refine inr;
      Intros _; Refine H2;
      Refine H3; Intros k _; Refine ExIntro; Refine k;
      Refine Eq_trans (TimesMN.ap2 k x); Refine H; Immed;
  Save lLessEqMN_dec_intro;

Discharge MN;

Unfreeze OneMN TimesMN;

(* ================================================================================
   Define the notion of submonoid.
*)

[    submonoid : {MN|Monoid} (Subset MN.car) -> Prop
          = submodel|sigMN|axiomsMN
];

[MN | Monoid] [P | Subset MN.car] [subMN : submonoid P];

[    submonoid_one : P.ap MN.OneMN
          = subMN star21
]
[    submonoid_times : {x|obj MN} (P.ap x) -> {y|obj MN} (P.ap y) ->
                       P.ap (MN.TimesMN.ap2 x y)
           = subMN star22
];

Discharge MN;

(* ================================================================================
   Define homomorphism of monoids.
*)

[M,M' | Monoid];

  Goal HomomorphismMN_intro
     : {h : Fun M.car M'.car}
       {h_one : Eq (h.ap M.OneMN) M'.OneMN}
       {h_times : {x,y:obj M} Eq (h.ap (M.TimesMN.ap2 x y))
                                 (M'.TimesMN.ap2 (h.ap x) (h.ap y))}
       Homomorphism M M';
    intros;
    Refine Homomorphism_intro h;
    Refine TwoSET_elim [c:FuncSymb sigMN] homo_resp_Functions h c;
    Refine h_one;
    Refine h_times;
    Intros; Refine EmptySET_iter c;
  Save;

  [h : Homomorphism M M'];

  [     HomoMN_one
            : Eq (h.Homo_f.ap M.OneMN) M'.OneMN
            = h.Homo_resp_Functions star21
  ]
  [     HomoMN_times
            : {x,y:obj M} Eq (h.Homo_f.ap (M.TimesMN.ap2 x y))
                             (M'.TimesMN.ap2 (h.Homo_f.ap x) (h.Homo_f.ap y))
            = h.Homo_resp_Functions star22
  ];

  [     HomoMN_nontrivial : Prop
            = Ex[x:obj M] ~(Eq (h.Homo_f.ap x) M'.OneMN)
  ];

  Goal HomoMN_not_one : (Injection h.Homo_f) ->
                         {x|obj M} ~(Eq x M.OneMN) -> ~(Eq (h.Homo_f.ap x) M'.OneMN);
    Intros ____; Refine H1;
    Refine H;
    Refine Eq_trans ? H2;
    Refine Eq_sym; Refine HomoMN_one;
  Save;

Discharge M;

(* ================================================================================
   Build a few example monoids.
*)

(* The singleton set forms (trivially) a monoid.

    UnitMonoid = < {*}, *, \lambda x:{*}.* >
*)

Goal UnitMonoid : Monoid;
  Refine Monoid_intro;
  Refine UnitSet;
  Refine Fun2_intro; Refine [x,y:el UnitSet] Star; Intros ______; Refine Eq_refl;
  Refine Star;
  Intros ___; Refine Eq_refl;
  Refine pair; Refine ?+1; Refine UnitSET_elim (Eq Star); Refine Eq_refl;
Save;

(* The natural numbers with zero and addition, and with one and multiplication
   form a monoid.

    NatMonoid = < N, zeroN, plusN >
    NatMulMonoid = < N, oneN, timesN >
*)

[     NatMonoid : Monoid
          = Monoid_intro PlusN_assoc ZeroN_ident
]
[     NatMulMonoid : Monoid
          = Monoid_intro TimesN_assoc OneN_ident
];

(* The identity function together with the composition over a set A forms a monoid
   with the objects the functions from A to A.

    FunMonoid = \lambda A:Set < A=>A, id, comp >

*)

Goal FunMonoid : Set -> Monoid;
  intros A;
  Refine Monoid_intro;
  Refine Function A A;
  Refine Composition;
  Refine +1 Composition_assoc;
  Refine +1 Identit_ident;
Save;

(* --------------------------------------------------------------------------------
   Give a set A and a monoid MN we can construct a new monoid as follows.
   The objects (elements) of the monoid are the functions from A to MN.

   As the identity we take    OneFun        = \lambda x. 1
   For multiplication we take TimesFun(f,g) = \lambda x. f(x) * g(x)
*)

[A : Set] [MN : Monoid];

(* OneFun = \lambda x. 1 *)

Goal OneFun : el (Function A MN.car);
  Refine Fun_intro;
  intros x; Refine MN.OneMN;
  Intros ___; Refine Eq_refl;
Save;

(* TimesFun(f,g) = \lambda x. f(x) * g(x) *)

Goal timesFun : bop (Function A MN.car).el;
  Intros f g;
  Refine Fun_intro;
  Refine compose2 MN.TimesMN.ap2 f.ap g.ap;
  Intros ___;
  Refine exten2; Refine exten ? H; Refine exten ? H;
Save;

Goal TimesFun : Fun2 (Function A MN.car) (Function A MN.car) (Function A MN.car);
  Refine Fun2_intro;
  Refine timesFun;
  Intros f g _ f' g' _ x;
  Refine exten2 ? (H x) (H1 x);
Save;

Discharge A;

[A | Set] [MN | Monoid];

Goal Associative (TimesFun A MN);
  Intros f g h x;
  Refine TimesMN_assoc;
Save TimesFun_assoc;

Goal Identity (TimesFun A MN) (OneFun A MN);
  Refine pair;
  Intros f x;
  Refine lOneMN_ident;
  Intros f x;
  Refine rOneMN_ident;
Save OneFun_ident;

Goal FunctionMN : Monoid;
  Refine Monoid_intro;
  Refine +3 TimesFun_assoc;
  Refine +1 OneFun_ident;
Save;

Discharge A;

