
Module Choice Import Subsets;

(* --------------------------------------------------------------------------------
   The Axiom of Choice and the Axiom of Unique Choice.

   This file extends the context only with declarations. No axioms are assumed.
*)

[     AxiomOfChoice : Prop
          = {A,B|Set} {R:Rel A B}
            ({x:el A} Ex [y:el B] R.ap2 x y) -> 
            Ex [f:Fun A B] {x:el A} R.ap2 x (f.ap x)
]
[     axiom_of_choice : Prop
          = {T,U|SET} {R:T->U->Prop}
            ({x:T} Ex [y:U] R x y) -> 
            Ex [f:T->U] {x:T} R x (f x)
]
[     AxiomOfUniqueChoice : Prop
          = {A,B|Set} {R:Rel A B}
            ({x:el A} ExOne [y:el B] R.ap2 x y) -> 
            Ex [f:Fun A B] {x:el A} R.ap2 x (f.ap x)
];

(* --------------------------------------------------------------------------------
   These are much stronger axiom which we don't need.
   Given the graph of a function, not only the existance of the function is assumed,
   but the function is also given as an object.

[     AxiomOfChoice : TYPE
          = {A,B|Set} {R:Rel A B} (TotalRel R) -> 
            <f:Fun A B> {x:el A} R.ap2 x (f.ap x)
]
[     axiom_of_choice : TYPE
          = {T,U|SET} {R:T->U->Prop} (Totalrel R) -> 
            <f:T->U> {x:T} R x (f x)
]
[     AxiomOfUniqueChoice : TYPE
          = {A,B|Set} {R:Rel A B} (TotalRel R) -> (UniqueRel R) ->
            <f:Fun A B> {x:el A} R.ap2 x (f.ap x)
];
*)

(* --------------------------------------------------------------------------------
   Some consequences.
*)

Goal AxiomOfChoice -> axiom_of_choice;
  Intros ac ____; Refine ac (QRel R) H;
  intros f _;
  Refine ExIntro; Refine f.ap; Refine H1;
Save AC2ac;

Goal axiom_of_choice -> AxiomOfUniqueChoice;
  Intros ac ____;
  Refine ac R.ap2 [x:el A](H x).fst;
  intros f _;
  Refine ExIntro;
  Refine Fun_intro f; Refine +1 H1;
  Intros ___; Refine (H x).snd; Refine H1;
  Refine extenRel ? H2.Eq_sym ?.Eq_refl; Refine H1;
Save ac2AUC;

Goal AxiomOfChoice -> AxiomOfUniqueChoice;
  intros;
  Refine ac2AUC (AC2ac H);
Save AC2AUC;

(* ================================================================================
   Proof that from the axiom of choice, excluded middle follows.
*)

[AC : AxiomOfChoice];

[P : Prop];

$[     phi : Prop -> Prop
          = [alpha:Prop] alpha \/ P
]
$[     psi : Prop -> Prop
          = [alpha:Prop] ~alpha \/ P
]
$[     gamma : (Pred Omega) -> Prop
          = [f:Pred Omega] ({alpha:Prop} iff (f.ap alpha) (phi alpha)) \/
                           ({alpha:Prop} iff (f.ap alpha) (psi alpha))
];

Goal Phi : el (Predicate Omega);
  Refine Pred_intro;
  Refine phi;
  Intros ____; Refine H1;
  intros; Refine inl; Refine H.fst H2;
  intros; Refine inr; Refine H2;
$Save;

Goal Psi : el (Predicate Omega);
  Refine Pred_intro;
  Refine psi;
  Intros ____; Refine H1;
  intros; Refine inl; Intros _; Refine H2; Refine H.snd H3;
  intros; Refine inr; Refine H2;
$Save;

Goal Gamma : Pred (Predicate Omega);
  Refine Pred_intro;
  Refine gamma;
  Intros ____; Refine H1;
  intros; Refine inl; intros; Refine pair;
    intros; Refine ?.H2.fst; Refine ?.H.snd; Refine H3;
    intros; Refine ?.H.fst; Refine ?.H2.snd; Refine H3;
  intros; Refine inr; intros; Refine pair;
    intros; Refine ?.H2.fst; Refine ?.H.snd; Refine H3;
    intros; Refine ?.H.fst; Refine ?.H2.snd; Refine H3;
$Save;

$[     A : Set
          = toSet Gamma
];

Goal Rel A Omega;
  Refine Rel_intro;
  Refine [z:el A][alpha:Prop] z.1.ap alpha;
  Expand extensionalRel;
  Intros _______;
  Refine y'.H.fst;
  Refine extenPred ? H1 H2;
$Save f_graph;

Goal Ex [f:Pred A] ({x:el A} x.1.ap (f.ap x));
  Refine AC f_graph;
  intros z;
  Equiv Ex [y:el Omega] z.1.ap y;
  Refine z.2;
  intros; Refine ExIntro; Refine trueProp;
    Refine ?.H.snd; Refine inl; Refine trueprf;
  intros; Refine ExIntro; Refine absurd;
    Refine ?.H.snd; Refine inl; Refine Id;
$Save f_exist;

Goal el A;
  Intros #;
  Refine Phi;
  Refine inl; intros; Refine iff_refl;
$Save PHI;

Goal el A;
  Intros #;
  Refine Psi;
  Refine inr; intros; Refine iff_refl;
$Save PSI;

Goal Ex [f:Pred A] (phi (f.ap PHI)) /\ (psi (f.ap PSI));
  Refine f_exist; intros f _;
  Refine ExIntro; Refine f;
  Refine pair; Refine H PHI; Refine H PSI;
$Save f_lemma;

Goal P -> Eq Phi Psi;
  Intros p alpha;
  Refine pair;
  intros; Refine H;
  intros; Refine inr; Refine p;
  intros; Refine inr; Refine p;
  intros; Refine H;
  intros; Refine inr; Refine p;
  intros; Refine inr; Refine p;
$Save phi_psi;

Goal P \/ ~P;
  Refine f_lemma; intros f _;
  Refine H.fst;
  intros +1; Refine inl; Refine H1;
  intros; Refine H.snd;
  intros +1; Refine inl; Refine H2;
  intros; Refine inr; Intros _; Refine H2;
  Refine extenPred f ? H1;
  Refine phi_psi H3;
Save ACimpEM';

Discharge P;

Goal ExcludedMiddle;
  Intros _;
  Refine ACimpEM' alpha;
Save ACimpEM;

Discharge AC;
