
Module Bishop Import Subsets Choice Nat;

(* 
   In this module we define another notion of subsets based on Bishop's work.

   We call them categorical subsets.

*)

[     CatSubset : Set -> TYPE
          = [S:Set] <A:Set> <f:Fun A S> Injection f
];

[S | Set];

[     carCat : (CatSubset S) -> Set
          = [C : CatSubset S] C.1
]
[     elCat : (CatSubset S) -> SET
          = [C : CatSubset S] el C.carCat
]
[     iCat : {C:CatSubset S} Fun (carCat C) S
          = [C : CatSubset S] C.2.1
]
[     injecCat : {C:CatSubset S} Injection (iCat C)
          = [C : CatSubset S] C.2.2
]
[     CatSubset_intro [A:Set] [i:Fun A S] [injec : Injection i] : CatSubset S
          = (A, i, injec : <A:Set><i:Fun A S>Injection i)
];

[     elemCat : (el S) -> (CatSubset S) -> Prop
          = [x:el S] [C:CatSubset S] Ex [a:elCat C] Eq (C.iCat.ap a) x
];

(* --------------------------------------------------------------------------------
   Following Bishop, define a relation on categorical subsets and
   prove it is an equivalence relation.
*)

[     Eq_CatSubset : (CatSubset S) -> (CatSubset S) -> Prop
          = [X,Y:CatSubset S] 
            Ex2 [f:Fun X.carCat Y.carCat] [g:Fun Y.carCat X.carCat]
                (Eq (composition Y.iCat f) X.iCat) /\
                (Eq (composition X.iCat g) Y.iCat)
];

Goal {C:CatSubset S} Eq_CatSubset C C;
  intros;
  Refine Ex2Intro;
  Refine Identit; Refine Identit; Refine pair;
  Refine rIdentit_ident;
  Refine rIdentit_ident;
Save Eq_CatSubset_refl;

Goal {C,D|CatSubset S} (Eq_CatSubset C D) -> (Eq_CatSubset D C);
  intros;
  Refine H; Intros f g _;
  Refine Ex2Intro;
  Refine g; Refine f; Refine pair;
  Refine H1.snd; Refine H1.fst;
Save Eq_CatSubset_sym;

Goal {C|CatSubset S}{D:CatSubset S}{E|CatSubset S} 
     (Eq_CatSubset C D) -> (Eq_CatSubset D E) -> (Eq_CatSubset C E);
  intros;
  Refine H; Intros f g _;
  Refine H1; Intros k l _;
  Refine Ex2Intro;
  Refine composition k f; Refine composition g l; Refine pair;
  Refine Eq_trans ? ? H2.fst;
  Refine Eq_trans (composition (composition E.iCat k) f);
    Refine Composition_assoc;
  Refine exten2 (Composition ???) ??.Eq_refl;
  Refine H3.fst;
  Refine Eq_trans ? ? H3.snd;
  Refine Eq_trans ? (Composition_assoc ???); Refine exten2 ???.Eq_refl;
  Refine H2.snd;
Save Eq_CatSubset_trans;

(*
   Now show that the equality relation gives raise to the existance of an
   isomorphism.
*)

Goal {C,D|CatSubset S} (Eq_CatSubset C D) -> (Iso C.carCat D.carCat);
  intros;
  Refine H; intros f g _;
  Refine Ex2Intro; Refine f; Refine g;
  Refine pair;

  Refine Injection_lemma1 (injecCat C);
  Refine Eq_trans ? (Comp_assoc ???);
  Refine Eq_trans (composition (iCat D) f);
    Refine exten2 (Composition ???) ??.Eq_refl;
    Refine snd H1;
  Refine Eq_trans ? H1.fst;
    Refine Eq_sym; Refine lIdentit_ident;

  Refine Injection_lemma1 (injecCat D);
  Refine Eq_trans ? (Comp_assoc ???);
  Refine Eq_trans (composition (iCat C) g);
    Refine exten2 (Composition ???) ??.Eq_refl;
    Refine fst H1;
  Refine Eq_trans ? H1.snd;
    Refine Eq_sym; Refine lIdentit_ident;
Save Eq_CarSubset_iso;

(* --------------------------------------------------------------------------------
   We can also define the equality relation over categorical subsets
   by using elemCat.
*)

[     Eq_CatSubset' : (CatSubset S) -> (CatSubset S) -> Prop
          = [X,Y:CatSubset S] {x:el S} iff (elemCat x X) (elemCat x Y)
];

Goal {C:CatSubset S} Eq_CatSubset' C C;
  Intros __; Refine pair;
  Refine Id;
  Refine Id;
Save Eq_CatSubset'_refl;

Goal {C,D|CatSubset S} (Eq_CatSubset' C D) -> (Eq_CatSubset' D C);
  Intros ____; Refine pair;
  Refine ?.H.snd;
  Refine ?.H.fst;
Save Eq_CatSubset'_sym;

Goal {C|CatSubset S}{D:CatSubset S}{E|CatSubset S} 
     (Eq_CatSubset' C D) -> (Eq_CatSubset' D E) -> (Eq_CatSubset' C E);
  Intros ______; Refine pair;
  intros; Refine ?.H1.fst; Refine ?.H.fst; Refine H2;
  intros; Refine ?.H.snd; Refine ?.H1.snd; Refine H2;
Save Eq_CatSubset'_trans;

(* --------------------------------------------------------------------------------
   And now the interesting part: show that both definitions are equivalent.
*)

Discharge S;

[AUC :  AxiomOfUniqueChoice];
[S | Set];
[C,C' | CatSubset S];

Goal Rel C.carCat C'.carCat;
  Refine Rel_intro;
  Refine [x:elCat C] [y:elCat C'] Eq (C'.iCat.ap y) (C.iCat.ap x);
  Intros _______;
  Refine Eq_trans (C'.iCat.ap y); Refine exten ? H1.Eq_sym;
  Refine Eq_trans ? H2; Refine exten ? H;
$Save graph;

Goal ({x:el S} (elemCat x C) -> (elemCat x C')) ->
     (Ex [f:Fun C.carCat C'.carCat] Eq (composition C'.iCat f) C.iCat);
  intros;
  Refine AUC graph;
  intros; Refine pair;
  Refine H (C.iCat.ap x); 
  Refine ExIntro; Refine x; Refine Eq_refl;
  intros y y' __; Refine injecCat C';
  Refine Eq_trans ? H1; Refine H2.Eq_sym;
Save Eq_CatSubset_lemma0;

Discharge AUC;
[S | Set];

Goal AxiomOfUniqueChoice ->
     {C,C'|CatSubset S} (Eq_CatSubset' C C') -> (Eq_CatSubset C C');
  intros AUC ___;
  Refine Eq_CatSubset_lemma0 AUC [x:el S]x.H.fst;
  Refine Eq_CatSubset_lemma0 AUC [x:el S]x.H.snd;
  intros g _ f _;
  Refine Ex2Intro; Refine f; Refine g; Refine pair H2 H1;
Save Eq_CatSubset_lemma1;

Goal {C,C'|CatSubset S} (Eq_CatSubset C C') -> (Eq_CatSubset' C C');
  Intros ____;
  Refine H; intros f g _;
  Refine pair;
  intros;
    Refine H2; intros c _;
    Refine ExIntro; Refine f.ap c;
    Refine Eq_trans ? (H1.fst c); Refine H3;
  intros;
    Refine H2; intros c _;
    Refine ExIntro; Refine g.ap c;
    Refine Eq_trans ? (H1.snd c); Refine H3;
Save Eq_CatSubset_lemma2;

(* --------------------------------------------------------------------------------
   Define two functions toCat and deCat which converts categorical subsets into
   ordinary (charistic) subsets and vice versa.
   Also define a term which makes a set out of a (ordinary) subset.
*)

Goal (CatSubset S) -> (Subset S);
  intros C;
  Refine Pred_intro;
  Refine [s:el S] Ex [a:el C.carCat] Eq (C.iCat.ap a) s;
  Intros x y __;
  exE H1; intros a _; exI ?; Refine a; Refine Eq_trans ? H2 H;
Save toSubset;

Goal (Subset S) -> (CatSubset S);
  intros P;
  Refine CatSubset_intro;
  Refine toSet P;
  Refine Fun_intro;
    intros a; Refine a.1;
    Intros x y _; Refine H;
  Intros x y _;
  Refine H;
Save toCat;

(* --------------------------------------------------------------------------------
   Prove that toCat and toSubset are isomorphic:

       {P : Subset S} P.toCat.toSubset = P

   which is easy to prove. The other way around

       AUC -> {C : CatSubset S} C.toSubset.toCat = C

   needs the axiom of unique choice.
*)

Goal {P:Subset S} {x:el S} iff (elem x P) (elemCat x P.toCat);
  intros;
  Equiv iff  (P.ap x) (Ex ([a:P.toSet.el] Eq (a.1) x));
  Refine pair;
  intros;
    Refine ExIntro; Intros #; Refine x; Refine H; Refine Eq_refl;
  intros;
    Refine H; intros y _; Refine extenPred ? H1; Refine y.2;
Save elem_cat;

Goal {C:CatSubset S} {x:el S} iff (elemCat x C) (elem x C.toSubset);
  intros; Refine iff_refl;
Save elemCat_subset;

Goal {P:Subset S} Eq|(Predicate S) P.toCat.toSubset P;
  Intros __;
  Refine Eq_sym; Refine elem_cat;
Save Subset_cat;

Goal {C:CatSubset S} Eq_CatSubset' C.toSubset.toCat C;
  Intros __;
  Equiv iff (Ex ([c:<x:el S> Ex ([a:elCat C] Eq (C.iCat.ap a) x)] Eq c.1 x))
            (Ex ([a:elCat C]Eq (C.iCat.ap a) x));
  Refine pair;
  intros;
    Refine H; intros a _;
    Refine a.2; intros b _;
    Refine ExIntro; Refine b; Refine Eq_trans ? H2 H1;
  intros;
    Refine H; intros a _;
    Refine ExIntro; Intros #; Refine x; Refine H;
    Refine Eq_refl;
Save Cat_subset';

Goal AxiomOfUniqueChoice ->
     {C:CatSubset S} Eq_CatSubset C.toSubset.toCat C;
  intros AUC _;
  Refine Eq_CatSubset_lemma1 AUC;
  Refine Cat_subset';
Save Cat_subset;

Discharge S;

(* ================================================================================
   Example: the positive natural numbers, and the set {3,6}
*)

[Examples:Prop];

[C_PosNat = CatSubset_intro Nat Succ Succ_inj : CatSubset Nat];

Goal Subset Nat;
  Refine Fun_intro;
  Refine [x:el Nat] ~(Eq x ZeroN);
  Intros ___; Qrepl H; Refine Eq_refl;
Save PosNat;

Goal f : Fun TwoSet Nat;
  Refine Fun_intro;
    Refine TwoSET_elim TwoSET\nat; Refine ThreeN; Refine SixN;
  Intros ___; Qrepl H; Refine Eq_refl;
Save;

Goal f_inj : Injection f;
  Refine TwoSET_elim ([a:el TwoSet]{a':TwoSET}(Eq (ap f a) (ap f a'))->Eq a a');
  Refine TwoSET_elim ([a':TwoSET] (Eq ThreeN (ap f a')) -> Eq|TwoSet star21 a');
  intros; Refine Eq_refl;
  intros; Refine Succ_not_zero ? (Eq_sym (Succ_inj (Succ_inj (Succ_inj H))));
  Refine TwoSET_elim ([a':TwoSET] (Eq SixN (ap f a')) -> Eq|TwoSet star22 a');
  intros; Refine Succ_not_zero ? (Succ_inj (Succ_inj (Succ_inj H)));
  intros; Refine Eq_refl;
Save;

[     C_ThreeSix : CatSubset Nat
          = CatSubset_intro TwoSet f f_inj
];

Goal ThreeSix : Subset Nat;
  Refine Pred_intro;
  Refine [x:el Nat] (Eq x ThreeN) \/ (Eq x SixN);
  Intros ____; Qrepl H.Eq_sym;  Refine H1;
Save;

Forget Examples;
