
Module AbMonoid Import Monoid;

(*
   An abelian monoid is a monoid for which commutativity holds. This
   module is quite boring. It just changes the names of OneMN,
   TimesMN, PowerMN to ZeroMN, PlusMN, MultMN.
*)

[MN : Monoid];

[     ZeroMN : obj MN
          = MN.OneMN
]
[     PlusMN : BFunMdl MN
          = MN.TimesMN
];

[     PlusMN_assoc : Associative PlusMN
          = MN.TimesMN_assoc
]
[     ZeroMN_ident : Identity PlusMN ZeroMN
          = MN.OneMN_ident
]
[     rPlusMN_commut
          : (Commutative PlusMN) -> {x,y,z:obj MN}
            Eq (PlusMN.ap2 (PlusMN.ap2 x y) z) (PlusMN.ap2 (PlusMN.ap2 x z) y)
          = MN.rTimesMN_commut
]
[     lPlusMN_commut
          : (Commutative PlusMN) -> {x,y,z:obj MN}
            Eq (PlusMN.ap2 x (PlusMN.ap2 y z)) (PlusMN.ap2 y (PlusMN.ap2 x z))
          = MN.lTimesMN_commut
];

[     MultMN : Fun2 MN.car Nat MN.car
          = MN.PowerMN
]
[     MultMN_zero : {x:obj MN} Eq (MultMN.ap2 x ZeroN) ZeroMN
          = MN.PowerMN_zero
]
[     MultMN_succ : {x:obj MN}{n:el Nat}
                    Eq (MultMN.ap2 x (Succ.ap n)) (PlusMN.ap2 (MultMN.ap2 x n) x)
          = MN.PowerMN_succ
]
[     MultMN_one : rIdentity MultMN OneN
          = MN.PowerMN_one
];

Discharge MN;
