
Module syntax Import neList;

(* This module introduces the notion of terms given some
signature. Only single-sorted signatures are possible. *)

(* --------------------------------------------------------------------------------
   A signature consists of
    -  a type FuncSymb of function symbols (and constant symbols)
    -  a type PredSymb of predicate sysmbols
    -  an arity map FuncArity which assigs the arity to every function symbol
    -  an arity map PredArity which assigs the arity to every predicate symbol
*)

Inductive [Signature : TYPE]
Constructors [Signature_intro : {FuncSymb | SET} {FuncAr : FuncSymb -> nat}
                                {PredSymb | SET} {PredAr : PredSymb -> nat}
                                Signature];

[     FuncSymb : Signature -> SET
          = Signature_elim (Signature\SET)
                           ([FuncSymb:SET] [FuncAr:FuncSymb->nat]
                            [PredSymb:SET] [PredAr:PredSymb->nat] FuncSymb)
]
[     PredSymb : Signature -> SET
          = Signature_elim (Signature\SET)
                           ([FuncSymb:SET] [FuncAr:FuncSymb->nat]
                            [PredSymb:SET] [PredAr:PredSymb->nat] PredSymb)
]
[     FuncArity : {s|Signature} (FuncSymb s) -> nat
          = Signature_elim ([s:Signature](FuncSymb s) -> nat)
                           ([FuncSymb:SET] [FuncAr:FuncSymb->nat]
                            [PredSymb:SET] [PredAr:PredSymb->nat] FuncAr)
]
[     PredArity : {s|Signature} (PredSymb s) -> nat
          = Signature_elim ([s:Signature](PredSymb s) -> nat)
                           ([FuncSymb:SET] [FuncAr:FuncSymb->nat]
                            [PredSymb:SET] [PredAr:PredSymb->nat] PredAr)
];

(* --------------------------------------------------------------------------------
   Let s be a signature.
   Define n-tuples of terms. Define terms.
   Define atomic formulas.
*)

[s : Signature];

Inductive [terms : nat -> SET]
Constructors [TFV   : nat -> (terms OneN)]
             [TFC   : {c:FuncSymb s} (terms (FuncArity c)) -> (terms OneN)]
             [tnil  : terms ZeroN]
             [tcons : {n|nat} (terms OneN) -> (terms n) -> (terms (succ n))];

[term : SET = terms OneN];

(* Define the set Terms from terms by using Leibniz equality. *)

[Terms [n:nat] : Set = QSet (terms n)];

[Term : Set = Terms OneN];

Inductive [atomic_form : SET]
Constructors [AFPred : {p:PredSymb s} (terms (PredArity p)) -> atomic_form]
             [AFEq   : (terms TwoN) -> atomic_form];

Inductive [formula : SET]
Constructors [FFAtom : atomic_form -> formula]
             [FFEx, FFAll, FFnot : formula -> formula]
             [FFimp, FFor, FFand : formula -> formula -> formula];

Discharge s;

[s | Signature];

[     TFcons : ((terms s ZeroN) -> term s) -> (term s)
          = [H:(terms s ZeroN) -> term s] H (tnil s)
]
[     TFfun : ((terms s OneN) -> term s) -> (term s) -> (term s)
          = Id|((terms s OneN) -> term s)
]
[     TFfun2 : ((terms s TwoN) -> term s) -> bop (term s)
          = [H:(terms s TwoN) -> term s] [t,u:term s] H (tcons s t u)
];

(* ================================================================================
   Define simultaneous substitution and substitution in one variable.
*)

Goal SimSubst : {rho:el (neList (Prod Nat (Term s)))}
                {n|nat} (Terms s n).el -> (Terms s n).el;
  intros _;
  Refine terms_elim ? [n:nat] (Terms s n).el \ (Terms s n).el;
  intros n; Refine nelist_iter ?? rho;
    intros z; Refine if Nat_discr n z.First z.Second (TFV s n);
    intros z ih; Refine if Nat_discr n z.First z.Second ih;
  intros c _; Refine TFC s c;
  Refine tnil;
  intros ___; Refine tcons;
Save;

[     Subst_n : {n|nat} (Terms s n).el -> Nat.el -> (Term s).el -> (Terms s n).el
          = [n|nat] [t:el (Terms s n)] [x:el Nat] [u:el (Term s)]
            SimSubst (base (Tuple x u)) t
]
[     Subst : (Term s).el ->  Nat.el -> (Term s).el -> (Term s).el
          = Subst_n | OneN
];

(* --------------------------------------------------------------------------------
   Define a relation VARn sucht that for any term t and natural number x:

     ((VARn n).ap2 t x)    iff    x occurs in t
*)

Goal {n|nat} (Terms s n).el -> Nat.el -> Prop;
  intros m u x;
  Refine terms_elim s ([n:nat](terms s n)\Prop) ???? u;
  intros y; Refine if Nat_discr y x trueProp absurd;
  intros __; Refine Id;
  Refine absurd;
  intros ___; Refine or;
Save var_n;

Goal {n|nat} extensionalRel (var_n|n);
  Intros _______;
  Qrepl H; Qrepl H1; Refine Id;
Save var_n_exten;

Goal VARn : {n:nat} Rel (Terms s n) Nat;
  intros _;
  Refine Rel_intro ? (var_n_exten|n);
Save;

Discharge s;
