
Module mu Import Nat_order;

(* Define bounded minimalisation

         \mu x < z . \phi(x)
*)

[phi | nat -> Prop] [phi_dec : decidable_pred phi];

[     mu' : Nat.el -> Nat.el -> Nat.el
          = nat_elim (nat\nat->nat)
                     ([z:nat]z)
                     ([x:nat][ih:nat->nat][z:nat] select (phi_dec x) (ih x) (ih z))
]
[     mu : Nat.el -> Nat.el
          = [z:nat] mu' z z
];

(*
    (\mu z . phi z) !=  z     ->     \phi (\mu z . phi z)
*)

Goal {z|el Nat} ~(Eq (mu z) z) -> phi (mu z);
  intros zz;
  Refine nat_elim [x:nat]{z:nat} ~(Eq (mu' x z) z) -> phi (mu' x z);

  intros; Refine H; Refine Eq_refl;

  intros x ih z;
  Equiv  ~(Eq (select (phi_dec x) (mu x) (mu' x z)) z) ->
         phi (select (phi_dec x) (mu x) (mu' x z));
  Refine select_lemma ([y:el Nat] ~(Eq y z) -> phi y);

  intros; Refine Nat_discr (mu x) x;
  intros; Qrepl H2; Refine H;
  intros; Refine ih; Refine H2;

  intros; Refine ih ? H1;
Save mu_phi;

(*
      (\mu z . \phi z)  <=  z
*)

Goal {z:el Nat} LessEqN.ap2 (mu z) z;
  intros zz;
  Refine nat_elim [x:nat] {z:nat} (LessEqN.ap2 x z) -> LessEqN.ap2 (mu' x z) z;
  Refine +2 LessEqN_refl;
  intros z _; Refine LessEqN_refl;
  intros x ih z _;
  Equiv LessEqN.ap2 (select (phi_dec x) (mu' x x) (mu' x z)) z;
  Refine select_lemma ([y:nat] LessEqN.ap2 y z);

  intros;
  Refine LessEqN_trans x; Refine ih; Refine LessEqN_refl;
  Refine LessEqN_succ_elim H;

  intros; Refine ih; 
  Refine LessEqN_succ_elim H;
Save mu_UB;

(*
     (\phi y)   ->    (\mu (y+Sz) . \phi (y+Sz)) <= y
*)

Goal {y|el Nat} (phi y) -> {z:el Nat} LessEqN.ap2 (mu (PlusN.ap2 y (Succ.ap z))) y;
  intros __ zz;
  Refine nat_elim [x:nat] {z:nat} LessEqN.ap2 (mu' (PlusN.ap2 y (Succ.ap x)) z) y;

  intros;
  Equiv LessEqN.ap2 (select (phi_dec y) (mu y) (mu' y z)) y;
  Refine select_lemma [x:nat] LessEqN.ap2 x y;
  intros; Refine mu_UB;
  intros; Refine H1 H;

  intros x ih z;
  Equiv LessEqN.ap2 (select (phi_dec (PlusN.ap2 y x.succ))
                            (mu (PlusN.ap2 y x.succ))
                            (mu' (PlusN.ap2 y x.succ) z)) y;
  Refine select_lemma [x:nat] LessEqN.ap2 x y;
  intros; Refine ih;
  intros; Refine ih;
Save mu_OK';

(*
     (\phi x)    ->   (\mu z . phi z) <= x
*)

Goal {x|el Nat} (phi x) -> {z:el Nat} (LessEqN.ap2 (mu z) x);
  intros;
  Refine LessEqN_partit z x;
  intros; Refine LessEqN_trans z; Refine mu_UB; Refine H1;
  intros; Refine LessEqN_Ex_intro (LessN_elim_succ H1);
  intros y _;
  Claim Eq z (PlusN.ap2 x (Succ.ap y));
  Qrepl ?+1;
  Refine mu_OK' H;
  Refine Eq_trans (PlusN.ap2 (Succ.ap x) y); Refine H2.Eq_sym;
  Refine lPlusSuccN;
Save mu_OK;

Discharge phi;
