
Module Real Import Field_order;

(* 
   We introduce the real numbers as an ordered field. Of course this is a very
   limited axiomatization, but it will suffice for the moment.

   To make things easier, we also assume that the equality on reals is
   decidable, so we work in a classical setting.
*)

$[OREAL : OrderedField];

[REAL       : Field = OREAL.FieldOFd]
[REAL_Group : Group = REAL.GroupFd]
[REAL_Ring  : Ring  = REAL.RingFd]
[Real       : Set   = OREAL.car];

$[Real_discr : Discrete Real];

(* --------------------------------------------------------------------------------
   In this module no new lemmas are proven. We only import all results
   from the ordered fields and give the new names.
*)

[PlusR   : Fun2 Real Real Real = OREAL.PlusOFd  ]
[DoubleR : Fun Real Real       = OREAL.DoubleOFd]
[MinusR  : Fun2 Real Real Real = OREAL.MinusOFd ]
[TimesR  : Fun2 Real Real Real = OREAL.TimesOFd ]
[SquareR : Fun Real Real       = OREAL.SquareOFd]
[PowerR  : Fun2 Real Nat Real  = OREAL.PowerOFd ]
[DivR    : Fun2 Real Real Real = OREAL.DivOFd   ]
[NegR    : Fun Real Real       = OREAL.NegOFd   ]
[RecipR  : Fun Real Real       = OREAL.RecipOFd ]
[ZeroR   : el Real             = OREAL.ZeroOFd  ]
[OneR    : el Real             = OREAL.OneOFd   ]
[NegOneR : el Real             = OREAL.NegOneOFd]
[TwoR    : el Real             = OREAL.TwoOFd   ];

[PlusR_assoc         : Associative PlusR                    = OREAL.PlusOFd_assoc     ]
[PlusR_commut        : Commutative PlusR                    = OREAL.PlusOFd_commut    ]
[ZeroR_ident         : Identity PlusR ZeroR                 = OREAL.ZeroOFd_ident     ]
[lZeroR_ident        : lIdentity PlusR ZeroR                = OREAL.lZeroOFd_ident    ]
[rZeroR_ident        : rIdentity PlusR ZeroR                = OREAL.rZeroOFd_ident    ]
[NegR_invers         : Inverse PlusR ZeroR NegR             = OREAL.NegOFd_invers     ]
[lNegR_invers        : lInverse PlusR ZeroR NegR            = OREAL.lNegOFd_invers    ]
[rNegR_invers        : rInverse PlusR ZeroR NegR            = OREAL.rNegOFd_invers    ]

[rPlusR_cancel       : rCancelation PlusR                   = OREAL.rPlusOFd_cancel   ]
[lPlusR_cancel       : lCancelation PlusR                   = OREAL.lPlusOFd_cancel   ]
[PlusR_cancel        : Cancelation PlusR                    = OREAL.PlusOFd_cancel    ]
[NegR_invol          : Involutive NegR                      = OREAL.NegOFd_invol      ]
[NegR_inj            : Injection NegR                       = REAL.NegFd_inj          ]
[NegZeroR            : Eq (NegR.ap ZeroR) ZeroR             = OREAL.NegZeroOFd        ]
[NegZeroR_ident      : Identity PlusR (NegR.ap ZeroR)       = REAL.NegZeroFd_ident    ]
[rNegZeroR_ident     : rIdentity PlusR (NegR.ap ZeroR)      = REAL.rNegZeroFd_ident   ]
[lNegZeroR_ident     : lIdentity PlusR (NegR.ap ZeroR)      = REAL.lNegZeroFd_ident   ];

[TimesR_assoc        : Associative TimesR                   = OREAL.TimesOFd_assoc    ]
[TimesR_commut       : Commutative TimesR                   = OREAL.TimesOFd_commut   ]
[OneR_ident          : Identity TimesR OneR                 = OREAL.OneOFd_ident      ]
[lOneR_ident         : lIdentity TimesR OneR                = OREAL.lOneOFd_ident     ]
[rOneR_ident         : rIdentity TimesR OneR                = OREAL.rOneOFd_ident     ]
[RecipR_invers       : MultInverse TimesR ZeroR OneR RecipR = OREAL.RecipOFd_invers   ]
[TimesPlusR_distrib  : Distributive PlusR TimesR        = OREAL.TimesPlusOFd_distrib  ];

[lTimesPlusR_distrib : lDistributive PlusR TimesR       = OREAL.lTimesPlusOFd_distrib ]
[rTimesPlusR_distrib : rDistributive PlusR TimesR       = OREAL.rTimesPlusOFd_distrib ];

Goal rTimesMinusR_distrib : rDistributive MinusR TimesR;
  Refine REAL.rTimesMinusFd_distrib;
Save;

Goal lTimesMinusR_distrib : lDistributive MinusR TimesR;
  Refine REAL.lTimesMinusFd_distrib;
Save;

Goal TimesMinusR_distrib : Distributive MinusR TimesR;
  Refine REAL.TimesMinusFd_distrib;
Save;

[     NegR_lemma1 : {x|el Real} (Eq x ZeroR) -> Eq x (NegR.ap x)
           = REAL.NegFd_lemma1
]
[     rPlusR_commut : {x,y,z:el Real} Eq (PlusR.ap2 (PlusR.ap2 x y) z)
                                         (PlusR.ap2 (PlusR.ap2 x z) y)
           = REAL.rPlusFd_commut
]
[     rTimesR_commut : {x,y,z:el Real} Eq (TimesR.ap2 (TimesR.ap2 x y) z)
                                         (TimesR.ap2 (TimesR.ap2 x z) y)
           = REAL.rTimesFd_commut
]
[     TimesR_lemma1 : {a,b,c,d:el Real} Eq (TimesR.ap2 (PlusR.ap2 a b) (PlusR.ap2 c d))
                       (PlusR.ap2 (PlusR.ap2 (PlusR.ap2 (TimesR.ap2 a c)
                                                        (TimesR.ap2 a d))
                                                        (TimesR.ap2 b c))
                                                        (TimesR.ap2 b d))
           = REAL.TimesFd_lemma1
]
[     SquareR_lemma1 : {x,y:el Real} Eq (TimesR.ap2 (PlusR.ap2 x y) (MinusR.ap2 x y))
                                        (MinusR.ap2 (SquareR.ap x) (SquareR.ap y))
           = REAL.SquareFd_lemma1
]
[     MinusR_lemma1 : {x,y|el Real} (Eq (MinusR.ap2 x y) ZeroR) -> Eq x y
           = REAL.MinusFd_lemma1
]
[     PlusNegR_distrib : {x,y:el Real} Eq (PlusR.ap2 (NegR.ap x) (NegR.ap y))
                                          (NegR.ap (PlusR.ap2 x y))
          = REAL.PlusNegFd_distrib
]
[     rTimesZeroR : {x:el Real} Eq (TimesR.ap2 x ZeroR) ZeroR 
          = REAL.rTimesZeroFd
]
[     lTimesZeroR : {x:el Real} Eq (TimesR.ap2 ZeroR x) ZeroR 
          = REAL.lTimesZeroFd
]
[     rTimesNegR_distrib : {x,y:el Real} Eq (TimesR.ap2 x (NegR.ap y))
                                            (NegR.ap (TimesR.ap2 x y))
          = REAL.rTimesNegFd_distrib   
]
[     lTimesNegR_distrib : {x,y:el Real} Eq (TimesR.ap2 (NegR.ap x) y)
                                            (NegR.ap (TimesR.ap2 x y))
          = REAL.lTimesNegFd_distrib
]
[     TimesNegR_distrib : {x,y:el Real} Eq (TimesR.ap2 (NegR.ap x) (NegR.ap y))
                                           (TimesR.ap2 x y)
          = REAL.TimesNegFd_distrib
]
[     SquareNegR_distrib : {x:el Real} Eq (SquareR.ap (NegR.ap x)) (SquareR.ap x)
          = REAL.SquareNegFd_distrib
]
[     rRecipR_invers : {x|el Real} ~(Eq x ZeroR) ->
                                   (Eq (TimesR.ap2 x (RecipR.ap x)) OneR)
          = OREAL.rRecipOFd_invers
]
[     lRecipR_invers : {x|el Real} ~(Eq x ZeroR) ->
                                   (Eq (TimesR.ap2 (RecipR.ap x) x) OneR)
          = OREAL.lRecipOFd_invers  
]
[     Real_non_trivial : ~(Eq ZeroR OneR)
          = REAL.Field_non_trivial
]
[     OneR_not_zero : ~(Eq OneR ZeroR)
          = REAL.OneFd_not_zero
]
[     TwoR_not_zero : ~(Eq TwoR ZeroR)
          = OREAL.TwoOFd_not_zero
]
[     RecipR_not_zero : {x|el Real} ~(Eq x ZeroR) -> ~(Eq (RecipR.ap x) ZeroR)
          = REAL.RecipFd_not_zero
]
[     RecipR_invol : {x|el Real} ~(Eq x ZeroR) -> Eq (RecipR.ap (RecipR.ap x)) x
          = REAL.RecipFd_invol
]
[     RecipR_inj : {x,x'|el Real} ~(Eq x ZeroR) -> ~(Eq x' ZeroR) ->
                                  (Eq (RecipR.ap x) (RecipR.ap x')) -> Eq x x'
          = REAL.RecipFd_inj
]
[     rTimesR_cancel : {a|el Real} ~(Eq a ZeroR) ->
                       {x,y|el Real} (Eq (TimesR.ap2 x a) (TimesR.ap2 y a)) -> (Eq x y) 
          = REAL.rTimesFd_cancel  
]
[     lTimesR_cancel : {a|el Real} ~(Eq a ZeroR) ->
                       {x,y|el Real} (Eq (TimesR.ap2 a x) (TimesR.ap2 a y)) -> (Eq x y) 
          = REAL.lTimesFd_cancel  
]
[     TimesR_not_zero : {x,y|el Real} ~(Eq x ZeroR) -> ~(Eq y ZeroR) ->
                                      ~(Eq (TimesR.ap2 x y) ZeroR)
          = REAL.TimesFd_not_zero
];

Goal TwoR_lemma1 : {x:el Real} Eq (DoubleR.ap x) (TimesR.ap2 TwoR x);
  Refine REAL.TwoFd_lemma1;
Save;

Goal TwoR_lemma2 : {x:el Real} Eq (DivR.ap2 (DoubleR.ap x) TwoR) x;
  Refine TwoOFd_lemma1;
Save;

Goal DoubleR_not_zero : {x|el Real} ~(Eq x ZeroR) -> ~(Eq (DoubleR.ap x) ZeroR);
  Refine DoubleOFd_not_zero;
Save;

Goal DivR_lemma1 : {x,y|el Real} ~(Eq y ZeroR) -> Eq (DivR.ap2 (TimesR.ap2 x y) y) x;
  Refine REAL.DivFd_lemma1;
Save;

Goal DivR_lemma2 : {x,y|el Real} ~(Eq x ZeroR) -> Eq (DivR.ap2 (TimesR.ap2 x y) x) y;
  Refine REAL.DivFd_lemma2;
Save;

Goal PowerR_one : {x:el Real} Eq (PowerR.ap2 x OneN) x;
  Refine REAL.PowerFd_one;
Save;

Goal PowerR_two : {x:el Real} Eq (PowerR.ap2 x TwoN) (SquareR.ap x);
  Refine REAL.PowerFd_two;
Save;

Goal PowerR_plus : {x:el Real}{m,n:el Nat} Eq (PowerR.ap2 x (PlusN.ap2 m n))
                              (TimesR.ap2 (PowerR.ap2 x m) (PowerR.ap2 x n));
  Refine REAL.PowerFd_plus;
Save;

Goal PowerR_times : {x:el Real}{m,n:el Nat} Eq (PowerR.ap2 x (TimesN.ap2 m n))
                                             (PowerR.ap2 (PowerR.ap2 x m) n);
  Refine REAL.PowerFd_times;
Save;

Goal PowerR_distrib : {x,y:el Real}{n:el Nat}
                       Eq (PowerR.ap2 (TimesR.ap2 x y) n)
                          (TimesR.ap2 (PowerR.ap2 x n) (PowerR.ap2 y n));
  Refine REAL.PowerFd_distrib;
Save;

Goal PowerR_lemma2 : {x:el Real}{m,n:el Nat}
                       Eq (PowerR.ap2 (PowerR.ap2 x m) n)
                          (PowerR.ap2 (PowerR.ap2 x n) m);
  Refine REAL.PowerFd_lemma2;
Save;

(* --------------------------------------------------------------------------------
*)

[     LessEqR : Rel Real Real
          = OREAL.LessEqOFd
];

Goal LessEqR_refl : Reflexive LessEqR;
  Refine LessEqOFd_refl;
Save;

Goal LessEqR_antisym : AntiSymmetric LessEqR;
  Refine LessEqOFd_antisym;
Save;

Goal LessEqR_trans : Transitive LessEqR;
  Refine LessEqOFd_trans;
Save;

Goal LessEqR_total : Total LessEqR;
  Refine LessEqOFd_total;
Save;

[PositiveR       : Pred Real       = OREAL.PositiveOFd]
[StrPosR         : Pred Real       = OREAL.StrPosOFd  ]
[NegativeR       : Pred Real       = OREAL.NegativeOFd]
[StrNegR         : Pred Real       = OREAL.StrNegOFd  ];

[     PositiveZeroR : PositiveR.ap ZeroR
          = OREAL.PositiveZeroOFd
]
[     NegativeZeroR : NegativeR.ap ZeroR
          = OREAL.NegativeZeroOFd
]
[     PositiveOneR : PositiveR.ap OneR
          = OREAL.PositiveOneOFd
]
[     PositiveTwoR : PositiveR.ap TwoR
          = OREAL.PositiveTwoOFd
];

Goal NegOrPosR : {x:el Real} (NegativeR.ap x) \/ (PositiveR.ap x);
  Refine NegOrPosOFd;
Save;

Goal StrNegOrPosR : {x:el Real} (StrNegR.ap x) \/ (PositiveR.ap x);
  Refine StrNegOrPosOFd ? Real_discr;
Save;

Goal StrNegOrZeroOrStrPosR : {x:el Real} or3 (StrNegR.ap x) (Eq x ZeroR) (StrPosR.ap x);
  Refine StrNegOrZeroOrStrPosOFd ? Real_discr;
Save;

Goal PositiveR_antisym : {x|el Real} (PositiveR.ap x) -> (NegativeR.ap x) -> Eq x ZeroR;
  Refine PositiveOFd_antisym;
Save;

Goal LessEqPlusR_compat
          : preserve2 LessEqR.ap2 LessEqR.ap2 LessEqR.ap2 PlusR.ap2;
  Refine LessEqPlusOFd_compat;
Save;

[     PositiveTimesR_compat
          : {x,y|el Real} (PositiveR.ap x) -> (PositiveR.ap y) ->
                          (PositiveR.ap (TimesR.ap2 x y))
          = OREAL.PositiveTimesOFd_compat
]
[     PositivePlusR_compat
          : {x,y|el Real} (PositiveR.ap x) -> (PositiveR.ap y) ->
                          (PositiveR.ap (PlusR.ap2 x y))
          = OREAL.PositivePlusOFd_compat
]
[     PositiveRecipR_compat
          : {x|el Real} (PositiveR.ap x) -> ~(Eq x ZeroR) ->
                        (PositiveR.ap (RecipR.ap x))
          = OREAL.PositiveRecipOFd_compat
]
[     PlusPosR_lemma2
          : {x,y|el Real}
            (PositiveR.ap x) -> (PositiveR.ap y) -> (Eq (PlusR.ap2 x y) ZeroR) ->
            ((Eq x ZeroR) /\ (Eq y ZeroR))
          = OREAL.PlusPosOFd_lemma2
]
[     NegR_antisym : {x|el Real} (Eq x (NegR.ap x)) -> Eq x ZeroR
          = OREAL.NegOFd_antisym
];

Goal PositiveNegR_elim : {x|el Real} (NegativeR.ap x) -> (PositiveR.ap (NegR.ap x));
  Refine [x|el Real] Id|(NegativeR.ap x);
Save;

Goal NegativeNegR_elim : {x|el Real} (PositiveR.ap x) -> (NegativeR.ap (NegR.ap x));
  Refine NegativeNegOFd_elim;
Save;

Goal PositiveSquareR : {x:el Real} (PositiveR.ap (SquareR.ap x));
  Refine SquarePosOFd;
Save;

Goal SquarePosR_lemma1
   : {x,y:el Real} (PositiveR.ap (PlusR.ap2 (SquareR.ap x) (SquareR.ap y)));
  Refine SquarePosOFd_lemma1;
Save;

Goal SquareTimesR
   : {x,y:el Real} Eq (SquareR.ap (TimesR.ap2 x y))
                      (TimesR.ap2 (SquareR.ap x) (SquareR.ap y));
  Refine REAL.SquareTimesFd;
Save;

Goal LessEqR_lemma1 : {x|el Real} (PositiveR.ap x) -> LessEqR.ap2 (NegR.ap x) x;
  Refine LessEqOFd_lemma1;
Save;

Goal LessEqR_lemma2 : {x|el Real} (NegativeR.ap x) -> LessEqR.ap2 x (NegR.ap x);
  Refine LessEqOFd_lemma2;
Save;

Goal LessEqPlusR_lemma1
   : {x,y,z|el Real} (PositiveR.ap z) -> (LessEqR.ap2 x y) ->
                     LessEqR.ap2 x (PlusR.ap2 y z);
  Refine LessEqPlusOFd_lemma1;
Save;

Goal rLessEqTimesR_compat
   : {c,x,y|el Real} (PositiveR.ap c) -> (LessEqR.ap2 x y) ->
                     LessEqR.ap2 (TimesR.ap2 x c) (TimesR.ap2 y c);
  Refine rLessEqTimesOFd_compat;
Save;

Goal lLessEqTimesR_compat
   : {c,x,y|el Real} (PositiveR.ap c) -> (LessEqR.ap2 x y) ->
                     LessEqR.ap2 (TimesR.ap2 c x) (TimesR.ap2 c y);
  Refine lLessEqTimesOFd_compat;
Save;

[     SquareR_inj : {x,y|el Real} (PositiveR.ap x) -> (PositiveR.ap y) ->
                    (Eq (SquareR.ap x) (SquareR.ap y)) -> Eq x y
          = OREAL.SquareOFd_inj Real_discr
]
[     SquareR_lemma2 : {x,y|el Real} (Eq (SquareR.ap x) (SquareR.ap y)) -> 
                                     ((Eq x y) \/ (Eq x (NegR.ap y)))
          = OREAL.SquareOFd_lemma2 Real_discr
]
[
      SquareR_not_zero : {x|el Real} ~(Eq x ZeroR) -> ~(Eq (SquareR.ap x) ZeroR)
          = REAL.SquareFd_not_zero
]
[     PlusSquareR_not_zero : {x,y|el Real}
                     ((~(Eq x ZeroR)) \/ ~((Eq y ZeroR))) ->
                     ~(Eq (PlusR.ap2 (SquareR.ap x) (SquareR.ap y)) ZeroR)
          = OREAL.PlusSquareOFd_not_zero
]
[     PlusSquareR_zero : {x,y|el Real}
                     (Eq (PlusR.ap2 (SquareR.ap x) (SquareR.ap y)) ZeroR) ->
                     ((Eq x ZeroR) /\ (Eq y ZeroR))
          = OREAL.PlusSquareOFd_zero Real_discr
];
