
Module Q Import basic;

(*  Contents
    --------
    o Definition and rules for manipulating Leibniz equality.

    Note
    ----
    o Loading this file causes Qrepl to be configured for Leibniz equality.

*)

[T,S,U | SET];

[     Q : T->T->Prop 
          = [x,y:T] {P:T->Prop} (P x) -> (P y)
] 
[     Q_refl : refl Q
          = [t:T] [P:T->Prop] [h:P t] h
]
[     Q_sym : sym Q
          = [t,u|T] [g:Q t u] g ([x:T]Q x t) (Q_refl t)
]
[     Q_trans : trans Q
          = [t,u,v|T] [p:Q t u] [q:Q u v] [P:T->Prop] compose (q P) (p P)
];

Inductive [Q' : T -> Prop]
Parameters [x : T]
Constructors [Q'_refl : Q' x];
Discharge x;

DischargeKeep T;

[     Q_resp : {f:T->S} respect f Q 
          = [f:T->S] [t,u|T] [h:Q t u] h ([z:T]Q (f t) (f z)) (Q_refl (f t))
]
[     Q_resp2 : {f:T->U->S} respect2 f Q
          = [f:T->U->S] [t,t'|T] [u,u':U] [Eqtt':Q t t'] [Equu':Q u u']
            Eqtt' ([x:T]Q (f t u) (f x u'))
                  (Equu' ([y:U]Q (f t u) (f t y))
                         (Q_refl (f t u)))
];

Goal {x,y|T} (Q x y) -> {P:T->Prop} (P x) -> (P y);
  Intros x y H P H1;
  Refine H P H1;
Save Q_subst;

Goal {x,y|T} (Q' x y) -> Q x y;
  intros;
  Refine Q'_elim x ([y:T][z:Q' x y] Q x y);
  Refine Q_refl;
  Immed;
Save Q'_subst;

Goal sym (Q'|T);
  Intros x y _;
  Refine Q'_subst H ([y:T] Q' y x);
  Refine Q'_refl;
Save Q'_sym;

Goal trans (Q'|T);
  Intros;
  Qrepl Q'_subst H;
  Immed;
Save Q'_trans;

Discharge T;

Configure Qrepl Q Q_subst Q_sym;

[T | SET];

[    substitutive [R : T->T->Prop] : Prop
          = {x,y|T} (R x y) -> Q x y
];

[R | T->T->Prop] [subs : substitutive R];

[    subs_sym [R_refl:reflexive R] : symmetric R
          = [x,y|T] [H:R x y] subs H ([z:T]R z x) x.R_refl
]
[    subs_trans : transitive R
          = [x,y,z:T] [H:R x y] [H1:R y z] subs H1 (R x) H
];

Discharge T;

