
Module PolyR Import Real Poly1;

(* Define polynomials in one variable over the reals. *)

[     MonomialR : Set
          = Monomial1 REAL_Ring
];

Goal CoefMonR : Fun MonomialR Real;
  Refine CoefMon1 REAL_Ring;
Save;

Goal IndexMonR : Fun MonomialR Nat;
  Refine IndexMon1 REAL_Ring;
Save;

Goal MonomialR_intro : Fun2 Real Nat MonomialR;
  Refine Monomial1_intro REAL_Ring;
Save;

[     PolyRingR : Ring
          = PolyRing1 REAL_Ring
]
[     PolyR : Set
          = Poly1 REAL_Ring
];

Goal ZeroPR : el PolyR;
  Refine ZeroPoly1 REAL_Ring;
Save;

Goal OnePR : el PolyR;
  Refine OnePoly1 REAL_Ring;
Save;

Goal CoefR : Fun2 PolyR Nat Real;
  Refine CoefPoly1 REAL_Ring;
Save;

Goal ConstPolyR : Fun Real PolyR;
  Refine ConstPoly1 REAL_Ring;
Save;

Goal IdPolyR : el PolyR;
  Refine IdPoly1 REAL_Ring;
Save;

Goal PlusPR : Fun2 PolyR PolyR PolyR;
  Refine PlusPoly1 REAL_Ring;
Save;

Goal NegPR : Fun PolyR PolyR;
  Refine NegPoly1 REAL_Ring;
Save;

Goal TimesPR : Fun2 PolyR PolyR PolyR;
  Refine TimesPoly1 REAL_Ring;
Save;

Goal PowerPR : Fun2 PolyR Nat PolyR;
  Refine PowerPoly1 REAL_Ring;
Save;

(* --------------------------------------------------------------------------------
   Define the notion of application.
*)

Goal apPR : PolyR.el -> op Real.el;
  Refine apP1 REAL_Ring;
Save;

Goal {c,x:el Real} Eq (apPR (ConstPolyR.ap c) x) c;
  Refine apP1_const REAL_Ring;
Save apPR_const;

Goal {x:el Real} Eq (apPR IdPolyR x) x;
  Refine apP1_id REAL_Ring;
Save apPR_id;

Goal {f,g:el PolyR} {x:el Real}
     Eq (apPR (PlusPR.ap2 f g) x) (PlusR.ap2 (apPR f x) (apPR g x));
  Refine apP1_plus REAL_Ring;
Save apPR_plus;

Goal {f,g:el PolyR}{x:el Real}
     Eq (apPR (TimesPR.ap2 f g) x) (TimesR.ap2 (apPR f x) (apPR g x));
  Refine apP1_times REAL_Ring TimesR_commut;
Save apPR_times;

Goal {f:el PolyR}{n:el Nat}{x:el Real}
     Eq (apPR (PowerPR.ap2 f n) x) (PowerR.ap2 (apPR f x) n);
  Refine apP1_power REAL_Ring TimesR_commut;
Save apPR_power;

(* --------------------------------------------------------------------------------
   Define the notion f degree of a real polynomial.
*)

Goal DegreeR : Fun PolyR Nat;
  Refine DegreeP1 REAL_Ring Real_discr;
Save;

Goal degreeR' : PolyR.el -> PolyR.el -> Nat.el;
  Refine degreeP' NatIMonoid REAL_Ring Real_discr;
Save;

Goal {f,g|el PolyR} (Eq (DegreeR.ap f) ZeroN) ->
                    Eq (DegreeR.ap (PlusPR.ap2 f g)) (DegreeR.ap g);
  Refine DegreePlusP_lemma1 NatIMonoid REAL_Ring Real_discr;
Save DegreePlusPR_lemma1;

Goal {f,g|el PolyR} (Eq (DegreeR.ap g) ZeroN) ->
                    Eq (DegreeR.ap (PlusPR.ap2 f g)) (DegreeR.ap f);
  Refine DegreePlusP_lemma2 NatIMonoid REAL_Ring Real_discr;
Save DegreePlusPR_lemma2;

