
Module Nat_div Import Nat_order;

(* --------------------------------------------------------------------------------
   Define `divides x y' and the dual `not divides x y'.
*)

[     divides [a,b:el Nat]: Prop
          = Ex [x:el Nat] Eq (TimesN.ap2 a x) b
]
[     not_divides [a,b:el Nat] : Prop
          = {x:el Nat} ~(Eq (TimesN.ap2 a x) b)
];

Goal divides_refl : reflexive divides;
  Intros x; exI ?; Refine OneN; Refine snd OneN_ident;
Save;

Goal divides_antisym : antisymmetric (Eq|Nat) divides;
  Intros x y __; exE H; exE H1; Intros a _ b _;
  orE (TimesN_cancel y|(timesN a b)|OneN ?);
  Refine Eq_trans (timesN (timesN y a) b); Refine TimesN_assoc;
  Qrepl H2; Refine H3;
  intros; Qrepl H2.Eq_sym; Qrepl H4; Refine TimesN_axiom_1;
  intros;
  andE TimesN_OneN ? ? H4; Equiv Eq x (TimesN.ap2 y OneN);
  Qrepl H2.Eq_sym; Qrepl H5; Refine Eq_refl;
Save;

Goal divides_trans : transitive divides;
  Intros x y z __;
  exE H; exE H1; Intros a _ b _;
  exI ?; Refine timesN b a;
  Refine Eq_trans (timesN (timesN x b) a); Refine TimesN_assoc;
  Qrepl H3; Qrepl H2; Refine Eq_refl;
Save;

Goal divides_lemma_1 : {x,y:el Nat} (divides x y) -> or (LessEqN.ap2 x y) (Eq y ZeroN);
  intros; exE H; intros a _; orE LessN_part_zero a;
  intros; orIR;
    Qrepl H1.Eq_sym; Qrepl H2; Refine Eq_refl;
  intros; orIL;
    Refine extenRel LessEqN; Refine timesN x OneN; Refine +1 timesN x a;
      Refine Eq_refl; Refine H1;
    Refine Times_pres_LessEqN; Refine LessEqN_refl;
    Refine LessN_elim_succ H2;
Save;

Goal divides_lemma_2
   : {x,y,z:el Nat} (divides z (PlusN.ap2 x y)) -> (divides z x) -> divides z y;
  intros;
  exE H; exE H1; intros b _ a _;
  Refine LessEqN_Ex_total a b;
  intros; exE H4; intros c _;
    exI ?; Refine ZeroN;
    Refine PlusN_ZeroN (timesN z c) y; intros +1; Refine H7.Eq_sym;
    Refine lPlusN_cancel (TimesN.ap2 z a);
    Refine Eq_trans (PlusN.ap2 (PlusN.ap2 (TimesN.ap2 z a) (TimesN.ap2 z c)) y);
      Refine PlusN_assoc;
    Qrepl (lTimesPlusN_distrib z a c).Eq_sym;
    Qrepl H5; Qrepl H2; Refine H3.Eq_sym;
  intros; exE H4; intros c _;
    exI ?; Refine c;
    Refine lPlusN_cancel x;
    Qrepl H3.Eq_sym; Qrepl H5.Eq_sym; Qrepl H2.Eq_sym;
    Refine Eq_sym; Refine lTimesPlusN_distrib;
Save;

Goal divides_lemma_3 : {x,y|el Nat} (divides x y) -> (divides x (succ y)) -> Eq x OneN;
  intros;
  exE divides_lemma_2 ? OneN ? H1 H;
  intros; Refine fst (TimesN_OneN ? ? ?);
  Immed;
Save;

Goal divides_plusN
   : {x,y,z|el Nat} (divides z x) -> (divides z y) -> divides z (PlusN.ap2 x y);
  intros; exE H; exE H1; intros b _ a _; exI ?; Refine PlusN.ap2 a b;
  Refine Eq_trans (PlusN.ap2 (TimesN.ap2 z a) (TimesN.ap2 z b));
  Refine lTimesPlusN_distrib;
  Refine exten2; Immed;
Save;

Goal divides_timesN
   : {x,y,z|el Nat} ((divides z x) \/ (divides z y)) -> divides z (TimesN.ap2 x y);
  intros; orE H;
  intros; exE H1; intros a _; exI ?; Refine timesN a y;
    Refine Eq_trans (timesN (timesN z a) y); Refine TimesN_assoc;
    Qrepl H2; Refine Eq_refl;
  intros; exE H1; intros a _; exI ?; Refine timesN a x;
    Refine Eq_trans (timesN (timesN z a) x); Refine TimesN_assoc;
    Qrepl H2; Refine TimesN_commut;
Save;

(* --------------------------------------------------------------------------------
   Construct a division algorithm.
*)

Goal division : {x,y:el Nat} (LessN.ap2 ZeroN y) ->
            Ex2 [q,r:el Nat] and (Eq x (PlusN.ap2 (TimesN.ap2 q y) r)) (LessN.ap2 r y);
  Refine CourseValueInduction [x:el Nat] {y:el Nat} (LessN.ap2 ZeroN y) ->
                     Ex2 [q,r:el Nat] and (Eq x (plusN (timesN q y) r)) (LessN.ap2 r y);
  intros x ih y _; Refine LessN_partit x y;
  intros; 
    Refine Ex2Intro; Refine ZeroN; Refine x;
    andI;
      Qrepl TimesN_axiom_1 y; Refine (lZeroN_ident x).Eq_sym;
      Refine H1;
  intros;
    Refine Ex2Intro; Refine OneN; Refine ZeroN;
    andI; Qrepl OneN_ident.fst y; Immed;
  intros;
    exE LessEqN_Ex_intro|y|x; Refine H1.snd;
    intros z _;
    Refine ih z ? y H;
    Refine  H2 (LessN.ap2 z);
      Refine extenRel LessN ?.lZeroN_ident ?.Eq_refl;
      Refine rPlus_pres_LessN H;
    intros q r _; andE H3; Refine Ex2Intro; Refine succ q; Refine r; andI;
    Qrepl H2.Eq_sym; Qrepl H4;
    Refine Eq_trans (PlusN.ap2 (PlusN.ap2 y (TimesN.ap2 q y)) r);
      Refine PlusN_assoc;
    Refine exten2 ? ? ?.Eq_refl;
    Qrepl (TimesN_axiom_2 q y); Refine PlusN_commut;
    Refine H5;
Save;

(*
   Prove the existance of a greatest common divisor and show its uniqueness.
*)

[     IsGCD [x,y,z:el Nat] : Prop
          = and3 (divides z x)
                 (divides z y)
                 ({z':el Nat} (divides z' x) -> (divides z' y) -> divides z' z)
];

Goal GCD : {x,y:el Nat} Ex [z:el Nat] IsGCD x y z;
  Refine CourseValueInduction ([x:nat] {y:nat} Ex ([z:nat]IsGCD x y z));
  intros x ih y; orE LessEqN_partit x y;
  intros; orE LessN_part_zero x;
  intros;
    exI ?; Refine y; Refine pair3;
    Qrepl H1; exI ?; Refine ZeroN; Refine Eq_refl;
    Refine divides_refl;
    intros; Immed;
  intros;
    Refine division y x H1; intros q r _; andE H2;
    exE (ih r H4 x); intros z _; Refine H5; intros;
    exI ?; Refine z; Refine pair3;
    Refine H7;
    Qrepl H3; Refine divides_plusN; Refine divides_timesN; orIR; Immed;
    intros; Refine H8; Refine divides_lemma_2 (timesN q x);
      Qrepl H3.Eq_sym; Refine +1 divides_timesN; orIR +1; Immed;
  intros;
    exE (ih y H x); intros z _; Refine H1; intros;
    exI ?; Refine z; Refine pair3; Immed; intros; Refine H4; Immed;
Save;

Goal GCD_unique : {x,y,z,z':el Nat} (IsGCD x y z) -> (IsGCD x y z') -> Eq z z';
  intros; Refine H; Refine H1; intros;
  Refine divides_antisym;
  Refine H4 ? H5 H6; Refine H7 ? H2 H3;
Save;

Goal divides_decidable : {a,b:el Nat} or (divides a b) (not_divides a b);
  intros x y;
  exE GCD x y; intros a _; Refine H; intros;
  orE Nat_discr a x;
  intros; orIL; Qrepl H4.Eq_sym; Refine H2;
  intros; orIR; Intros z; notI; notE H4; Refine divides_antisym;
    Immed; Refine H3; Refine divides_refl; exI ?; Immed;
Save;

Goal divides_exclusive : {a,b|el Nat} (divides a b) -> (not_divides a b) -> absurd;
  intros; Refine H;
  intros x _; Refine H1 x;
  Refine H2;
Save;

Goal divides_dec : decidable_rel divides;
  Intros a b;
  orE divides_decidable a b;
  Refine inl;
  intros; Refine inr;
  Intros _; Refine divides_exclusive H1 H;
Save;

(* --------------------------------------------------------------------------------
   Introduce factorial x!
*)

[     fac : Nat.el -> Nat.el
          = nat_rec OneN ([n,ih:nat]TimesN.ap2 ih (Succ.ap n))
]
[     Fac : Fun Nat Nat
          = QFun fac
];

Goal le_one_fac : {x:el Nat} LessEqN.ap2 OneN (fac x);
  Refine nat_ind [x:nat] LessEqN.ap2 OneN (fac x);
  Refine trueprf;
  intros; Refine LessEqN_trans; Refine fac n; Immed;
  Equiv LessEqN.ap2 (timesN (fac n) OneN) (timesN (fac n) (succ n));
  Refine Times_pres_LessEqN; Refine LessEqN_refl; Refine trueprf;
Save;

Goal fac_divides
   : {x,y|el Nat} (LessEqN.ap2 OneN x) -> (LessEqN.ap2 x y) -> divides x (fac y);
  intros _;
  Refine nat_ind [y:nat] (LessEqN.ap2 OneN x)->(LessEqN.ap2 x y)->divides x (fac y);
  intros; exI ?; Refine ZeroN;
    Refine Succ_not_zero ? (LessEqN_zero (LessEqN_trans ? H H1));
  intros; orE Nat_discr x (succ n);
    intros; exI ?; Refine fac n;
    Qrepl H2;
    Refine TimesN_commut;
  intros; exE ih; Refine H;
    Refine LessEqN_intro_succ; Refine pair H2 H1;
  intros y _; exI ?; Refine timesN y (succ n);
    Refine Eq_trans (timesN (timesN x y) (succ n)); Refine TimesN_assoc;
    Refine exten2 TimesN; Immed; Refine Eq_refl;
Save;

