
Module Field_order Import Order Field;

[     sigOFd : Signature
          = Signature_intro (SixSET_iter ZeroN    (* a constant *)
                                         ZeroN    (* a constant *)
                                         OneN     (* a unary function *)
                                         OneN     (* a unary function *)
                                         TwoN     (* a binary function *)
                                         TwoN     (* a binary function *)
                            )
                            (UnitSET_iter OneN)   (* a predicate *)
];

Goal axiomsOFd : Axioms sigOFd;
  Refine Axioms_intro;
  Intros A IC IP;
  Zero  == (IC star61).apn : el A;
  One   == (IC star62).apn : el A;
  Neg   == IC star63       : Fun A A;
  Recip == IC star64       : Fun A A;
  Plus  == IC star65       : Fun2 A A A;
  Times == IC star66       : Fun2 A A A;
  Pos   == IP star         : Pred A;
  Refine and (and9 (Associative Plus)
                   (Commutative Plus)
                   (Identity Plus Zero)
                   (Inverse Plus Zero Neg)
                   (Associative Times)
                   (Commutative Times)
                   (Identity Times One)
                   (MultInverse Times Zero One Recip)
                   (Distributive Plus Times))
             (and4 ({x:el A} (Pos.ap (Neg.ap x)) \/ (Pos.ap x))
                   ({x|el A} (Pos.ap x) -> (Pos.ap (Neg.ap x)) -> Eq x Zero)
                   ({x,y|el A} (Pos.ap x) -> (Pos.ap y) -> Pos.ap (Plus.ap2 x y))
                   ({x,y|el A} (Pos.ap x) -> (Pos.ap y) -> Pos.ap (Times.ap2 x y)));
Save;

[OrderedField = Model axiomsOFd];

Goal OrderedField_intro
   : {A|Set}{Plus,Times|Fun2 A A A}{Neg,Recip|Fun A A}{Zero,One|el A}{Pos|Pred A}
     {Plus_assoc   : Associative Plus}    {Plus_commut  : Commutative Plus}
     {rZero_ident  : rIdentity Plus Zero} {rNeg_invers  : rInverse Plus Zero Neg}
     {Times_assoc  : Associative Times}   {Times_commut : Commutative Times}
     {rOne_ident   : rIdentity Times One}
     {Recip_invers : MultInverse Times Zero One Recip}
     {rPlus_Times_distrib : rDistributive Plus Times}
     {Pos_total    : {x:el A} (Pos.ap (Neg.ap x)) \/ (Pos.ap x)}
     {Pos_antisym  : {x|el A} (Pos.ap x) -> (Pos.ap (Neg.ap x)) -> Eq x Zero}
     {Pos_plus     : {x,y|el A} (Pos.ap x) -> (Pos.ap y) -> Pos.ap (Plus.ap2 x y)}
     {Pos_times    : {x,y|el A} (Pos.ap x) -> (Pos.ap y) -> Pos.ap (Times.ap2 x y)}
     OrderedField;
  intros;
  Refine Model_intro;
  Refine A;
  Refine SixSET_elim [c:FuncSymb sigOFd] nFunc A (FuncArity c);
  Refine constant Zero;
  Refine constant One;
  Refine Neg;
  Refine Recip;
  Refine Plus;
  Refine Times;
  Refine UnitSET_elim [c:PredSymb sigOFd] nPred A (PredArity c);
  Refine Pos;
  Refine pair;
  Refine pair9 Plus_assoc Plus_commut
               (Identity_intro Plus_commut rZero_ident)
               (Inverse_intro Plus_commut rNeg_invers)
               Times_assoc Times_commut
               (Identity_intro Times_commut rOne_ident) Recip_invers
               (Distributive_intro Times_commut rPlus_Times_distrib);
  Refine pair4 Pos_total Pos_antisym Pos_plus Pos_times;
Save;

(* --------------------------------------------------------------------------------
   Let F be an ordered field. Define functions to extract all components of F
   and some lemma's we know from fields.
*)

[F : OrderedField];

  [ZeroOFd        : obj F                    = intCons F star61]
  [OneOFd         : obj F                    = intCons F star62]
  [NegOFd         : UFunMdl F                = intFunc F star63]
  [RecipOFd       : UFunMdl F                = intFunc F star64]
  [PlusOFd        : BFunMdl F                = intFunc F star65]
  [TimesOFd       : BFunMdl F                = intFunc F star66]
  [PositiveOFd    : PredMdl F                = intPred F star  ];

  [     PlusOFd_assoc : Associative PlusOFd
            = and9_out1 F.axioms.fst
  ]
  [     PlusOFd_commut : Commutative PlusOFd
            = and9_out2 F.axioms.fst
  ]
  [     ZeroOFd_ident : Identity PlusOFd ZeroOFd
            = and9_out3 F.axioms.fst
  ]
  [     NegOFd_invers : Inverse PlusOFd ZeroOFd NegOFd
            = and9_out4 F.axioms.fst
  ]
  [     TimesOFd_assoc : Associative TimesOFd
            = and9_out5 F.axioms.fst
  ]
  [     TimesOFd_commut : Commutative TimesOFd
            = and9_out6 F.axioms.fst
  ]
  [     OneOFd_ident : Identity TimesOFd OneOFd
            = and9_out7 F.axioms.fst
  ]
  [     RecipOFd_invers : MultInverse TimesOFd ZeroOFd OneOFd RecipOFd
            = and9_out8 F.axioms.fst
  ]
  [     TimesPlusOFd_distrib : Distributive PlusOFd TimesOFd
            = and9_out9 F.axioms.fst
  ];

  Goal NegativeOFd : Pred F.car;
    Refine Pred_intro;
    Refine [x:obj F] PositiveOFd.ap (NegOFd.ap x);
    Intros ___; Refine extenPred; Refine exten; Refine H;
  Save;

  [     NegOrPosOFd
            : {x:obj F} (NegativeOFd.ap x) \/ (PositiveOFd.ap x)
            = and4_out1 F.axioms.snd
  ]
  [     PositiveOFd_antisym
            : {x|obj F} (PositiveOFd.ap x) -> (NegativeOFd.ap x) -> Eq x ZeroOFd
            = and4_out2 F.axioms.snd
  ]
  [     PositivePlusOFd_compat
            : {x,y|obj F} (PositiveOFd.ap x) -> (PositiveOFd.ap y) ->
                          (PositiveOFd.ap (PlusOFd.ap2 x y))
            = and4_out3 F.axioms.snd
  ]
  [     PositiveTimesOFd_compat
            : {x,y|obj F} (PositiveOFd.ap x) -> (PositiveOFd.ap y) ->
                          (PositiveOFd.ap (TimesOFd.ap2 x y))
            = and4_out4 F.axioms.snd
  ];

Freeze ZeroOFd OneOFd NegOFd NegOFd RecipOFd PlusOFd TimesOFd PositiveOFd;

  [rZeroOFd_ident        : rIdentity PlusOFd ZeroOFd       = snd ZeroOFd_ident       ]
  [lZeroOFd_ident        : lIdentity PlusOFd ZeroOFd       = fst ZeroOFd_ident       ]
  [rNegOFd_invers        : rInverse PlusOFd ZeroOFd NegOFd = snd NegOFd_invers       ]
  [lNegOFd_invers        : lInverse PlusOFd ZeroOFd NegOFd = fst NegOFd_invers       ]
  [rOneOFd_ident         : rIdentity TimesOFd OneOFd       = snd OneOFd_ident        ]
  [lOneOFd_ident         : lIdentity TimesOFd OneOFd       = fst OneOFd_ident        ]
  [rTimesPlusOFd_distrib : rDistributive PlusOFd TimesOFd  = snd TimesPlusOFd_distrib]
  [lTimesPlusOFd_distrib : lDistributive PlusOFd TimesOFd  = fst TimesPlusOFd_distrib];

  [     FieldOFd : Field
            = Field_intro PlusOFd_assoc PlusOFd_commut rZeroOFd_ident rNegOFd_invers
                          TimesOFd_assoc TimesOFd_commut rOneOFd_ident RecipOFd_invers
                          rTimesPlusOFd_distrib
  ];

  [     MinusOFd : BFunMdl F
            = FieldOFd.MinusFd
  ]
  [     NegOneOFd : obj F
            = FieldOFd.NegOneFd
  ]
  [     TwoOFd : obj F
            = FieldOFd.TwoFd
  ]
  [     DoubleOFd : UFunMdl F
            = FieldOFd.DoubleFd
  ]
  [     SquareOFd : UFunMdl F
            = FieldOFd.SquareFd
  ]
  [     DivOFd : BFunMdl F
            = FieldOFd.DivFd
  ]
  [     PowerOFd  : Fun2 F.car Nat F.car
            = FieldOFd.PowerFd
  ];

  [     NegZeroOFd : Eq (NegOFd.ap ZeroOFd) ZeroOFd
            = FieldOFd.NegZeroFd
  ]
  [     NegOFd_invol : Involutive NegOFd
            = FieldOFd.NegFd_invol
  ]
  [     rRecipOFd_invers
            : {x|obj F} ~(Eq x ZeroOFd) -> (Eq (TimesOFd.ap2 x (RecipOFd.ap x)) OneOFd)
            = FieldOFd.rRecipFd_invers
  ]
  [     lRecipOFd_invers
            : {x|obj F} ~(Eq x ZeroOFd) -> (Eq (TimesOFd.ap2 (RecipOFd.ap x) x) OneOFd)
            = FieldOFd.lRecipFd_invers
  ]
  [     PlusOFd_cancel : Cancelation PlusOFd
            = FieldOFd.PlusFd_cancel
  ]
  [     rPlusOFd_cancel : rCancelation PlusOFd
            = FieldOFd.rPlusFd_cancel
  ]
  [     lPlusOFd_cancel : lCancelation PlusOFd
            = FieldOFd.lPlusFd_cancel
  ];

(* -------------------------------------------------------------------------------- *)

  Goal StrPosOFd : Pred F.car;
    Refine Pred_intro;
    Refine [x:obj F] (PositiveOFd.ap x) /\ ~(Eq x ZeroOFd);
    Intros ____; Refine pair;
    Refine extenPred PositiveOFd H H1.fst;
    Intros _; Refine H1.snd; Refine Eq_trans x' H H2;
  Save;

  Goal StrNegOFd : Pred F.car;
    Refine Pred_intro;
    Refine [x:obj F] (NegativeOFd.ap x) /\ ~(Eq x ZeroOFd);
    Intros ____; Refine pair;
    Refine extenPred NegativeOFd H H1.fst;
    Intros _; Refine H1.snd; Refine Eq_trans x' H H2;
  Save;

  Goal NegativeNegOFd_elim
     : {x|obj F} (PositiveOFd.ap x) -> (NegativeOFd.ap (NegOFd.ap x));
    intros;
    Refine extenPred PositiveOFd ? H;
    Refine Eq_sym; Refine NegOFd_invol;
  Save;

  Goal PositiveNegOFd_elim
     : {x|obj F} (NegativeOFd.ap x) -> (PositiveOFd.ap (NegOFd.ap x));
    intros _;
    Refine Id;
  Save;

  Goal NegOFd_antisym : {x|obj F} (Eq x (NegOFd.ap x)) -> Eq x ZeroOFd;
    intros;
    orE NegOrPosOFd x;
    intros; Refine PositiveOFd_antisym ? H1; Refine extenPred ? H.Eq_sym H1;
    intros; Refine PositiveOFd_antisym H1; Refine extenPred ? H H1;
  Save;

  Goal SquarePosOFd : {x:obj F} (PositiveOFd.ap (SquareOFd.ap x));
    intros;
    orE NegOrPosOFd x;
    intros; Refine extenPred; Refine +2 PositiveTimesOFd_compat H H;
    Refine FieldOFd.TimesNegFd_distrib;
    intros; Refine PositiveTimesOFd_compat H H;
  Save;

  Goal PositiveZeroOFd : PositiveOFd.ap ZeroOFd;
    Refine extenPred;
    Refine +1 FieldOFd.lTimesZeroFd;
    Refine +1 SquarePosOFd;
  Save;

  Goal NegativeZeroOFd : NegativeOFd.ap ZeroOFd;
    Refine extenPred PositiveOFd;
    Refine +1 Eq_sym; Refine +1 NegZeroOFd;
    Refine PositiveZeroOFd;
  Save;

  Goal PositiveOneOFd : PositiveOFd.ap OneOFd;
    Refine extenPred;
    Refine +1 lOneOFd_ident;
    Refine SquarePosOFd;
  Save;

  Goal PositiveTwoOFd : PositiveOFd.ap TwoOFd;
    Refine PositivePlusOFd_compat;
    Refine ?+1; Refine PositiveOneOFd;
  Save;

  Goal ~(Eq TwoOFd ZeroOFd);
    Intros _;
    Refine FieldOFd.OneFd_not_zero;
    Refine PositiveOFd_antisym;
    Refine PositiveOneOFd;
    Refine extenPred; Refine NegOFd.ap OneOFd;
    Refine +1 NegativeNegOFd_elim; Refine +1 PositiveOneOFd;
    Refine lPlusOFd_cancel OneOFd;
    Refine Eq_trans ZeroOFd; Refine rNegOFd_invers;
    Refine Eq_sym H;
  Save TwoOFd_not_zero;

  Goal StrNegOrZeroOrStrPosOFd
     : (Discrete F.car) ->
       {x:obj F} or3 (StrNegOFd.ap x) (Eq x ZeroOFd) (StrPosOFd.ap x);
    intros; orE H x ZeroOFd;
    Refine or3_in2;
    intros; orE NegOrPosOFd x;
    intros; Refine or3_in1; Refine pair H2 H1;
    intros; Refine or3_in3; Refine pair H2 H1;
  Save;

  Goal StrNegOrPosOFd
     : (Discrete F.car) -> {x:obj F} (StrNegOFd.ap x) \/ (PositiveOFd.ap x);
    intros; Refine StrNegOrZeroOrStrPosOFd H x;
    Refine inl;
    intros; Refine inr;
      Refine extenPred PositiveOFd H1.Eq_sym; Refine PositiveZeroOFd;
    intros; Refine inr; Refine fst H1;
  Save;

  Goal SquarePosOFd_lemma1
     : {x,y:obj F}
       (PositiveOFd.ap (PlusOFd.ap2 (SquareOFd.ap x) (SquareOFd.ap y)));
    Intros;
    Refine PositivePlusOFd_compat;
    Refine SquarePosOFd;
    Refine SquarePosOFd;
  Save;

  Goal PositiveRecipOFd_compat
     : {x|obj F} (PositiveOFd.ap x) -> ~(Eq x ZeroOFd) ->
                 (PositiveOFd.ap (RecipOFd.ap x));
    intros;
    orE NegOrPosOFd (RecipOFd.ap x);
    intros;
    Refine FieldOFd.Field_non_trivial;
    Refine Eq_sym; Refine PositiveOFd_antisym; Refine PositiveOneOFd;
    Refine extenPred PositiveOFd;
      Refine (TimesOFd.ap2 x (NegOFd.ap (RecipOFd.ap x)));
    Refine +1 PositiveTimesOFd_compat H H2;
    Refine Eq_trans (NegOFd.ap (DivOFd.ap2 x x));
      Refine FieldOFd.rTimesNegFd_distrib;
    Refine exten; Refine FieldOFd.rRecipFd_invers H1;
    Refine Id;
  Save;

(* --------------------------------------------------------------------------------
   Define the LessEq relation for ordered fields and prove some properties.
*)

  Goal LessEqOFd : BRelMdl F;
    Refine Rel_intro;
    Refine [x,y:obj F] PositiveOFd.ap (MinusOFd.ap2 y x);
    Intros ______; Refine extenPred; Refine exten2; Immed;
  Save;

  Goal LessEqOFd_trans : Transitive LessEqOFd;
    Intros t u v __;
    Refine extenPred; Refine (PlusOFd.ap2 (MinusOFd.ap2 v u) (MinusOFd.ap2 u t));
    Refine +1 PositivePlusOFd_compat H1 H;
    Refine Eq_trans (PlusOFd.ap2 v (PlusOFd.ap2 (NegOFd.ap u) (MinusOFd.ap2 u t)));
      Refine Eq_sym; Refine PlusOFd_assoc;
    Refine exten2 ? ?.Eq_refl;
    Refine Eq_trans (MinusOFd.ap2 (PlusOFd.ap2 (NegOFd.ap u) u) t);
      Refine PlusOFd_assoc;
    Refine Eq_trans (MinusOFd.ap2 ZeroOFd t);
      Refine exten2 ? ? ?.Eq_refl; Refine lNegOFd_invers;
    Refine lZeroOFd_ident;
  Save;

  Goal LessEqOFd_antisym : AntiSymmetric LessEqOFd;
    Intros t u __;
    Refine rPlusOFd_cancel (NegOFd.ap t);
    Refine Eq_trans ZeroOFd; Refine rNegOFd_invers;
    Refine Eq_sym; Refine PositiveOFd_antisym H;
    Refine extenPred ? ? H1;
    Refine Eq_trans (PlusOFd.ap2 (NegOFd.ap u) (NegOFd.ap (NegOFd.ap t)));
      Refine +1 FieldOFd.PlusNegFd_distrib;
    Refine Eq_trans (PlusOFd.ap2 (NegOFd.ap u) t); Refine PlusOFd_commut;
    Refine exten2 ? ?.Eq_refl;
    Refine Eq_sym; Refine NegOFd_invol;
  Save;

  Goal LessEqOFd_total : Total LessEqOFd;
    Intros x y;
    orE NegOrPosOFd (MinusOFd.ap2 y x);
    intros; Refine inr;
    Refine extenPred PositiveOFd ? H;
    Refine Eq_trans (PlusOFd.ap2 (NegOFd.ap y) (NegOFd.ap (NegOFd.ap x)));
      Refine Eq_sym; Refine FieldOFd.PlusNegFd_distrib;
    Refine Eq_trans (PlusOFd.ap2 (NegOFd.ap (NegOFd.ap x)) (NegOFd.ap y));
      Refine PlusOFd_commut;
    Refine exten2 ? ? ?.Eq_refl; Refine NegOFd_invol;
    Refine inl;
  Save;

  Goal LessEqOFd_refl : Reflexive LessEqOFd;
    Refine LessEq_tot_refl LessEqOFd_total;
  Save;

  Goal LessEqPlusOFd_compat
     : preserve2 LessEqOFd.ap2 LessEqOFd.ap2 LessEqOFd.ap2 PlusOFd.ap2;
    Intros; [mx = NegOFd.ap x] [mxy = NegOFd.ap (PlusOFd.ap2 x y)];
    Refine extenPred; Refine +2 PositivePlusOFd_compat H H1;
    Refine Eq_trans (PlusOFd.ap2 x' (PlusOFd.ap2 mx (MinusOFd.ap2 y' y)));
      Refine Eq_sym; Refine PlusOFd_assoc;
    Refine Eq_trans (PlusOFd.ap2 x' (MinusOFd.ap2 y' (PlusOFd.ap2 x y)));
    Refine exten2 ? ?.Eq_refl; Refine +1 PlusOFd_assoc;
    Refine Eq_trans (MinusOFd.ap2 (PlusOFd.ap2 mx y') y);
      Refine PlusOFd_assoc;
    Refine Eq_trans (MinusOFd.ap2 (MinusOFd.ap2 y' x) y);
      Refine exten2 ? ? ?.Eq_refl; Refine PlusOFd_commut;
    Refine Eq_trans (PlusOFd.ap2 y' (MinusOFd.ap2 mx y));
      Refine Eq_sym; Refine PlusOFd_assoc;
    Refine exten2 ? ?.Eq_refl; Refine FieldOFd.PlusNegFd_distrib;
  Save;

  Goal PosLessEqOFd : ({x|obj F} (PositiveOFd.ap x) -> LessEqOFd.ap2 ZeroOFd x) /\
                      ({x|obj F} (LessEqOFd.ap2 ZeroOFd x) -> PositiveOFd.ap x);
    Refine pair;
    intros; Refine extenPred PositiveOFd ? H;
      Refine Eq_trans (PlusOFd.ap2 x ZeroOFd);
      Refine Eq_sym; Refine rZeroOFd_ident;
      Refine exten2 ? ?.Eq_refl; Refine Eq_sym; Refine NegZeroOFd;
    intros; Refine extenPred PositiveOFd ? H;
      Refine Eq_trans (PlusOFd.ap2 x ZeroOFd);
      Refine exten2 PlusOFd ?.Eq_refl; Refine NegZeroOFd; Refine rZeroOFd_ident;
  Save;

  Goal NegLessEqOFd : ({x|obj F} (NegativeOFd.ap x) -> LessEqOFd.ap2 x ZeroOFd) /\
                      ({x|obj F} (LessEqOFd.ap2 x ZeroOFd) -> NegativeOFd.ap x);
    Refine pair;
    intros; Refine extenPred PositiveOFd ? H; Refine Eq_sym; Refine lZeroOFd_ident;
    intros; Refine extenPred PositiveOFd ? H; Refine lZeroOFd_ident;
  Save;

  Goal LessEqOFd_total_order : TotallyOrdered LessEqOFd;
    Refine TotallyOrdered_intro LessEqOFd_antisym LessEqOFd_trans LessEqOFd_total;
  Save;

  Goal {x|obj F} (PositiveOFd.ap x) -> LessEqOFd.ap2 (NegOFd.ap x) x;
    intros;
    Refine extenPred PositiveOFd; Refine PlusOFd.ap2 x x;
    Refine exten2 PlusOFd ?.Eq_refl;
    Refine Eq_sym; Refine NegOFd_invol;
    Refine PositivePlusOFd_compat H H;
  Save LessEqOFd_lemma1;

  Goal {x|obj F} (NegativeOFd.ap x) -> LessEqOFd.ap2 x (NegOFd.ap x);
    intros;
    Refine extenRel ? ?.(NegOFd_invol) ?.Eq_refl;
    Refine LessEqOFd_lemma1 H;
  Save LessEqOFd_lemma2;

  Goal {x,y,z|obj F} (PositiveOFd.ap z) ->
                        (LessEqOFd.ap2 x y) -> LessEqOFd.ap2 x (PlusOFd.ap2 y z);
    intros;
    Refine extenRel ? ? ?.Eq_refl; Refine +1 rZeroOFd_ident x;
    Refine LessEqPlusOFd_compat H1;
    Refine extenPred PositiveOFd ? H;
    Refine Eq_sym; Refine FieldOFd.rNegZeroFd_ident;
  Save LessEqPlusOFd_lemma1;

  Goal {c,x,y|obj F} (PositiveOFd.ap c) ->
       (LessEqOFd.ap2 x y) -> LessEqOFd.ap2 (TimesOFd.ap2 x c) (TimesOFd.ap2 y c);
    intros;
    Refine extenPred PositiveOFd; Refine +1 FieldOFd.rTimesMinusFd_distrib;
    Refine PositiveTimesOFd_compat H1 H;
  Save rLessEqTimesOFd_compat;

  Goal {c,x,y|obj F} (PositiveOFd.ap c) ->
       (LessEqOFd.ap2 x y) -> LessEqOFd.ap2 (TimesOFd.ap2 c x) (TimesOFd.ap2 c y);
    intros;
    Refine extenPred PositiveOFd; Refine +1 FieldOFd.lTimesMinusFd_distrib;
    Refine PositiveTimesOFd_compat H H1;
  Save lLessEqTimesOFd_compat;

(* --------------------------------------------------------------------------------
   Miscellaneous.
*)

  Goal PlusPosOFd_lemma2 : {x,y|obj F}
      (PositiveOFd.ap x) -> (PositiveOFd.ap y) -> (Eq (PlusOFd.ap2 x y) ZeroOFd) ->
      ((Eq x ZeroOFd) /\ (Eq y ZeroOFd));
    intros;
    Claim {x,y:obj F} (PositiveOFd.ap x) -> (PositiveOFd.ap y) ->
                      (Eq (PlusOFd.ap2 x y) ZeroOFd) -> (Eq x ZeroOFd);
    Refine pair; Refine ?15; Immed; Refine ?15 y x; Immed;
    Refine Eq_trans (PlusOFd.ap2 x y); Refine PlusOFd_commut; Immed;

    intros a b Pos_a Pos_b z;
    Refine PositiveOFd_antisym Pos_a;
    Refine NegLessEqOFd.snd;

    Refine extenRel ? ? z; Refine +1 rZeroOFd_ident;
    Refine LessEqPlusOFd_compat ?.LessEqOFd_refl; Refine PosLessEqOFd.fst Pos_b;
  Save;

  Goal {x:obj F} Eq (DivOFd.ap2 (DoubleOFd.ap x) TwoOFd) x;
    intros;
    Refine Eq_trans (DivOFd.ap2 (TimesOFd.ap2 x TwoOFd) TwoOFd);
      Refine exten2 DivOFd ? ?.Eq_refl;
      Refine Eq_trans (TimesOFd.ap2 TwoOFd x);
      Refine FieldOFd.TwoFd_lemma1; Refine TimesOFd_commut;
    Refine Eq_trans (TimesOFd.ap2 x (DivOFd.ap2 TwoOFd TwoOFd));
      Refine Eq_sym; Refine TimesOFd_assoc;
    Refine Eq_trans (TimesOFd.ap2 x OneOFd);
      Refine +1 rOneOFd_ident;
    Refine exten2 TimesOFd ?.Eq_refl;
    Refine rRecipOFd_invers; Refine TwoOFd_not_zero;
  Save TwoOFd_lemma1;

  Goal {x|obj F} (Eq (DoubleOFd.ap x) ZeroOFd) -> Eq x ZeroOFd;
    intros;
    Refine Eq_trans (DivOFd.ap2 (DoubleOFd.ap x) TwoOFd);
      Refine Eq_sym ?.TwoOFd_lemma1;
    Refine Eq_trans (DivOFd.ap2 ZeroOFd TwoOFd);
      Refine exten2 ? H ?.Eq_refl;
    Refine FieldOFd.lTimesZeroFd;
  Save DoubleOFd_zero;

  Goal {x|obj F} ~(Eq x ZeroOFd) -> ~(Eq (DoubleOFd.ap x) ZeroOFd);
    intros _;
    Refine Contrapos (DoubleOFd_zero|x);
  Save DoubleOFd_not_zero;

(* --------------------------------------------------------------------------------
   Some lemmas concerning squares.
*)

  Goal (Discrete F.car) -> {x,y|obj F} (PositiveOFd.ap x) -> (PositiveOFd.ap y) ->
       (Eq (SquareOFd.ap x) (SquareOFd.ap y)) -> Eq x y;
    intros F_discr;
    Claim {x,y|obj F} (PositiveOFd.ap x) -> (PositiveOFd.ap y) ->
                         (LessEqOFd.ap2 x y) ->
                         (Eq (SquareOFd.ap x) (SquareOFd.ap y)) -> Eq x y;
    intros;
    orE LessEqOFd_total x y;
    intros; Refine ?19 H H1 H3 H2;
    intros; Refine (?19 H1 H H3 H2.Eq_sym).Eq_sym;
    intros; orE F_discr x ZeroOFd;

    intros; orE F_discr y ZeroOFd;
    intros; Refine Eq_trans ZeroOFd H4 H5.Eq_sym;
    intros; Refine H5;
    Refine Eq_trans (TimesOFd.ap2 y OneOFd);
      Refine Eq_sym; Refine rOneOFd_ident;
    Refine Eq_trans (TimesOFd.ap2 y (DivOFd.ap2 y y));
      Refine exten2 ? ?.Eq_refl; Refine Eq_sym; Refine rRecipOFd_invers H5;
    Refine Eq_trans (DivOFd.ap2 (SquareOFd.ap y) y);
      Refine TimesOFd_assoc;
    Refine Eq_trans (DivOFd.ap2 ZeroOFd y);
      Refine +1 FieldOFd.lTimesZeroFd;
    Refine exten2 ? ? ?.Eq_refl;
    Refine Eq_trans (SquareOFd.ap x);
      Refine Eq_sym H3;
    Refine Eq_trans (SquareOFd.ap ZeroOFd);
      Refine exten ? H4;
    Refine FieldOFd.rTimesZeroFd;

    intros;
    Refine Eq_trans (TimesOFd.ap2 x OneOFd);
      Refine Eq_sym; Refine rOneOFd_ident;
    Refine Eq_trans (TimesOFd.ap2 x (DivOFd.ap2 x x));
      Refine exten2 ? ?.Eq_refl; Refine Eq_sym; Refine rRecipOFd_invers H4;
    Refine Eq_trans (DivOFd.ap2 (SquareOFd.ap x) x);
      Refine TimesOFd_assoc;
    Refine Eq_trans (DivOFd.ap2 (TimesOFd.ap2 x y) x);
    Next +1;
    Refine Eq_trans (TimesOFd.ap2 (DivOFd.ap2 x x) y);
      Refine FieldOFd.rTimesFd_commut;
    Refine Eq_trans (TimesOFd.ap2 OneOFd y);
      Refine exten2 ? ? ?.Eq_refl; Refine rRecipOFd_invers H4;
    Refine lOneOFd_ident;

    Refine exten2 ? ? ?.Eq_refl;
    Refine LessEqOFd_antisym;
    Refine lLessEqTimesOFd_compat H H2;
    Refine extenRel ? ?.Eq_refl H3.Eq_sym;
    Refine rLessEqTimesOFd_compat H1 H2;
  Save SquareOFd_inj;

  Goal SquareOFd_lemma2
     : (Discrete F.car) -> {x,y|obj F} (Eq (SquareOFd.ap x) (SquareOFd.ap y)) -> 
                                          ((Eq x y) \/ (Eq x (NegOFd.ap y)));
    intros F_discr;
    Claim {x,y|obj F} (PositiveOFd.ap x) ->
                     (Eq (SquareOFd.ap x) (SquareOFd.ap y)) -> 
                     ((Eq x y) \/ (Eq x (NegOFd.ap y)));
    intros;
    orE NegOrPosOFd x;
    intros; orE ?17 H1; Refine y;
    Refine Eq_trans ? ? H; Refine FieldOFd.SquareNegFd_distrib;
    intros; Refine inr;
      Refine Eq_trans (NegOFd.ap (NegOFd.ap x)); Refine Eq_sym; Refine NegOFd_invol;
      Refine exten ? H2;
    intros; Refine inl; Refine FieldOFd.NegFd_inj; Refine H2;
    intros; Refine ?17 H1 H;
    intros; orE NegOrPosOFd y;
    intros; Refine inr; Refine SquareOFd_inj F_discr H H2;
      Refine Eq_trans (SquareOFd.ap y) H1;
      Refine Eq_sym; Refine FieldOFd.SquareNegFd_distrib;
    intros; Refine inl; Refine SquareOFd_inj F_discr H H2 H1;
  Save;

  Goal PlusSquareOFd_zero : (Discrete F.car) -> {x,y|obj F}
                  (Eq (PlusOFd.ap2 (SquareOFd.ap x) (SquareOFd.ap y)) ZeroOFd) ->
                  ((Eq x ZeroOFd) /\ (Eq y ZeroOFd));
    intros F_discr ___;
    andE PlusPosOFd_lemma2 (SquarePosOFd x) (SquarePosOFd y) H;
    Refine pair;
    Refine FieldOFd.SquareFd_zero F_discr H1;
    Refine FieldOFd.SquareFd_zero F_discr H2;
  Save;

  Goal PlusSquareOFd_not_zero
     : {x,y|obj F} (~(Eq x ZeroOFd) \/ ~(Eq y ZeroOFd)) ->
       ~(Eq (PlusOFd.ap2 (SquareOFd.ap x) (SquareOFd.ap y)) ZeroOFd);
    Intros ____;
    Refine PlusPosOFd_lemma2 (SquarePosOFd x) (SquarePosOFd y) H1;
    intros; orE H;
    intros; Refine FieldOFd.SquareFd_not_zero H4 H2;
    intros; Refine FieldOFd.SquareFd_not_zero H4 H3;
  Save;

Discharge F;


