
Module Drinker Import lib_logic;

(* Add the rule of double negation to obtain classical logic. *)

[     DN : {P:Prop} ~~P -> P
];

Goal ExFalso : {P:Prop} absurd -> P;
  intros; Refine H;
Save;

(* Let `C' be a non-empty type, `D' be a predicate.
   Then there exists a person with the following property:
   everyone is drunk whenever he is. *)

Goal {C:Type} C -> {D:C->Prop} Ex [x:C] (D x) -> {y:C} D y;
  Intros C a D;                 (*  0 *)
  Refine DN;                    (*  1 *)
  Intros H2;                    (*  2 *)
  Refine H2;                    (*  3 *)
  Refine ExIntro; Refine a;     (*  4 *)
  Intros H5;                    (*  5 *)
  Intros z;                     (*  6 *)
  Refine DN;                    (*  7 *)
  Intros H8;                    (*  8 *)
  Refine H2;                    (*  9 *)
  Refine ExIntro; Refine z;     (* 10 *)
  Intros H11;                   (* 11 *)
  Refine ExFalso;               (* 12 *)
  Refine H8 H11;                (* 13 *)
Save DrinkersPrinciple;

(* After some alpha conversion:

type of eee = {C:Type} C -> {D:C->Prop} Ex ([x:C] (D x) -> {y:C}D y)

value of DrinkersPrinciple =
  [C:Type] [a:C] [D:C->Prop]
  DN (Ex ([x:C](D x)->{y:C}D y))
    ([H2:not (Ex ([x:C](D x)->{y:C}D y))]
      H2
        (ExIntro ([x:C](D x)->{y:C}D y)
          ([H5:D a]
            [z:C]
              DN (D z)
                ([H8:not (D z)]
                  H2
                    (ExIntro ([x:C](D x)->{y:C} D y)
                      ([H11:D z]
                        ExFalso ({y:C}D y)
                          (H8 H11)))))))

*)

(* And Robert's way: *)

Goal {A,B:Prop} (~A -> B) -> (~B -> A);
  intros;
  Refine DN A; Intros _;
  Refine H1; Refine H H2;
Save clas_imp_law;

[T | Type];

Goal {P:T->Prop} ~(Ex P) -> {x:T} ~(P x);
  Intros ____;
  Refine H; Refine ExIntro; Immed;
Save ExAll_lemma;

Goal {P:T->Prop} (~{x:T} P x) -> Ex [x:T] ~(P x);
  intros;
  Refine clas_imp_law;
  Refine +1 ExAll_lemma;
  Intros _; Refine H;
     intros;
     Refine DN; Intros _;
     Refine H1; Refine +1 H2;
Save DrinkersPrinciple_2;

Discharge T;

