
Module AbMonoid_sum Import AbMonoid Nat_order;

(*
   This module defines the summation operator for monoids. To be useful
   it is assumed the monoid is abelian.
*)

[MN | Monoid];

[PlusMN_commut : Commutative MN.PlusMN];

(* --------------------------------------------------------------------------------
   Given a commutative monoid define the summation from 0 by induction:

       0                        S n            /   n       \
      ---                       ---            |  ---      |
      \                         \              |  \        |
      /    f i  ==>  f 0        /    f i  ==>  |  /   f i  | + f (S n)
      ---                       ---            |  ---      |
      i=0                       i=0            \  i=0      /
*)

[     sum0MN [f:Nat.el->MN.obj] : Nat.el -> MN.obj
          = nat_rec (f ZeroN)
                    ([n:nat][ih:obj MN] MN.PlusMN.ap2 ih (f (Succ.ap n)))
];

Goal {f,g|Nat.el->MN.obj}
     ({x:el Nat} Eq (f x) (g x)) -> {x:el Nat} Eq (sum0MN f x) (sum0MN g x);
  intros ___;
  Refine nat_elim [x:nat] Eq (sum0MN f x) (sum0MN g x);
  Refine H; 
  intros n ih; Refine exten2 MN.PlusMN ih; Refine H;
Save sum0MN_exten;

Goal Sum0MN : Fun2 (Function Nat MN.car) Nat MN.car;
  Refine Fun2_intro;
  intros f; Refine sum0MN f.ap;
  Intros f g _ x y _; Qrepl H1; Refine sum0MN_exten H;
Save;

(*       n            n
        ---          ---
        \            \
        /    f i  =  /    if (i<=n) then (f i) else (g i)
        ---          ---
        i=0          i=0
*)

Goal {n:el Nat} {f,g:Nat.el -> MN.obj}
     Eq (sum0MN f n) (sum0MN ([i:el Nat] select (LessEqN_partit i n) (f i) (g i)) n);
  intros p __;
  Refine Eq_sym;
  Refine nat_elim [n:el Nat] (LessEqN.ap2 n p) ->
      Eq (sum0MN ([i:el Nat] select (LessEqN_partit i p) (f i) (g i)) n) (sum0MN f n);
  Refine +2 LessEqN_refl;

  intros;
  Refine select_left; Refine LessEqN_partit_ok; Refine LessEqN_LB;

  intros n ih _; Refine exten2 MN.PlusMN;
  Refine ih; Refine LessEqN_succ_elim H;
  Refine select_left; Refine LessEqN_partit_ok; Refine H;
Save sum0MN_if;

(*      S n         	     /   n 	     \
        ---         	     |  ---	     |
        \           	     |  \  	     |
        /    f i  =  (f 0) + |  /    f (S i) |
        ---         	     |  ---	     |
        i=0         	     \  i=0	     /
*)

Goal {f:Nat.el -> MN.obj} {n:el Nat}
     Eq (sum0MN f (Succ.ap n))
        (MN.PlusMN.ap2 (f ZeroN) (sum0MN (compose f succ) n));
  intros _; [g = compose f succ];
  Refine nat_elim [n:el Nat] Eq (sum0MN f (Succ.ap n))
                                (MN.PlusMN.ap2 (f ZeroN) (sum0MN g n));
  Refine Eq_refl;
  intros n ih;
  Refine Eq_trans (MN.PlusMN.ap2 (MN.PlusMN.ap2 (f ZeroN) (sum0MN g n))
                                 (g (Succ.ap n)));
    Refine exten2 ? ih ?.Eq_refl;
  Refine Eq_sym; Refine PlusMN_assoc;
Save sum0MN_zero;

(*   /   n       \   / 	 n 	\      	 n
     |  ---      |   | 	---     |       ---
     |  \        |   | 	\       |       \
     |  /    f i | + | 	/   g i |  =    /    (f i) + (g i)
     |  ---      |   | 	---     |       ---
     \  i=0      /   \ 	i=0     /       i=0
*)

Goal {f,g:Nat.el -> MN.obj} {n:el Nat} Eq (MN.PlusMN.ap2 (sum0MN f n) (sum0MN g n))
                                          (sum0MN (compose2 MN.PlusMN.ap2 f g) n);
  intros __;
  Refine nat_elim [n:el Nat] Eq (MN.PlusMN.ap2 (sum0MN f n) (sum0MN g n))
                                (sum0MN (compose2 MN.PlusMN.ap2 f g) n);
  Refine Eq_refl;
  intros _ ih;
  Refine Eq_trans (MN.PlusMN.ap2 (MN.PlusMN.ap2 (MN.PlusMN.ap2
           (sum0MN f n) (f (Succ.ap n))) (sum0MN g n)) (g (Succ.ap n)));
    Refine PlusMN_assoc;
  Refine Eq_trans (MN.PlusMN.ap2 (MN.PlusMN.ap2 (MN.PlusMN.ap2
           (sum0MN f n) (sum0MN g n)) (f (Succ.ap n))) (g (Succ.ap n)));
    Refine exten2 ???.Eq_refl; Refine rPlusMN_commut; Refine PlusMN_commut;
  Refine Eq_trans (MN.PlusMN.ap2 (MN.PlusMN.ap2 (sum0MN f n) (sum0MN g n))
                            (MN.PlusMN.ap2 (f (Succ.ap n)) (g (Succ.ap n))));
    Refine Eq_sym; Refine PlusMN_assoc;
  Refine exten2 ? ih ?.Eq_refl;
Save sum0MN_times;

(*     /   n 	  \	 n
       |  ---	  |	---
       |  \  	  |	\
     g |  /   f i |  =  /   f (g i)     (if g distributes over addition)
       |  ---	  |	---
       \  i=0	  /	i=0
*)

Goal {g:op MN.obj} (distributive (Eq|MN.car) MN.PlusMN.ap2 g) ->
     {f|Nat.el->MN.obj} {n|el Nat}
     Eq (g (sum0MN f n)) (sum0MN (compose g f) n);
  intros ___;
  Refine nat_elim [n:el Nat] Eq (g (sum0MN f n)) (sum0MN (compose g f) n);
  Refine Eq_refl;
  intros n ih;
  Refine Eq_trans (MN.PlusMN.ap2 (g (sum0MN f n)) (g (f (succ n))));
    Refine H;
  Refine exten2 ? ih ?.Eq_refl;
Save sum0MN_distrib;

Discharge MN;
