#ifndef lint
static char yysccsid[] = "@(#)yaccpar	1.8 (Berkeley) 01/20/90";
#endif
#define YYBYACC 1
#line 22 "nyelv.y"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "nodeType.h"

#define MAXNROFPARAMS 8192         /* Maxmimum number of parameters in a declaration */
#define MAXNROFINTERFACENAMES 8192

nodeType *construct_id(char *s);
nodeType *construct_onep(char *p_name,char *p_type); /* Its content shouldn't be deallocated! */
nodeType *construct_new_pali(nodeType *newparameter);
nodeType *merge_palis(nodeType *lista1, nodeType *lista2);
char *content_of_id(nodeType *p);
nodeType *construct_typenode(char *s);
char *content_of_typenode(nodeType *p);

void freeNode(nodeType *p);

/* CODE GENERATION PROTOTYPES */

void cg_if_init(void);
void cg_if_exit(void);
void cg_h_init(void);
void cg_h_exit(void);
void cg_module_init(char *modulnev);
void cg_module_exit(void);
void cg_interface_init(char *ifnev);
void cg_interface_exit(void);
void cg_functions_emit(char *nev,nodeType *params,char *rettypename);

/* Type conversion routines */

char *myidltype_to_c(char *name) ;
char *myidltype_to_c_CLEANTYPE(char *name,int returntype) ;
char *myidltype_to_c1(char *name) ;

/* Interface name aliases */

void make_new_interface_name_alias(char *name);
int is_interface_name_alias(char *name);

#line 65 "nyelv.y"
typedef union {
  int  iValue;    /* Integer value -- not used in this application */
  char *sValue;   /* String value  on the parsing stack */
  nodeType *nPtr; /* Complex abstract syntax tree node */
} YYSTYPE;
#line 54 "y.tab.c"
#define MODULEUTASITAS 257
#define INTERFACEUTASITAS 258
#define EXCEPTIONUTASITAS 259
#define RAISESUTASITAS 260
#define FUNCTIONUTASITAS 261
#define INUTASITAS 262
#define RETURNSUTASITAS 263
#define STRINGUTASITAS 264
#define INT32UTASITAS 265
#define BOOLEANUTASITAS 266
#define IORUTASITAS 267
#define SYM_LPAREN 268
#define SYM_RPAREN 269
#define SYM_LBRACKET 270
#define SYM_RBRACKET 271
#define SYM_COMMA 272
#define SYM_SEMICOLON 273
#define SYM_NUMBER 274
#define SYM_ISMERETLEN 275
#define SYM_EOF 276
#define SYM_IDENTIFIER 277
#define YYERRCODE 256
short yylhs[] = {                                        -1,
    0,    5,    7,    7,    8,   10,    9,    6,    6,    6,
    6,   12,   12,   13,   13,   14,   11,   11,   15,   15,
   16,   16,   17,   17,    2,    2,    3,    4,    4,    4,
    4,    4,    1,
};
short yylen[] = {                                         2,
    4,    3,    2,    1,    3,    3,    3,    1,    1,    2,
    2,    6,    5,    1,    2,    3,    1,    2,    7,    6,
    4,    0,    1,    3,    1,    3,    3,    1,    1,    1,
    1,    1,    1,
};
short yydefred[] = {                                      0,
    0,    0,    0,   33,    0,    0,    0,    0,    0,    0,
    4,    0,    2,    0,    0,    0,   10,   28,   29,   31,
   30,   32,    0,    3,    0,    0,   11,    5,    6,    0,
    1,    0,    0,   18,    0,    0,    0,    0,    0,    7,
   13,    0,    0,   15,    0,    0,    0,    0,   16,   12,
    0,    0,    0,    0,    0,   27,    0,   20,    0,   26,
    0,    0,   19,    0,   21,   24,
};
short yydgoto[] = {                                       2,
   22,   47,   48,   23,    3,    8,    9,   10,   24,   11,
   25,   12,   37,   38,   26,   53,   62,
};
short yysindex[] = {                                   -253,
 -269,    0, -256,    0, -244, -269, -269, -242, -256, -246,
    0, -256,    0, -245, -240, -258,    0,    0,    0,    0,
    0,    0, -269,    0, -239, -246,    0,    0,    0, -254,
    0, -235, -237,    0, -236, -269, -233, -246, -255,    0,
    0, -234, -232,    0, -246, -226, -229, -230,    0,    0,
 -269, -225, -228, -226, -218,    0, -269,    0, -227,    0,
 -224, -222,    0, -269,    0,    0,
};
short yyrindex[] = {                                      0,
    0,    0,    0,    0,    0,    0,    0,    0, -220,    0,
    0, -219,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, -217,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, -216,    0,    0,
    0,    0,    0,    0,    0, -215,    0, -212,    0,    0,
    0,    0,    0, -215,    0,    0,    0,    0,    0,    0,
 -210,    0,    0,    0,    0,    0,
};
short yygindex[] = {                                      0,
   -1,   -6,    0,  -29,    0,   15,    0,    0,    0,    0,
   27,    0,   22,    0,    0,    7,   -2,
};
#define YYTABLESIZE 63
short yytable[] = {                                       5,
   36,    6,    7,    1,   14,   15,   45,    4,   36,   18,
   19,   20,   21,   46,   31,   51,   35,   18,   19,   20,
   21,   32,    4,   17,   28,   13,   27,   29,   16,   30,
    4,   33,   39,   52,   42,   40,   41,   43,   49,   54,
   50,   55,   57,   45,   58,   63,   65,   64,   60,   56,
    8,    9,   34,   17,   14,   61,   25,   22,   23,   44,
   59,   66,   61,
};
short yycheck[] = {                                       1,
   30,  258,  259,  257,    6,    7,  262,  277,   38,  264,
  265,  266,  267,  269,  273,   45,  271,  264,  265,  266,
  267,   23,  277,    9,  270,  270,   12,  273,  271,  270,
  277,  271,  268,  260,   36,  273,  273,  271,  273,  269,
  273,  272,  268,  262,  273,  273,  269,  272,   55,   51,
  271,  271,   26,  271,  271,   57,  269,  273,  269,   38,
   54,   64,   64,
};
#define YYFINAL 2
#ifndef YYDEBUG
#define YYDEBUG 0
#endif
#define YYMAXTOKEN 277
#if YYDEBUG
char *yyname[] = {
"end-of-file",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"MODULEUTASITAS",
"INTERFACEUTASITAS","EXCEPTIONUTASITAS","RAISESUTASITAS","FUNCTIONUTASITAS",
"INUTASITAS","RETURNSUTASITAS","STRINGUTASITAS","INT32UTASITAS",
"BOOLEANUTASITAS","IORUTASITAS","SYM_LPAREN","SYM_RPAREN","SYM_LBRACKET",
"SYM_RBRACKET","SYM_COMMA","SYM_SEMICOLON","SYM_NUMBER","SYM_ISMERETLEN",
"SYM_EOF","SYM_IDENTIFIER",
};
char *yyrule[] = {
"$accept : program",
"program : modul interfeszek SYM_RBRACKET SYM_SEMICOLON",
"modul : MODULEUTASITAS identifier SYM_LBRACKET",
"interfesz : interfesz1 interfesz2",
"interfesz : interfesz1a",
"interfesz1 : INTERFACEUTASITAS identifier SYM_LBRACKET",
"interfesz1a : INTERFACEUTASITAS identifier SYM_SEMICOLON",
"interfesz2 : definiciok SYM_RBRACKET SYM_SEMICOLON",
"interfeszek : interfesz",
"interfeszek : exception",
"interfeszek : interfesz interfeszek",
"interfeszek : exception interfeszek",
"exception : EXCEPTIONUTASITAS identifier SYM_LBRACKET exceptiontagok SYM_RBRACKET SYM_SEMICOLON",
"exception : EXCEPTIONUTASITAS identifier SYM_LBRACKET SYM_RBRACKET SYM_SEMICOLON",
"exceptiontagok : exceptiontag",
"exceptiontagok : exceptiontag exceptiontagok",
"exceptiontag : typename identifier SYM_SEMICOLON",
"definiciok : definicio",
"definiciok : definicio definiciok",
"definicio : typename identifier SYM_LPAREN parameterek SYM_RPAREN raisedexceptions SYM_SEMICOLON",
"definicio : typename identifier SYM_LPAREN SYM_RPAREN raisedexceptions SYM_SEMICOLON",
"raisedexceptions : RAISESUTASITAS SYM_LPAREN exceptionnames SYM_RPAREN",
"raisedexceptions :",
"exceptionnames : identifier",
"exceptionnames : identifier SYM_COMMA exceptionnames",
"parameterek : parameter",
"parameterek : parameter SYM_COMMA parameterek",
"parameter : INUTASITAS typename identifier",
"typename : STRINGUTASITAS",
"typename : INT32UTASITAS",
"typename : IORUTASITAS",
"typename : BOOLEANUTASITAS",
"typename : identifier",
"identifier : SYM_IDENTIFIER",
};
#endif
#define yyclearin (yychar=(-1))
#define yyerrok (yyerrflag=0)
#ifdef YYSTACKSIZE
#ifndef YYMAXDEPTH
#define YYMAXDEPTH YYSTACKSIZE
#endif
#else
#ifdef YYMAXDEPTH
#define YYSTACKSIZE YYMAXDEPTH
#else
#define YYSTACKSIZE 500
#define YYMAXDEPTH 500
#endif
#endif
int yydebug;
int yynerrs;
int yyerrflag;
int yychar;
short *yyssp;
YYSTYPE *yyvsp;
YYSTYPE yyval;
YYSTYPE yylval;
short yyss[YYSTACKSIZE];
YYSTYPE yyvs[YYSTACKSIZE];
#define yystacksize YYSTACKSIZE
#line 238 "nyelv.y"
/* Here comes the main processing part */

#include <stdio.h>

extern FILE *yyin;
extern int num_lines;
char OUTPUT_FILE_NAME[1024]; /* should be POSIX_MAX_FILENAMELEN */
char OUTPUT_FILE_NAME2[1024]; /* should be POSIX_MAX_FILENAMELEN */
char CURRENT_ID[1024]; /* long enough to hold a module+interface ID */

/* Prints out an error message with line number, where the error occurred */
void yyerror(char *szoveg)
{
    printf("%s (line:%d)\n", szoveg, num_lines);
    fflush(stdout);
    exit(1);
}

/* main program */
main(int argc, char **argv)
{

   if (argc>=2)
   {
     if ((yyin=fopen(argv[1], "r"))==NULL)
     {
       yyin=stdin;
     }
   }
   else
   {
      yyin=stdin;
   }

   if (argc>=3)
   {
     fprintf(stderr,"Too many arguments\n");
     exit(-1);
   }
   
   yyparse(); /* Call the parser */

   cg_module_exit(); /* finish emitting the last module */
}

static nodeType *construct_con(int i)  /* Not used currently */
{
  nodeType *p;

  /* allocate node */
  if ((p = malloc(sizeof(conNodeType))) == NULL) 
       yyerror("out of memory");

  /* fill in the informations */
  p->type = typeCon;
  p->con.value = i;

  return p;
}

/* Constructs a node in the abstract syntax tree, which represents a data type */
nodeType *construct_typenode(char *s) 
{
  nodeType *p;

  /* allocate node */
  if ((p = malloc(sizeof(typeNodeType))) == NULL) 
       yyerror("out of memory");

  /* fill in the informations */
  p->type = typeTypeName;
  p->tp.name = malloc(strlen(s)+1);
  strcpy(p->tp.name,s);

  return p;
}

/* Returns the content of a type node which is a data type */
char *content_of_typenode(nodeType *p) 
{
  if (!p) return NULL; /* something is wring */
  if (p->type == typeTypeName) {
    return strdup(p->tp.name); 
  } else return NULL;

}

/* Constructs a node in the abstract syntax tree, which represents an identifier */
nodeType *construct_id(char *s) 
{
  nodeType *p;

  /* allocate node */
  if ((p = malloc(sizeof(idNodeType))) == NULL) 
       yyerror("out of memory");

  /* fill in the informations */
  p->type = typeId;
  p->id.name = malloc(strlen(s)+1);
  strcpy(p->id.name,s);

  return p;
}

/* Returns the content of a type node which is an identifier */
char *content_of_id(nodeType *p) 
{
  if (!p) return; /* valami disznosag van */
  if (p->type == typeId) {
    return strdup(p->id.name); 
  } else return NULL;

}

/* Constructs a node in the abstract syntax tree, which represents one parameter */
/* Later these can be merged into longer parameter lists */
nodeType *construct_onep(char *p_name,char *p_type) 
{
  nodeType *p;

  /* allocate node */
  if ((p = malloc(sizeof(onepNodeType))) == NULL) 
       yyerror("out of memory");

  /* fill in the informations */
  p->type = typeOneParam;
  p->onep.parname = malloc(strlen(p_name)+1);
  p->onep.partype = malloc(strlen(p_type)+1);
  strcpy(p->onep.parname,p_name);
  strcpy(p->onep.partype,p_type);

  return p;
}

/* Constructs a node in the abstract syntax tree, which represents a parameter list */
nodeType *construct_new_pali(nodeType *newparameter)
{
  nodeType *p;

  if (newparameter->type != typeOneParam) {
	fprintf(stderr,"ASSERTION FAILED: construct_new_pali got a parameter, which is not the type with one parameter.\n");
	exit(-1);
  } /* ASSERT */

  /* allocate node */
  if ((p = malloc(sizeof(paliNodeType))) == NULL) 
       yyerror("out of memory");

  /* fill in the informations */
  p->type = typeParamList;
  p->pali.howmanyparameters = 1;
  p->pali.palist = malloc(sizeof(onepNodeType)*1); /* XXX */
  p->pali.palist[0]=(onepNodeType*) newparameter;

  return p;
}

/* Merge two parameter lists, creates a new list object */
nodeType *merge_palis(nodeType *lista1, nodeType *lista2)
{
  nodeType *p;
  onepNodeType **o;
  int i;

  if ((lista1->type != typeParamList) || (lista2->type != typeParamList)) {
    fprintf(stderr,"ASSERTION FAILED: merge_palis got a parameter, which is not a parameter list itself\n");
    exit(-1);
  } /* ASSERT */

  /* allocate node */
  if ((p = malloc(sizeof(paliNodeType))) == NULL) 
       yyerror("out of memory");

  /* fill in the informations */
  p->type = typeParamList;
  p->pali.howmanyparameters = lista1->pali.howmanyparameters + lista2->pali.howmanyparameters;
  p->pali.palist = malloc(sizeof(onepNodeType*)*p->pali.howmanyparameters); /* XXX */
  o = p->pali.palist ;
#ifdef DEBUG
  /* First print out everything */
  for (i=0;i<lista1->pali.howmanyparameters;i++)
  {
    fprintf(stderr,".%d:[%d]",i,lista1->pali.palist[i]->type);
    fprintf(stderr,"%s.",((onepNodeType *)(lista1->pali.palist[i]))->parname);
  }
  for (i=0;i<lista2->pali.howmanyparameters;i++)
  {
    fprintf(stderr,".%d(%d):[%d].",i+lista1->pali.howmanyparameters,i,lista2->pali.palist[i]->type);
    fprintf(stderr,"%s.",((onepNodeType *)(lista2->pali.palist[i]))->parname);
  }
#endif
  /* Now concatenate the lists */
  for (i=0;i<lista1->pali.howmanyparameters;i++)
    o[i]=lista1->pali.palist[i];
  for (i=0;i<lista2->pali.howmanyparameters;i++)
    o[i+lista1->pali.howmanyparameters]=lista2->pali.palist[i];
  /* XXX !!! lista1 and lista2 should be freed, but not the pointers (elements) */
  /* , only the "wrapper" */

  return p;
}

/* Free the memory allocated by the given node */
void freeNode(nodeType *p)
{
  int i;

  /* do the work according to the node's type */
  if (!p) return; /* something is wring */
  if (p->type == typeId) {
    free(p->id.name); /* this was malloc'd separately */
  }
  if (p->type == typeOneParam) {
    free(p->onep.parname); /* this was malloc'd separately */
    free(p->onep.partype); /* this was malloc'd separately */
  }
  if (p->type == typeParamList) {
    for (i=0;i<p->pali.howmanyparameters;i++)
      {
	if (p->pali.palist[i]->type != typeOneParam) {
		fprintf(stderr,"ASSERTION FAILED: in freeNode, while freeing parameter lists");
		exit(-1);
	} /* ASSERT */
        freeNode((nodeType *)(p->pali.palist[i]));
      }
    free(p->pali.palist);  /* this was malloc'd separately */
  }
  free(p);
}

/* ------------------------------------------- CODE GENERATION --------------------------------- */
/* This part is responsible for generating the CORBA IDL and other stuff */

#ifdef GENERATE_IDL
FILE *idlfile; /* IDL file produced for orbit-idl */
#endif
FILE *hfile;   /* header file produced for htoclean */
FILE *adapterfile; /* adapter file produced for htoclean */
#define MAXNAMELEN 8192
char modulename[MAXNAMELEN];
char interfacename[MAXNAMELEN];

#define NEST2 all_spaces(2)
#define NEST4 all_spaces(4)

/* returns 'n' spaces */
char *all_spaces(int n) /* The returned value is STATIC!!! */
{
  int i;
  char *s;

  s=malloc(n+1);
  for (i=0;i<n;i++) {
    s[i]=' ';
  }
  s[n]='\0';
  return(s); /* XXX needs to be freed */
}

/* Initialize code generator for the 'h' file */
void cg_h_init(void)
{
  strcpy(OUTPUT_FILE_NAME,OUTPUT_FILE_NAME2);
  hfile=fopen(strcat(OUTPUT_FILE_NAME,".h"),"w");
}

/* Initialize code generator for the by-interface file */
/* It initializes the 'h' file (calls the corresp. func.) and the adapter file */
void cg_if_init(void)
{
  /* Create file name from module name + interface name */
  sprintf(OUTPUT_FILE_NAME,"%s_%s",modulename,interfacename);
  /* Now do the processing */
  strcpy(OUTPUT_FILE_NAME2,OUTPUT_FILE_NAME);
#ifdef GENERATE_IDL
  idlfile=fopen(strcat(OUTPUT_FILE_NAME,".idl"),/*"output.idl",*/ "w");
  fprintf(idlfile,"module %s {\n",modulename); /* ! Needs end of module mark */
  fprintf(idlfile,"%sinterface %s {\n",NEST2,interfacename); /* ! Needs end of interface mark */
#endif
  cg_h_init();
  strcpy(OUTPUT_FILE_NAME,OUTPUT_FILE_NAME2);
  adapterfile=fopen(strcat(OUTPUT_FILE_NAME,"_adapter.c"),"w");
  fprintf(adapterfile," #include %cClean.h%c  \n",'<','>'); 
  fprintf(adapterfile," #include <stdlib.h>  \n"); 
  fprintf(adapterfile," #include <stdio.h>  \n"); 
  fprintf(adapterfile," #include <orb/orbit.h>  \n"); 
  fprintf(adapterfile," #include %c%s.h%c  \n",'"',modulename,'"'); 
  fprintf(adapterfile," \n"); 
  fprintf(adapterfile," static CleanString common_clean_return_value_string;  \n"); 
  fprintf(adapterfile," static int ccrvs_is_mallocated = 0;  \n"); 
  fprintf(adapterfile," static int common_clean_return_value_integer;  \n"); 
  fprintf(adapterfile," static char* NYEMA = %cNYEMA%c;  \n",'"','"'); 
  fprintf(adapterfile," "); 
  fprintf(adapterfile," extern void * __nl_kun_cs_my_orb;\n"); 
  fprintf(adapterfile," extern CORBA_exception_type __nl_kun_cs_lastop_exception;\n"); 
  fprintf(adapterfile," extern char *__nl_kun_cs_lastop_excname;"); 
  fprintf(adapterfile," "); 
  /*fprintf(hfile," #include %cClean.h%c  \n",'"','"'); */
  /*fprintf(hfile," Clean ( :: *State :== Int )   \n"); */
}

/* Flush and exit code generator for the 'h' file */
void cg_h_exit(void)
{
  fclose(hfile);
}

/* Flush ans exit the by-interface files ('h' and adapter) */
void cg_if_exit(void)
{
  fclose(adapterfile);
  cg_h_exit();
#ifdef GENERATE_IDL
  fprintf(idlfile,"%s};\n",NEST2);
  fprintf(idlfile,"};\n"); 
  fclose(idlfile);
#endif
}

/* Code generation, module, initialization */
void cg_module_init(char *modulnev)
{
  strcpy(modulename,modulnev);
}

/* Code generation, module, finalization */
void cg_module_exit(void)
{
}

/* Code generation, interface, initialization */
void cg_interface_init(char *ifnev)
{
  strcpy(interfacename,ifnev);
}

/* Code generation, interface, finalization */
void cg_interface_exit(void)
{
}

/* Generates the code (into then h,adapter,idl file) or a function */
void cg_functions_emit(char *nev,nodeType *params, char *rettypename) 
{
  onepNodeType *o;
  int i;
  int returntypeisstring;
  char CleanTypeString[8192];
  char TEMPCleanTypeString[8192];
 
  if (params != NULL) {
			if (params->type != typeParamList) {
				fprintf(stderr,"ASSERTION FAILED: cg_functions_emit got a parameter, which is not a parameter list itself");
				exit(-1);
				} /* ASSERT */
  }

#ifdef GENERATE_IDL
  fprintf(idlfile,"%s",NEST4); 
#endif

#ifdef GENERATE_IDL
  if (strcmp(rettypename,"ior") == 0) {
    fprintf(idlfile,"  string %s ( ", nev); 
  } else { 
    fprintf(idlfile,"  %s %s ( ", rettypename, nev); 
  }
#endif


  if (params != NULL) {
    for (i=0;i<params->pali.howmanyparameters;i++)
    {
#ifdef GENERATE_IDL
      if (i != 0) fprintf(idlfile," , "); 
#endif
		  if (params->pali.palist[i]->type != typeOneParam) {
			  fprintf(stderr,"ASSERTION FAILED: got a parameter which is not a parameter\n");
                  }
      o=params->pali.palist[i];
#ifdef GENERATE_IDL
      fprintf(idlfile," in %s %s ",((onepNodeType *)o)->partype,((onepNodeType *)o)->parname); 
#endif
    }
  }

#ifdef GENERATE_IDL
  fprintf(idlfile," ) ;"); 
  fprintf(idlfile,"\n"); 
#endif

  /* Now generate the C header file  */

  sprintf(CleanTypeString,"Clean( CORBA_%s :: ",nev);
  returntypeisstring=0;
  if ((strcmp(rettypename,"string") != 0) && (strcmp(rettypename,"ior") != 0)) {
    fprintf(hfile,"  %s ", myidltype_to_c(rettypename)); 
  } else {
    fprintf(hfile,"  void "); 
    returntypeisstring=1;
  }
  fprintf(hfile,"  CORBA_%s ( ", nev); 

  /* -- Now the object reference -- */
  /* According to the htoclean specs, its compatible with an int */
  fprintf(hfile," int CORBA_IOR "); 
  sprintf(TEMPCleanTypeString," Int ");
  strcat(CleanTypeString,TEMPCleanTypeString);
  /* -- */
 
  if (params != NULL) {
    for (i=0;i<params->pali.howmanyparameters;i++)
    {
      fprintf(hfile," , "); 
      if (params->pali.palist[i]->type != typeOneParam) {
        fprintf(stderr,"ASSERTION FAILED: got a parameter which is not a parameter (1)\n");
      }
      o=params->pali.palist[i];
      fprintf(hfile," %s %s ",myidltype_to_c(((onepNodeType *)o)->partype),((onepNodeType *)o)->parname); 
      sprintf(TEMPCleanTypeString," %s ",myidltype_to_c_CLEANTYPE( ((onepNodeType *)o)->partype  , 0  ));
      strcat(CleanTypeString,TEMPCleanTypeString);
    }
  }

  /* Doesn't changes the variable i !!! */
  if (returntypeisstring==1) {
    if (i != 0) fprintf(hfile," , "); 
    fprintf(hfile," CleanString * ret_str_val "); 
  }

  fprintf(hfile," ) ;"); 
  fprintf(hfile,"\n"); 

  sprintf(TEMPCleanTypeString," Int -> ( %s , Int ) ) \n",myidltype_to_c_CLEANTYPE(rettypename,1));
  strcat(CleanTypeString,TEMPCleanTypeString);
  fprintf(hfile,"%s\n",CleanTypeString); 


  /* And now generate the adapter file */
  /* the role of an adapter file is to be callable by Clean applications,
   * and then it should call the CORBA client stubs
   */


  /*fprintf(adapterfile,"  %s CORBA_%s ( ", myidltype_to_c(rettypename), nev); */
  if ((strcmp(rettypename,"string") != 0) && (strcmp(rettypename,"ior") != 0)) {
    fprintf(adapterfile,"  %s ", myidltype_to_c(rettypename)); 
  } else {
    fprintf(adapterfile,"  void "); 
  }
  fprintf(adapterfile,"  CORBA_%s ( ", nev); 

  /* -- Now the object reference -- */
  /* According to the htoclean specs, its compatible with an int */
  fprintf(adapterfile," int CORBA_IOR ");  
  /*fprintf(adapterfile," void* CORBA_IOR ");  */ /* XXX */
  /* -- */

  if (params != NULL) {
    for (i=0;i<params->pali.howmanyparameters;i++)
    {
      /* if (i != 0) */ fprintf(adapterfile," , "); 
		  if (params->pali.palist[i]->type != typeOneParam) {
			  fprintf(stderr,"ASSERTION FAILED: got a parameter which is not a parameter (1)\n");
                  }
      o=params->pali.palist[i];
      fprintf(adapterfile," %s %s ",myidltype_to_c(((onepNodeType *)o)->partype),((onepNodeType *)o)->parname); 
    }
  }
  /* Dont touch the variable i !!! */
  if (returntypeisstring==1) {
    if (i != 0) fprintf(adapterfile," , "); 
    fprintf(adapterfile," CleanString * ret_str_val "); 
  }

  fprintf(adapterfile," ) "); 
  fprintf(adapterfile,"\n"); 
  fprintf(adapterfile,"{\n"); 

  if (params != NULL) {
    for (i=0;i<params->pali.howmanyparameters;i++)
    {
      o=params->pali.palist[i];
      fprintf(adapterfile," %s par_%d;\n",myidltype_to_c1(((onepNodeType *)o)->partype),i); 
    }
  }
  fprintf(adapterfile," CORBA_Environment ev,evc;\n"); 
  fprintf(adapterfile," CORBA_char *rcc=NULL; /* to be able to free the resulting objref */\n"); 


  if ((strcmp(rettypename,"string") == 0) || (strcmp(rettypename,"ior") == 0)) {
    fprintf(adapterfile," char* string_return_value; unsigned int string_v_e_len ;\n");
  } else {
    fprintf(adapterfile," int common_clean_return_value_integer ; \n");
  }

  /* Clean to C Conversion */

  if (params != NULL) {
    for (i=0;i<params->pali.howmanyparameters;i++)
    {
      char parname[8192];

      o=params->pali.palist[i];
      sprintf(parname,"par_%d",i); 
      if (strcmp( (((onepNodeType *)o)->partype) , "string" ) == 0) {
        fprintf(adapterfile," %s = calloc(1,CleanStringLength(",parname); 
        fprintf(adapterfile," %s)+1); \n",((onepNodeType *)o)->parname); 
        fprintf(adapterfile," strncpy(%s,CleanStringCharacters(%s),CleanStringLength(%s)); \n", parname,
                                   ((onepNodeType *)o)->parname,
                                   ((onepNodeType *)o)->parname);
#ifdef DEBUG_VALUES
      fprintf(adapterfile," printf(%c%c%c%c,%s); \n",'"','%','s','"',parname); 
#endif
      }
      if (strcmp( (((onepNodeType *)o)->partype) , "long" ) == 0) {
        fprintf(adapterfile," %s = %s; \n",parname,((onepNodeType *)o)->parname); 
      }
      if (strcmp( (((onepNodeType *)o)->partype) , "boolean" ) == 0) {
        fprintf(adapterfile," %s = %s; \n",parname,((onepNodeType *)o)->parname); 
      }
      if (strcmp( (((onepNodeType *)o)->partype) , "ior" ) == 0) {
        fprintf(adapterfile," %s = %s; \n",parname,((onepNodeType *)o)->parname); 
      }
    }
  }

    fprintf(adapterfile," CORBA_exception_init(&ev);\n ");
    fprintf(adapterfile," CORBA_exception_init(&evc);\n ");

   /* Call of a CORBA method */
  
   /* Beginning of an assignment (generated) */
 
   if ((strcmp(rettypename,"string") == 0) || (strcmp(rettypename,"ior") == 0)) {
    fprintf(adapterfile," string_return_value = ");
   } else {
    fprintf(adapterfile," common_clean_return_value_integer = ");
   }
   if ((strcmp(rettypename,"ior") == 0)) {
    fprintf(adapterfile,"rcc=CORBA_ORB_object_to_string(__nl_kun_cs_my_orb,");
   }
 
   /* Right side of an assignment */

   fprintf(adapterfile,"  %s ( (void *) CORBA_IOR ",  nev); 

  if (params != NULL) {
    for (i=0;i<params->pali.howmanyparameters;i++)
    {
      fprintf(adapterfile,", par_%d ",i); 
    }
  }
  fprintf(adapterfile,", &ev) "); 

  if ((strcmp(rettypename,"ior") == 0)) {
    fprintf(adapterfile,", &evc)");
  }
  fprintf(adapterfile,";\n");

  fprintf(adapterfile,"  __nl_kun_cs_lastop_exception = ev._major ;\n");
  /* If there wasm't an exception, then the exception string variable is UNDEFINED */
   fprintf(adapterfile,"  if (ev._major != CORBA_NO_EXCEPTION) {\n"); 
   fprintf(adapterfile,"    if (__nl_kun_cs_lastop_excname != NULL) {\n"); 
   fprintf(adapterfile,"      CORBA_free(__nl_kun_cs_lastop_excname);\n"); 
   fprintf(adapterfile,"    }\n"); 
   fprintf(adapterfile,"    __nl_kun_cs_lastop_excname=CORBA_exception_id(&ev);;\n"); 
   fprintf(adapterfile,"  }\n"); 

   fprintf(adapterfile,"if (ev._major == CORBA_NO_EXCEPTION) {\n"); /* If ther wasn't any exception */
     if ((strcmp(rettypename,"string") == 0) || (strcmp(rettypename,"ior") == 0)) {
       fprintf(adapterfile," string_v_e_len = strlen(string_return_value);\n");
     } else {
     }
   fprintf(adapterfile,"}\n"); /* If ther wasn't any exception */

   /* RETURN VALUE */

   if ((strcmp(rettypename,"string") == 0) || (strcmp(rettypename,"ior") == 0)) {
     fprintf(adapterfile,"if (ev._major != CORBA_NO_EXCEPTION) {\n"); /* If ther wasn't any exception */
     fprintf(adapterfile,"  string_return_value=NYEMA; /* Failure */ \n");
     fprintf(adapterfile,"  string_v_e_len = strlen(string_return_value);\n");
     fprintf(adapterfile,"  /* THOU SHALT NOT FREE NYEMA! */ \n");
     fprintf(adapterfile,"}\n"); /* If ther wasn't any exception */
    /* Now generate the return of the string value */
    fprintf(adapterfile," /* result is in : string_return_value, string_v_e_len */ \n");
    fprintf(adapterfile,"if (ccrvs_is_mallocated) {\n free(common_clean_return_value_string); 
}\n");
    fprintf(adapterfile," common_clean_return_value_string=malloc(sizeof(int)+1+string_v_e_len);\n"); 

    fprintf(adapterfile," memcpy((char*)(1+(unsigned int*)common_clean_return_value_string),string_return_value,string_v_e_len);");
    fprintf(adapterfile," ccrvs_is_mallocated = 1;  \n"); 
    fprintf(adapterfile," *((unsigned int *)(common_clean_return_value_string)) = string_v_e_len;  \n"); 
    fprintf(adapterfile," *ret_str_val = common_clean_return_value_string;  \n"); 
   } else {
    fprintf(adapterfile," /* result is in : common_clean_return_value_integer */ \n");
    fprintf(adapterfile,"if (ev._major != CORBA_NO_EXCEPTION) {\n"); /* If ther wasn't any exception */
    fprintf(adapterfile," common_clean_return_value_integer=0;  /* Failure */ \n"); 
    fprintf(adapterfile,"}\n"); /* If ther wasn't any exception */
    fprintf(adapterfile," return common_clean_return_value_integer;  \n"); 
   }
  

   if ((strcmp(rettypename,"ior") == 0)) {
    fprintf(adapterfile,"if (rcc != NULL) { CORBA_free(rcc); rcc=NULL; }");
   }
  fprintf(adapterfile,"}\n"); 
  fprintf(adapterfile,"\n"); 

}

/* ----------------------------------------------------------- */
/* Type conversion routines                                    */

char *myidltype_to_c(char *name) 
{
  if (strcmp(name,"string")==0) return("CleanString"); /* * for the mode "in" */
  if (strcmp(name,"ior")==0) return("int"); /* * compatible with CORBA_Object */
  if (strcmp(name,"long")==0) return("int");
  if (strcmp(name,"boolean")==0) return("int");
  return("????UNKNOWN TYPE???");
}

char *myidltype_to_c_CLEANTYPE(char *name, int returntype) 
{
  if (strcmp(name,"string")==0) return("String"); /* * for the mode "in" */
  if (strcmp(name,"ior")==0) 
  {
    if (returntype) {
      return("String"); /* * for the mode "in"  -- was "String" csb 99jun13*/
    } else {
      return("Int"); /* * for the mode "in" */
    }
  }
  if (strcmp(name,"long")==0) return("Int");
  if (strcmp(name,"boolean")==0) return("Int");
  return("????UNKNOWN TYPE???");
}

char *myidltype_to_c1(char *name) 
{
  if (strcmp(name,"string")==0) return("char *"); 
  if (strcmp(name,"ior")==0) return("char *"); 
  if (strcmp(name,"long")==0) return("int");
  if (strcmp(name,"boolean")==0) return("int");
  return("????UNKNOWN TYPE???");
}

/* It can store names of interfaces, so that these can be recognised */
/* later as IOR (interoperable reference) objects                    */

char **interface_name_aliases;
static int nr_of_interface_aliases=0;
static int is_iftable_initialised=0;

void make_new_interface_name_alias(char *name)
{
  if (!is_iftable_initialised) {
    interface_name_aliases=malloc(sizeof(char *) * MAXNROFINTERFACENAMES);
    is_iftable_initialised=1;
  }
  interface_name_aliases[nr_of_interface_aliases]=malloc(strlen(name)+1);
  strcpy(interface_name_aliases[nr_of_interface_aliases],name);
  nr_of_interface_aliases++;
}

int is_interface_name_alias(char *name)
{
  int i;

  for (i=0;i<nr_of_interface_aliases;i++) 
    if (strcmp(interface_name_aliases[i],name)==0) return 1;
  return 0;
}
#line 900 "y.tab.c"
#define YYABORT goto yyabort
#define YYACCEPT goto yyaccept
#define YYERROR goto yyerrlab
int
yyparse()
{
    register int yym, yyn, yystate;
#if YYDEBUG
    register char *yys;
    extern char *getenv();

    if (yys = getenv("YYDEBUG"))
    {
        yyn = *yys;
        if (yyn >= '0' && yyn <= '9')
            yydebug = yyn - '0';
    }
#endif

    yynerrs = 0;
    yyerrflag = 0;
    yychar = (-1);

    yyssp = yyss;
    yyvsp = yyvs;
    *yyssp = yystate = 0;

yyloop:
    if (yyn = yydefred[yystate]) goto yyreduce;
    if (yychar < 0)
    {
        if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("yydebug: state %d, reading %d (%s)\n", yystate,
                    yychar, yys);
        }
#endif
    }
    if ((yyn = yysindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
#if YYDEBUG
        if (yydebug)
            printf("yydebug: state %d, shifting to state %d\n",
                    yystate, yytable[yyn]);
#endif
        if (yyssp >= yyss + yystacksize - 1)
        {
            goto yyoverflow;
        }
        *++yyssp = yystate = yytable[yyn];
        *++yyvsp = yylval;
        yychar = (-1);
        if (yyerrflag > 0)  --yyerrflag;
        goto yyloop;
    }
    if ((yyn = yyrindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
        yyn = yytable[yyn];
        goto yyreduce;
    }
    if (yyerrflag) goto yyinrecovery;
#ifdef lint
    goto yynewerror;
#endif
yynewerror:
    yyerror("syntax error");
#ifdef lint
    goto yyerrlab;
#endif
yyerrlab:
    ++yynerrs;
yyinrecovery:
    if (yyerrflag < 3)
    {
        yyerrflag = 3;
        for (;;)
        {
            if ((yyn = yysindex[*yyssp]) && (yyn += YYERRCODE) >= 0 &&
                    yyn <= YYTABLESIZE && yycheck[yyn] == YYERRCODE)
            {
#if YYDEBUG
                if (yydebug)
                    printf("yydebug: state %d, error recovery shifting\
 to state %d\n", *yyssp, yytable[yyn]);
#endif
                if (yyssp >= yyss + yystacksize - 1)
                {
                    goto yyoverflow;
                }
                *++yyssp = yystate = yytable[yyn];
                *++yyvsp = yylval;
                goto yyloop;
            }
            else
            {
#if YYDEBUG
                if (yydebug)
                    printf("yydebug: error recovery discarding state %d\n",
                            *yyssp);
#endif
                if (yyssp <= yyss) goto yyabort;
                --yyssp;
                --yyvsp;
            }
        }
    }
    else
    {
        if (yychar == 0) goto yyabort;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("yydebug: state %d, error recovery discards token %d (%s)\n",
                    yystate, yychar, yys);
        }
#endif
        yychar = (-1);
        goto yyloop;
    }
yyreduce:
#if YYDEBUG
    if (yydebug)
        printf("yydebug: state %d, reducing by rule %d (%s)\n",
                yystate, yyn, yyrule[yyn]);
#endif
    yym = yylen[yyn];
    yyval = yyvsp[1-yym];
    switch (yyn)
    {
case 2:
#line 105 "nyelv.y"
{
         cg_module_init(content_of_id(yyvsp[-1].nPtr));
         freeNode(yyvsp[-1].nPtr);
       }
break;
case 5:
#line 115 "nyelv.y"
{
         cg_interface_init(content_of_id(yyvsp[-1].nPtr));
         if (!is_interface_name_alias(content_of_id(yyvsp[-1].nPtr))) {
           make_new_interface_name_alias(content_of_id(yyvsp[-1].nPtr));
         }
         cg_if_init();
         freeNode(yyvsp[-1].nPtr);
      }
break;
case 6:
#line 125 "nyelv.y"
{ /* FORWARD */
         make_new_interface_name_alias(content_of_id(yyvsp[-1].nPtr));
         freeNode(yyvsp[-1].nPtr);
      }
break;
case 7:
#line 131 "nyelv.y"
{
         cg_if_exit();
         cg_interface_exit();
      }
break;
case 12:
#line 145 "nyelv.y"
{
           /* The content is ignored, only small syntax checks are done */
         }
break;
case 13:
#line 150 "nyelv.y"
{
           /* The content is ignored, only small syntax checks are done */
         }
break;
case 16:
#line 160 "nyelv.y"
{
               fprintf(stderr,"Exception member ignored.\n");
            }
break;
case 19:
#line 172 "nyelv.y"
{ 
               /* printf(" function name: %s  / return value type: STRING \n", content_of_id($2)); */
               sprintf(CURRENT_ID,"%s_%s_%s",modulename,interfacename,content_of_id(yyvsp[-5].nPtr));
               cg_functions_emit(CURRENT_ID,yyvsp[-3].nPtr,content_of_typenode(yyvsp[-6].nPtr));
               freeNode(yyvsp[-5].nPtr);
             }
break;
case 20:
#line 178 "nyelv.y"
{ 
               sprintf(CURRENT_ID,"%s_%s_%s",modulename,interfacename,content_of_id(yyvsp[-4].nPtr));
               cg_functions_emit(CURRENT_ID,NULL,content_of_typenode(yyvsp[-5].nPtr));
               freeNode(yyvsp[-4].nPtr);
             }
break;
case 21:
#line 186 "nyelv.y"
{ 
               fprintf(stderr,"Exception names ignored.\n");
            }
break;
case 22:
#line 189 "nyelv.y"
{ }
break;
case 25:
#line 199 "nyelv.y"
{ 
                         yyval.nPtr=construct_new_pali(yyvsp[0].nPtr);
                         /*$$=construct_new_pali(construct_onep("alma","STRING"));*/
                         /*freeNode($1); */
                       }
break;
case 26:
#line 204 "nyelv.y"
{
                         yyval.nPtr=merge_palis(construct_new_pali(yyvsp[-2].nPtr),yyvsp[0].nPtr);
                         /* freeNode ?? XXX see merge_palis (wrapper needs to be freed) */
                         /*freeNode($1); */
                       }
break;
case 27:
#line 212 "nyelv.y"
{ 
               /* printf(" parameter neve: %s \n", content_of_id($3)); */
               yyval.nPtr=construct_onep(content_of_id(yyvsp[0].nPtr),content_of_typenode(yyvsp[-1].nPtr));
               freeNode(yyvsp[0].nPtr);
               freeNode(yyvsp[-1].nPtr);
             }
break;
case 28:
#line 220 "nyelv.y"
{ yyval.nPtr=construct_typenode("string"); }
break;
case 29:
#line 221 "nyelv.y"
{ yyval.nPtr=construct_typenode("long"); }
break;
case 30:
#line 222 "nyelv.y"
{ yyval.nPtr=construct_typenode("ior"); }
break;
case 31:
#line 223 "nyelv.y"
{ yyval.nPtr=construct_typenode("boolean"); }
break;
case 32:
#line 224 "nyelv.y"
{ 
                            if (is_interface_name_alias(content_of_id(yyvsp[0].nPtr)))
                            {
                              yyval.nPtr=construct_typenode("ior"); 
                            } else {
                              fprintf(stderr,"Identifier is not an interface name: %s\n",content_of_id(yyvsp[0].nPtr));
                              yyval.nPtr=construct_typenode("unknown"); 
                            }
                          }
break;
case 33:
#line 234 "nyelv.y"
{ yyval.nPtr=construct_id(yyvsp[0].sValue); }
break;
#line 1174 "y.tab.c"
    }
    yyssp -= yym;
    yystate = *yyssp;
    yyvsp -= yym;
    yym = yylhs[yyn];
    if (yystate == 0 && yym == 0)
    {
#if YYDEBUG
        if (yydebug)
            printf("yydebug: after reduction, shifting from state 0 to\
 state %d\n", YYFINAL);
#endif
        yystate = YYFINAL;
        *++yyssp = YYFINAL;
        *++yyvsp = yyval;
        if (yychar < 0)
        {
            if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
            if (yydebug)
            {
                yys = 0;
                if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
                if (!yys) yys = "illegal-symbol";
                printf("yydebug: state %d, reading %d (%s)\n",
                        YYFINAL, yychar, yys);
            }
#endif
        }
        if (yychar == 0) goto yyaccept;
        goto yyloop;
    }
    if ((yyn = yygindex[yym]) && (yyn += yystate) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yystate)
        yystate = yytable[yyn];
    else
        yystate = yydgoto[yym];
#if YYDEBUG
    if (yydebug)
        printf("yydebug: after reduction, shifting from state %d \
to state %d\n", *yyssp, yystate);
#endif
    if (yyssp >= yyss + yystacksize - 1)
    {
        goto yyoverflow;
    }
    *++yyssp = yystate;
    *++yyvsp = yyval;
    goto yyloop;
yyoverflow:
    yyerror("yacc stack overflow");
yyabort:
    return (1);
yyaccept:
    return (0);
}
