%{
/* 
 * Clean-CORBA extension version 0.3
 * Csizmazia Balazs
 * csb@cs.kun.nl
 * 
 * This is the lex source file for the compiler.
 *
 */

#include <string.h>
#include "nodeType.h"
#include "y.tab.h"

extern int is_interface_name_alias(char *); /* Defined in the yacc source */
int num_lines = 0;
int _i;
%}

%%
"/*" 		{ /* Skip C-style comments */
			int c, comment_lines;

                        comment_lines=0;
                        for (;;) {
                          while ((c=input()) != '*' && c!=EOF) 
                            if (c == '\n') comment_lines++;
                          if (c=='*') {
                            while ((c=input()) =='*') ;
                            if (c=='/') break;
                          }
                          if (c == EOF) { yyerror("EOF encountered in comment"); break; }
                        }
                        num_lines+=comment_lines;
		}
[ \t\r\n]+      { /* whitespace */ _i=0;
                  for (_i=0;_i<strlen(yytext);_i++) 
                    if (yytext[_i]=='\n') num_lines++;
                } 
[a-zA-Z][a-z0-9A-Z\_]* { 
                   yylval.sValue=strdup(yytext);
               if (strcmp(yytext,"module")==0) 
                   { return MODULEUTASITAS; }
               if (strcmp(yytext, "interface")==0) 
                   { return INTERFACEUTASITAS; }
               if (strcmp(yytext, "exception")==0) 
                   { return EXCEPTIONUTASITAS; }
               if (strcmp(yytext, "function")==0) 
                   { return FUNCTIONUTASITAS; }
               if (strcmp(yytext, "in")==0) 
                   { return INUTASITAS; }
               if (strcmp(yytext, "returns")==0) 
                   { return RETURNSUTASITAS; }
               if (strcmp(yytext, "string")==0) 
                   { return STRINGUTASITAS; }
               if (strcmp(yytext, "long")==0) 
                   { return INT32UTASITAS; }
               if (strcmp(yytext, "ior")==0) 
                   { return IORUTASITAS; }
               if (strcmp(yytext, "raises")==0) 
                   { return RAISESUTASITAS; }
               if (strcmp(yytext, "boolean")==0) 
                   { return BOOLEANUTASITAS; }
               return SYM_IDENTIFIER; }
[0-9]+         { yylval.iValue=atoi(yytext); return SYM_NUMBER;}
\(             return SYM_LPAREN;
\)             return SYM_RPAREN;
\{             return SYM_LBRACKET;
\}             return SYM_RBRACKET;
\,             return SYM_COMMA;
\;             { return SYM_SEMICOLON; }

%%

