module counterreset

//  ********************************************************************************
//  Clean tutorial example program.
//  
//  This program defines a Controls component that implements a manually settable 
//	counter. A receiver is used to add a reset option.
//  ********************************************************************************

import StdEnv, StdIO

::  NoState
    =   NoState

Start :: *World -> *World
Start world
    =   startIO NoState NoState [initialise] [] world
where
    initialise ps
        #   (windowid, ps)  = accPIO openId  ps
        #   (displayid,ps)  = accPIO openId  ps
        #   (resetid,  ps)  = accPIO openRId ps
        #   (error,ps)      = openDialog NoState
        						(dialog windowid displayid resetid) ps
        |   error<>NoError
            =   abort "counter could not open Dialog."
        |   otherwise
            =   ps

dialog windowid displayid resetid
    =   Dialog "Counter" 
            (   counter
            :+: resetbutton
            )
            [   WindowId    windowid
            ,   WindowClose (noLS closeProcess)
            ]
where
    counter
        =   {   newLS   = initcount
            ,   newDef  = CompoundControl
                          (   EditControl (toString initcount) (hmm 50.0) 1
                                                [ControlSelectState   Unable
                                                ,ControlPos           (Center,zero)
                                                ,ControlId            displayid
                                                ]
                          :+: ButtonControl "-" [ControlFunction      (count (-1))
                                                ,ControlPos           (Center,zero)
                                                ]
                          :+: ButtonControl "+" [ControlFunction      (count   1 )]
                          :+: Receiver resetid reset []
                          )   []
            }
    where
        initcount   = 0
        
        count :: Int (Int,PSt .l .p) -> (Int,PSt .l .p)
        count dx (count,ps)
            =   (count+dx,setText windowid displayid (count+dx) ps)
        
        reset :: m (Int,PSt .l .p) -> (Int,PSt .l .p)
        reset _ (_,ps)
            =   (initcount,setText windowid displayid initcount ps)
        
        setText :: Id Id x (PSt .l .p) -> PSt .l .p | toString x
        setText wid cid x ps
            =   appPIO (setWindow wid [setControlTexts [(cid,toString x)]]) ps
    
    resetbutton
        =   ButtonControl "Reset"
        		[ControlFunction (noLS (snd o syncSend resetid undef))
                ,ControlPos      (Center,zero)
                ]
