system module BigInt

import  StdOverloaded
import  ExtendedArithBasics
from    _SystemBigInt   import BigInt
from    StdString       import String

// integers of unbounded length: 

:: NonNegBool   :== Bool // whether a number is non negative
:: Base         :== Int  // base for conversion from/to Strings, must be within [2..36]

// Comparison operators:

instance ==             BigInt
instance <              BigInt
instance isEven         BigInt
instance isOdd          BigInt

// Arithmetic:

instance +              BigInt
instance -              BigInt
instance zero           BigInt

instance *              BigInt
instance /              BigInt              //  Truncated to 0
instance one            BigInt

instance ^              BigInt
instance sqrt           BigInt

instance abs            BigInt
instance sign           BigInt
instance ~              BigInt

instance mod            BigInt
instance rem            BigInt
instance gcd            BigInt
instance lcm            BigInt

quotRem :: !u:BigInt !.BigInt -> (!.BigInt,!v:BigInt), [u <= v]
    // quotient (truncated to 0) and remainder 
divMod  :: !.BigInt !.BigInt  -> (!.BigInt,!BigInt)
    // quotient (truncated to -infinity) and remainder 
powMod  :: !BigInt !BigInt !BigInt -> .BigInt
    // powMod b e m = (b^e) mod (abs m), requirements: e>=0, m<>0

// specialised versions for operations with 32 bit numbers

instance EqInt          BigInt
instance LessInt        BigInt
instance GreaterInt     BigInt
instance +%             BigInt
instance -%             BigInt
instance %-             BigInt
instance *%             BigInt
instance ^%             BigInt

// conversion

instance toString BigInt
bigIntToString  ::  !Base !Bool !BigInt -> String
    // Bool: digits above '9' are uppercase
stringToBigInt  ::  !Base !String -> .BigInt

class toBigInt          a   :: !a       ->  .BigInt
instance toBigInt       Int
instance toBigInt       {#Char}

instance toReal         BigInt
instance toInt          BigInt
    // truncates to -(2^31) resp. (2^31)-1
    
unpackBigInt :: !u:BigInt -> (!NonNegBool, !u:{#Int})
    /*  access to the internal representation. The elements of the array should be
        interpreted as unsigned 32 bit digits. 
        BigInt==zero -> the returned array is {0}
        otherwise    -> the returned array contains no trailing zeros */
packBigInt :: !NonNegBool !u:{#Int} -> u:BigInt
    /*  iff the array contains trailing zeros and the size of that array is bigger
        than one then the array will be copied */

ratioToReal :: !BigInt !BigInt -> Real
    // convert arg1/arg2 to real

// inplace operations:

(.+.)  infix  6 :: !*BigInt !*BigInt -> .BigInt // addition
(.+ )  infixl 6 :: !*BigInt ! BigInt -> .BigInt

(.-.)  infix  6 :: !*BigInt !*BigInt -> .BigInt // subtraction
(.- )  infixl 6 :: !*BigInt ! BigInt -> .BigInt
( -.)  infix  6 :: ! BigInt !*BigInt -> .BigInt

copyBigInt :: !u:BigInt -> (!.BigInt,!u:BigInt)

nrOfBits :: !BigInt -> Int
fitsIntoInt :: !BigInt -> Bool                  // whether a BigInt fits into a 32 bit Int

